from __future__ import print_function, division
import requests
import netCDF4
import os
import logging
import time


def download_nc(catalog, cachedir, dodsC2fileServer=False):
    if not os.path.isdir(cachedir):
        raise IOError('directory {!r} not found'.format(cachedir))

    if not isinstance(catalog, netCDF4.Dataset):
        catalog = netCDF4.Dataset(catalog)

    paths = catalog.variables['urlPath'][:]

    for i, url in enumerate(str(b''.join(row).decode('utf-8')) for row in paths):
        if dodsC2fileServer:
            url = url.replace('dodsC', 'fileServer')
        localpath = os.path.join(cachedir, os.path.split(url)[1])
        download_file(url, localpath)
    logging.getLogger(__name__).warning('all netCDF-files preloaded')


def preload_nc(cachedir=None, reset=True, **kwargs):
    from .. import settings  # import catalog_path

    if cachedir is None:
        cachedir = settings.nc_cachedir
    else:
        settings.nc_cachedir = cachedir

    if reset:
        logging.getLogger(__name__).info('preloading datafiles')
        t0 = time.time()
        download_nc(settings.catalog_path, cachedir, **kwargs)
        logging.getLogger(__name__).info('preloading completed in {.2f}s'.format(time.time()-t0))

    logging.getLogger(__name__).info('loading from cache {!r}'.format(cachedir))


def download_file(url, filename):
    """download a file from a given url"""
    t0 = time.time()
    r = requests.get(url, stream=True)
    with open(filename, 'wb') as f:
        for chunk in r.iter_content(chunk_size=1024):
            if chunk:
                f.write(chunk)
    logging.getLogger(__name__).info('downloaded {} to {} in {:.2f}s'.format(url, filename, time.time() - t0))