from ..datasets.landboundaries import NL
import re


def plot_progress(progresslog,
                  xmin=450000, ymin=5700000,
                  xmax=700000, ymax=5950000,):

    """
    show a progress image of all processed blocks
    :param progresslog: filename of the progress log
    :param xmin:
    :param ymin:
    :param xmax:
    :param ymax:
    :return:
    """
    from matplotlib import pyplot as plt
    with open(progresslog, 'r') as f:
        dtstr = f.readline()
        locations = []
        p = re.compile(r'(..) xll([0-9\.]+)yll([0-9\.]+)w([0-9\.]+)h([0-9\.]+)')
        types = [str, float, float, float, float]
        for line in f:
            m = p.match(line)
            if not m:
                continue
            locations.append(tuple(t(v) for t, v in zip(types, m.groups())))

    labeldict = {
        'OK': (.0, 1., .0),  # processing completed successfully
        'ER': (1., .0, .0),  # error in datablock
        'IV': (1., 1., .0),  # invalid data in datablock
        '--': (1., .5, .0),  # empty datablock
    }

    plt.figure()
    for label, xll, yll, w, h in locations:
        plt.gca().add_patch(plt.Rectangle((xll, yll), w, h, facecolor=labeldict[label]))

    NL.plot(plt.gca(), lw=.5, color='k')

    plt.xlim(xmin, xmax)
    plt.ylim(ymin, ymax)
    plt.gca().set_aspect('equal')

    plt.title(progresslog)

    return plt.gcf()


def show_progress(progresslog,
                  xmin=450000, ymin=5700000,
                  xmax=700000, ymax=5950000,):
    from matplotlib import pyplot as plt
    fig = plot_progress(progresslog,
                        xmin=xmin, ymin=ymin,
                        xmax=xmax, ymax=ymax)
    plt.show()


def save_progress(progresslog, figname,
                  xmin=450000, ymin=5700000,
                  xmax=700000, ymax=5950000,):
    fig = plot_progress(progresslog,
                        xmin=xmin, ymin=ymin,
                        xmax=xmax, ymax=ymax)
    fig.savefig(figname, dpi=150)