import numpy as np
from . import utils

def rotate(x, y, Z, direction):
    """
    rotate a dataset for the given degrees
    :param x: 1D array of x positions
    :param y: 1D array of y positions
    :param Z: 2D array of values
    :param direction: direction in degrees
    :return: 2D array of x positions, 2D array of y positions, 2D array of values
    """

    # x and y to 2D arrays
    X, Y = np.meshgrid(x, y)

    # rotate each matrix
    rotZ = rotate2D(Z, direction)
    rotX = rotate2D(X, direction)
    rotY = rotate2D(Y, direction)

    return rotX, rotY, rotZ


def rotate2D(data, direction):
    """rotate a matrix with a given number of degrees (no cropping)"""
    return utils.rotate(data, direction-90, cropped=False)