(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13477,        336]
NotebookOptionsPosition[     12638,        312]
NotebookOutlinePosition[     13037,        328]
CellTagsIndexPosition[     12994,        325]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Figure S6", "Section",
 CellChangeTimes->{{3.9710194737137403`*^9, 3.9710194781126933`*^9}, {
  3.9710204028501344`*^9, 
  3.971020403498561*^9}},ExpressionUUID->"138b2f1f-c690-4405-ab83-\
06485b490c0b"],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. S6(a) - L = 10 nm, charges at x = 9.5 nm, cA = 0.001 ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["nm", 
    RowBox[{"-", "2"}]], TraditionalForm]],ExpressionUUID->
  "4d8474b2-c8ee-4b70-80d1-f6f86bed64ee"],
 "."
}], "Subsection",
 CellChangeTimes->{{3.9544843440246716`*^9, 3.9544843673748503`*^9}, 
   3.9546105586216345`*^9, {3.9546106091296377`*^9, 3.9546107494107013`*^9}, {
   3.9569815679642496`*^9, 3.9569815957636623`*^9}, {3.9569817085796347`*^9, 
   3.9569817623098183`*^9}, {3.9569837438289447`*^9, 3.956983757390109*^9}, {
   3.9710194920420227`*^9, 3.971019563798727*^9}, {3.9710200130107603`*^9, 
   3.971020013587948*^9}, {3.9710210134231086`*^9, 
   3.971021014003169*^9}},ExpressionUUID->"2e561c97-53bc-4b2f-a7b5-\
27951685413d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Red", " ", "curve", " ", 
    RowBox[{"curve", ".", " ", "Data"}], " ", 
    RowBox[{"format", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"distance", " ", "to", " ", "the", " ", "substrate", " ", 
        RowBox[{"(", "nm", ")"}]}], ",", " ", 
       RowBox[{"energy", " ", 
        RowBox[{"(", "eV", ")"}]}]}], "}"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabPhi", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.055`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0.108`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.`", ",", "0.148`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", "0.186`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "0.219`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "0.248`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "0.258`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", "0.277`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", "0.28600000000000003`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.293`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", "0.28500000000000003`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", "0.28200000000000003`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", "0.28600000000000003`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", "0.28500000000000003`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.28200000000000003`"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Black", " ", 
     RowBox[{"curve", ".", " ", "Data"}], " ", 
     RowBox[{"format", ":", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"distance", " ", "to", " ", "the", " ", "substrate", " ", 
         RowBox[{"(", "nm", ")"}]}], ",", 
        RowBox[{"standard", " ", "deviation", " ", 
         RowBox[{"(", "eV", ")"}]}]}], "}"}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"tabsigma", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.0285`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0.051000000000000004`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.`", ",", "0.0685`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", "0.081`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "0.088`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "0.095`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "0.096`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", "0.097`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", "0.092`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.08600000000000001`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", "0.075`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", "0.065`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", "0.061`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", "0.057`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.049`"}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9710198222425203`*^9, 3.971019846444437*^9}, {
   3.9710198916738214`*^9, 3.971020019300717*^9}, {3.971020487335923*^9, 
   3.971020491981224*^9}, {3.9710206276966677`*^9, 3.9710206586398807`*^9}, 
   3.9710212156878214`*^9},ExpressionUUID->"c12537ee-3b5f-4f6c-b709-\
74b2b7c4cf64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. S6(b) - L = 10 nm, charges at x = 9.5 nm, cA = 0.001 ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["nm", 
    RowBox[{"-", "2"}]], TraditionalForm]],ExpressionUUID->
  "ff372cb3-4099-4513-ac66-6a6ea5db3304"],
 ". Work function shift distribution"
}], "Subsection",
 CellChangeTimes->{{3.9544843440246716`*^9, 3.9544843673748503`*^9}, 
   3.9546105586216345`*^9, {3.9546106091296377`*^9, 3.9546107494107013`*^9}, {
   3.9569815679642496`*^9, 3.9569815957636623`*^9}, {3.9569817085796347`*^9, 
   3.9569817623098183`*^9}, {3.9569837438289447`*^9, 3.956983757390109*^9}, {
   3.9710194920420227`*^9, 3.971019563798727*^9}, {3.9710200130107603`*^9, 
   3.971020013587948*^9}, {3.9710210134231086`*^9, 3.971021014003169*^9}, {
   3.9710210485719557`*^9, 3.9710210596469717`*^9}, {3.9710212272471676`*^9, 
   3.971021229796858*^9}},ExpressionUUID->"02b604b8-e0a4-43a6-9408-\
0d16f8650b91"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Data", " ", 
    RowBox[{"format", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"work", " ", "function", " ", "shift", " ", 
        RowBox[{"(", "eV", ")"}]}], ",", " ", 
       RowBox[{"probability", " ", "density", " ", 
        RowBox[{"(", 
         SuperscriptBox["eV", 
          RowBox[{"-", "1"}]], ")"}]}]}], "}"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"tabdistr", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.01`", ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.03`", ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.05`", ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.06999999999999999`", ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.09`", ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.11`", ",", "0.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.13`", ",", "0.0625`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.15000000000000002`", ",", "0.47500000000000003`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.17`", ",", "1.425`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.19`", ",", "2.2875`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.21000000000000002`", ",", "4.1000000000000005`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.23`", ",", "5.0125`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.25`", ",", "5.2625`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.27`", ",", "4.9`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.29000000000000004`", ",", "5.1875`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.31`", ",", "4.2250000000000005`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.33`", ",", "3.7125000000000004`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.35000000000000003`", ",", "3.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.37`", ",", "2.4000000000000004`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.39`", ",", "1.8125`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.41000000000000003`", ",", "1.475`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.43`", ",", "1.2000000000000002`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.45`", ",", "0.7375`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.47000000000000003`", ",", "0.5750000000000001`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.49`", ",", "0.375`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.51`", ",", "0.3375`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.53`", ",", "0.25`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.55`", ",", "0.225`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5700000000000001`", ",", "0.225`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.59`", ",", "0.1375`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.61`", ",", "0.17500000000000002`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.63`", ",", "0.1125`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.65`", ",", "0.037500000000000006`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.67`", ",", "0.0625`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6900000000000001`", ",", "0.037500000000000006`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.7100000000000001`", ",", "0.025`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.73`", ",", "0.05`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.75`", ",", "0.025`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.77`", ",", "0.0125`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.79`", ",", "0.0125`"}], "}"}]}], "}"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.954484373491315*^9, 3.9544845795192566`*^9}, {
   3.954484665282324*^9, 3.9544848027302885`*^9}, {3.9546108068543854`*^9, 
   3.9546108617394247`*^9}, {3.9546109349853373`*^9, 
   3.9546111377294116`*^9}, {3.954642907395705*^9, 3.9546433795426345`*^9}, {
   3.9546434101069107`*^9, 3.9546434129310436`*^9}, {3.9546480296936207`*^9, 
   3.9546480712638903`*^9}, {3.954654245592142*^9, 3.954654393001356*^9}, {
   3.9568230383693314`*^9, 3.956823065653358*^9}, {3.956823127628683*^9, 
   3.9568231313703213`*^9}, {3.9568232143670034`*^9, 
   3.9568232502551093`*^9}, {3.9568233291241384`*^9, 
   3.9568233494519806`*^9}, {3.9568233812326794`*^9, 
   3.9568235748131638`*^9}, {3.9568236198337135`*^9, 3.956823689408574*^9}, {
   3.9568237550773497`*^9, 3.956823763194145*^9}, {3.9568238466047297`*^9, 
   3.9568238655236945`*^9}, {3.956823914319029*^9, 3.9568239539437943`*^9}, {
   3.9568239937900505`*^9, 3.9568243136266065`*^9}, {3.9568243602709413`*^9, 
   3.9568245288281155`*^9}, {3.956824559516723*^9, 3.9568246456865797`*^9}, {
   3.9568246819888687`*^9, 3.9568249119176846`*^9}, {3.956824998682644*^9, 
   3.9568251272814684`*^9}, {3.9568251610666757`*^9, 3.956825366222701*^9}, {
   3.9568254527875185`*^9, 3.956825591881707*^9}, {3.956825640143817*^9, 
   3.9568256560406475`*^9}, {3.9568257136821365`*^9, 3.956825792776184*^9}, {
   3.9568266120282516`*^9, 3.9568267270636864`*^9}, {3.9577605247714014`*^9, 
   3.957760670873786*^9}, {3.957760758857541*^9, 3.9577608046481705`*^9}, {
   3.957764279100653*^9, 3.9577643896671853`*^9}, 3.95776442163724*^9, {
   3.9577644970516806`*^9, 3.9577644989290123`*^9}, {3.9577749027160487`*^9, 
   3.9577749087402177`*^9}, {3.957845485407214*^9, 3.9578455404343653`*^9}, {
   3.9578456156956673`*^9, 3.9578456919045606`*^9}, {3.957845723908668*^9, 
   3.957845812996273*^9}, {3.9578458464640713`*^9, 3.9578458483380413`*^9}, {
   3.957845885408515*^9, 3.9578461315500298`*^9}, {3.9578461645753*^9, 
   3.957846178994524*^9}, {3.9578462114437327`*^9, 3.957846271608716*^9}, {
   3.9578463236091022`*^9, 3.9578465864787807`*^9}, {3.957846714617014*^9, 
   3.9578469207453947`*^9}, {3.9578472066974926`*^9, 3.957847263871876*^9}, {
   3.9578490741783204`*^9, 3.9578490744385996`*^9}, {3.971021071800555*^9, 
   3.971021077333349*^9}, {3.9710211254899797`*^9, 
   3.9710212107587056`*^9}},ExpressionUUID->"915af877-5dab-4fde-b534-\
758507270e66"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1138.5, 567},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0799bdfc-6622-44d6-96e3-65172c939745"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 209, 4, 67, "Section",ExpressionUUID->"138b2f1f-c690-4405-ab83-06485b490c0b"],
Cell[CellGroupData[{
Cell[814, 30, 772, 16, 54, "Subsection",ExpressionUUID->"2e561c97-53bc-4b2f-a7b5-27951685413d"],
Cell[1589, 48, 3858, 101, 162, "Input",ExpressionUUID->"c12537ee-3b5f-4f6c-b709-74b2b7c4cf64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5484, 154, 907, 17, 54, "Subsection",ExpressionUUID->"02b604b8-e0a4-43a6-9408-0d16f8650b91"],
Cell[6394, 173, 6216, 135, 202, "Input",ExpressionUUID->"915af877-5dab-4fde-b534-758507270e66"]
}, Open  ]]
}, Open  ]]
}
]
*)

