(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26671,        560]
NotebookOptionsPosition[     25568,        531]
NotebookOutlinePosition[     26000,        548]
CellTagsIndexPosition[     25957,        545]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Figure S4 - average escape time of randomly absorbed electrons in films with \
various thicknesses\
\>", "Title",
 CellChangeTimes->{{3.8510551467809277`*^9, 3.8510551638900614`*^9}, {
   3.8512562628138685`*^9, 3.851256266924469*^9}, {3.8512683216422997`*^9, 
   3.8512683230613003`*^9}, {3.8512749880798616`*^9, 3.851274992160311*^9}, {
   3.852179657158142*^9, 3.852179657496433*^9}, {3.8522648835258236`*^9, 
   3.852264895503807*^9}, {3.9539098323881783`*^9, 3.9539098594810305`*^9}, {
   3.953909902272316*^9, 3.9539099208441963`*^9}, {3.957189077209676*^9, 
   3.957189083407381*^9}, {3.957338699833256*^9, 3.9573387013753347`*^9}, {
   3.9710176310164804`*^9, 3.971017639338797*^9}, {3.971017671178914*^9, 
   3.9710176741065598`*^9}, 
   3.971019183795371*^9},ExpressionUUID->"4db28663-3797-4aad-9051-\
57d37be2ea72"],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. S4(a) \nData format: {disorder energy (eV), ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "10"], " ", "[", 
    RowBox[{
     SubscriptBox["t", "esc"], "(", 
     StyleBox["s",
      FontSlant->"Plain"], ")"}], "]"}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "eef546b7-0cd7-4ff5-acff-591125b730db"],
 "}"
}], "Subsection",
 CellChangeTimes->{{3.955872333779544*^9, 3.955872361529569*^9}, {
  3.955938751919899*^9, 3.9559388178335752`*^9}, {3.9710176866378436`*^9, 
  3.971017693252328*^9}, {3.971019006510806*^9, 
  3.9710190071695924`*^9}},ExpressionUUID->"a4fc4e13-e07e-4328-8071-\
ca2be7ce5ce6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Results", " ", "without", " ", "gradient"}], ",", " ", 
    RowBox[{
    "without", " ", "image", " ", "potential", " ", "and", " ", "without", 
     " ", "surface", " ", 
     RowBox[{"effects", ".", " ", "No"}], " ", "trapped", " ", 
     RowBox[{"charges", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Layer", " ", "thickness", " ", "5", " ", "nm", " ", 
     RowBox[{"(", "tab5nm", ")"}]}], " ", "..."}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tab5nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.041392685158225`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.01`", ",", "1.1303337684950059`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.02`", ",", "1.220108088040055`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "1.8356905714924254`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "2.773786444981193`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "4.009727022688622`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "5.505149978319905`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "7.207499723307305`"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab10nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.5854607295085006`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.01`", ",", "1.677606952720493`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.02`", ",", "1.7944880466591693`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "2.517195897949974`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "3.385963570600697`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "4.812579155409046`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "6.130333768495006`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "7.732393759822968`"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.9175055095525464`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.01`", ",", "2.0374264979406234`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.02`", ",", "2.1613680022349744`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "2.872738827472668`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "3.7857567999626425`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "5.095750347480817`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "6.6232492903979`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "8.37383114507383`"}], "}"}]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.971017993112315*^9, 
  3.9710180743068953`*^9}},ExpressionUUID->"1adcc407-6189-4336-93c7-\
247b715fde44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. S4(b) \nData format: {disorder energy (eV), ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "10"], " ", "[", 
    RowBox[{
     SubscriptBox["t", "esc"], "(", 
     StyleBox["s",
      FontSlant->"Plain"], ")"}], "]"}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "f726150e-9768-4e57-a995-394262a7470b"],
 "}"
}], "Subsection",
 CellChangeTimes->{{3.955872333779544*^9, 3.955872361529569*^9}, {
  3.955938751919899*^9, 3.9559388178335752`*^9}, {3.9710176866378436`*^9, 
  3.971017693252328*^9}, {3.971018138042*^9, 3.971018138566167*^9}, {
  3.9710190106383276`*^9, 
  3.9710190119181023`*^9}},ExpressionUUID->"59199799-3ff4-440b-ae1f-\
3b9ddbaa603d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"No", " ", "trapped", " ", 
     RowBox[{"charges", ".", " ", "No"}], " ", "gradient"}], ",", " ", 
    RowBox[{
     RowBox[{"no", " ", "surface", " ", 
      RowBox[{"effects", ".", " ", "With"}], " ", "Coulomb", " ", "and", " ", 
      "image", " ", 
      RowBox[{"potential", ".", " ", "epsr"}]}], " ", "=", " ", "3."}]}], 
   "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Layer", " ", "thickness", " ", "5", " ", "nm", " ", 
      RowBox[{"(", "tab5nm", ")"}]}], " ", "..."}], " ", "20", " ", "nm", " ", 
    RowBox[{"(", "tab20nm", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tab5nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5877109650189113`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.025`", ",", "0.696356388733332`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "1.1370374547895126`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "2.1367205671564067`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "3.2975416678181593`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "4.595980950129249`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "5.88513440028078`"}], "}"}]}], "}"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"tab10nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0.8756399370041683`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.025`", ",", "0.9876662649262745`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "1.4842998393467857`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "2.491361693834272`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "3.667546339511516`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "5.361727836017592`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "7.372912002970106`"}], "}"}]}], "}"}]}], ";"}],
    "\n", 
   RowBox[{
    RowBox[{"tab15nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.0170333392987803`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.025`", ",", "1.1003705451175627`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "1.5622928644564746`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "2.491361693834272`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "3.816042340921996`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "5.424881636631066`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "7.262451089730428`"}], "}"}]}], "}"}]}], ";"}],
    "\n", 
   RowBox[{
    RowBox[{"tab20nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.117271295655764`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.025`", ",", "1.1931245983544614`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05`", ",", "1.635483746814912`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.075`", ",", "2.6106601630898796`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1`", ",", "3.9642596301968482`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.125`", ",", "5.51093355671559`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15`", ",", "7.434568904034198`"}], "}"}]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.955872388920825*^9, 3.9558725979365387`*^9}, {
   3.9558726356405373`*^9, 3.9558726388869047`*^9}, {3.9558728475108223`*^9, 
   3.955873100115905*^9}, {3.95587313221039*^9, 3.9558738602577195`*^9}, {
   3.955873893511059*^9, 3.955873893862446*^9}, {3.9558767108903775`*^9, 
   3.955876751138098*^9}, 3.9558767852823963`*^9, {3.9558840593003736`*^9, 
   3.955884091317212*^9}, 3.955884123135358*^9, {3.9558841578423653`*^9, 
   3.955884207777422*^9}, {3.955888160067427*^9, 3.955888184907954*^9}, {
   3.9558883910034466`*^9, 3.955888404691558*^9}, {3.9558913931525865`*^9, 
   3.9558914541918287`*^9}, {3.95589487497134*^9, 3.95589488924024*^9}, {
   3.955896664918374*^9, 3.955896708748208*^9}, {3.955896768962916*^9, 
   3.955896786590457*^9}, {3.956051129567286*^9, 3.9560511599536533`*^9}, {
   3.9560511928623276`*^9, 3.9560512275556355`*^9}, {3.9562072947810187`*^9, 
   3.9562073966540775`*^9}, {3.956212512743596*^9, 3.9562125463336315`*^9}, {
   3.956212825117474*^9, 3.956212825549539*^9}, {3.9562158078137255`*^9, 
   3.956215840264112*^9}, {3.956217380141038*^9, 3.9562173838264594`*^9}, {
   3.9562174446123877`*^9, 3.956217500760397*^9}, {3.9562175462625923`*^9, 
   3.9562175468798885`*^9}, {3.9562175855553675`*^9, 
   3.9562175877610903`*^9}, {3.9562204819459934`*^9, 
   3.9562205176083546`*^9}, {3.956221285394072*^9, 3.9562215844866576`*^9}, {
   3.956221670646243*^9, 3.956221761859417*^9}, {3.9562218468210964`*^9, 
   3.9562218821929803`*^9}, 3.9562219151077137`*^9, {3.9562280202711697`*^9, 
   3.9562280371303225`*^9}, {3.95622807748816*^9, 3.956228077988018*^9}, {
   3.9562408609987907`*^9, 3.956240872288025*^9}, {3.9562516890188537`*^9, 
   3.9562516956762257`*^9}, {3.956290655919032*^9, 3.956290698135733*^9}, {
   3.956305847083724*^9, 3.9563058552688904`*^9}, {3.9563099943559036`*^9, 
   3.956310015097064*^9}, {3.956320216914632*^9, 3.9563202393644977`*^9}, {
   3.9563203241089716`*^9, 3.9563203280985355`*^9}, {3.956320361858857*^9, 
   3.9563203804589477`*^9}, {3.9563271639071875`*^9, 
   3.9563271783823185`*^9}, {3.956378946550456*^9, 3.9563789507170773`*^9}, {
   3.9564780363120346`*^9, 3.9564783111923857`*^9}, {3.9564783427713084`*^9, 
   3.9564783486390934`*^9}, {3.9564783916840754`*^9, 
   3.9564784158640966`*^9}, {3.9564784593236294`*^9, 
   3.9564784669161777`*^9}, {3.9564788373299375`*^9, 3.956478864583563*^9}, {
   3.9564794442465105`*^9, 3.956479457225795*^9}, {3.9564805157769055`*^9, 
   3.9564805244051523`*^9}, {3.9564805689762487`*^9, 
   3.9564805990420046`*^9}, {3.956485321753499*^9, 3.9564855776602945`*^9}, {
   3.9564875418767614`*^9, 3.956487556692979*^9}, {3.957338749576338*^9, 
   3.9573388079197087`*^9}, {3.9573542812486367`*^9, 3.957354529868764*^9}, {
   3.957356391228701*^9, 3.9573564246033053`*^9}, {3.9573598648257275`*^9, 
   3.9573598860800295`*^9}, {3.9573599186280084`*^9, 
   3.9573599188039627`*^9}, {3.9573613630925045`*^9, 3.957361401824229*^9}, {
   3.957361433486136*^9, 3.9573614814380054`*^9}, {3.9573627161407413`*^9, 
   3.9573627177732716`*^9}, {3.957362865953545*^9, 3.9573628829098682`*^9}, {
   3.957362930722986*^9, 3.957362937089432*^9}, {3.9573646405158763`*^9, 
   3.957364656359145*^9}, {3.9573647626340013`*^9, 3.9573647847590723`*^9}, {
   3.957368040353706*^9, 3.957368251467077*^9}, {3.9573682835762367`*^9, 
   3.957368291069992*^9}, 3.9573683234296565`*^9, {3.9573686473994727`*^9, 
   3.9573686749022465`*^9}, {3.9573688519404507`*^9, 
   3.9573688634531574`*^9}, {3.957368902078205*^9, 3.9573689024217415`*^9}, {
   3.9573689780251026`*^9, 3.957369002364519*^9}, {3.9573704759694567`*^9, 
   3.957370478676075*^9}, {3.9573714618203077`*^9, 3.9573714950151367`*^9}, {
   3.9574137248683047`*^9, 3.957413730913787*^9}, {3.957413915433632*^9, 
   3.9574139389355526`*^9}, {3.9574139844179525`*^9, 
   3.9574139997091303`*^9}, {3.9574140317756243`*^9, 3.9574140335864863`*^9}, 
   3.957414067593794*^9, {3.957414900562945*^9, 3.957414935746411*^9}, {
   3.957414973746522*^9, 3.957414980152546*^9}, {3.9574150193795853`*^9, 
   3.95741506744133*^9}, {3.957416447274604*^9, 3.9574164954809213`*^9}, {
   3.957435840700493*^9, 3.95743594235927*^9}, {3.9574359736438913`*^9, 
   3.9574360706704817`*^9}, {3.9574474613136044`*^9, 
   3.9574475090185003`*^9}, {3.9574475492534647`*^9, 3.957447619736079*^9}, {
   3.957447663668516*^9, 3.9574478381018343`*^9}, {3.9578546263423395`*^9, 
   3.9578546288076897`*^9}, {3.957854670749976*^9, 3.9578547227431927`*^9}, {
   3.9578547640494995`*^9, 3.9578547658923798`*^9}, {3.957854811011159*^9, 
   3.957854904417533*^9}, {3.9578549735119658`*^9, 3.9578553081299744`*^9}, {
   3.9578553499301815`*^9, 3.9578554624302416`*^9}, {3.957855497180372*^9, 
   3.95785555303051*^9}, {3.9578556144473734`*^9, 3.9578557373145914`*^9}, {
   3.957855773403411*^9, 3.9578557736976476`*^9}, {3.9578558039143343`*^9, 
   3.957855805106221*^9}, {3.9578558373667564`*^9, 3.9578558376073055`*^9}, {
   3.9578559140483317`*^9, 3.9578559224147654`*^9}, {3.9578559664485064`*^9, 
   3.957856155248457*^9}, {3.957856193665249*^9, 3.957856217419567*^9}, 
   3.957856264032304*^9, {3.957856316389209*^9, 3.95785641401562*^9}, {
   3.9578567262741365`*^9, 3.957856739588382*^9}, {3.957856860122572*^9, 
   3.957856866545444*^9}, {3.9578569400699825`*^9, 3.957856941303194*^9}, {
   3.957856984864732*^9, 3.9578573664471807`*^9}, {3.9578574562569647`*^9, 
   3.9578575220067368`*^9}, {3.957857564057067*^9, 3.9578575907127438`*^9}, {
   3.9578576475910215`*^9, 3.9578576754622364`*^9}, 3.957857713247381*^9, {
   3.9578577460836163`*^9, 3.9578577499774446`*^9}, 3.957857817510415*^9, {
   3.957857880075225*^9, 3.9578579007872896`*^9}, {3.957857933832339*^9, 
   3.9578579707622256`*^9}, 3.957858162142299*^9, 3.9578581931609163`*^9, {
   3.9578582280164895`*^9, 3.9578582281928453`*^9}, {3.957862649562977*^9, 
   3.957862741484066*^9}, {3.9578627827774057`*^9, 3.957862835495533*^9}, {
   3.957862885703926*^9, 3.957862899323905*^9}, {3.9710179288294926`*^9, 
   3.971017962814144*^9}, 3.9710181210923696`*^9, {3.971018151626167*^9, 
   3.9710181795294056`*^9}, {3.971018261751254*^9, 
   3.971018415779575*^9}},ExpressionUUID->"2d916604-b697-4d67-9f28-\
a6e2a467ae4e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. S4(c) \nData format: {trap concentration, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "10"], " ", "[", 
    RowBox[{
     SubscriptBox["t", "esc"], "(", 
     StyleBox["s",
      FontSlant->"Plain"], ")"}], "]"}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "e56df286-5bc3-445f-8d23-23979c8637f3"],
 "}"
}], "Subsection",
 CellChangeTimes->{{3.955872333779544*^9, 3.955872361529569*^9}, {
  3.955938751919899*^9, 3.9559388178335752`*^9}, {3.9710176866378436`*^9, 
  3.971017693252328*^9}, {3.971018138042*^9, 3.971018138566167*^9}, {
  3.9710184491889153`*^9, 3.971018449821181*^9}, {3.971019015552251*^9, 
  3.971019042312726*^9}},ExpressionUUID->"4d0b883f-e065-495c-a067-\
3ce67a53c9fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Trapped", " ", "charges", " ", "with", " ", "varying", " ", 
      RowBox[{"concentration", ".", " ", "With"}], " ", "Coulomb", " ", "and",
       " ", "image", " ", 
      RowBox[{"potential", ".", " ", "epsr"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"3.", " ", "L"}], " ", "=", " ", 
      RowBox[{"15", " ", "nm"}]}]}], ",", " ", 
    RowBox[{"sigma", " ", "=", " ", 
     RowBox[{"0.10", " ", "eV"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Layer", " ", "thickness", " ", "10", " ", "nm", " ", 
      RowBox[{"(", "tab10nm", ")"}]}], " ", "..."}], " ", "15", " ", "nm", 
    " ", 
    RowBox[{"(", "tab15nm", ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "A", " ", "trap", " ", "concentration", " ", "of", " ", "0.004", " ", 
    RowBox[{"(", 
     RowBox[{"maximum", " ", "value", " ", "considered"}], ")"}], " ", 
    "corresponds", " ", "to", " ", "a", " ", "density", " ", "of", " ", "4", 
    "*", 
    SuperscriptBox["10", "24"], " ", 
    SuperscriptBox["m", 
     RowBox[{"-", "3"}]]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"tab10nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "4.209997296082369`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0003`", ",", "3.94384062640126`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.001`", ",", "3.667546339511516`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.002`", ",", "3.422425676371204`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.003`", ",", "3.1994809148623555`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.004`", ",", "3.0972573096934197`"}], "}"}]}], "}"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"tab15nm", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "4.629511534200453`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0003`", ",", "4.245315216352733`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.001`", ",", "3.8349926037330295`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.002`", ",", "3.6284911049671225`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.003`", ",", "3.3946267642722088`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.004`", ",", "3.21984638602436`"}], "}"}]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.955872388920825*^9, 3.9558725979365387`*^9}, {
   3.9558726356405373`*^9, 3.9558726388869047`*^9}, {3.9558728475108223`*^9, 
   3.955873100115905*^9}, {3.95587313221039*^9, 3.9558738602577195`*^9}, {
   3.955873893511059*^9, 3.955873893862446*^9}, {3.9558767108903775`*^9, 
   3.955876751138098*^9}, 3.9558767852823963`*^9, {3.9558840593003736`*^9, 
   3.955884091317212*^9}, 3.955884123135358*^9, {3.9558841578423653`*^9, 
   3.955884207777422*^9}, {3.955888160067427*^9, 3.955888184907954*^9}, {
   3.9558883910034466`*^9, 3.955888404691558*^9}, {3.9558913931525865`*^9, 
   3.9558914541918287`*^9}, {3.95589487497134*^9, 3.95589488924024*^9}, {
   3.955896664918374*^9, 3.955896708748208*^9}, {3.955896768962916*^9, 
   3.955896786590457*^9}, {3.956051129567286*^9, 3.9560511599536533`*^9}, {
   3.9560511928623276`*^9, 3.9560512275556355`*^9}, {3.9562072947810187`*^9, 
   3.9562073966540775`*^9}, {3.956212512743596*^9, 3.9562125463336315`*^9}, {
   3.956212825117474*^9, 3.956212825549539*^9}, {3.9562158078137255`*^9, 
   3.956215840264112*^9}, {3.956217380141038*^9, 3.9562173838264594`*^9}, {
   3.9562174446123877`*^9, 3.956217500760397*^9}, {3.9562175462625923`*^9, 
   3.9562175468798885`*^9}, {3.9562175855553675`*^9, 
   3.9562175877610903`*^9}, {3.9562204819459934`*^9, 
   3.9562205176083546`*^9}, {3.956221285394072*^9, 3.9562215844866576`*^9}, {
   3.956221670646243*^9, 3.956221761859417*^9}, {3.9562218468210964`*^9, 
   3.9562218821929803`*^9}, 3.9562219151077137`*^9, {3.9562280202711697`*^9, 
   3.9562280371303225`*^9}, {3.95622807748816*^9, 3.956228077988018*^9}, {
   3.9562408609987907`*^9, 3.956240872288025*^9}, {3.9562516890188537`*^9, 
   3.9562516956762257`*^9}, {3.956290655919032*^9, 3.956290698135733*^9}, {
   3.956305847083724*^9, 3.9563058552688904`*^9}, {3.9563099943559036`*^9, 
   3.956310015097064*^9}, {3.956320216914632*^9, 3.9563202393644977`*^9}, {
   3.9563203241089716`*^9, 3.9563203280985355`*^9}, {3.956320361858857*^9, 
   3.9563203804589477`*^9}, {3.9563271639071875`*^9, 
   3.9563271783823185`*^9}, {3.956378946550456*^9, 3.9563789507170773`*^9}, {
   3.9564780363120346`*^9, 3.9564783111923857`*^9}, {3.9564783427713084`*^9, 
   3.9564783486390934`*^9}, {3.9564783916840754`*^9, 
   3.9564784158640966`*^9}, {3.9564784593236294`*^9, 
   3.9564784669161777`*^9}, {3.9564788373299375`*^9, 3.956478864583563*^9}, {
   3.9564794442465105`*^9, 3.956479457225795*^9}, {3.9564805157769055`*^9, 
   3.9564805244051523`*^9}, {3.9564805689762487`*^9, 
   3.9564805990420046`*^9}, {3.956485321753499*^9, 3.9564855776602945`*^9}, {
   3.9564875418767614`*^9, 3.956487556692979*^9}, {3.957338749576338*^9, 
   3.9573388079197087`*^9}, {3.9573542812486367`*^9, 3.957354529868764*^9}, {
   3.957356391228701*^9, 3.9573564246033053`*^9}, {3.9573598648257275`*^9, 
   3.9573598860800295`*^9}, {3.9573599186280084`*^9, 
   3.9573599188039627`*^9}, {3.9573613630925045`*^9, 3.957361401824229*^9}, {
   3.957361433486136*^9, 3.9573614814380054`*^9}, {3.9573627161407413`*^9, 
   3.9573627177732716`*^9}, {3.957362865953545*^9, 3.9573628829098682`*^9}, {
   3.957362930722986*^9, 3.957362937089432*^9}, {3.9573646405158763`*^9, 
   3.957364656359145*^9}, {3.9573647626340013`*^9, 3.9573647847590723`*^9}, {
   3.957368040353706*^9, 3.957368251467077*^9}, {3.9573682835762367`*^9, 
   3.957368291069992*^9}, 3.9573683234296565`*^9, {3.9573686473994727`*^9, 
   3.9573686749022465`*^9}, {3.9573688519404507`*^9, 
   3.9573688634531574`*^9}, {3.957368902078205*^9, 3.9573689024217415`*^9}, {
   3.9573689780251026`*^9, 3.957369002364519*^9}, {3.9573704759694567`*^9, 
   3.957370478676075*^9}, {3.9573714618203077`*^9, 3.9573714950151367`*^9}, {
   3.9574137248683047`*^9, 3.957413730913787*^9}, {3.957413915433632*^9, 
   3.9574139389355526`*^9}, {3.9574139844179525`*^9, 
   3.9574139997091303`*^9}, {3.9574140317756243`*^9, 3.9574140335864863`*^9}, 
   3.957414067593794*^9, {3.957414900562945*^9, 3.957414935746411*^9}, {
   3.957414973746522*^9, 3.957414980152546*^9}, {3.9574150193795853`*^9, 
   3.95741506744133*^9}, {3.957416447274604*^9, 3.9574164954809213`*^9}, {
   3.957435840700493*^9, 3.95743594235927*^9}, {3.9574359736438913`*^9, 
   3.9574360706704817`*^9}, {3.9574474613136044`*^9, 
   3.9574475090185003`*^9}, {3.9574475492534647`*^9, 3.957447619736079*^9}, {
   3.957447663668516*^9, 3.9574478381018343`*^9}, {3.9578546263423395`*^9, 
   3.9578546288076897`*^9}, {3.957854670749976*^9, 3.9578547227431927`*^9}, {
   3.9578547640494995`*^9, 3.9578547658923798`*^9}, {3.957854811011159*^9, 
   3.957854904417533*^9}, {3.9578549735119658`*^9, 3.9578553081299744`*^9}, {
   3.9578553499301815`*^9, 3.9578554624302416`*^9}, {3.957855497180372*^9, 
   3.95785555303051*^9}, {3.9578556144473734`*^9, 3.9578557373145914`*^9}, {
   3.957855773403411*^9, 3.9578557736976476`*^9}, {3.9578558039143343`*^9, 
   3.957855805106221*^9}, {3.9578558373667564`*^9, 3.9578558376073055`*^9}, {
   3.9578559140483317`*^9, 3.9578559224147654`*^9}, {3.9578559664485064`*^9, 
   3.957856155248457*^9}, {3.957856193665249*^9, 3.957856217419567*^9}, 
   3.957856264032304*^9, {3.957856316389209*^9, 3.95785641401562*^9}, {
   3.9578567262741365`*^9, 3.957856739588382*^9}, {3.957856860122572*^9, 
   3.957856866545444*^9}, {3.9578569400699825`*^9, 3.957856941303194*^9}, {
   3.957856984864732*^9, 3.9578573664471807`*^9}, {3.9578574562569647`*^9, 
   3.9578575220067368`*^9}, {3.957857564057067*^9, 3.9578575907127438`*^9}, {
   3.9578576475910215`*^9, 3.9578576754622364`*^9}, 3.957857713247381*^9, {
   3.9578577460836163`*^9, 3.9578577499774446`*^9}, 3.957857817510415*^9, {
   3.957857880075225*^9, 3.9578579007872896`*^9}, {3.957857933832339*^9, 
   3.9578579707622256`*^9}, 3.957858162142299*^9, 3.9578581931609163`*^9, {
   3.9578582280164895`*^9, 3.9578582281928453`*^9}, {3.957862649562977*^9, 
   3.957862741484066*^9}, {3.9578627827774057`*^9, 3.957862835495533*^9}, {
   3.957862885703926*^9, 3.957862899323905*^9}, {3.9710179288294926`*^9, 
   3.971017962814144*^9}, 3.9710181210923696`*^9, {3.971018151626167*^9, 
   3.9710181795294056`*^9}, {3.971018261751254*^9, 3.971018415779575*^9}, {
   3.971018636941645*^9, 3.971018641215513*^9}, {3.971018744497385*^9, 
   3.97101879421708*^9}, {3.9710189752010775`*^9, 3.971018995529459*^9}, {
   3.971019051284614*^9, 3.9710191667125177`*^9}, 
   3.9710192166051435`*^9},ExpressionUUID->"175f5933-6c1a-4420-b8b5-\
2d5752e1f224"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>0.95 Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"517029a1-523f-4bc3-8798-2426f8df686a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 836, 14, 151, "Title",ExpressionUUID->"4db28663-3797-4aad-9051-57d37be2ea72"],
Cell[CellGroupData[{
Cell[1441, 40, 667, 18, 77, "Subsection",ExpressionUUID->"a4fc4e13-e07e-4328-8071-ca2be7ce5ce6"],
Cell[2111, 60, 3151, 81, 154, "Input",ExpressionUUID->"1adcc407-6189-4336-93c7-247b715fde44"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5299, 146, 715, 19, 77, "Subsection",ExpressionUUID->"59199799-3ff4-440b-ae1f-3b9ddbaa603d"],
Cell[6017, 167, 9797, 180, 190, "Input",ExpressionUUID->"2d916604-b697-4d67-9f28-a6e2a467ae4e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15851, 352, 757, 19, 77, "Subsection",ExpressionUUID->"4d0b883f-e065-495c-a067-3ce67a53c9fe"],
Cell[16611, 373, 8929, 154, 136, "Input",ExpressionUUID->"175f5933-6c1a-4420-b8b5-2d5752e1f224"]
}, Open  ]]
}, Open  ]]
}
]
*)

