(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    445380,       9331]
NotebookOptionsPosition[    443464,       9288]
NotebookOutlinePosition[    443868,       9304]
CellTagsIndexPosition[    443825,       9301]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Figure S3 - gradient dependence of t_esc (see Sec. S4)", "Section",
 CellChangeTimes->{{3.9710062365501156`*^9, 3.971006251532937*^9}, {
  3.971006854470301*^9, 
  3.971006861108626*^9}},ExpressionUUID->"6d6ab418-5536-4b14-9fde-\
eb1b7ae47925"],

Cell[TextData[{
 "Data format: {film thickness (nm), ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "10"], "[", 
    RowBox[{
     SubscriptBox["t", "esc"], "(", "s", ")"}], "]"}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "0a8c70b1-27ec-477a-9954-c2228d5e651a"],
 "}"
}], "Section",
 CellChangeTimes->{{3.971006568739811*^9, 3.9710066717292285`*^9}, {
  3.9710067562632475`*^9, 
  3.9710067574781466`*^9}},ExpressionUUID->"db752163-ba70-4898-90b0-\
471b75baa474"],

Cell[CellGroupData[{

Cell["\<\
(a) Only the gradient is included (no image potential, no surface effect)\
\>", "Section",
 CellChangeTimes->{{3.9570171298158393`*^9, 3.957017145665162*^9}, {
  3.957080152611906*^9, 3.957080167029992*^9}, {3.957080197719389*^9, 
  3.957080209671468*^9}, {3.957083561411101*^9, 3.9570835966446943`*^9}, {
  3.957088108068791*^9, 3.957088109332756*^9}, {3.9710062448895235`*^9, 
  3.971006260815127*^9}},ExpressionUUID->"04d765f3-d06f-4dee-bcfd-\
7b332d9ea2e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Simulation", " ", "results", " ", "for", " ", "tesc_average", " ", "as", 
     " ", "a", " ", "function", " ", "of", " ", "the", " ", "layer", " ", 
     "thickness"}], ",", " ", 
    RowBox[{
     RowBox[{"without", " ", "gradient", " ", 
      RowBox[{"(", "tabg0", ")"}], " ", "and", " ", "for", " ", "a", " ", 
      "gradient", " ", "of"}], " ", "-", 
     RowBox[{"0.01", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg1", ")"}], " ", "to"}], " ", "-", 
     RowBox[{"0.06", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg6", ")"}]}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabg0", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4.666666666666666`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "11.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "15.166666666666666`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "20.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "25.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "31.666666666666664`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "38.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "46.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "54.166666666666664`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "63.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "72.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "82.66666666666667`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "97.71875`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "105.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "117.16666666666666`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "130.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "143.5`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3.214577414202713`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "7.585624051156782`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "15.226981229389699`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "27.807840982834655`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "47.82516188541632`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "79.00853256845305`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "126.92153401292471`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "199.85451851620408`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "310.1494293911746`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "476.16495275519884`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "725.1904565925959`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "1097.7654161879211`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "1654.0803974890896`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "2483.460257188173`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "4206.179535447353`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "5555.417503356832`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "8285.746105758135`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "12341.027912016752`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "18360.736989345096`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4.269568748997848`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "13.27800263156999`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "35.26259482829754`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "86.32917740771825`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "202.1744668825375`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "461.67680063480094`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "1038.730127147382`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "2316.0119092818827`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "5134.466646199954`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "11340.003587967005`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "24980.75602037066`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "54927.71562853292`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "120608.43967826283`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "264547.202316537`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "678470.8581759707`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "1.2697969991892064`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "2.7794760260552396`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "6.081229527931045`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1.3299986003993893`*^7"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "5.827142070475768`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "24.696412070676622`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "90.66882016001495`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "312.6854083076164`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "1047.6435301300162`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3460.1231655146557`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "11339.53686672941`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "36990.846688339276`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "120308.98962664933`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "390487.3940075377`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1.2655104759244523`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "4.0967003837265093`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "1.325020388202236`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4.282622126708723`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "1.6094776789584324`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "4.4668320169467`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "1.4417182171916876`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "4.651821478940619`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1.500543991750038`*^10"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "8.12671986961557`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "48.12461619650462`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "251.35463253963698`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "1253.0623448599101`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6126.990425314936`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "29678.670096557198`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "143005.0105388839`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "686782.094651906`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "3.2908729567403696`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "1.5743708046178913`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "7.522934765699239`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "3.591489807788722`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "1.7133874264910707`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "8.169451608284963`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "4.427931690338189`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "1.854860926718185`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "8.83388990839629`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "4.2057282104406846`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "2.00162159489372`*^13"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg5", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11.521781907066895`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "97.0348903204449`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "733.2375494730135`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5345.92060487471`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "38411.20603019503`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "273953.08632630564`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "1.9453405166913052`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "1.3774791855190061`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "9.734825286304876`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "6.870103232931607`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "4.843359075131342`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "3.4118132550440357`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "2.4018883357135468`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "1.6900752988156274`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "1.3156329747556402`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "8.354599175098452`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "5.858876563347235`*^14"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg6", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "16.534200379038058`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "200.4614385913881`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2211.9095278716172`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "23702.443988742478`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "250871.3990345851`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "2.6379165982258627`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "2.762803294914331`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "2.886116602741917`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "3.009547087405795`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "3.1342206009722565`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "3.2609319427893823`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "3.390208403629478`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "3.521819934039627`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "3.651115583232526`*^14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "4.0042817924329175`*^15"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9570179772619314`*^9, 3.9570180953308115`*^9}, {
   3.957018130955658*^9, 3.957018215682221*^9}, {3.9570182483795967`*^9, 
   3.9570182498622723`*^9}, {3.9570182837986765`*^9, 
   3.9570182852908335`*^9}, {3.957018322219037*^9, 3.9570183250144663`*^9}, {
   3.957018363945951*^9, 3.9570183681405325`*^9}, {3.957018442196556*^9, 
   3.957018610886937*^9}, {3.9570186496028247`*^9, 3.9570187244844*^9}, {
   3.957018765810251*^9, 3.9570188498960905`*^9}, {3.957018918296104*^9, 
   3.9570189374221983`*^9}, {3.957019000142621*^9, 3.957019223719556*^9}, {
   3.9570192658838415`*^9, 3.9570193388030453`*^9}, {3.957019606873952*^9, 
   3.9570196071413164`*^9}, {3.9570196888161397`*^9, 3.957019689036353*^9}, {
   3.957019734845105*^9, 3.9570197589959383`*^9}, {3.9570197952984085`*^9, 
   3.9570197971588607`*^9}, {3.957019838683606*^9, 3.957019985227247*^9}, {
   3.957020038838397*^9, 3.9570201283874245`*^9}, 3.957020197149083*^9, {
   3.9570204733372583`*^9, 3.957020500620798*^9}, {3.9570205509616127`*^9, 
   3.95702066161045*^9}, {3.957020692895506*^9, 3.957020708878168*^9}, {
   3.9570207595181*^9, 3.9570208497017155`*^9}, {3.957020888824114*^9, 
   3.957020889060049*^9}, {3.9570209951649275`*^9, 3.9570210101170444`*^9}, {
   3.9570210550686293`*^9, 3.9570210588326006`*^9}, {3.9570210907714324`*^9, 
   3.957021265128262*^9}, {3.957021371426813*^9, 3.9570214149432645`*^9}, {
   3.9570214602954516`*^9, 3.9570214916352696`*^9}, {3.9570218346690845`*^9, 
   3.957021883427083*^9}, {3.957021916297*^9, 3.9570220552469535`*^9}, {
   3.9570221070400944`*^9, 3.957022185042626*^9}, {3.957022259364053*^9, 
   3.957022310992408*^9}, {3.9570224069747143`*^9, 3.9570226593058558`*^9}, {
   3.957022690348491*^9, 3.9570229809182606`*^9}, {3.9570803458809958`*^9, 
   3.9570804160235357`*^9}, 3.9570804900867395`*^9, 3.9570805508265257`*^9, {
   3.9570807836844387`*^9, 3.957080790237952*^9}, 3.9570808381222596`*^9, {
   3.957080879397051*^9, 3.9570808860910635`*^9}, {3.9570809282777843`*^9, 
   3.9570809451037183`*^9}, {3.957081122125296*^9, 3.9570811981441336`*^9}, {
   3.957081292736041*^9, 3.957081326686044*^9}, {3.9570816413830557`*^9, 
   3.9570817312476215`*^9}, {3.9570818055953684`*^9, 
   3.9570818835880594`*^9}, {3.9570826015912066`*^9, 
   3.9570826843652077`*^9}, {3.9570834465178623`*^9, 
   3.9570834564388247`*^9}, {3.9570835870720224`*^9, 3.957083606433529*^9}, 
   3.957086703684191*^9, 3.9570867426678734`*^9, 3.9570880402176228`*^9, 
   3.957089705844701*^9, {3.9571576365028973`*^9, 3.957157637180953*^9}, {
   3.9710063078863835`*^9, 3.9710063832134285`*^9}, 
   3.971006543140801*^9},ExpressionUUID->"d0018850-ab64-4461-94e5-\
df8544c105f1"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcPKrJMPoq0eQMU5HJbsutD9WOMNlC/g
oMb1v/TP609QvojD6W4mFX/p71C+hEOzx/6C+/d/QfkyDo/E4zPux/yD8hUc
fkzOCOK6wuAA4Ss55M/n23UnnQnKV3Hw1Pt6ZM87ZihfzUHw9FdRnhxWKF/D
IZ/babPJIzYoX8thpQjf6m9BHFC+joP7K485s/ZzQvl6Drds9h0U1uSG8g0c
2gRvP97xlwfKN3RYsfsWu95XXijfyOH7t6P2+yL4oXxjh4QNnibdsQJQvonD
oVcVppZ8gg4AQDlQ2w==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcPKrJMPoq0eQMU5HJbsutD9WOMNlC/g
oMb1v/TP609QvojD6W4mFX/p71C+hEOzx/6C+/d/QfkyDo/E4zPux/yD8hUc
fkzOCOK6wuAA4Ss55M/n23UnnQnKV3Hw1Pt6ZM87ZihfzUHw9FdRnhxWKF/D
IZ/babPJIzYoX8thpQjf6m9BHFC+joP7K485s/ZzQvl6Drds9h0U1uSG8g0c
2gRvP97xlwfKN3RYsfsWu95XXijfyOH7t6P2+yL4oXxjh4QNnibdsQJQvonD
oVcVppZ8gg4AQDlQ2w==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
            "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
           "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcPKrJMPoq0eQMU5HJbsutD9WOMNlC/g
oMb1v/TP609QvojD6W4mFX/p71C+hEOzx/6C+/d/QfkyDo/E4zPux/yD8hUc
fkzOCOK6wuAA4Ss55M/n23UnnQnKV3Hw1Pt6ZM87ZihfzUHw9FdRnhxWKF/D
IZ/babPJIzYoX8thpQjf6m9BHFC+joP7K485s/ZzQvl6Drds9h0U1uSG8g0c
2gRvP97xlwfKN3RYsfsWu95XXijfyOH7t6P2+yL4oXxjh4QNnibdsQJQvonD
oVcVppZ8gg4AQDlQ2w==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
         "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVxXk4lHkAB/DRuBqDV9dqhRlN1NBkeiux1e9b9kmIzWJ7orQm1+Zo2RRS
jqjooLIRTZOsdtWTjh27UUkocu3jrkjlKiPEmDRG7O4fn+fDFe373n8Wg8Fw
+c//i4+INIV+ORve1zCdPbsGSGUzZ+t2TjQZ2z3T1NI/QGaelh7lcFKIanzS
y2NkgIjLTptqcC4SfdOxve4MGQlZHxk6YVpA1vzyJtXNTEaaVUEZH02LSbLR
wxqXABnR6ui2GDJ9RrghB5w2D8tIbo0kfND0BdmhO+BoMz1ICm+ldIQIZETw
wrjvufMwCSSNFz9EyElJYkktbfuRhPUt65EWKsmvMQVP5zmMEhY3yeL1Wga4
NmVprcFj5AxVy8/9kYl3i4N62YflRNTh8YhZp4ndrTZavPxxEv4kSbTPgoVT
72tqW6oU5M7PbHdDR12MW44YTbV9IrmHgmXW2ynorfrGjvllgiRKptzGPxhA
FGLYG6+vJIzmN3gQMxchmsUrshZNEvP9AVEe/PlY6p/gmAYV6VVk/qDzcAEW
jb8cnto2RZz69h4+F26IcoedIqeoL8S1N93SxORrcL9cOSjMniayClF89U0j
3Os+YJj2xwwRGLQZ2+82RvzmEvv+AAZYROHbKTfB4z/VNpaNMOAw5DVh5snB
TuauJawkNTwv91PzsuKikZn98sr8WSg6UenDUXCx55KkNUI8CwEakW8aGszg
+lXx31JrJvZEHCpiZy+GJz/ntbCEiRWBlg1bfXmwHfZ5roI6/pljpRNpuwSR
GWvurW5Wx/3CxBwrpjnqm9peXffWwCE1/ra6V+aIk6fK0kY0wOqM2RImtYDO
E07143hN9F3jZkhil6JIEDco0NZCxtKF6sWey3AvZlShk6OF9OyAKl8OHy98
rDbzeNrwytjVwH7HR7N8S2DKdW18/jZfKSm1hEVw9D6fdbPR07cpqvy4FbJi
Ih6GVc7G1fVCo3rf5fANiRsb3s7CzeRIg8DlAjh88gi9/paF4557nJkKAVhC
dvHdIB2s7swtOF6/AjzX9kG+SgdZy3Ju1jtbw5sZ7Nd1lI24stNZzsXW+JA9
p1LNUBcuRp75NTwhdvTkjIcX6GJjWJW3QYoQbyuG9hoL9SBZJOLVKYQoP+Ze
vbZSD7yK3y+4eq9E2duE4DQXfaQvL+c3la5E9tDZ1ytb9BEgV298xqfRP+Rl
vJimILozxklJo6ErbAx1OkghJNF9yuksjeCkc49ioihEukvb2edpVLe7G9yI
pnBCEXkm/QKNhCNtUp1YCoW2SlWmmMan2g5VXTwF5eOZtms3aHQF9Kd8l0oh
vYl9urKKxq1LqnwPMYXsvNCgY89osD8+mEi6TCFvf4P9lloaP9kfcSySUPhr
QfpkbQMNnowxNP8qhU6vuUHNrTSybDRXtV+jYNGz0L67h0Z8E1W+4zYFa2mM
yW99NF4taZqbeoeCXXKH0v8dDdvo8/4ldylstRDfHpDRGDddMNuoiEJEMMdk
dJRGUKjRts5iCrHrEpR35TSelHXmsu9TSNbtbtmvoGE277J83QMKWbfyTn7+
TKOzhJMpLqVwNV49sGSShp1e9/v6RxRuuPlvip2ikembZzddRkFq9tR4wzQN
udTvlKCcQqncXDkzQ8NN27zLp4LCvzPhMew=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Line[CompressedData["
1:eJwVxXk4lHkAB/DRuBqDV9dqhRlN1NBkeiux1e9b9kmIzWJ7orQm1+Zo2RRS
jqjooLIRTZOsdtWTjh27UUkocu3jrkjlKiPEmDRG7O4fn+fDFe373n8Wg8Fw
+c//i4+INIV+ORve1zCdPbsGSGUzZ+t2TjQZ2z3T1NI/QGaelh7lcFKIanzS
y2NkgIjLTptqcC4SfdOxve4MGQlZHxk6YVpA1vzyJtXNTEaaVUEZH02LSbLR
wxqXABnR6ui2GDJ9RrghB5w2D8tIbo0kfND0BdmhO+BoMz1ICm+ldIQIZETw
wrjvufMwCSSNFz9EyElJYkktbfuRhPUt65EWKsmvMQVP5zmMEhY3yeL1Wga4
NmVprcFj5AxVy8/9kYl3i4N62YflRNTh8YhZp4ndrTZavPxxEv4kSbTPgoVT
72tqW6oU5M7PbHdDR12MW44YTbV9IrmHgmXW2ynorfrGjvllgiRKptzGPxhA
FGLYG6+vJIzmN3gQMxchmsUrshZNEvP9AVEe/PlY6p/gmAYV6VVk/qDzcAEW
jb8cnto2RZz69h4+F26IcoedIqeoL8S1N93SxORrcL9cOSjMniayClF89U0j
3Os+YJj2xwwRGLQZ2+82RvzmEvv+AAZYROHbKTfB4z/VNpaNMOAw5DVh5snB
TuauJawkNTwv91PzsuKikZn98sr8WSg6UenDUXCx55KkNUI8CwEakW8aGszg
+lXx31JrJvZEHCpiZy+GJz/ntbCEiRWBlg1bfXmwHfZ5roI6/pljpRNpuwSR
GWvurW5Wx/3CxBwrpjnqm9peXffWwCE1/ra6V+aIk6fK0kY0wOqM2RImtYDO
E07143hN9F3jZkhil6JIEDco0NZCxtKF6sWey3AvZlShk6OF9OyAKl8OHy98
rDbzeNrwytjVwH7HR7N8S2DKdW18/jZfKSm1hEVw9D6fdbPR07cpqvy4FbJi
Ih6GVc7G1fVCo3rf5fANiRsb3s7CzeRIg8DlAjh88gi9/paF4557nJkKAVhC
dvHdIB2s7swtOF6/AjzX9kG+SgdZy3Ju1jtbw5sZ7Nd1lI24stNZzsXW+JA9
p1LNUBcuRp75NTwhdvTkjIcX6GJjWJW3QYoQbyuG9hoL9SBZJOLVKYQoP+Ze
vbZSD7yK3y+4eq9E2duE4DQXfaQvL+c3la5E9tDZ1ytb9BEgV298xqfRP+Rl
vJimILozxklJo6ErbAx1OkghJNF9yuksjeCkc49ioihEukvb2edpVLe7G9yI
pnBCEXkm/QKNhCNtUp1YCoW2SlWmmMan2g5VXTwF5eOZtms3aHQF9Kd8l0oh
vYl9urKKxq1LqnwPMYXsvNCgY89osD8+mEi6TCFvf4P9lloaP9kfcSySUPhr
QfpkbQMNnowxNP8qhU6vuUHNrTSybDRXtV+jYNGz0L67h0Z8E1W+4zYFa2mM
yW99NF4taZqbeoeCXXKH0v8dDdvo8/4ldylstRDfHpDRGDddMNuoiEJEMMdk
dJRGUKjRts5iCrHrEpR35TSelHXmsu9TSNbtbtmvoGE277J83QMKWbfyTn7+
TKOzhJMpLqVwNV49sGSShp1e9/v6RxRuuPlvip2ikembZzddRkFq9tR4wzQN
udTvlKCcQqncXDkzQ8NN27zLp4LCvzPhMew=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Line[CompressedData["
1:eJwVxXk4lHkAB/DRuBqDV9dqhRlN1NBkeiux1e9b9kmIzWJ7orQm1+Zo2RRS
jqjooLIRTZOsdtWTjh27UUkocu3jrkjlKiPEmDRG7O4fn+fDFe373n8Wg8Fw
+c//i4+INIV+ORve1zCdPbsGSGUzZ+t2TjQZ2z3T1NI/QGaelh7lcFKIanzS
y2NkgIjLTptqcC4SfdOxve4MGQlZHxk6YVpA1vzyJtXNTEaaVUEZH02LSbLR
wxqXABnR6ui2GDJ9RrghB5w2D8tIbo0kfND0BdmhO+BoMz1ICm+ldIQIZETw
wrjvufMwCSSNFz9EyElJYkktbfuRhPUt65EWKsmvMQVP5zmMEhY3yeL1Wga4
NmVprcFj5AxVy8/9kYl3i4N62YflRNTh8YhZp4ndrTZavPxxEv4kSbTPgoVT
72tqW6oU5M7PbHdDR12MW44YTbV9IrmHgmXW2ynorfrGjvllgiRKptzGPxhA
FGLYG6+vJIzmN3gQMxchmsUrshZNEvP9AVEe/PlY6p/gmAYV6VVk/qDzcAEW
jb8cnto2RZz69h4+F26IcoedIqeoL8S1N93SxORrcL9cOSjMniayClF89U0j
3Os+YJj2xwwRGLQZ2+82RvzmEvv+AAZYROHbKTfB4z/VNpaNMOAw5DVh5snB
TuauJawkNTwv91PzsuKikZn98sr8WSg6UenDUXCx55KkNUI8CwEakW8aGszg
+lXx31JrJvZEHCpiZy+GJz/ntbCEiRWBlg1bfXmwHfZ5roI6/pljpRNpuwSR
GWvurW5Wx/3CxBwrpjnqm9peXffWwCE1/ra6V+aIk6fK0kY0wOqM2RImtYDO
E07143hN9F3jZkhil6JIEDco0NZCxtKF6sWey3AvZlShk6OF9OyAKl8OHy98
rDbzeNrwytjVwH7HR7N8S2DKdW18/jZfKSm1hEVw9D6fdbPR07cpqvy4FbJi
Ih6GVc7G1fVCo3rf5fANiRsb3s7CzeRIg8DlAjh88gi9/paF4557nJkKAVhC
dvHdIB2s7swtOF6/AjzX9kG+SgdZy3Ju1jtbw5sZ7Nd1lI24stNZzsXW+JA9
p1LNUBcuRp75NTwhdvTkjIcX6GJjWJW3QYoQbyuG9hoL9SBZJOLVKYQoP+Ze
vbZSD7yK3y+4eq9E2duE4DQXfaQvL+c3la5E9tDZ1ytb9BEgV298xqfRP+Rl
vJimILozxklJo6ErbAx1OkghJNF9yuksjeCkc49ioihEukvb2edpVLe7G9yI
pnBCEXkm/QKNhCNtUp1YCoW2SlWmmMan2g5VXTwF5eOZtms3aHQF9Kd8l0oh
vYl9urKKxq1LqnwPMYXsvNCgY89osD8+mEi6TCFvf4P9lloaP9kfcSySUPhr
QfpkbQMNnowxNP8qhU6vuUHNrTSybDRXtV+jYNGz0L67h0Z8E1W+4zYFa2mM
yW99NF4taZqbeoeCXXKH0v8dDdvo8/4ldylstRDfHpDRGDddMNuoiEJEMMdk
dJRGUKjRts5iCrHrEpR35TSelHXmsu9TSNbtbtmvoGE277J83QMKWbfyTn7+
TKOzhJMpLqVwNV49sGSShp1e9/v6RxRuuPlvip2ikembZzddRkFq9tR4wzQN
udTvlKCcQqncXDkzQ8NN27zLp4LCvzPhMew=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0.8, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUOK41MxaZ0nUHEOhzMF/7mjfnyE8gUc
zD1vzzpz8AeUL+LAp/8rpeHXPyhfwsGtxmmRQhGTA4Qv4zA5+U35hABWKF/B
QW32Cr0zihxQvpJDGO9L87+vuKB8FYevDI91JdbzQvlqDiw7XFvfmAtA+RoO
634ueaU6XRDK13L4n7/hZfdXIShfx2GRyfs1IcEiUL6ew2X136uXbBCF8g0c
nPJlXtUEi0P5hg7qqqeCLLMkoHwjB1EuPot5xyShfGOHG/M/Lj6nJA3lmzho
lznduFQn4wAAJ1dNmQ==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUOK41MxaZ0nUHEOhzMF/7mjfnyE8gUc
zD1vzzpz8AeUL+LAp/8rpeHXPyhfwsGtxmmRQhGTA4Qv4zA5+U35hABWKF/B
QW32Cr0zihxQvpJDGO9L87+vuKB8FYevDI91JdbzQvlqDiw7XFvfmAtA+RoO
634ueaU6XRDK13L4n7/hZfdXIShfx2GRyfs1IcEiUL6ew2X136uXbBCF8g0c
nPJlXtUEi0P5hg7qqqeCLLMkoHwjB1EuPot5xyShfGOHG/M/Lj6nJA3lmzho
lznduFQn4wAAJ1dNmQ==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0.8, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUOK41MxaZ0nUHEOhzMF/7mjfnyE8gUc
zD1vzzpz8AeUL+LAp/8rpeHXPyhfwsGtxmmRQhGTA4Qv4zA5+U35hABWKF/B
QW32Cr0zihxQvpJDGO9L87+vuKB8FYevDI91JdbzQvlqDiw7XFvfmAtA+RoO
634ueaU6XRDK13L4n7/hZfdXIShfx2GRyfs1IcEiUL6ew2X136uXbBCF8g0c
nPJlXtUEi0P5hg7qqqeCLLMkoHwjB1EuPot5xyShfGOHG/M/Lj6nJA3lmzho
lznduFQn4wAAJ1dNmQ==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0.8, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0.8, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV0vs/1XcAx3G3tI6jOZRwvjjHhBCObz2Whc87KpXo4q7HlEuU0DSqoYYS
puxsmUKSW7KicOhxuphy66DTdESLmRyyiZV04qCdbT+8Hs9/4MUNObx7v4qS
kpLHf/1v4ckQdV5YgbM0YGBEZ6OEtEg42/043xBGdYeadriEKNoaT3E4mYSn
IjTVypCQwqZzxos4eST555/CmF0SEuUUHz1jXEmoec8RNe8eIpk/kPPWWEh8
Lj2QykKfkcX9w+aTxiLSNnh1uO9UHynuKIp9bfwbuRYaO1TQ3E+qb2b2R9mM
k6StJWasE8MkgnTnTRyZJholO7NsOl6RmNFVUkG1nBxNYR6rVX5NGNzT5n+s
U0L51xEF9TlvSLZWp2XxPlUEnVc9JpqYIiH93r+odqnD40PJvRnH9yS29XTI
YXMGKinRpoDUD6TmK6aX3lZNJJayXlVcmSXFiYfG7fy0UFVXadIwMUdSixZ2
vZ9gwds07GgN6yNRkgzhXoIODvqXaw5ZKYhZXPhxb8vleMso4IwJlTAiu+Cr
cV8Xo3nvW707lLFtNPLEj7F6ODsZ71AypQLPEb6VkZEBxkvueGbqqGG8OST5
URUbKRn8N6+4i2DD6jV03WuIDvvsIFM3dTCILHhg2gjumoYBz/0Xw20ycMbE
h4PkGxJuVMoneP4wTDnQmovIKo+zeWVLUJ/REsSRcZE96J/qJGAgfFH8kFhs
gtCerM0PXmgg9EhiPTP/M8TN7ci9O8mEbYSVeHuwKdal9qXvmNfEE21rjXiH
lagVn3FrNv4Ud6tTC6xVzVBTHiry1dNCorLlzq7fzRDatqJ3/Q0tMAYStsQI
zPH2QlVdtBMLo1e5OUVJFshXZva9aGEhx0JfTeizCpc8Tr687acNfn54ezDH
Evd4Qt6vQ9oIzPlSzByzxO22Z7vXRuhgdmO5vKjRChrO6nsYch1IR12OP0y3
RqKH4ppByjKUOPHYj4NXYxNhDuYvW46qtHhWxGobWIte+vteXo50n1B3VZkN
/lbNKwtaqYu1A8WV6Y9tsYQb1td7WxcXVxVUPXa3A3pndnyHFfi26dxFd6Ed
uqOLblb1rIAH26e8w5QHxwaLIcNwPWyIad/DyuShNTfBVzSphyIqxLRLxkN5
wFDdSLI+TJsrcj332KNMsNRvPcMA/NUPLZ822uNEk1HnIN8A4dNq3SJLGreq
XczembARUvOOk/k9DcUa23ZcZyMq1Wth2w80hP01kcX/fRDvJehjnqcRl7pm
qcotNjJk8dn8XBp/PnHwaRawUe0gn79QSKM7cqN0UyMb8geK3qvXaRRdCVBs
62aD/5R5rqWdhgvz9Oc+M2zkl0YfOCOi8bFWvb9ezkZpnNh1SyeN+oDMk7oL
bDTo8uc6xTQsK7Jb+5QoDATqHJA8o7HMJc8rkEHBXKrvOiylMXKs+vBeQwp2
ggSjslEal414Ok3GFL5I65fvH6Ph11rXwDGhsN288NZf4zQ6tIUfX5pROHKI
YzQ1RaOuqjkrzI5CkmOKvHaaRoz3ZttWewppmsM9cTIaFvOPnq5cS+HizdKs
2Vkal7aI9cccKJQkq0XcmaPh/2bnfTdHCtd37XdJWqChlSvZd82ZgsCkzdD5
HxoiR1+1JRsoNE6byRUKGmnS5xUHXSn8C605KWY=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Line[CompressedData["
1:eJwV0vs/1XcAx3G3tI6jOZRwvjjHhBCObz2Whc87KpXo4q7HlEuU0DSqoYYS
puxsmUKSW7KicOhxuphy66DTdESLmRyyiZV04qCdbT+8Hs9/4MUNObx7v4qS
kpLHf/1v4ckQdV5YgbM0YGBEZ6OEtEg42/043xBGdYeadriEKNoaT3E4mYSn
IjTVypCQwqZzxos4eST555/CmF0SEuUUHz1jXEmoec8RNe8eIpk/kPPWWEh8
Lj2QykKfkcX9w+aTxiLSNnh1uO9UHynuKIp9bfwbuRYaO1TQ3E+qb2b2R9mM
k6StJWasE8MkgnTnTRyZJholO7NsOl6RmNFVUkG1nBxNYR6rVX5NGNzT5n+s
U0L51xEF9TlvSLZWp2XxPlUEnVc9JpqYIiH93r+odqnD40PJvRnH9yS29XTI
YXMGKinRpoDUD6TmK6aX3lZNJJayXlVcmSXFiYfG7fy0UFVXadIwMUdSixZ2
vZ9gwds07GgN6yNRkgzhXoIODvqXaw5ZKYhZXPhxb8vleMso4IwJlTAiu+Cr
cV8Xo3nvW707lLFtNPLEj7F6ODsZ71AypQLPEb6VkZEBxkvueGbqqGG8OST5
URUbKRn8N6+4i2DD6jV03WuIDvvsIFM3dTCILHhg2gjumoYBz/0Xw20ycMbE
h4PkGxJuVMoneP4wTDnQmovIKo+zeWVLUJ/REsSRcZE96J/qJGAgfFH8kFhs
gtCerM0PXmgg9EhiPTP/M8TN7ci9O8mEbYSVeHuwKdal9qXvmNfEE21rjXiH
lagVn3FrNv4Ud6tTC6xVzVBTHiry1dNCorLlzq7fzRDatqJ3/Q0tMAYStsQI
zPH2QlVdtBMLo1e5OUVJFshXZva9aGEhx0JfTeizCpc8Tr687acNfn54ezDH
Evd4Qt6vQ9oIzPlSzByzxO22Z7vXRuhgdmO5vKjRChrO6nsYch1IR12OP0y3
RqKH4ppByjKUOPHYj4NXYxNhDuYvW46qtHhWxGobWIte+vteXo50n1B3VZkN
/lbNKwtaqYu1A8WV6Y9tsYQb1td7WxcXVxVUPXa3A3pndnyHFfi26dxFd6Ed
uqOLblb1rIAH26e8w5QHxwaLIcNwPWyIad/DyuShNTfBVzSphyIqxLRLxkN5
wFDdSLI+TJsrcj332KNMsNRvPcMA/NUPLZ822uNEk1HnIN8A4dNq3SJLGreq
XczembARUvOOk/k9DcUa23ZcZyMq1Wth2w80hP01kcX/fRDvJehjnqcRl7pm
qcotNjJk8dn8XBp/PnHwaRawUe0gn79QSKM7cqN0UyMb8geK3qvXaRRdCVBs
62aD/5R5rqWdhgvz9Oc+M2zkl0YfOCOi8bFWvb9ezkZpnNh1SyeN+oDMk7oL
bDTo8uc6xTQsK7Jb+5QoDATqHJA8o7HMJc8rkEHBXKrvOiylMXKs+vBeQwp2
ggSjslEal414Ok3GFL5I65fvH6Ph11rXwDGhsN288NZf4zQ6tIUfX5pROHKI
YzQ1RaOuqjkrzI5CkmOKvHaaRoz3ZttWewppmsM9cTIaFvOPnq5cS+HizdKs
2Vkal7aI9cccKJQkq0XcmaPh/2bnfTdHCtd37XdJWqChlSvZd82ZgsCkzdD5
HxoiR1+1JRsoNE6byRUKGmnS5xUHXSn8C605KWY=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0.8, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Line[CompressedData["
1:eJwV0vs/1XcAx3G3tI6jOZRwvjjHhBCObz2Whc87KpXo4q7HlEuU0DSqoYYS
puxsmUKSW7KicOhxuphy66DTdESLmRyyiZV04qCdbT+8Hs9/4MUNObx7v4qS
kpLHf/1v4ckQdV5YgbM0YGBEZ6OEtEg42/043xBGdYeadriEKNoaT3E4mYSn
IjTVypCQwqZzxos4eST555/CmF0SEuUUHz1jXEmoec8RNe8eIpk/kPPWWEh8
Lj2QykKfkcX9w+aTxiLSNnh1uO9UHynuKIp9bfwbuRYaO1TQ3E+qb2b2R9mM
k6StJWasE8MkgnTnTRyZJholO7NsOl6RmNFVUkG1nBxNYR6rVX5NGNzT5n+s
U0L51xEF9TlvSLZWp2XxPlUEnVc9JpqYIiH93r+odqnD40PJvRnH9yS29XTI
YXMGKinRpoDUD6TmK6aX3lZNJJayXlVcmSXFiYfG7fy0UFVXadIwMUdSixZ2
vZ9gwds07GgN6yNRkgzhXoIODvqXaw5ZKYhZXPhxb8vleMso4IwJlTAiu+Cr
cV8Xo3nvW707lLFtNPLEj7F6ODsZ71AypQLPEb6VkZEBxkvueGbqqGG8OST5
URUbKRn8N6+4i2DD6jV03WuIDvvsIFM3dTCILHhg2gjumoYBz/0Xw20ycMbE
h4PkGxJuVMoneP4wTDnQmovIKo+zeWVLUJ/REsSRcZE96J/qJGAgfFH8kFhs
gtCerM0PXmgg9EhiPTP/M8TN7ci9O8mEbYSVeHuwKdal9qXvmNfEE21rjXiH
lagVn3FrNv4Ud6tTC6xVzVBTHiry1dNCorLlzq7fzRDatqJ3/Q0tMAYStsQI
zPH2QlVdtBMLo1e5OUVJFshXZva9aGEhx0JfTeizCpc8Tr687acNfn54ezDH
Evd4Qt6vQ9oIzPlSzByzxO22Z7vXRuhgdmO5vKjRChrO6nsYch1IR12OP0y3
RqKH4ppByjKUOPHYj4NXYxNhDuYvW46qtHhWxGobWIte+vteXo50n1B3VZkN
/lbNKwtaqYu1A8WV6Y9tsYQb1td7WxcXVxVUPXa3A3pndnyHFfi26dxFd6Ed
uqOLblb1rIAH26e8w5QHxwaLIcNwPWyIad/DyuShNTfBVzSphyIqxLRLxkN5
wFDdSLI+TJsrcj332KNMsNRvPcMA/NUPLZ822uNEk1HnIN8A4dNq3SJLGreq
XczembARUvOOk/k9DcUa23ZcZyMq1Wth2w80hP01kcX/fRDvJehjnqcRl7pm
qcotNjJk8dn8XBp/PnHwaRawUe0gn79QSKM7cqN0UyMb8geK3qvXaRRdCVBs
62aD/5R5rqWdhgvz9Oc+M2zkl0YfOCOi8bFWvb9ezkZpnNh1SyeN+oDMk7oL
bDTo8uc6xTQsK7Jb+5QoDATqHJA8o7HMJc8rkEHBXKrvOiylMXKs+vBeQwp2
ggSjslEal414Ok3GFL5I65fvH6Ph11rXwDGhsN288NZf4zQ6tIUfX5pROHKI
YzQ1RaOuqjkrzI5CkmOKvHaaRoz3ZttWewppmsM9cTIaFvOPnq5cS+HizdKs
2Vkal7aI9cccKJQkq0XcmaPh/2bnfTdHCtd37XdJWqChlSvZd82ZgsCkzdD5
HxoiR1+1JRsoNE6byRUKGmnS5xUHXSn8C605KWY=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 1, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOjlGUH59S9gIpzOLC3cxZZeXyD8gUc
sh57Fu4P/A/liziUcpj+/vWV2QHCl3D48u/4tlRNDihfxiHeWMaGP4AHyldw
WNey8+pzcwEoX8lhEZdd4y5XIShfxaFY79kKyyARKF/NIXT+W6tzsWJQvobD
s8RPkTsyJKB8LQfz9bM/KxZLQfk6DjH7zV6q18pA+XoOd9iV39xrk4PyDRzC
zsbNuZSpAOUbOrRc4T9wxkcRyjdyMD4pczQiUAnKN3bYOeHR+kuhylC+icPH
V5JutlEqDgCg2k3G
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOjlGUH59S9gIpzOLC3cxZZeXyD8gUc
sh57Fu4P/A/liziUcpj+/vWV2QHCl3D48u/4tlRNDihfxiHeWMaGP4AHyldw
WNey8+pzcwEoX8lhEZdd4y5XIShfxaFY79kKyyARKF/NIXT+W6tzsWJQvobD
s8RPkTsyJKB8LQfz9bM/KxZLQfk6DjH7zV6q18pA+XoOd9iV39xrk4PyDRzC
zsbNuZSpAOUbOrRc4T9wxkcRyjdyMD4pczQiUAnKN3bYOeHR+kuhylC+icPH
V5JutlEqDgCg2k3G
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 1, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOjlGUH59S9gIpzOLC3cxZZeXyD8gUc
sh57Fu4P/A/liziUcpj+/vWV2QHCl3D48u/4tlRNDihfxiHeWMaGP4AHyldw
WNey8+pzcwEoX8lhEZdd4y5XIShfxaFY79kKyyARKF/NIXT+W6tzsWJQvobD
s8RPkTsyJKB8LQfz9bM/KxZLQfk6DjH7zV6q18pA+XoOd9iV39xrk4PyDRzC
zsbNuZSpAOUbOrRc4T9wxkcRyjdyMD4pczQiUAnKN3bYOeHR+kuhylC+icPH
V5JutlEqDgCg2k3G
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 1, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 1, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwV0Hk4lAkAx/HJVStCSq65zJtpBsN4Hxue8v5KpZCtZWpjOwxGW+6nIUfH
yl0yLbl6LGrpHrG0z7RFYUOuLUo9Y7cex3pMx2Kah5HN7v7xfT7/f9ni2K8j
dGg02s7/+t+Kk2IDYfglL9fcAqvCykKqfYDlv5eVTKmjJtZI+oupxcfNZ1is
XOrcLsrCY7GMqniYz9RnlVEzZ5NyY52rqKiN0uhZ5nVqSyA3a3VBLTXw6XDR
FFNBfYxra3G5Wk8tVY5w3zO7qNJFO0WapJmqflIZ/5b5ikpYMS3Km+mm5HW5
yiiBiiID3PpWdCupSOpp2bsENfW3A+skuW+MihnnjTbKtZTJJ8XB5FsqypCd
wX3tToMjyV5+qn2KOm/aza8+pIuTWssv1s6pKbEyqEW3xwCjxjnxR+Jmqfjf
MsSxXENE+2xqSXs5T9XHGQVa7jBGrZm8bkb/M1WdelTlstcU86t26OvdpyG9
cmH3x3dmSJpclfFwrw5oA29wP8UcWb9nSsPe6sL+mOR4EH81qg642u6p1seY
pmTP8gcWMGlyL5r3WArf8SMnfoi3RG5DyqMPH5chYEzmwGBY42JraGjXVUOo
2sSnO2/bYK788jPRRiMIzF7QvQ/SIbFmaoUaYxhSmtBhNQM8sWaqpcAEPu+D
Z+1ELKRe0+0PqDXFy9bwJcGObDjwXv9557QZmnLaD7A0bCw9Hzl01H8lJPrS
N319doh8nH8jgGeOsITUJqNyDmZGDknyZs3hHOnQ5x9KoCMnK0TxaBX6Vzou
l3qsBVvH18G0YjV+ladfctS1R+3Be6Mt31kgdQl/V88f9qiXdSaW+KyB4XDK
9phGLvT8eN5itiXGa9lFlWnrkD755VzmO0sUrbPSU4h4yAoZyX7aaQVZuaQj
lMXH3XpPWmKxNYKL9vcZTfAhuDBeb3zovw9barSVzQ5w2CLw6vW0xej45uOt
2Y4QKTk/jxvQcXmj0KY31Am6237RsR+j43am1CzSSYDholnPlgYGskVhfroa
AWjRebf8TjDhNlx9PbvXGUHn9i+ccmShlHfpdq+fC7yCeooNClk49TC/1E/h
gkn9PAZbh42dNqKaJ4QQngtTm91i2dgU0xFilitEVbhcqRlko9JWTPRohOi8
ey/U19sORNvV4oAQVyxLpX/rd8MOMqdW/rNmV7w9w1NvNeFAotZ72sUnIUvM
SBpM40BcP8PKLSDhr3SLMxnlICo9cMH3AolvXg6phsY4kAY2DhkVkgh/nhxR
9RcHORrpeVkxidT+B8FCFQdyD+2nkgoS19u2bg2c5kD7aPFF7U0SBrdE1iWL
HMieGeW3d5BoTpO2M2wJlF+JPpzVRaI7eQ01QSdw5Vif9/ZuEi8SFYo6JoG7
FrL57j4SH+L+kYNDYDjY/PDAcxI2EZllYj4B7qiV98goiaSdF2Nq3Qm4NKYw
fhonke67fjLGk4BnplIbMUGiwOdV2PoNBPy5FXcmVSRqNtH3dVIEEo6yGNPT
JAbdarxV2wikbfhe26Am8cbVp7lhO4FM45HBYxoSKudJ91RfAqV1V87OzZHQ
4TsJjAIIXD6tF3lvnsQKbv+1wa8I3NwdsTltgYQVEc+p2E2g0e4x3eszCYJt
/mNEIIFmtb12cZGEkNFkKRAR+Bf8xhoD
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Line[CompressedData["
1:eJwV0Hk4lAkAx/HJVStCSq65zJtpBsN4Hxue8v5KpZCtZWpjOwxGW+6nIUfH
yl0yLbl6LGrpHrG0z7RFYUOuLUo9Y7cex3pMx2Kah5HN7v7xfT7/f9ni2K8j
dGg02s7/+t+Kk2IDYfglL9fcAqvCykKqfYDlv5eVTKmjJtZI+oupxcfNZ1is
XOrcLsrCY7GMqniYz9RnlVEzZ5NyY52rqKiN0uhZ5nVqSyA3a3VBLTXw6XDR
FFNBfYxra3G5Wk8tVY5w3zO7qNJFO0WapJmqflIZ/5b5ikpYMS3Km+mm5HW5
yiiBiiID3PpWdCupSOpp2bsENfW3A+skuW+MihnnjTbKtZTJJ8XB5FsqypCd
wX3tToMjyV5+qn2KOm/aza8+pIuTWssv1s6pKbEyqEW3xwCjxjnxR+Jmqfjf
MsSxXENE+2xqSXs5T9XHGQVa7jBGrZm8bkb/M1WdelTlstcU86t26OvdpyG9
cmH3x3dmSJpclfFwrw5oA29wP8UcWb9nSsPe6sL+mOR4EH81qg642u6p1seY
pmTP8gcWMGlyL5r3WArf8SMnfoi3RG5DyqMPH5chYEzmwGBY42JraGjXVUOo
2sSnO2/bYK788jPRRiMIzF7QvQ/SIbFmaoUaYxhSmtBhNQM8sWaqpcAEPu+D
Z+1ELKRe0+0PqDXFy9bwJcGObDjwXv9557QZmnLaD7A0bCw9Hzl01H8lJPrS
N319doh8nH8jgGeOsITUJqNyDmZGDknyZs3hHOnQ5x9KoCMnK0TxaBX6Vzou
l3qsBVvH18G0YjV+ladfctS1R+3Be6Mt31kgdQl/V88f9qiXdSaW+KyB4XDK
9phGLvT8eN5itiXGa9lFlWnrkD755VzmO0sUrbPSU4h4yAoZyX7aaQVZuaQj
lMXH3XpPWmKxNYKL9vcZTfAhuDBeb3zovw9barSVzQ5w2CLw6vW0xej45uOt
2Y4QKTk/jxvQcXmj0KY31Am6237RsR+j43am1CzSSYDholnPlgYGskVhfroa
AWjRebf8TjDhNlx9PbvXGUHn9i+ccmShlHfpdq+fC7yCeooNClk49TC/1E/h
gkn9PAZbh42dNqKaJ4QQngtTm91i2dgU0xFilitEVbhcqRlko9JWTPRohOi8
ey/U19sORNvV4oAQVyxLpX/rd8MOMqdW/rNmV7w9w1NvNeFAotZ72sUnIUvM
SBpM40BcP8PKLSDhr3SLMxnlICo9cMH3AolvXg6phsY4kAY2DhkVkgh/nhxR
9RcHORrpeVkxidT+B8FCFQdyD+2nkgoS19u2bg2c5kD7aPFF7U0SBrdE1iWL
HMieGeW3d5BoTpO2M2wJlF+JPpzVRaI7eQ01QSdw5Vif9/ZuEi8SFYo6JoG7
FrL57j4SH+L+kYNDYDjY/PDAcxI2EZllYj4B7qiV98goiaSdF2Nq3Qm4NKYw
fhonke67fjLGk4BnplIbMUGiwOdV2PoNBPy5FXcmVSRqNtH3dVIEEo6yGNPT
JAbdarxV2wikbfhe26Am8cbVp7lhO4FM45HBYxoSKudJ91RfAqV1V87OzZHQ
4TsJjAIIXD6tF3lvnsQKbv+1wa8I3NwdsTltgYQVEc+p2E2g0e4x3eszCYJt
/mNEIIFmtb12cZGEkNFkKRAR+Bf8xhoD
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 1, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJwV0Hk4lAkAx/HJVStCSq65zJtpBsN4Hxue8v5KpZCtZWpjOwxGW+6nIUfH
yl0yLbl6LGrpHrG0z7RFYUOuLUo9Y7cex3pMx2Kah5HN7v7xfT7/f9ni2K8j
dGg02s7/+t+Kk2IDYfglL9fcAqvCykKqfYDlv5eVTKmjJtZI+oupxcfNZ1is
XOrcLsrCY7GMqniYz9RnlVEzZ5NyY52rqKiN0uhZ5nVqSyA3a3VBLTXw6XDR
FFNBfYxra3G5Wk8tVY5w3zO7qNJFO0WapJmqflIZ/5b5ikpYMS3Km+mm5HW5
yiiBiiID3PpWdCupSOpp2bsENfW3A+skuW+MihnnjTbKtZTJJ8XB5FsqypCd
wX3tToMjyV5+qn2KOm/aza8+pIuTWssv1s6pKbEyqEW3xwCjxjnxR+Jmqfjf
MsSxXENE+2xqSXs5T9XHGQVa7jBGrZm8bkb/M1WdelTlstcU86t26OvdpyG9
cmH3x3dmSJpclfFwrw5oA29wP8UcWb9nSsPe6sL+mOR4EH81qg642u6p1seY
pmTP8gcWMGlyL5r3WArf8SMnfoi3RG5DyqMPH5chYEzmwGBY42JraGjXVUOo
2sSnO2/bYK788jPRRiMIzF7QvQ/SIbFmaoUaYxhSmtBhNQM8sWaqpcAEPu+D
Z+1ELKRe0+0PqDXFy9bwJcGObDjwXv9557QZmnLaD7A0bCw9Hzl01H8lJPrS
N319doh8nH8jgGeOsITUJqNyDmZGDknyZs3hHOnQ5x9KoCMnK0TxaBX6Vzou
l3qsBVvH18G0YjV+ladfctS1R+3Be6Mt31kgdQl/V88f9qiXdSaW+KyB4XDK
9phGLvT8eN5itiXGa9lFlWnrkD755VzmO0sUrbPSU4h4yAoZyX7aaQVZuaQj
lMXH3XpPWmKxNYKL9vcZTfAhuDBeb3zovw9barSVzQ5w2CLw6vW0xej45uOt
2Y4QKTk/jxvQcXmj0KY31Am6237RsR+j43am1CzSSYDholnPlgYGskVhfroa
AWjRebf8TjDhNlx9PbvXGUHn9i+ccmShlHfpdq+fC7yCeooNClk49TC/1E/h
gkn9PAZbh42dNqKaJ4QQngtTm91i2dgU0xFilitEVbhcqRlko9JWTPRohOi8
ey/U19sORNvV4oAQVyxLpX/rd8MOMqdW/rNmV7w9w1NvNeFAotZ72sUnIUvM
SBpM40BcP8PKLSDhr3SLMxnlICo9cMH3AolvXg6phsY4kAY2DhkVkgh/nhxR
9RcHORrpeVkxidT+B8FCFQdyD+2nkgoS19u2bg2c5kD7aPFF7U0SBrdE1iWL
HMieGeW3d5BoTpO2M2wJlF+JPpzVRaI7eQ01QSdw5Vif9/ZuEi8SFYo6JoG7
FrL57j4SH+L+kYNDYDjY/PDAcxI2EZllYj4B7qiV98goiaSdF2Nq3Qm4NKYw
fhonke67fjLGk4BnplIbMUGiwOdV2PoNBPy5FXcmVSRqNtH3dVIEEo6yGNPT
JAbdarxV2wikbfhe26Am8cbVp7lhO4FM45HBYxoSKudJ91RfAqV1V87OzZHQ
4TsJjAIIXD6tF3lvnsQKbv+1wa8I3NwdsTltgYQVEc+p2E2g0e4x3eszCYJt
/mNEIIFmtb12cZGEkNFkKRAR+Bf8xhoD
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0.6, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUM+a8lqNrm3UHEOh81X133++eoXlC/g
ENCVP/ekMbMDhC/iUMFc8GzpCQ4oX8Kh/flxJw8fPihfxuHQ8+zKE48FoXwF
h+MvjNJE5otA+UoOs75xCz2PEIfyVRw2MyQx7hKUgvLVHKICt+RcOykD5Ws4
WPLfWp3dKA/lazkU94t/9ZFRhPJ1HLR+Mb7eXa4E5es57Jp28hPXZWUo38Ch
9uKkG7e8VKF8Q4el+VzSCZ1qUL6RQ/vsGI68J+pQvrHDzUg72Qx7TSjfxCH8
lchev1laDgDjKUxx
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUM+a8lqNrm3UHEOh81X133++eoXlC/g
ENCVP/ekMbMDhC/iUMFc8GzpCQ4oX8Kh/flxJw8fPihfxuHQ8+zKE48FoXwF
h+MvjNJE5otA+UoOs75xCz2PEIfyVRw2MyQx7hKUgvLVHKICt+RcOykD5Ws4
WPLfWp3dKA/lazkU94t/9ZFRhPJ1HLR+Mb7eXa4E5es57Jp28hPXZWUo38Ch
9uKkG7e8VKF8Q4el+VzSCZ1qUL6RQ/vsGI68J+pQvrHDzUg72Qx7TSjfxCH8
lchev1laDgDjKUxx
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0.6, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUM+a8lqNrm3UHEOh81X133++eoXlC/g
ENCVP/ekMbMDhC/iUMFc8GzpCQ4oX8Kh/flxJw8fPihfxuHQ8+zKE48FoXwF
h+MvjNJE5otA+UoOs75xCz2PEIfyVRw2MyQx7hKUgvLVHKICt+RcOykD5Ws4
WPLfWp3dKA/lazkU94t/9ZFRhPJ1HLR+Mb7eXa4E5es57Jp28hPXZWUo38Ch
9uKkG7e8VKF8Q4el+VzSCZ1qUL6RQ/vsGI68J+pQvrHDzUg72Qx7TSjfxCH8
lchev1laDgDjKUxx
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0.6, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0.6, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtkH1Q03UAh4cs5HiRAUIgL25zbOzr5MXvaVLW7xPaaYD4Bniw02TyprwJ
MUPEQI4Jaug0DnGiMBA8T16iG56ogQEFqIyQ1JSRHmNSaCngkOGM7K7n7rnn
/4cnS98SP4/FYq17539dORSuW6EYZFj/o75VmfFs8UOmzLbvYnJEI9PYdGQo
xW+ccWZVhas+uM8kMgNnnmdOMaLm+pfzr+iZNINYr2k0MW/TBT0OPs8ZG16h
6PEqFvxJqvWx2knmOOc2Ue+0xLphO2nS+DQjG4pot7xjBUFN6NOuo2+YjJ8K
ZekiG7x4HWrutGGhea/dVrfP7dH2dWmFk3ge1AeSxwO2cTB5XPKQK2ejoNK8
+dVzR5yZeyrxVFmBNfgEN3Kc0Uh9u0I01hBmJWRHEBcIJq6+XmW2wajxdJTt
D65Y4JASvNDLHiGGPQdPZbhBeiVN3JTsgPBR5VJv70X4hmO+1PaAg/FOWX5P
gwf40wMhnk8d4ed432vNF15IrupvjbZ1hg1jjNVNeeNFzg6NvddCrPsr5jU/
kgv+IpeD6s9c8FtHnEWMhAd7jxNj2iRXtBR37eAaeQgMUw1nZr+PhPfkT7Ra
PuYH96mnz7thV+aBFjvVErgknZx42ewO/8Sl2rBYAYZfuOkL2xeh30liKw/y
QcTqnuoZvQeuNxaclVgKYdVq/ffIK08csCCb7gwLkTS7d36DpzdsdDnr0zQi
FJyr6OAwi2Go45VW5vpiz9X6QqOQi1Jfd3ZrpBip7MUn7rZyoVQldMdyCUr+
iH48HsxDTOl2rd0YQdHBfaxNvTzMrK01VbYthe5VnbWPlA+9ITi7o0iCDeyq
qBV6Pqo/DvToi10G1+n6Yy37lqBBIXdMXOYHc16BVQZLgKLIXaGWRj+0Xwva
sr9IgBU69aWiPn88esBWTLj7oFx8tqEvNADOJeVvL1T7IO9mSXloawDUAmzv
WSnEBo/I2luCQCxI7S1Z1SPEp2ndUscjgSjb4MEe3ShCpadMcMcYiH2cQ7Fz
IyIIOi+WhUuXIyu5iR2V4gvlsg5yt205wr9qzzZN+iJhij3QSyjy4/WDdgox
ZM2T3CMnKPqf9WdJ7QlSCraaQ05SHD21xe2GA4F8q+aB3bcUa4PuXfd0Iig2
yo8ryyiuHn4073dXgsYg05vT5yjUPINy57uPph/n7tddpsjYNlsfTwmUd+1K
uropnDoFhvRoAlVNatLhXgrt7ovFv0gJarK0a9bfpijiEEngDoIrrsrZ21qK
N9v9v5yUEehinJMG71GMzgRZyFMIRHr3NSN6iha/jV45eQQBmhzvCwaKtHsD
Nx8dIvhQMWSKH6MQ50bEfVRIECY6992f4xQVvdGXzcUEmclc74kJCkVcXFDe
KYLc1YdM309RMLZjuselBAr7kV+zjBSm5t35OE1Q3lRzbGaGInUurduigqA6
n514bZbCt25ij+w8weXN8cG5ZoqRsKwFnVUEGv7PXp/8Q3F2arp5SQ1B25TQ
NDdHEaXaH1lYS/AvPu3wyg==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Line[CompressedData["
1:eJwtkH1Q03UAh4cs5HiRAUIgL25zbOzr5MXvaVLW7xPaaYD4Bniw02TyprwJ
MUPEQI4Jaug0DnGiMBA8T16iG56ogQEFqIyQ1JSRHmNSaCngkOGM7K7n7rnn
/4cnS98SP4/FYq17539dORSuW6EYZFj/o75VmfFs8UOmzLbvYnJEI9PYdGQo
xW+ccWZVhas+uM8kMgNnnmdOMaLm+pfzr+iZNINYr2k0MW/TBT0OPs8ZG16h
6PEqFvxJqvWx2knmOOc2Ue+0xLphO2nS+DQjG4pot7xjBUFN6NOuo2+YjJ8K
ZekiG7x4HWrutGGhea/dVrfP7dH2dWmFk3ge1AeSxwO2cTB5XPKQK2ejoNK8
+dVzR5yZeyrxVFmBNfgEN3Kc0Uh9u0I01hBmJWRHEBcIJq6+XmW2wajxdJTt
D65Y4JASvNDLHiGGPQdPZbhBeiVN3JTsgPBR5VJv70X4hmO+1PaAg/FOWX5P
gwf40wMhnk8d4ed432vNF15IrupvjbZ1hg1jjNVNeeNFzg6NvddCrPsr5jU/
kgv+IpeD6s9c8FtHnEWMhAd7jxNj2iRXtBR37eAaeQgMUw1nZr+PhPfkT7Ra
PuYH96mnz7thV+aBFjvVErgknZx42ewO/8Sl2rBYAYZfuOkL2xeh30liKw/y
QcTqnuoZvQeuNxaclVgKYdVq/ffIK08csCCb7gwLkTS7d36DpzdsdDnr0zQi
FJyr6OAwi2Go45VW5vpiz9X6QqOQi1Jfd3ZrpBip7MUn7rZyoVQldMdyCUr+
iH48HsxDTOl2rd0YQdHBfaxNvTzMrK01VbYthe5VnbWPlA+9ITi7o0iCDeyq
qBV6Pqo/DvToi10G1+n6Yy37lqBBIXdMXOYHc16BVQZLgKLIXaGWRj+0Xwva
sr9IgBU69aWiPn88esBWTLj7oFx8tqEvNADOJeVvL1T7IO9mSXloawDUAmzv
WSnEBo/I2luCQCxI7S1Z1SPEp2ndUscjgSjb4MEe3ShCpadMcMcYiH2cQ7Fz
IyIIOi+WhUuXIyu5iR2V4gvlsg5yt205wr9qzzZN+iJhij3QSyjy4/WDdgox
ZM2T3CMnKPqf9WdJ7QlSCraaQ05SHD21xe2GA4F8q+aB3bcUa4PuXfd0Iig2
yo8ryyiuHn4073dXgsYg05vT5yjUPINy57uPph/n7tddpsjYNlsfTwmUd+1K
uropnDoFhvRoAlVNatLhXgrt7ovFv0gJarK0a9bfpijiEEngDoIrrsrZ21qK
N9v9v5yUEehinJMG71GMzgRZyFMIRHr3NSN6iha/jV45eQQBmhzvCwaKtHsD
Nx8dIvhQMWSKH6MQ50bEfVRIECY6992f4xQVvdGXzcUEmclc74kJCkVcXFDe
KYLc1YdM309RMLZjuselBAr7kV+zjBSm5t35OE1Q3lRzbGaGInUurduigqA6
n514bZbCt25ij+w8weXN8cG5ZoqRsKwFnVUEGv7PXp/8Q3F2arp5SQ1B25TQ
NDdHEaXaH1lYS/AvPu3wyg==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0.6, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Line[CompressedData["
1:eJwtkH1Q03UAh4cs5HiRAUIgL25zbOzr5MXvaVLW7xPaaYD4Bniw02TyprwJ
MUPEQI4Jaug0DnGiMBA8T16iG56ogQEFqIyQ1JSRHmNSaCngkOGM7K7n7rnn
/4cnS98SP4/FYq17539dORSuW6EYZFj/o75VmfFs8UOmzLbvYnJEI9PYdGQo
xW+ccWZVhas+uM8kMgNnnmdOMaLm+pfzr+iZNINYr2k0MW/TBT0OPs8ZG16h
6PEqFvxJqvWx2knmOOc2Ue+0xLphO2nS+DQjG4pot7xjBUFN6NOuo2+YjJ8K
ZekiG7x4HWrutGGhea/dVrfP7dH2dWmFk3ge1AeSxwO2cTB5XPKQK2ejoNK8
+dVzR5yZeyrxVFmBNfgEN3Kc0Uh9u0I01hBmJWRHEBcIJq6+XmW2wajxdJTt
D65Y4JASvNDLHiGGPQdPZbhBeiVN3JTsgPBR5VJv70X4hmO+1PaAg/FOWX5P
gwf40wMhnk8d4ed432vNF15IrupvjbZ1hg1jjNVNeeNFzg6NvddCrPsr5jU/
kgv+IpeD6s9c8FtHnEWMhAd7jxNj2iRXtBR37eAaeQgMUw1nZr+PhPfkT7Ra
PuYH96mnz7thV+aBFjvVErgknZx42ewO/8Sl2rBYAYZfuOkL2xeh30liKw/y
QcTqnuoZvQeuNxaclVgKYdVq/ffIK08csCCb7gwLkTS7d36DpzdsdDnr0zQi
FJyr6OAwi2Go45VW5vpiz9X6QqOQi1Jfd3ZrpBip7MUn7rZyoVQldMdyCUr+
iH48HsxDTOl2rd0YQdHBfaxNvTzMrK01VbYthe5VnbWPlA+9ITi7o0iCDeyq
qBV6Pqo/DvToi10G1+n6Yy37lqBBIXdMXOYHc16BVQZLgKLIXaGWRj+0Xwva
sr9IgBU69aWiPn88esBWTLj7oFx8tqEvNADOJeVvL1T7IO9mSXloawDUAmzv
WSnEBo/I2luCQCxI7S1Z1SPEp2ndUscjgSjb4MEe3ShCpadMcMcYiH2cQ7Fz
IyIIOi+WhUuXIyu5iR2V4gvlsg5yt205wr9qzzZN+iJhij3QSyjy4/WDdgox
ZM2T3CMnKPqf9WdJ7QlSCraaQ05SHD21xe2GA4F8q+aB3bcUa4PuXfd0Iig2
yo8ryyiuHn4073dXgsYg05vT5yjUPINy57uPph/n7tddpsjYNlsfTwmUd+1K
uropnDoFhvRoAlVNatLhXgrt7ovFv0gJarK0a9bfpijiEEngDoIrrsrZ21qK
N9v9v5yUEehinJMG71GMzgRZyFMIRHr3NSN6iha/jV45eQQBmhzvCwaKtHsD
Nx8dIvhQMWSKH6MQ50bEfVRIECY6992f4xQVvdGXzcUEmclc74kJCkVcXFDe
KYLc1YdM309RMLZjuselBAr7kV+zjBSm5t35OE1Q3lRzbGaGInUurduigqA6
n514bZbCt25ij+w8weXN8cG5ZoqRsKwFnVUEGv7PXp/8Q3F2arp5SQ1B25TQ
NDdHEaXaH1lYS/AvPu3wyg==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], 
         PointBox[{{1., 0.}, {2., 1.0615196503164914`}, {3., 
          1.986927919308835}, {4., 2.865244697304039}, {5., 
          3.7280225045288518`}, {6., 4.584457943302535}, {7., 
          5.437676197513687}, {8., 6.288995632179083}, {9., 
          7.139085045140855}, {10., 7.988328161518648}, {11., 
          8.836963262991967}, {12., 9.685146667800888}, {13., 
          10.532985252119337`}, {14., 11.380552813095742`}, {15., 
          12.227906054395696`}, {16., 13.119134750015046`}, {17., 
          13.92192561877535}, {18., 14.767814348251266`}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             
             Point[{{1., 0.}, {2., 1.0615196503164914`}, {3., 
              1.986927919308835}, {4., 2.865244697304039}, {5., 
              3.7280225045288518`}, {6., 4.584457943302535}, {7., 
              5.437676197513687}, {8., 6.288995632179083}, {9., 
              7.139085045140855}, {10., 7.988328161518648}, {11., 
              8.836963262991967}, {12., 9.685146667800888}, {13., 
              10.532985252119337`}, {14., 11.380552813095742`}, {15., 
              12.227906054395696`}, {16., 13.119134750015046`}, {17., 
              13.92192561877535}, {18., 14.767814348251266`}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          
          Point[{{1., 0.}, {2., 1.0615196503164914`}, {3., 
           1.986927919308835}, {4., 2.865244697304039}, {5., 
           3.7280225045288518`}, {6., 4.584457943302535}, {7., 
           5.437676197513687}, {8., 6.288995632179083}, {9., 
           7.139085045140855}, {10., 7.988328161518648}, {11., 
           8.836963262991967}, {12., 9.685146667800888}, {13., 
           10.532985252119337`}, {14., 11.380552813095742`}, {15., 
           12.227906054395696`}, {16., 13.119134750015046`}, {17., 
           13.92192561877535}, {18., 14.767814348251266`}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwB4QIe/SFib1JlAgAAAC0AAAACAAAAIKUBpu353j8AAAAAAAAAAK6vidts
Luo/a+Ghm5gV0j9nP9GZ7HLzPxvOhMmVy+M/buUp47Su+T+mfNqWX1buPwoh
hCffOABAEO3euPPi9D+OEMsqoWADQO2MJmAIOfo/YttUvwPMBkAhghoHvgAA
QHHFhGJvJwpAFTKK8nfXAkCxcAxTGEkNQJna5DpafQVAoXtr6jBXEEDa7qIG
bFwIQIKf/FH07BFAqvtLL6YKC0AA0+BAvHoTQMN8XWxgqw1AJnRmeFQqFUDN
NGkWpUIQQOT1l1YLvRZAfycZJS6XEUBK5Wp9knEYQA/QevVOCBNATuSQKx4e
GkDEshDQr3IUQOrDYoDIrRtAwREc2aTEFUAuEdYdQ18dQJ0m2aMxMxdACj/1
YdzzHkC/twudUokYQEftWvciVSBAv/7vVwv8GUDYwmQBWiwhQOV/CB0EaBtA
tYjEXiD1IUBSfZYQkbscQGYFdeDOziJAnjDWxbUrHkBjcnu1DJojQDBgi6lu
gx9AL2crzkxhJED0ZLrLM2ogQM8SLAt1OSVAv/SHI/wgIUC7roKbLAMmQK5C
kJKOyyFAewEqUMzdJkCLa3HibIQiQArcekhutCdAe7FsN+s5I0DlpiGUn3wo
QJG1oqMz4yNAlCgZBLlVKUCTlLHwx5okQJCaZsdhICpAuzH7VCZGJUBalF3O
DOcqQPXrXr4k7iVA+ESl+Z++K0AegZsIb6QmQOPlQnjChyxAatQSaoNOJ0Ci
PTEbzWEtQKcCY6zjBihArYV1EWctLkAG7+0FDrMoQIdVY0sD9S5AeviSZNhb
KUA13KGph80vQNvcEKTuEipAmCmbrc1LMEBhf8n6zr0qQH/AjZhLuTBA1vxa
Mvt2K0BNG1WlyiQxQFuXBm/HLCxAQW7HWxGJMUAG8OzCXdYsQJ8cYiTM9TFA
nyOs9z+OLUBcT3SyDjkyQAAAAAAAAC5AYQwxNg==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Line[CompressedData["
1:eJwB4QIe/SFib1JlAgAAAC0AAAACAAAAIKUBpu353j8AAAAAAAAAAK6vidts
Luo/a+Ghm5gV0j9nP9GZ7HLzPxvOhMmVy+M/buUp47Su+T+mfNqWX1buPwoh
hCffOABAEO3euPPi9D+OEMsqoWADQO2MJmAIOfo/YttUvwPMBkAhghoHvgAA
QHHFhGJvJwpAFTKK8nfXAkCxcAxTGEkNQJna5DpafQVAoXtr6jBXEEDa7qIG
bFwIQIKf/FH07BFAqvtLL6YKC0AA0+BAvHoTQMN8XWxgqw1AJnRmeFQqFUDN
NGkWpUIQQOT1l1YLvRZAfycZJS6XEUBK5Wp9knEYQA/QevVOCBNATuSQKx4e
GkDEshDQr3IUQOrDYoDIrRtAwREc2aTEFUAuEdYdQ18dQJ0m2aMxMxdACj/1
YdzzHkC/twudUokYQEftWvciVSBAv/7vVwv8GUDYwmQBWiwhQOV/CB0EaBtA
tYjEXiD1IUBSfZYQkbscQGYFdeDOziJAnjDWxbUrHkBjcnu1DJojQDBgi6lu
gx9AL2crzkxhJED0ZLrLM2ogQM8SLAt1OSVAv/SHI/wgIUC7roKbLAMmQK5C
kJKOyyFAewEqUMzdJkCLa3HibIQiQArcekhutCdAe7FsN+s5I0DlpiGUn3wo
QJG1oqMz4yNAlCgZBLlVKUCTlLHwx5okQJCaZsdhICpAuzH7VCZGJUBalF3O
DOcqQPXrXr4k7iVA+ESl+Z++K0AegZsIb6QmQOPlQnjChyxAatQSaoNOJ0Ci
PTEbzWEtQKcCY6zjBihArYV1EWctLkAG7+0FDrMoQIdVY0sD9S5AeviSZNhb
KUA13KGph80vQNvcEKTuEipAmCmbrc1LMEBhf8n6zr0qQH/AjZhLuTBA1vxa
Mvt2K0BNG1WlyiQxQFuXBm/HLCxAQW7HWxGJMUAG8OzCXdYsQJ8cYiTM9TFA
nyOs9z+OLUBcT3SyDjkyQAAAAAAAAC5AYQwxNg==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Line[CompressedData["
1:eJwB4QIe/SFib1JlAgAAAC0AAAACAAAAIKUBpu353j8AAAAAAAAAAK6vidts
Luo/a+Ghm5gV0j9nP9GZ7HLzPxvOhMmVy+M/buUp47Su+T+mfNqWX1buPwoh
hCffOABAEO3euPPi9D+OEMsqoWADQO2MJmAIOfo/YttUvwPMBkAhghoHvgAA
QHHFhGJvJwpAFTKK8nfXAkCxcAxTGEkNQJna5DpafQVAoXtr6jBXEEDa7qIG
bFwIQIKf/FH07BFAqvtLL6YKC0AA0+BAvHoTQMN8XWxgqw1AJnRmeFQqFUDN
NGkWpUIQQOT1l1YLvRZAfycZJS6XEUBK5Wp9knEYQA/QevVOCBNATuSQKx4e
GkDEshDQr3IUQOrDYoDIrRtAwREc2aTEFUAuEdYdQ18dQJ0m2aMxMxdACj/1
YdzzHkC/twudUokYQEftWvciVSBAv/7vVwv8GUDYwmQBWiwhQOV/CB0EaBtA
tYjEXiD1IUBSfZYQkbscQGYFdeDOziJAnjDWxbUrHkBjcnu1DJojQDBgi6lu
gx9AL2crzkxhJED0ZLrLM2ogQM8SLAt1OSVAv/SHI/wgIUC7roKbLAMmQK5C
kJKOyyFAewEqUMzdJkCLa3HibIQiQArcekhutCdAe7FsN+s5I0DlpiGUn3wo
QJG1oqMz4yNAlCgZBLlVKUCTlLHwx5okQJCaZsdhICpAuzH7VCZGJUBalF3O
DOcqQPXrXr4k7iVA+ESl+Z++K0AegZsIb6QmQOPlQnjChyxAatQSaoNOJ0Ci
PTEbzWEtQKcCY6zjBihArYV1EWctLkAG7+0FDrMoQIdVY0sD9S5AeviSZNhb
KUA13KGph80vQNvcEKTuEipAmCmbrc1LMEBhf8n6zr0qQH/AjZhLuTBA1vxa
Mvt2K0BNG1WlyiQxQFuXBm/HLCxAQW7HWxGJMUAG8OzCXdYsQJ8cYiTM9TFA
nyOs9z+OLUBcT3SyDjkyQAAAAAAAAC5AYQwxNg==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.6, 0, 0.6], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], 
         PointBox[{{1., 0.}, {2., 1.2183831965664105`}, {3., 
          2.3020308427037053`}, {4., 3.344767359364275}, {5., 
          4.374793128967957}, {6., 5.399451151751115}, {7., 
          6.421261060542085}, {8., 7.44134996527325}, {9., 
          8.460313873155402}, {10., 9.478501142690057}, {11., 
          10.496129560866855`}, {12., 11.51334173496681}, {13., 
          12.530226396068672`}, {14., 13.546767147300733`}, {15., 
          14.562425581611881`}, {16., 15.602524632391798`}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             
             Point[{{1., 0.}, {2., 1.2183831965664105`}, {3., 
              2.3020308427037053`}, {4., 3.344767359364275}, {5., 
              4.374793128967957}, {6., 5.399451151751115}, {7., 
              6.421261060542085}, {8., 7.44134996527325}, {9., 
              8.460313873155402}, {10., 9.478501142690057}, {11., 
              10.496129560866855`}, {12., 11.51334173496681}, {13., 
              12.530226396068672`}, {14., 13.546767147300733`}, {15., 
              14.562425581611881`}, {16., 15.602524632391798`}}]}, 
            "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.6, 0, 0.6]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          
          Point[{{1., 0.}, {2., 1.2183831965664105`}, {3., 
           2.3020308427037053`}, {4., 3.344767359364275}, {5., 
           4.374793128967957}, {6., 5.399451151751115}, {7., 
           6.421261060542085}, {8., 7.44134996527325}, {9., 
           8.460313873155402}, {10., 9.478501142690057}, {11., 
           10.496129560866855`}, {12., 11.51334173496681}, {13., 
           12.530226396068672`}, {14., 13.546767147300733`}, {15., 
           14.562425581611881`}, {16., 15.602524632391798`}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.6, 0, 0.6]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.6, 0, 0.6], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAA2bo2u4Pz4j8AAAAAAAAAAK6vidts
Luo/+rTenaBYzT9nP9GZ7HLzP+u2glWAPeQ/buUp47Su+T+VKlsMBnLwPwoh
hCffOABA3pXjwopO9z+OEMsqoWADQIEi077Wtf0/YttUvwPMBkCmpdjHMFMC
QHHFhGJvJwpAMt+RFUO7BUCxcAxTGEkNQGmp/gW56AhAoXtr6jBXEEC1weJg
zloMQIKf/FH07BFAsmp6XkeSD0AA0+BAvHoTQGccrqDGXBFAJnRmeFQqFUCA
qlpHuRITQOT1l1YLvRZA8ABhv12rFEBK5Wp9knEYQGr+ouxRZhZATuSQKx4e
GkB3DoqMLBkYQOrDYoDIrRtA2ubK/biuGUAuEdYdQ18dQEdmRySVZhtACj/1
YdzzHkAJrh0cIwEdQEftWvciVSBA1pwvyQC+HkDYwmQBWiwhQBtPc3RiOSBA
tYjEXiD1IUD2s/tsHQUhQGYFdeDOziJAV+whQADiIUBjcnu1DJojQOII9fs7
sCJAL2crzkxhJEC4rhrxanojQM8SLAt1OSVAESjewMFVJEC7roKbLAMmQJeF
TnlxIiVAewEqUMzdJkCgtlwMSQAmQArcekhutCdA9HC92BPaJkDlpiGUn3wo
QHIPy403pSdAlCgZBLlVKUB2gXYdg4EoQJCaZsdhICpAp9fOlSdPKUBalF3O
DOcqQB63eUe/GCpA+ESl+Z++K0AcasLTfvMqQOPlQnjChyxARQG4SJe/K0Ci
PTEbzWEtQPZrS5jXnCxArYV1EWctLkDOuovQcGstQIdVY0sD9S5A8ZIeQv01
LkA13KGph80vQJk+T46xES9AmCmbrc1LMEBuzizDvt4vQBfa8oswXDBAAAAA
AAAAMEBCZBYr
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             Line[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAA2bo2u4Pz4j8AAAAAAAAAAK6vidts
Luo/+rTenaBYzT9nP9GZ7HLzP+u2glWAPeQ/buUp47Su+T+VKlsMBnLwPwoh
hCffOABA3pXjwopO9z+OEMsqoWADQIEi077Wtf0/YttUvwPMBkCmpdjHMFMC
QHHFhGJvJwpAMt+RFUO7BUCxcAxTGEkNQGmp/gW56AhAoXtr6jBXEEC1weJg
zloMQIKf/FH07BFAsmp6XkeSD0AA0+BAvHoTQGccrqDGXBFAJnRmeFQqFUCA
qlpHuRITQOT1l1YLvRZA8ABhv12rFEBK5Wp9knEYQGr+ouxRZhZATuSQKx4e
GkB3DoqMLBkYQOrDYoDIrRtA2ubK/biuGUAuEdYdQ18dQEdmRySVZhtACj/1
YdzzHkAJrh0cIwEdQEftWvciVSBA1pwvyQC+HkDYwmQBWiwhQBtPc3RiOSBA
tYjEXiD1IUD2s/tsHQUhQGYFdeDOziJAV+whQADiIUBjcnu1DJojQOII9fs7
sCJAL2crzkxhJEC4rhrxanojQM8SLAt1OSVAESjewMFVJEC7roKbLAMmQJeF
TnlxIiVAewEqUMzdJkCgtlwMSQAmQArcekhutCdA9HC92BPaJkDlpiGUn3wo
QHIPy403pSdAlCgZBLlVKUB2gXYdg4EoQJCaZsdhICpAp9fOlSdPKUBalF3O
DOcqQB63eUe/GCpA+ESl+Z++K0AcasLTfvMqQOPlQnjChyxARQG4SJe/K0Ci
PTEbzWEtQPZrS5jXnCxArYV1EWctLkDOuovQcGstQIdVY0sD9S5A8ZIeQv01
LkA13KGph80vQJk+T46xES9AmCmbrc1LMEBuzizDvt4vQBfa8oswXDBAAAAA
AAAAMEBCZBYr
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 16.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 16.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.6, 0, 0.6]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          Line[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAA2bo2u4Pz4j8AAAAAAAAAAK6vidts
Luo/+rTenaBYzT9nP9GZ7HLzP+u2glWAPeQ/buUp47Su+T+VKlsMBnLwPwoh
hCffOABA3pXjwopO9z+OEMsqoWADQIEi077Wtf0/YttUvwPMBkCmpdjHMFMC
QHHFhGJvJwpAMt+RFUO7BUCxcAxTGEkNQGmp/gW56AhAoXtr6jBXEEC1weJg
zloMQIKf/FH07BFAsmp6XkeSD0AA0+BAvHoTQGccrqDGXBFAJnRmeFQqFUCA
qlpHuRITQOT1l1YLvRZA8ABhv12rFEBK5Wp9knEYQGr+ouxRZhZATuSQKx4e
GkB3DoqMLBkYQOrDYoDIrRtA2ubK/biuGUAuEdYdQ18dQEdmRySVZhtACj/1
YdzzHkAJrh0cIwEdQEftWvciVSBA1pwvyQC+HkDYwmQBWiwhQBtPc3RiOSBA
tYjEXiD1IUD2s/tsHQUhQGYFdeDOziJAV+whQADiIUBjcnu1DJojQOII9fs7
sCJAL2crzkxhJEC4rhrxanojQM8SLAt1OSVAESjewMFVJEC7roKbLAMmQJeF
TnlxIiVAewEqUMzdJkCgtlwMSQAmQArcekhutCdA9HC92BPaJkDlpiGUn3wo
QHIPy403pSdAlCgZBLlVKUB2gXYdg4EoQJCaZsdhICpAp9fOlSdPKUBalF3O
DOcqQB63eUe/GCpA+ESl+Z++K0AcasLTfvMqQOPlQnjChyxARQG4SJe/K0Ci
PTEbzWEtQPZrS5jXnCxArYV1EWctLkDOuovQcGstQIdVY0sD9S5A8ZIeQv01
LkA13KGph80vQJk+T46xES9AmCmbrc1LMEBuzizDvt4vQBfa8oswXDBAAAAA
AAAAMEBCZBYr
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 16.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 0}, {20, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 20}, {0, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 20}, {0, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{1, 0}, {1, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{2, 0}, {2, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{3, 0}, {3, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{4, 0}, {4, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{5, 0}, {5, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{6, 0}, {6, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{7, 0}, {7, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{8, 0}, {8, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{9, 0}, {9, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{10, 0}, {10, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{11, 0}, {11, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{12, 0}, {12, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{13, 0}, {13, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{14, 0}, {14, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{15, 0}, {15, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{16, 0}, {16, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{17, 0}, {17, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{18, 0}, {18, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{19, 0}, {19, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 5}, {0.6, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 10}, {0.6, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 15}, {0.6, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -4}, {0.24000000000000002`, -4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -3}, {0.24000000000000002`, -3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -2}, {0.24000000000000002`, -2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -1}, {0.24000000000000002`, -1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 1}, {0.24000000000000002`, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 2}, {0.24000000000000002`, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 3}, {0.24000000000000002`, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 4}, {0.24000000000000002`, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 6}, {0.24000000000000002`, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 7}, {0.24000000000000002`, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 8}, {0.24000000000000002`, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 9}, {0.24000000000000002`, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 11}, {0.24000000000000002`, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 12}, {0.24000000000000002`, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 13}, {0.24000000000000002`, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 14}, {0.24000000000000002`, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 16}, {0.24000000000000002`, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 17}, {0.24000000000000002`, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 18}, {0.24000000000000002`, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 19}, {0.24000000000000002`, 19}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 1}, {19.76, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 2}, {19.76, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 3}, {19.76, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 4}, {19.76, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 5}, {19.4, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 6}, {19.76, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 7}, {19.76, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 8}, {19.76, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 9}, {19.76, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 10}, {19.4, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 11}, {19.76, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 12}, {19.76, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 13}, {19.76, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 14}, {19.76, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 15}, {19.4, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 16}, {19.76, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 17}, {19.76, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 18}, {19.76, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 19}, {19.76, 19}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{None, None}, {None, None}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.1, 21.}, {-0.2, 20.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9570804182393365`*^9, 3.9570804992087684`*^9, 3.957080843004285*^9, 
   3.9570808876000423`*^9, {3.9570809328705654`*^9, 3.957080946297207*^9}, {
   3.957081123572654*^9, 3.95708119912243*^9}, {3.9570812984278326`*^9, 
   3.957081327637355*^9}, {3.9570816426025934`*^9, 3.957081655751824*^9}, {
   3.9570816867449355`*^9, 3.957081732064227*^9}, {3.9570818085103645`*^9, 
   3.957081884376547*^9}, 3.9570826901246977`*^9, 3.957083460222689*^9, 
   3.9570863198039074`*^9, 3.957086705177944*^9, 3.957086744217181*^9, 
   3.9570880420199037`*^9, 3.95708971274308*^9, 3.9571576389652157`*^9},
 CellLabel->
  "Out[180]=",ExpressionUUID->"92ce8663-b077-4f44-b7a2-70b5ae31e4b9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure S.I. - gradient dependence of t_esc
(b) Only the gradient and the surface effect are included (no image potential)\
\>", "Section",
 CellChangeTimes->{{3.9570171298158393`*^9, 3.957017145665162*^9}, {
  3.957080152611906*^9, 3.957080167029992*^9}, {3.957080197719389*^9, 
  3.957080209671468*^9}, {3.957083561411101*^9, 3.9570835966446943`*^9}, {
  3.957083655604842*^9, 3.957083676212036*^9}, {3.9570843929899335`*^9, 
  3.957084440325094*^9}, {3.957088174714811*^9, 
  3.957088175875102*^9}},ExpressionUUID->"b0231352-eb09-4dfc-aeb2-\
d2cc7cba0c3d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Simulation", " ", "results", " ", "for", " ", "tesc_average", " ", "as", 
     " ", "a", " ", "function", " ", "of", " ", "the", " ", "layer", " ", 
     "thickness"}], ",", " ", 
    RowBox[{
     RowBox[{"without", " ", "gradient", " ", 
      RowBox[{"(", "tabg0", ")"}], " ", "and", " ", "for", " ", "a", " ", 
      "gradient", " ", "of"}], " ", "-", 
     RowBox[{"0.01", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg1", ")"}], " ", "to"}], " ", "-", 
     RowBox[{"0.06", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg6", ")"}]}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabg0", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2.5`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.039595999698189`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3.560115738949734`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5.878511330335879`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8.929178181122658`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "12.684000037281226`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "17.128918771797164`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "22.256124314106906`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "28.06093062187231`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "34.540355668150916`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "41.692411434981096`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "49.51572160223557`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "58.00930308410911`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "67.17243495101125`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "77.00966077209354`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "87.50531427399882`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "98.67432666461943`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "110.5113597898682`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "123.0162105395509`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3.214577414202713`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.058749450693502`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4.460618302972626`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "9.292318185212032`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "17.650774331878747`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "31.243990715909092`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "52.64763335787048`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "85.71281264433368`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "136.1796326830068`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "212.59049108094305`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "327.6457151239484`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "500.21373213276195`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "758.3103000064633`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "1143.512495701261`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "1717.9880906269138`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "2571.7206322793695`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "3841.7580552936406`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "5728.519142459595`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "8529.657923017721`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4.269568748997848`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.0873700390968235`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5.836468064537652`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "16.05960001713576`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "40.47908034291588`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "96.27436151443511`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "221.36641200339417`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "499.22839993291205`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "1113.307306481335`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "2466.2843510347748`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "5441.255796422276`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "11973.422632178068`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "26300.89568133664`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "57700.32313703501`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "126593.88696051133`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "276993.58296951914`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "606328.5644391994`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "1.3266036877637396`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "2.9013710314615625`*^6"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "5.827142070475768`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.1303720797543866`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "7.971706057370452`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "30.05663289524108`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "105.17857634713806`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "353.5790876709179`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "1166.5865216190732`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "3814.957476887137`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "12418.737422355967`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "40320.052340303635`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "130685.19775323548`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "423068.59492201195`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "1.3683731535863646`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4.422761872321766`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "1.4324631284939697`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "4.61300823486984`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "1.4888983385544074`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "4.8040517601683724`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1.549648953549205`*^9"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "8.12671986961557`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.1954879663667417`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "11.36006101392487`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "60.26542662019098`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "301.3436820623372`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "1469.1037180408732`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "7090.810967073267`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "34068.17138028724`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "163262.38379340706`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "781075.152297296`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "3.7322920776146133`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "1.781818859973458`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "8.500503104132932`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4.0530506242183775`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "1.943541613575401`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "9.20241023257466`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "4.382744358048076`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "2.0867852588602713`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "9.933310264657968`*^11"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg5", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "11.521781907066895`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.2951733531361485`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "16.90684889846501`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "128.4521993675538`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "932.759065830881`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "6666.545205663094`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "47357.086536926676`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "335353.30128698726`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "2.3700110683508827`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "1.6725774319457047`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1.1791519229301019`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "8.306315653950722`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "5.847602838339559`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4.114644414174774`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "2.932514648828642`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "2.0348752831607917`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "1.4299393343356703`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "1.0018529324451695`*^14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "6.785883508290026`*^14"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg6", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "16.534200379038058`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.450083750240002`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "26.37903840172273`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "290.3076703774348`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "3087.190257215407`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "32482.616994629065`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "340231.061002828`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "3.554199680915132`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "3.706205930735677`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "3.859740297255152`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "4.0157908494274926`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "4.175098332834568`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "4.338244863420672`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4.505385345262886`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "4.801130982569518`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "4.8477161953018725`*^14"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9570179772619314`*^9, 3.9570180953308115`*^9}, {
   3.957018130955658*^9, 3.957018215682221*^9}, {3.9570182483795967`*^9, 
   3.9570182498622723`*^9}, {3.9570182837986765`*^9, 
   3.9570182852908335`*^9}, {3.957018322219037*^9, 3.9570183250144663`*^9}, {
   3.957018363945951*^9, 3.9570183681405325`*^9}, {3.957018442196556*^9, 
   3.957018610886937*^9}, {3.9570186496028247`*^9, 3.9570187244844*^9}, {
   3.957018765810251*^9, 3.9570188498960905`*^9}, {3.957018918296104*^9, 
   3.9570189374221983`*^9}, {3.957019000142621*^9, 3.957019223719556*^9}, {
   3.9570192658838415`*^9, 3.9570193388030453`*^9}, {3.957019606873952*^9, 
   3.9570196071413164`*^9}, {3.9570196888161397`*^9, 3.957019689036353*^9}, {
   3.957019734845105*^9, 3.9570197589959383`*^9}, {3.9570197952984085`*^9, 
   3.9570197971588607`*^9}, {3.957019838683606*^9, 3.957019985227247*^9}, {
   3.957020038838397*^9, 3.9570201283874245`*^9}, 3.957020197149083*^9, {
   3.9570204733372583`*^9, 3.957020500620798*^9}, {3.9570205509616127`*^9, 
   3.95702066161045*^9}, {3.957020692895506*^9, 3.957020708878168*^9}, {
   3.9570207595181*^9, 3.9570208497017155`*^9}, {3.957020888824114*^9, 
   3.957020889060049*^9}, {3.9570209951649275`*^9, 3.9570210101170444`*^9}, {
   3.9570210550686293`*^9, 3.9570210588326006`*^9}, {3.9570210907714324`*^9, 
   3.957021265128262*^9}, {3.957021371426813*^9, 3.9570214149432645`*^9}, {
   3.9570214602954516`*^9, 3.9570214916352696`*^9}, {3.9570218346690845`*^9, 
   3.957021883427083*^9}, {3.957021916297*^9, 3.9570220552469535`*^9}, {
   3.9570221070400944`*^9, 3.957022185042626*^9}, {3.957022259364053*^9, 
   3.957022310992408*^9}, {3.9570224069747143`*^9, 3.9570226593058558`*^9}, {
   3.957022690348491*^9, 3.9570229809182606`*^9}, {3.9570803458809958`*^9, 
   3.9570804160235357`*^9}, 3.9570804900867395`*^9, 3.9570805508265257`*^9, {
   3.9570807836844387`*^9, 3.957080790237952*^9}, 3.9570808381222596`*^9, {
   3.957080879397051*^9, 3.9570808860910635`*^9}, {3.9570809282777843`*^9, 
   3.9570809451037183`*^9}, {3.957081122125296*^9, 3.9570811981441336`*^9}, {
   3.957081292736041*^9, 3.957081326686044*^9}, {3.9570816413830557`*^9, 
   3.9570817312476215`*^9}, {3.9570818055953684`*^9, 
   3.9570818835880594`*^9}, {3.9570826015912066`*^9, 
   3.9570826843652077`*^9}, {3.9570834465178623`*^9, 
   3.9570834564388247`*^9}, {3.9570835870720224`*^9, 3.957083606433529*^9}, {
   3.9570837420013647`*^9, 3.9570837563928175`*^9}, 3.957083792984332*^9, 
   3.957083838287492*^9, 3.9570838834220667`*^9, 3.957083928799616*^9, 
   3.9570839696759157`*^9, {3.957084008139803*^9, 3.9570840515430994`*^9}, {
   3.957084174804969*^9, 3.9570842146578255`*^9}, 3.95708449689047*^9, 
   3.957084530904195*^9, 3.9570845673536186`*^9, 3.9570846107396183`*^9, 
   3.957084645357972*^9, 3.957084680332451*^9, {3.9570847216604977`*^9, 
   3.957084753888129*^9}, {3.957086902891119*^9, 3.957086913125927*^9}, 
   3.957088070232334*^9, {3.9570884899553986`*^9, 3.9570885002229776`*^9}, 
   3.957089725744452*^9, {3.9571576459136467`*^9, 3.9571576464480495`*^9}, 
   3.971006411077659*^9, 
   3.9710065311639833`*^9},ExpressionUUID->"934a6ecb-cac7-497a-bdc7-\
ff39d31ee8a4"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcPKrJMPoq0eQMU5HKbPVUwTEboC5Qs4
7DG3UL9x/AmUL+JQN2d16P1f76B8CQclW8n+fZ8+Q/kyDmEuAu4TXn2H8hUc
9sgV9R7p+g3lKznckClNOPj2H5Sv4vAjxjh1pRCjA4Sv5mC+M973/DwmKF/D
YfkO5pQeeRYoX8vBr6X+6b3prFC+jkPKRw/jt5zsUL6ew/499szu5RxQvoHD
/1nZdkEPOaF8Q4cJcZ8ylD24oXwjhzWa3wXl1vJA+cYO20qLWyoE+KB8E4fr
j03ceor4HQDFF05L
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcPKrJMPoq0eQMU5HKbPVUwTEboC5Qs4
7DG3UL9x/AmUL+JQN2d16P1f76B8CQclW8n+fZ8+Q/kyDmEuAu4TXn2H8hUc
9sgV9R7p+g3lKznckClNOPj2H5Sv4vAjxjh1pRCjA4Sv5mC+M973/DwmKF/D
YfkO5pQeeRYoX8vBr6X+6b3prFC+jkPKRw/jt5zsUL6ew/499szu5RxQvoHD
/1nZdkEPOaF8Q4cJcZ8ylD24oXwjhzWa3wXl1vJA+cYO20qLWyoE+KB8E4fr
j03ceor4HQDFF05L
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
            "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
           "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcPKrJMPoq0eQMU5HKbPVUwTEboC5Qs4
7DG3UL9x/AmUL+JQN2d16P1f76B8CQclW8n+fZ8+Q/kyDmEuAu4TXn2H8hUc
9sgV9R7p+g3lKznckClNOPj2H5Sv4vAjxjh1pRCjA4Sv5mC+M973/DwmKF/D
YfkO5pQeeRYoX8vBr6X+6b3prFC+jkPKRw/jt5zsUL6ew/499szu5RxQvoHD
/1nZdkEPOaF8Q4cJcZ8ylD24oXwjhzWa3wXl1vJA+cYO20qLWyoE+KB8E4fr
j03ceor4HQDFF05L
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
         "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVkX081HcAx48jOud3lIoVd2QezkPHb1uRfD9pr1ZcrQeqSQ8Ox5YUc5uk
lVAIWbMSLxlSvLyo7PSaPMxTTHKNK9VYXbiSh0rX4STW/ni/3n+/X29L0aFt
IdoMBmPTR/533k+ieS7BuZ5p3nriDJ6CtMh5wp28I+T8U+1XhvYKMtdan8Dj
pZD86FlJuouC5DWkc3V5F0nlJXVSmpeChK+RHJzklpJ/3g4UpwYriPx9WNYb
bjWxy21QnipREL3eftsxbjtpGTkSclzwjBTcyY8c4T4mM2mjwYfRTyqupfSG
Ow+Trl2WjAUZgySUdF0cjVIRs6SYyt+kz0mE0n5AWqEhsugdJaK/hwjLMtH2
6SoGlGMJ7oNmIyTDqINfsJ+JqDb5wDaPMSLq9f2TeXce9vG/t49Pe00ibyeK
DtmysLdE+M340Bty4zB7u+lGQ7SOHC41nRonBUcPDAt2GkGhqm3jWqjIyfyZ
re9GjfGZY05knuAdYcgVqI1dCM9W9zrpGjWxiRbH+PIXYdqa+bAscIIMqi/s
MKhbjFe/B8SZRU0Sb+V3x85FmuJXvSevxRenyObBTAcLi0+gqrXS3VyjIcPN
ohN/lS9FauFUcVn7NHE27jFft88c3cIJk5ev3hMWUQf2qSzga5vEyWN8IF+N
+U9a+fGQ3Lr6kcB+ljxqCtbyd7T82FvltVc4R6qSW/by1Jbwidu/TMuZAbGu
RCGTWWHl5JFZr0YGgqKOVrFzlsOTFWDT4K2FFaEOMmGgNaxkXG5qlxbuLXA0
kLh9ij3Rk7PNQdqoqTiZ68i0wc3KC9Zuo9o4qsXfcvdfG4TJfVwsTjDB6ovd
ECG1hfryM2qLsQ6UVyyz8uPscImCa122DrLszHSq/exR6F/pkeOgi8wccVsg
j49Gz7G0Sqku/LP2yNgv+KiVz69Ysnoepr4s1uTXO8DIx/3m6MdvA0qvmKbT
joj3p3U++OqhcI3L0s5AJ3gL4XZsSA/lSRLjUCdnCHoWSVdF6eO0X5APU+0M
lVHnHDT6+LyvoPR05wqwnbNdq8/MR7Z9bnmnjwDrBxzKwk1YON6Qnu1TLUBP
rJyVWcLCpqV+xXesXbC2OWA1w90AayPadhunuKC9qOJGWaMB8peJrO+qXVAq
NuG0+bJh3Xz1/Obdrihp9Ko0f8JGplMTv7veFfGd22wagw0hVul0tfNpVNX8
EH9/whCiG295KWdpML2CrJYfpxB+cvuM98806oaUtxPiKUi2Sx+yf6ERczbs
28EECslqSUbmeRqjfQevFydTqHDTvL+QR+PBjzGeducoaBrneq6U0bhcnu7v
VEwhs5ud3tJGY73ZH+dWdlDIKToYdqqdhnaD+xfZnRSKomXrNnTQqBHXPZ66
R+Hm4szpDhkNZ2kT79Z9Cn3+C8PkD2iYft1Z4fGEgu2A2br+ARovE/vvrB2n
IJDGWlxW0ih0CIkoVFFwT+rVhLygsaf7hTFzgoLQNu/6y2Ea97hju1qmKUQd
4FmMj9OovjX5fL0OB3Ee8ZpKFY2owNjUq/M4SDLsvx+tpuGo/8FJfz4H2deK
zkxN0Sjw05a0G3JQeEIn9NY0jYCZRFO+EQdlW0O84mZoLC7Sq01dwIHUqtXc
c5aGbGPqvhETDupVNpq5ORopb9hM4RIO/gMNlCxF
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Line[CompressedData["
1:eJwVkX081HcAx48jOud3lIoVd2QezkPHb1uRfD9pr1ZcrQeqSQ8Ox5YUc5uk
lVAIWbMSLxlSvLyo7PSaPMxTTHKNK9VYXbiSh0rX4STW/ni/3n+/X29L0aFt
IdoMBmPTR/533k+ieS7BuZ5p3nriDJ6CtMh5wp28I+T8U+1XhvYKMtdan8Dj
pZD86FlJuouC5DWkc3V5F0nlJXVSmpeChK+RHJzklpJ/3g4UpwYriPx9WNYb
bjWxy21QnipREL3eftsxbjtpGTkSclzwjBTcyY8c4T4mM2mjwYfRTyqupfSG
Ow+Trl2WjAUZgySUdF0cjVIRs6SYyt+kz0mE0n5AWqEhsugdJaK/hwjLMtH2
6SoGlGMJ7oNmIyTDqINfsJ+JqDb5wDaPMSLq9f2TeXce9vG/t49Pe00ibyeK
DtmysLdE+M340Bty4zB7u+lGQ7SOHC41nRonBUcPDAt2GkGhqm3jWqjIyfyZ
re9GjfGZY05knuAdYcgVqI1dCM9W9zrpGjWxiRbH+PIXYdqa+bAscIIMqi/s
MKhbjFe/B8SZRU0Sb+V3x85FmuJXvSevxRenyObBTAcLi0+gqrXS3VyjIcPN
ohN/lS9FauFUcVn7NHE27jFft88c3cIJk5ev3hMWUQf2qSzga5vEyWN8IF+N
+U9a+fGQ3Lr6kcB+ljxqCtbyd7T82FvltVc4R6qSW/by1Jbwidu/TMuZAbGu
RCGTWWHl5JFZr0YGgqKOVrFzlsOTFWDT4K2FFaEOMmGgNaxkXG5qlxbuLXA0
kLh9ij3Rk7PNQdqoqTiZ68i0wc3KC9Zuo9o4qsXfcvdfG4TJfVwsTjDB6ovd
ECG1hfryM2qLsQ6UVyyz8uPscImCa122DrLszHSq/exR6F/pkeOgi8wccVsg
j49Gz7G0Sqku/LP2yNgv+KiVz69Ysnoepr4s1uTXO8DIx/3m6MdvA0qvmKbT
joj3p3U++OqhcI3L0s5AJ3gL4XZsSA/lSRLjUCdnCHoWSVdF6eO0X5APU+0M
lVHnHDT6+LyvoPR05wqwnbNdq8/MR7Z9bnmnjwDrBxzKwk1YON6Qnu1TLUBP
rJyVWcLCpqV+xXesXbC2OWA1w90AayPadhunuKC9qOJGWaMB8peJrO+qXVAq
NuG0+bJh3Xz1/Obdrihp9Ko0f8JGplMTv7veFfGd22wagw0hVul0tfNpVNX8
EH9/whCiG295KWdpML2CrJYfpxB+cvuM98806oaUtxPiKUi2Sx+yf6ERczbs
28EECslqSUbmeRqjfQevFydTqHDTvL+QR+PBjzGeducoaBrneq6U0bhcnu7v
VEwhs5ud3tJGY73ZH+dWdlDIKToYdqqdhnaD+xfZnRSKomXrNnTQqBHXPZ66
R+Hm4szpDhkNZ2kT79Z9Cn3+C8PkD2iYft1Z4fGEgu2A2br+ARovE/vvrB2n
IJDGWlxW0ih0CIkoVFFwT+rVhLygsaf7hTFzgoLQNu/6y2Ea97hju1qmKUQd
4FmMj9OovjX5fL0OB3Ee8ZpKFY2owNjUq/M4SDLsvx+tpuGo/8FJfz4H2deK
zkxN0Sjw05a0G3JQeEIn9NY0jYCZRFO+EQdlW0O84mZoLC7Sq01dwIHUqtXc
c5aGbGPqvhETDupVNpq5ORopb9hM4RIO/gMNlCxF
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Line[CompressedData["
1:eJwVkX081HcAx48jOud3lIoVd2QezkPHb1uRfD9pr1ZcrQeqSQ8Ox5YUc5uk
lVAIWbMSLxlSvLyo7PSaPMxTTHKNK9VYXbiSh0rX4STW/ni/3n+/X29L0aFt
IdoMBmPTR/533k+ieS7BuZ5p3nriDJ6CtMh5wp28I+T8U+1XhvYKMtdan8Dj
pZD86FlJuouC5DWkc3V5F0nlJXVSmpeChK+RHJzklpJ/3g4UpwYriPx9WNYb
bjWxy21QnipREL3eftsxbjtpGTkSclzwjBTcyY8c4T4mM2mjwYfRTyqupfSG
Ow+Trl2WjAUZgySUdF0cjVIRs6SYyt+kz0mE0n5AWqEhsugdJaK/hwjLMtH2
6SoGlGMJ7oNmIyTDqINfsJ+JqDb5wDaPMSLq9f2TeXce9vG/t49Pe00ibyeK
DtmysLdE+M340Bty4zB7u+lGQ7SOHC41nRonBUcPDAt2GkGhqm3jWqjIyfyZ
re9GjfGZY05knuAdYcgVqI1dCM9W9zrpGjWxiRbH+PIXYdqa+bAscIIMqi/s
MKhbjFe/B8SZRU0Sb+V3x85FmuJXvSevxRenyObBTAcLi0+gqrXS3VyjIcPN
ohN/lS9FauFUcVn7NHE27jFft88c3cIJk5ev3hMWUQf2qSzga5vEyWN8IF+N
+U9a+fGQ3Lr6kcB+ljxqCtbyd7T82FvltVc4R6qSW/by1Jbwidu/TMuZAbGu
RCGTWWHl5JFZr0YGgqKOVrFzlsOTFWDT4K2FFaEOMmGgNaxkXG5qlxbuLXA0
kLh9ij3Rk7PNQdqoqTiZ68i0wc3KC9Zuo9o4qsXfcvdfG4TJfVwsTjDB6ovd
ECG1hfryM2qLsQ6UVyyz8uPscImCa122DrLszHSq/exR6F/pkeOgi8wccVsg
j49Gz7G0Sqku/LP2yNgv+KiVz69Ysnoepr4s1uTXO8DIx/3m6MdvA0qvmKbT
joj3p3U++OqhcI3L0s5AJ3gL4XZsSA/lSRLjUCdnCHoWSVdF6eO0X5APU+0M
lVHnHDT6+LyvoPR05wqwnbNdq8/MR7Z9bnmnjwDrBxzKwk1YON6Qnu1TLUBP
rJyVWcLCpqV+xXesXbC2OWA1w90AayPadhunuKC9qOJGWaMB8peJrO+qXVAq
NuG0+bJh3Xz1/Obdrihp9Ko0f8JGplMTv7veFfGd22wagw0hVul0tfNpVNX8
EH9/whCiG295KWdpML2CrJYfpxB+cvuM98806oaUtxPiKUi2Sx+yf6ERczbs
28EECslqSUbmeRqjfQevFydTqHDTvL+QR+PBjzGeducoaBrneq6U0bhcnu7v
VEwhs5ud3tJGY73ZH+dWdlDIKToYdqqdhnaD+xfZnRSKomXrNnTQqBHXPZ66
R+Hm4szpDhkNZ2kT79Z9Cn3+C8PkD2iYft1Z4fGEgu2A2br+ARovE/vvrB2n
IJDGWlxW0ih0CIkoVFFwT+rVhLygsaf7hTFzgoLQNu/6y2Ea97hju1qmKUQd
4FmMj9OovjX5fL0OB3Ee8ZpKFY2owNjUq/M4SDLsvx+tpuGo/8FJfz4H2deK
zkxN0Sjw05a0G3JQeEIn9NY0jYCZRFO+EQdlW0O84mZoLC7Sq01dwIHUqtXc
c5aGbGPqvhETDupVNpq5ORopb9hM4RIO/gMNlCxF
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0.8, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUOK41MxaZ0nUHEOBzuxhdaBJVegfAGH
Q2F6dr4tL6B8EYdEzSl1G7w+Q/kSDvNqvlaYb/8J5cs4MIdxrCzd8x/KV3DY
tfrg+5OHmBwgfCWHm2bu72WnsUL5Kg5/PSO3l8dzQPlqDsc4GlueK3FD+RoO
uQUF1tse8UL5Wg5tTKJlEgECUL6OwzrjIwd51glC+XoOwZkR/kXcwlC+gcNn
X89H9zJEoHxDh405pcfFjopC+UYOKWsWm9UpikP5xg5vpjffW18rAeWbOIRq
/li95aakAwA1g0wx
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUOK41MxaZ0nUHEOBzuxhdaBJVegfAGH
Q2F6dr4tL6B8EYdEzSl1G7w+Q/kSDvNqvlaYb/8J5cs4MIdxrCzd8x/KV3DY
tfrg+5OHmBwgfCWHm2bu72WnsUL5Kg5/PSO3l8dzQPlqDsc4GlueK3FD+RoO
uQUF1tse8UL5Wg5tTKJlEgECUL6OwzrjIwd51glC+XoOwZkR/kXcwlC+gcNn
X89H9zJEoHxDh405pcfFjopC+UYOKWsWm9UpikP5xg5vpjffW18rAeWbOIRq
/li95aakAwA1g0wx
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0.8, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUOK41MxaZ0nUHEOBzuxhdaBJVegfAGH
Q2F6dr4tL6B8EYdEzSl1G7w+Q/kSDvNqvlaYb/8J5cs4MIdxrCzd8x/KV3DY
tfrg+5OHmBwgfCWHm2bu72WnsUL5Kg5/PSO3l8dzQPlqDsc4GlueK3FD+RoO
uQUF1tse8UL5Wg5tTKJlEgECUL6OwzrjIwd51glC+XoOwZkR/kXcwlC+gcNn
X89H9zJEoHxDh405pcfFjopC+UYOKWsWm9UpikP5xg5vpjffW18rAeWbOIRq
/li95aakAwA1g0wx
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0.8, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0.8, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtxQ841HcAx/HLnWrnxPlTvpWbq/Pv/PdtPUn1+xQ1ISWZp9Oau3bYCuVx
Tfoza0m26Go3fychqjWkLotWKzIT7lBJS08t9EfM/Lk4SdueZ+/neT1voSxu
o9yAxWKt/td/b014odAKBhjW/0UxbTn98SNMBvcad7qihontdexWl+uZYYMg
9QkrDcMVHrJ/vISFB71dRes9O5kM0yZxYQQbHLtZIsOtTxjZw02/spun489X
gRXSqR5mV/0hWZw9F3lLcm6K0l4ylTt5IVZrjbF0jdigtn6AKdy7vc89zBTB
tGz5oOsQc7BgMni0nw99cdTxvpARhnXnCX5JModx51kHEqtj7BIiEzeJLZHy
vdeWGVVjTI8u6yOja7MRd6m/9GmHnvHv/Xz/iV1WuCoZTN9vO8kE9SidBIK5
+KI+8UrAZ1NMX50s+feyedjoZ7af7cOCK7/D2ucTa/wwbNKP6GngMjpp14gA
gpaTz0b3GODDAcnYglAbbNwRWnGkiI3O2k+nSZyFWBajJVX1HFw+cmurjU4I
6ck/TCT3DBFpqHii0SzAYpXx3UdvpmNb/N7LvNyF8K1pW9g5aybcopw0gVIR
eKs2W+6Y/x60Zs5GCi9bfJ0x895jcHG1/GCeM9sOi4zW2twONsLeaeINzY/s
kBVY6aXawwO3K8kvVm2PysGu0bE8Y/SWClUF+xzAqcvxbv9xFlQOhFMd6ghu
+IENR1tNoMyNbJDaiFHCT0rcussUEtXHGt5zMU6VZubUjZli3LdEX3DdCaPW
DYXZaXx0965KrE11htzlxuBZvhmKlnvMa5G6wPX9FpFjiRnKUhT8KBdXWJ4r
KuhxNUdq6LYAts4V97s3v+q/bI4PugrPpba4YYhlK5D7WSDbMa+sJcAd4qor
mVZtFvjyRnp2QLU7atZFvPaWW2LdvNCS2yIP2Ga+tPvptSVWxjaE89M8ULbb
Oz/swGwUzJeJmnUeyPAqnIjnz4Go7kxmULgn0lXa/MbcOVC61Irbr3tCfuox
P0ZohcgRTlujmCI7gx2TfMkKssphm7RjFM8t/jbWehPsOBgy6X+couhqfKXb
CgJFiPo+7zuKLTLdJiUIjugUGcpMitaKibzg1QTlXvo3WfkU1f6G4rtBBPqb
7zpKz1OkJc9d80BKoGznpd9qoHDq9z3QnUqQWxwTfbiR4tmJBqHvNwTFCRof
vyaKAi//+tNHCapmKyeaNBQWqet5kccJuiTm0XfuUbwVSnJf5BLYdxOfp90U
zWFxVQNlBO7qJMHpXorDU0Obgy4QLE15qJc/p1hZkvC2/CJBoH3+hZd9FOrh
Pb47fyaI324jGBqiyE8/1D58g2Dfsq/0F0cowhbN2B1SR5Bi/PRugo6C/zCN
qOsJsiuKvx0fp0hxOBahuE1QlMyJqpmggJbP6WgmOB8sX7VvkmJCoTqzWEug
XvCb9Yopikvz5wRktRFcH7HTv3tHEVOX89fYHYJ/AJIt56g=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Line[CompressedData["
1:eJwtxQ841HcAx/HLnWrnxPlTvpWbq/Pv/PdtPUn1+xQ1ISWZp9Oau3bYCuVx
Tfoza0m26Go3fychqjWkLotWKzIT7lBJS08t9EfM/Lk4SdueZ+/neT1voSxu
o9yAxWKt/td/b014odAKBhjW/0UxbTn98SNMBvcad7qihontdexWl+uZYYMg
9QkrDcMVHrJ/vISFB71dRes9O5kM0yZxYQQbHLtZIsOtTxjZw02/spun489X
gRXSqR5mV/0hWZw9F3lLcm6K0l4ylTt5IVZrjbF0jdigtn6AKdy7vc89zBTB
tGz5oOsQc7BgMni0nw99cdTxvpARhnXnCX5JModx51kHEqtj7BIiEzeJLZHy
vdeWGVVjTI8u6yOja7MRd6m/9GmHnvHv/Xz/iV1WuCoZTN9vO8kE9SidBIK5
+KI+8UrAZ1NMX50s+feyedjoZ7af7cOCK7/D2ucTa/wwbNKP6GngMjpp14gA
gpaTz0b3GODDAcnYglAbbNwRWnGkiI3O2k+nSZyFWBajJVX1HFw+cmurjU4I
6ck/TCT3DBFpqHii0SzAYpXx3UdvpmNb/N7LvNyF8K1pW9g5aybcopw0gVIR
eKs2W+6Y/x60Zs5GCi9bfJ0x895jcHG1/GCeM9sOi4zW2twONsLeaeINzY/s
kBVY6aXawwO3K8kvVm2PysGu0bE8Y/SWClUF+xzAqcvxbv9xFlQOhFMd6ghu
+IENR1tNoMyNbJDaiFHCT0rcussUEtXHGt5zMU6VZubUjZli3LdEX3DdCaPW
DYXZaXx0965KrE11htzlxuBZvhmKlnvMa5G6wPX9FpFjiRnKUhT8KBdXWJ4r
KuhxNUdq6LYAts4V97s3v+q/bI4PugrPpba4YYhlK5D7WSDbMa+sJcAd4qor
mVZtFvjyRnp2QLU7atZFvPaWW2LdvNCS2yIP2Ga+tPvptSVWxjaE89M8ULbb
Oz/swGwUzJeJmnUeyPAqnIjnz4Go7kxmULgn0lXa/MbcOVC61Irbr3tCfuox
P0ZohcgRTlujmCI7gx2TfMkKssphm7RjFM8t/jbWehPsOBgy6X+couhqfKXb
CgJFiPo+7zuKLTLdJiUIjugUGcpMitaKibzg1QTlXvo3WfkU1f6G4rtBBPqb
7zpKz1OkJc9d80BKoGznpd9qoHDq9z3QnUqQWxwTfbiR4tmJBqHvNwTFCRof
vyaKAi//+tNHCapmKyeaNBQWqet5kccJuiTm0XfuUbwVSnJf5BLYdxOfp90U
zWFxVQNlBO7qJMHpXorDU0Obgy4QLE15qJc/p1hZkvC2/CJBoH3+hZd9FOrh
Pb47fyaI324jGBqiyE8/1D58g2Dfsq/0F0cowhbN2B1SR5Bi/PRugo6C/zCN
qOsJsiuKvx0fp0hxOBahuE1QlMyJqpmggJbP6WgmOB8sX7VvkmJCoTqzWEug
XvCb9Yopikvz5wRktRFcH7HTv3tHEVOX89fYHYJ/AJIt56g=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0.8, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Line[CompressedData["
1:eJwtxQ841HcAx/HLnWrnxPlTvpWbq/Pv/PdtPUn1+xQ1ISWZp9Oau3bYCuVx
Tfoza0m26Go3fychqjWkLotWKzIT7lBJS08t9EfM/Lk4SdueZ+/neT1voSxu
o9yAxWKt/td/b014odAKBhjW/0UxbTn98SNMBvcad7qihontdexWl+uZYYMg
9QkrDcMVHrJ/vISFB71dRes9O5kM0yZxYQQbHLtZIsOtTxjZw02/spun489X
gRXSqR5mV/0hWZw9F3lLcm6K0l4ylTt5IVZrjbF0jdigtn6AKdy7vc89zBTB
tGz5oOsQc7BgMni0nw99cdTxvpARhnXnCX5JModx51kHEqtj7BIiEzeJLZHy
vdeWGVVjTI8u6yOja7MRd6m/9GmHnvHv/Xz/iV1WuCoZTN9vO8kE9SidBIK5
+KI+8UrAZ1NMX50s+feyedjoZ7af7cOCK7/D2ucTa/wwbNKP6GngMjpp14gA
gpaTz0b3GODDAcnYglAbbNwRWnGkiI3O2k+nSZyFWBajJVX1HFw+cmurjU4I
6ck/TCT3DBFpqHii0SzAYpXx3UdvpmNb/N7LvNyF8K1pW9g5aybcopw0gVIR
eKs2W+6Y/x60Zs5GCi9bfJ0x895jcHG1/GCeM9sOi4zW2twONsLeaeINzY/s
kBVY6aXawwO3K8kvVm2PysGu0bE8Y/SWClUF+xzAqcvxbv9xFlQOhFMd6ghu
+IENR1tNoMyNbJDaiFHCT0rcussUEtXHGt5zMU6VZubUjZli3LdEX3DdCaPW
DYXZaXx0965KrE11htzlxuBZvhmKlnvMa5G6wPX9FpFjiRnKUhT8KBdXWJ4r
KuhxNUdq6LYAts4V97s3v+q/bI4PugrPpba4YYhlK5D7WSDbMa+sJcAd4qor
mVZtFvjyRnp2QLU7atZFvPaWW2LdvNCS2yIP2Ga+tPvptSVWxjaE89M8ULbb
Oz/swGwUzJeJmnUeyPAqnIjnz4Go7kxmULgn0lXa/MbcOVC61Irbr3tCfuox
P0ZohcgRTlujmCI7gx2TfMkKssphm7RjFM8t/jbWehPsOBgy6X+couhqfKXb
CgJFiPo+7zuKLTLdJiUIjugUGcpMitaKibzg1QTlXvo3WfkU1f6G4rtBBPqb
7zpKz1OkJc9d80BKoGznpd9qoHDq9z3QnUqQWxwTfbiR4tmJBqHvNwTFCRof
vyaKAi//+tNHCapmKyeaNBQWqet5kccJuiTm0XfuUbwVSnJf5BLYdxOfp90U
zWFxVQNlBO7qJMHpXorDU0Obgy4QLE15qJc/p1hZkvC2/CJBoH3+hZd9FOrh
Pb47fyaI324jGBqiyE8/1D58g2Dfsq/0F0cowhbN2B1SR5Bi/PRugo6C/zCN
qOsJsiuKvx0fp0hxOBahuE1QlMyJqpmggJbP6WgmOB8sX7VvkmJCoTqzWEug
XvCb9Yopikvz5wRktRFcH7HTv3tHEVOX89fYHYJ/AJIt56g=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 1, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOjlGUH59S9gIpzOJyy7+TLYr0K5Qs4
1C9kEWi6+QbKF3HIKp97cMnS71C+hEPus5NmL3QYHCB8GQeft4lvfZJZoHwF
h5XG0w5yd3JA+UoOdg+mCT1ZxgPlqzhszc+/FpogAOWrOXCHeO3gzRGC8jUc
dDgW8rKUi0D5Wg51U5OvFDaKQfk6DhM3e5lUdktA+XoOVy9JbjSYKgXlGzgc
TdIIvzJfBso3dEhem1j9erkclG/kcNgv40hjhAKUb+zwRqZ63e8YRSjfxMH6
l51zWqKSAwA21Eux
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOjlGUH59S9gIpzOJyy7+TLYr0K5Qs4
1C9kEWi6+QbKF3HIKp97cMnS71C+hEPus5NmL3QYHCB8GQeft4lvfZJZoHwF
h5XG0w5yd3JA+UoOdg+mCT1ZxgPlqzhszc+/FpogAOWrOXCHeO3gzRGC8jUc
dDgW8rKUi0D5Wg51U5OvFDaKQfk6DhM3e5lUdktA+XoOVy9JbjSYKgXlGzgc
TdIIvzJfBso3dEhem1j9erkclG/kcNgv40hjhAKUb+zwRqZ63e8YRSjfxMH6
l51zWqKSAwA21Eux
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 1, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOjlGUH59S9gIpzOJyy7+TLYr0K5Qs4
1C9kEWi6+QbKF3HIKp97cMnS71C+hEPus5NmL3QYHCB8GQeft4lvfZJZoHwF
h5XG0w5yd3JA+UoOdg+mCT1ZxgPlqzhszc+/FpogAOWrOXCHeO3gzRGC8jUc
dDgW8rKUi0D5Wg51U5OvFDaKQfk6DhM3e5lUdktA+XoOVy9JbjSYKgXlGzgc
TdIIvzJfBso3dEhem1j9erkclG/kcNgv40hjhAKUb+zwRqZ63e8YRSjfxMH6
l51zWqKSAwA21Eux
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 1, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 1, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtkY9bzHcAx+92zaiLruZKdefuUyrXleozQ8P3TX6cIk7CakVHJ4qGjpYo
JWRP7aZOLbMmdelpUZQtkYlYqhMmTedxqnuoZ4ZyreOm2fPs9Tyv5/UHvMSK
xJWxH7BYrKD3/tdroapSxwALw/ofa/EBz8czWbDW0BNlc68yuXatkpPrObjV
m3xjYOt9RtG96gqnbQzOFTl/kl7+hNnefECR6GmNZtuc26W7nzE1X3LDnJbY
4tMSZbX67l/MyT3xA35r7LB5s+P5qO5BJqPYIn/9Jw+x9merO+2HGdY9Ay6l
OCDToM5zDTQzHknK5FWSibhg6TewtRamz1Sw2uYyH5qK4Y7gB6NMsHHL3qPb
nbBg5WXNd1o2QvvU3kKhM+SK0ulJn3MwcE2R/luVC2oDjVrWCyv48joFQesE
EF2Maddrx8CaMcXoh4ToY89s3jJvLBY/j/ibhItQ83LJDtm7cehq2siOkIph
P8g6yj1vg7rD16NFJjFaGniZGcG2UH6oMuh0BIel0VNlVhOwYceeOm6RGzoC
MjrWrbDDtE3euqUx7ijrKm/Odebhtr3URjVrCt7J4zVGEw8NZzKOSzkeyDzb
vUzTZI89bMmKtkceyDH0GxJ+dIC1PkW2rdYThqLgqhkpH8OoFecXp3ph/ay1
isiFE5HvNcmqPnwqNlRyBrViPtRFypsxIgmOsr/YEvKCj4j8KB33qQTcJ2Nc
e39xxMiCMnNxozfG5i8/XZLnhF7j/OSmQ1L4ey8UNKybhJI5/i7tMT4waLoS
3s52RlWWirfJxxcNfU5l+TYuOBS+IYRj8oX+UiVf3OmC6fqTFYfapyErTq+4
X+OKwqnHq9pD/LB2pL6gZ58Aab/mFIbU+6E6cnq5Y5QQy1zCy265+0Mu47xk
ZkzGvG03I3nZ/sjlXlGvZ4tQ7KpwbzP54+foVn5dogju18qPhUYGYJj48i50
iqD2aZLcbQzAQ+/A09WfiaEcsrrTIqFIE2qkTIUYippBUfY3FIGZi6akTCBI
yAizBH9LsSj9WfF8HoEqrPYBN49i5d4jzjYO77+ZVLnqYxSbd+smfM8nODPL
/LbgBEVh/Oo3lwUE5qujndpKitdhyttsKYH6Ljfn+k2Kn9wPfpUtIyg6tTXu
YAtFvdjrtTyY4FSSLkjWSnFdeGub81KCC3z1m1Ydhd5p/MbK5QT6CIe4e/cp
xtkeC21fTeDZOymop5dCaSpz48US+NWmCEuNFNsHF//wh5IgMKvbHPuUYt+L
fqeSOIKlnieq+wco8vp9xtMEgh3xIuGrVxRNj+pGVu0kSJ2933xuiEL3cM1O
gYogy7bn9yQTxcMH5ufGXQSFZ099PTJC8erOnN5dKQQl6VabLr6h+Ef3OIpJ
JaiUx85PtVCMbdvf9dE+glpyQzD3HYVDi1tYRxpB45CHeXSUYvKN5vbC/QT/
Aluq0bs=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Line[CompressedData["
1:eJwtkY9bzHcAx+92zaiLruZKdefuUyrXleozQ8P3TX6cIk7CakVHJ4qGjpYo
JWRP7aZOLbMmdelpUZQtkYlYqhMmTedxqnuoZ4ZyreOm2fPs9Tyv5/UHvMSK
xJWxH7BYrKD3/tdroapSxwALw/ofa/EBz8czWbDW0BNlc68yuXatkpPrObjV
m3xjYOt9RtG96gqnbQzOFTl/kl7+hNnefECR6GmNZtuc26W7nzE1X3LDnJbY
4tMSZbX67l/MyT3xA35r7LB5s+P5qO5BJqPYIn/9Jw+x9merO+2HGdY9Ay6l
OCDToM5zDTQzHknK5FWSibhg6TewtRamz1Sw2uYyH5qK4Y7gB6NMsHHL3qPb
nbBg5WXNd1o2QvvU3kKhM+SK0ulJn3MwcE2R/luVC2oDjVrWCyv48joFQesE
EF2Maddrx8CaMcXoh4ToY89s3jJvLBY/j/ibhItQ83LJDtm7cehq2siOkIph
P8g6yj1vg7rD16NFJjFaGniZGcG2UH6oMuh0BIel0VNlVhOwYceeOm6RGzoC
MjrWrbDDtE3euqUx7ijrKm/Odebhtr3URjVrCt7J4zVGEw8NZzKOSzkeyDzb
vUzTZI89bMmKtkceyDH0GxJ+dIC1PkW2rdYThqLgqhkpH8OoFecXp3ph/ay1
isiFE5HvNcmqPnwqNlRyBrViPtRFypsxIgmOsr/YEvKCj4j8KB33qQTcJ2Nc
e39xxMiCMnNxozfG5i8/XZLnhF7j/OSmQ1L4ey8UNKybhJI5/i7tMT4waLoS
3s52RlWWirfJxxcNfU5l+TYuOBS+IYRj8oX+UiVf3OmC6fqTFYfapyErTq+4
X+OKwqnHq9pD/LB2pL6gZ58Aab/mFIbU+6E6cnq5Y5QQy1zCy265+0Mu47xk
ZkzGvG03I3nZ/sjlXlGvZ4tQ7KpwbzP54+foVn5dogju18qPhUYGYJj48i50
iqD2aZLcbQzAQ+/A09WfiaEcsrrTIqFIE2qkTIUYippBUfY3FIGZi6akTCBI
yAizBH9LsSj9WfF8HoEqrPYBN49i5d4jzjYO77+ZVLnqYxSbd+smfM8nODPL
/LbgBEVh/Oo3lwUE5qujndpKitdhyttsKYH6Ljfn+k2Kn9wPfpUtIyg6tTXu
YAtFvdjrtTyY4FSSLkjWSnFdeGub81KCC3z1m1Ydhd5p/MbK5QT6CIe4e/cp
xtkeC21fTeDZOymop5dCaSpz48US+NWmCEuNFNsHF//wh5IgMKvbHPuUYt+L
fqeSOIKlnieq+wco8vp9xtMEgh3xIuGrVxRNj+pGVu0kSJ2933xuiEL3cM1O
gYogy7bn9yQTxcMH5ufGXQSFZ099PTJC8erOnN5dKQQl6VabLr6h+Ef3OIpJ
JaiUx85PtVCMbdvf9dE+glpyQzD3HYVDi1tYRxpB45CHeXSUYvKN5vbC/QT/
Aluq0bs=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 1, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJwtkY9bzHcAx+92zaiLruZKdefuUyrXleozQ8P3TX6cIk7CakVHJ4qGjpYo
JWRP7aZOLbMmdelpUZQtkYlYqhMmTedxqnuoZ4ZyreOm2fPs9Tyv5/UHvMSK
xJWxH7BYrKD3/tdroapSxwALw/ofa/EBz8czWbDW0BNlc68yuXatkpPrObjV
m3xjYOt9RtG96gqnbQzOFTl/kl7+hNnefECR6GmNZtuc26W7nzE1X3LDnJbY
4tMSZbX67l/MyT3xA35r7LB5s+P5qO5BJqPYIn/9Jw+x9merO+2HGdY9Ay6l
OCDToM5zDTQzHknK5FWSibhg6TewtRamz1Sw2uYyH5qK4Y7gB6NMsHHL3qPb
nbBg5WXNd1o2QvvU3kKhM+SK0ulJn3MwcE2R/luVC2oDjVrWCyv48joFQesE
EF2Maddrx8CaMcXoh4ToY89s3jJvLBY/j/ibhItQ83LJDtm7cehq2siOkIph
P8g6yj1vg7rD16NFJjFaGniZGcG2UH6oMuh0BIel0VNlVhOwYceeOm6RGzoC
MjrWrbDDtE3euqUx7ijrKm/Odebhtr3URjVrCt7J4zVGEw8NZzKOSzkeyDzb
vUzTZI89bMmKtkceyDH0GxJ+dIC1PkW2rdYThqLgqhkpH8OoFecXp3ph/ay1
isiFE5HvNcmqPnwqNlRyBrViPtRFypsxIgmOsr/YEvKCj4j8KB33qQTcJ2Nc
e39xxMiCMnNxozfG5i8/XZLnhF7j/OSmQ1L4ey8UNKybhJI5/i7tMT4waLoS
3s52RlWWirfJxxcNfU5l+TYuOBS+IYRj8oX+UiVf3OmC6fqTFYfapyErTq+4
X+OKwqnHq9pD/LB2pL6gZ58Aab/mFIbU+6E6cnq5Y5QQy1zCy265+0Mu47xk
ZkzGvG03I3nZ/sjlXlGvZ4tQ7KpwbzP54+foVn5dogju18qPhUYGYJj48i50
iqD2aZLcbQzAQ+/A09WfiaEcsrrTIqFIE2qkTIUYippBUfY3FIGZi6akTCBI
yAizBH9LsSj9WfF8HoEqrPYBN49i5d4jzjYO77+ZVLnqYxSbd+smfM8nODPL
/LbgBEVh/Oo3lwUE5qujndpKitdhyttsKYH6Ljfn+k2Kn9wPfpUtIyg6tTXu
YAtFvdjrtTyY4FSSLkjWSnFdeGub81KCC3z1m1Ydhd5p/MbK5QT6CIe4e/cp
xtkeC21fTeDZOymop5dCaSpz48US+NWmCEuNFNsHF//wh5IgMKvbHPuUYt+L
fqeSOIKlnieq+wco8vp9xtMEgh3xIuGrVxRNj+pGVu0kSJ2933xuiEL3cM1O
gYogy7bn9yQTxcMH5ufGXQSFZ099PTJC8erOnN5dKQQl6VabLr6h+Ef3OIpJ
JaiUx85PtVCMbdvf9dE+glpyQzD3HYVDi1tYRxpB45CHeXSUYvKN5vbC/QT/
Aluq0bs=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0.6, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUM+a8lqNrm3UHEOh9mXCiSW3r4K5Qs4
XHI8fvXaI5g+EYc/kcVXNKr/QPkSDmlLYxrlrjI7QPgyDrtuRc6UD+OE8hUc
DEu/LLc8xwflKzn8n3KCR0FRCMpXcTjydOKlfzdFoHw1B9l0I0G5SeJQvobD
sYVevzZ7SkH5Wg6H53+Nf8QgC+XrOOxW9Ao9sF0eytdzcNPda6JvrgjlGziw
mTVNOjRZCco3dDCdHdHU8lYZyjdyqFhi+HmShyqUb+xwfObxaZMWq0H5Jg7B
W25INf9TdwAAIjVPZQ==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUM+a8lqNrm3UHEOh9mXCiSW3r4K5Qs4
XHI8fvXaI5g+EYc/kcVXNKr/QPkSDmlLYxrlrjI7QPgyDrtuRc6UD+OE8hUc
DEu/LLc8xwflKzn8n3KCR0FRCMpXcTjydOKlfzdFoHw1B9l0I0G5SeJQvobD
sYVevzZ7SkH5Wg6H53+Nf8QgC+XrOOxW9Ao9sF0eytdzcNPda6JvrgjlGziw
mTVNOjRZCco3dDCdHdHU8lYZyjdyqFhi+HmShyqUb+xwfObxaZMWq0H5Jg7B
W25INf9TdwAAIjVPZQ==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0.6, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgUM+a8lqNrm3UHEOh9mXCiSW3r4K5Qs4
XHI8fvXaI5g+EYc/kcVXNKr/QPkSDmlLYxrlrjI7QPgyDrtuRc6UD+OE8hUc
DEu/LLc8xwflKzn8n3KCR0FRCMpXcTjydOKlfzdFoHw1B9l0I0G5SeJQvobD
sYVevzZ7SkH5Wg6H53+Nf8QgC+XrOOxW9Ao9sF0eytdzcNPda6JvrgjlGziw
mTVNOjRZCco3dDCdHdHU8lYZyjdyqFhi+HmShyqUb+xwfObxaZMWq0H5Jg7B
W25INf9TdwAAIjVPZQ==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0.6, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0.6, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtjH0w1HkAh4nOjZZZtu28ZM+y/H6txeo7rtOc9lPcyEtdLtLphK02l1os
e9OhSS/y0mDrjBxJKK52VIredCgKt9nmvN9xncma8lKDbe+sNnvdzD0zzzz/
PVxx0tf7lpmYmGz64H/t2TjLtRoygcn/FDJV/Ko4MyRoLuT2f68SiUciWs2e
foSBwMufSzljopTHJ8VJlCWCnvvHvCWTooZkxna7YCt0GLyTzg3OiqoyEqeE
UUx4OMW9uiXViY5XGsLfztjgh6X+oqt39SKTvjE8SGehWhLVYvH6vcg9TXI4
gs9GV/IDW9kGU2h053as+GUVbhYmxWyJNUPIxIEjZ1PsYPSVBb6qX46tGoUH
h+OA5ovvpLfnLDDVLs7qqnfEVGLdjRRrS3jZDDoFxDoho626cGYnA5YiXfyo
loNj8rYTEZnWCHod/Y9LpDO0v5dYtkiYGH601zRawMXzP5jy6TwbNOV27HbW
cbGMsTqx6CdbSJbLx9RqFwybfuXNamNhjyyjiVHmilcU66hV30p47/dQh8Xz
cO16WXLVGBvPbAUr5H5ucDMEC9nLP0HztePlAjN3DB7OzzCy7ZBhyt/29E93
+N2fL+72t4flaPpmaSOFiBjONs84B0zUcosrM2nUCUdKLJIcUUzbm9+LXANl
V6vyYfFqKMoknfHOfEwrfMPma50QXRyjZrzkY+y+tPDBLQ4WAi/rK1s8kHPl
2QXJ0KcYn9h0+FGOAL6auIr2VGdU+/s49sR7YmngUG+ABRf12XKb/Z5emIgN
2GJUcJETuSfUTOeFurLFUgs7F/iOVl3J6fFG+53HqqNXXVC6pry+J1SIxYPf
BBLiiqNtBaWh94Q4bW56aUenK7Y4Rl7+leeDv8Py+5/s5GGjtHOXTZ4PjniO
hsjGeKhcLeY91flg9+zGnwtS3cBrryvZumstYkKTQzUGNyg8H/F7W9ZiXVRW
a84Jd0i05r918wkOfHnJoZxNQdww75xXRHBXpWierKBw8Ph2Q8gZglQZKzbk
IgX59sYhxo8EAvuSZcpqCrk6eaGihKBKUh58sI7CNT/9u3MVBHmmtUNvblDQ
PzQO1ioJotc1a7XtFBS9jIKOTgJD9YTH0iSFsppDCae6CZqCE57tnqFQk6YO
2KwiSJ6dkrW+oXB7lWJRpSbQ+M/ey9JSGI1mJfQNEPQMLwaZvadAjdsHvBgn
OG/N3Psxk4awMZ1zaYIgqumsxXe2NNZnj+j3vSSw+Zat7F5JI4yquDE5RZB9
xWE+356GLNGZMzdHIA10y7JypZH5xTH9TS0BPV3nKnWjkW31oj9NR/DiDL9T
TdEovV5zemHhw/8vb2uFgEZ1lvn++4sEzFM3G2a9aCjD923KNBCoBL6R4T40
Gl2eOG1YIjjZd2ehgdBo0brrjUaCDenrz9t+RuNfcM7RtQ==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Line[CompressedData["
1:eJwtjH0w1HkAh4nOjZZZtu28ZM+y/H6txeo7rtOc9lPcyEtdLtLphK02l1os
e9OhSS/y0mDrjBxJKK52VIredCgKt9nmvN9xncma8lKDbe+sNnvdzD0zzzz/
PVxx0tf7lpmYmGz64H/t2TjLtRoygcn/FDJV/Ko4MyRoLuT2f68SiUciWs2e
foSBwMufSzljopTHJ8VJlCWCnvvHvCWTooZkxna7YCt0GLyTzg3OiqoyEqeE
UUx4OMW9uiXViY5XGsLfztjgh6X+oqt39SKTvjE8SGehWhLVYvH6vcg9TXI4
gs9GV/IDW9kGU2h053as+GUVbhYmxWyJNUPIxIEjZ1PsYPSVBb6qX46tGoUH
h+OA5ovvpLfnLDDVLs7qqnfEVGLdjRRrS3jZDDoFxDoho626cGYnA5YiXfyo
loNj8rYTEZnWCHod/Y9LpDO0v5dYtkiYGH601zRawMXzP5jy6TwbNOV27HbW
cbGMsTqx6CdbSJbLx9RqFwybfuXNamNhjyyjiVHmilcU66hV30p47/dQh8Xz
cO16WXLVGBvPbAUr5H5ucDMEC9nLP0HztePlAjN3DB7OzzCy7ZBhyt/29E93
+N2fL+72t4flaPpmaSOFiBjONs84B0zUcosrM2nUCUdKLJIcUUzbm9+LXANl
V6vyYfFqKMoknfHOfEwrfMPma50QXRyjZrzkY+y+tPDBLQ4WAi/rK1s8kHPl
2QXJ0KcYn9h0+FGOAL6auIr2VGdU+/s49sR7YmngUG+ABRf12XKb/Z5emIgN
2GJUcJETuSfUTOeFurLFUgs7F/iOVl3J6fFG+53HqqNXXVC6pry+J1SIxYPf
BBLiiqNtBaWh94Q4bW56aUenK7Y4Rl7+leeDv8Py+5/s5GGjtHOXTZ4PjniO
hsjGeKhcLeY91flg9+zGnwtS3cBrryvZumstYkKTQzUGNyg8H/F7W9ZiXVRW
a84Jd0i05r918wkOfHnJoZxNQdww75xXRHBXpWierKBw8Ph2Q8gZglQZKzbk
IgX59sYhxo8EAvuSZcpqCrk6eaGihKBKUh58sI7CNT/9u3MVBHmmtUNvblDQ
PzQO1ioJotc1a7XtFBS9jIKOTgJD9YTH0iSFsppDCae6CZqCE57tnqFQk6YO
2KwiSJ6dkrW+oXB7lWJRpSbQ+M/ey9JSGI1mJfQNEPQMLwaZvadAjdsHvBgn
OG/N3Psxk4awMZ1zaYIgqumsxXe2NNZnj+j3vSSw+Zat7F5JI4yquDE5RZB9
xWE+356GLNGZMzdHIA10y7JypZH5xTH9TS0BPV3nKnWjkW31oj9NR/DiDL9T
TdEovV5zemHhw/8vb2uFgEZ1lvn++4sEzFM3G2a9aCjD923KNBCoBL6R4T40
Gl2eOG1YIjjZd2ehgdBo0brrjUaCDenrz9t+RuNfcM7RtQ==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0.6, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Line[CompressedData["
1:eJwtjH0w1HkAh4nOjZZZtu28ZM+y/H6txeo7rtOc9lPcyEtdLtLphK02l1os
e9OhSS/y0mDrjBxJKK52VIredCgKt9nmvN9xncma8lKDbe+sNnvdzD0zzzz/
PVxx0tf7lpmYmGz64H/t2TjLtRoygcn/FDJV/Ko4MyRoLuT2f68SiUciWs2e
foSBwMufSzljopTHJ8VJlCWCnvvHvCWTooZkxna7YCt0GLyTzg3OiqoyEqeE
UUx4OMW9uiXViY5XGsLfztjgh6X+oqt39SKTvjE8SGehWhLVYvH6vcg9TXI4
gs9GV/IDW9kGU2h053as+GUVbhYmxWyJNUPIxIEjZ1PsYPSVBb6qX46tGoUH
h+OA5ovvpLfnLDDVLs7qqnfEVGLdjRRrS3jZDDoFxDoho626cGYnA5YiXfyo
loNj8rYTEZnWCHod/Y9LpDO0v5dYtkiYGH601zRawMXzP5jy6TwbNOV27HbW
cbGMsTqx6CdbSJbLx9RqFwybfuXNamNhjyyjiVHmilcU66hV30p47/dQh8Xz
cO16WXLVGBvPbAUr5H5ucDMEC9nLP0HztePlAjN3DB7OzzCy7ZBhyt/29E93
+N2fL+72t4flaPpmaSOFiBjONs84B0zUcosrM2nUCUdKLJIcUUzbm9+LXANl
V6vyYfFqKMoknfHOfEwrfMPma50QXRyjZrzkY+y+tPDBLQ4WAi/rK1s8kHPl
2QXJ0KcYn9h0+FGOAL6auIr2VGdU+/s49sR7YmngUG+ABRf12XKb/Z5emIgN
2GJUcJETuSfUTOeFurLFUgs7F/iOVl3J6fFG+53HqqNXXVC6pry+J1SIxYPf
BBLiiqNtBaWh94Q4bW56aUenK7Y4Rl7+leeDv8Py+5/s5GGjtHOXTZ4PjniO
hsjGeKhcLeY91flg9+zGnwtS3cBrryvZumstYkKTQzUGNyg8H/F7W9ZiXVRW
a84Jd0i05r918wkOfHnJoZxNQdww75xXRHBXpWierKBw8Ph2Q8gZglQZKzbk
IgX59sYhxo8EAvuSZcpqCrk6eaGihKBKUh58sI7CNT/9u3MVBHmmtUNvblDQ
PzQO1ioJotc1a7XtFBS9jIKOTgJD9YTH0iSFsppDCae6CZqCE57tnqFQk6YO
2KwiSJ6dkrW+oXB7lWJRpSbQ+M/ey9JSGI1mJfQNEPQMLwaZvadAjdsHvBgn
OG/N3Psxk4awMZ1zaYIgqumsxXe2NNZnj+j3vSSw+Zat7F5JI4yquDE5RZB9
xWE+356GLNGZMzdHIA10y7JypZH5xTH9TS0BPV3nKnWjkW31oj9NR/DiDL9T
TdEovV5zemHhw/8vb2uFgEZ1lvn++4sEzFM3G2a9aCjD923KNBCoBL6R4T40
Gl2eOG1YIjjZd2ehgdBo0brrjUaCDenrz9t+RuNfcM7RtQ==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPS7iT2P79h4hwOdlu3350pfh3KF3AI
O6jOrbrsM5Qv4jBFU/Dx5nsMDhC+hEPWa4UGsUPsUL6Mw5FbHoGR0/mgfAWH
ot4WuRmbhaB8JYd+tsmRslJiUL6KQ6D6s/599ZJQvppD8UufmP1PZKB8DYeG
C4dPLVFRgPK1HL6sX7t5zzVFKF/HIW3mzqCNHcpQvp5DQN7Ww51WqlC+gQPb
FQNpq/dqUL6hgyJ3y6ofczWgfCOHwoVup1r9taB8Y4fVMx4mZALNhfBNHO4d
Tg04sVLXAQCE1U4W
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPS7iT2P79h4hwOdlu3350pfh3KF3AI
O6jOrbrsM5Qv4jBFU/Dx5nsMDhC+hEPWa4UGsUPsUL6Mw5FbHoGR0/mgfAWH
ot4WuRmbhaB8JYd+tsmRslJiUL6KQ6D6s/599ZJQvppD8UufmP1PZKB8DYeG
C4dPLVFRgPK1HL6sX7t5zzVFKF/HIW3mzqCNHcpQvp5DQN7Ww51WqlC+gQPb
FQNpq/dqUL6hgyJ3y6ofczWgfCOHwoVup1r9taB8Y4fVMx4mZALNhfBNHO4d
Tg04sVLXAQCE1U4W
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPS7iT2P79h4hwOdlu3350pfh3KF3AI
O6jOrbrsM5Qv4jBFU/Dx5nsMDhC+hEPWa4UGsUPsUL6Mw5FbHoGR0/mgfAWH
ot4WuRmbhaB8JYd+tsmRslJiUL6KQ6D6s/599ZJQvppD8UufmP1PZKB8DYeG
C4dPLVFRgPK1HL6sX7t5zzVFKF/HIW3mzqCNHcpQvp5DQN7Ww51WqlC+gQPb
FQNpq/dqUL6hgyJ3y6ofczWgfCOHwoVup1r9taB8Y4fVMx4mZALNhfBNHO4d
Tg04sVLXAQCE1U4W
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtxQ0w1HkAh3FvcWkNmzjC3u7GLrt+on9dZ4/bb/Z689KRl24oQl5OKI5O
uDs2L6UhdyfKS/LadUIaNdTpRV5y7OZwmPMyedmRnczkZbFF7m7mnpnPPKyg
M0dD1FRUVJz+9d+1izgmlfvVoPJ/OXrdvLKT6jj2dEkQO9siDBrxeqLeo4lv
dFYO8IvHhTHtaUFnuNoQHxB4rP8qFzacpXkaHdaBc9xRe9HNBWFZ0mm57TE9
dBdLe0P9V4Xi0jWPpTd0RD1gskcergtV+l/h90R9uI+ypNwfVMGJC03w4hnA
ois/h/61BqYVBT5bWgyRVbdcs0NVC86yiO9/jjHCbxvNriFTm3FkOpfPYGzH
tnaZKreJBvnzoJQXtSbQvbCmTz+uCxv6oJkowAzBPo+8rprSoS1UBI4uMpA+
M+f2IHYrDs75rrC9mciw6fvojEwfw62nVH2tWbhTL5eEeRjg/sU2f6aCBaPa
hGdLlYYI3RT/Sipl49TJpnPGBkYIjk26TyvcgZUrUb59kcbYGcaXugaao17p
c6i7ZTtebrXeEm9vgf3GCyt+fFM8qhMXWatzwLqvNpiSYoYkVZ57zxgH45rt
8Y4LDGiPJh6KbuQioGtMt8SGCVk1K6802RLfSvSTZUNM5FkaazR7W+HcHXbX
+Sss5BaGdgYyebhxOJIMC9jwzTshpc3wMKzemz84ycbql1XK0sd8qFynTTCv
78CUzCmhNdMabm8uOO0RmaPc0c5EEkiQtX0g7ep7c9Smx9PDiA3kmgHjT25Z
INM72EVdYYMTehqOWe4c7Bktu50p2YmWpdTkm1pcXLMqqpW42EJUIOhPucfF
j0+zr7k026JpW4927WlLuJl4V/1hbgdh/XcHz7OssC+6049+yQ6vtfyLdLut
UGoaZN6jsEPq52a982IezJ/fyj/itwtC8rHpDRs+ckkrr+/xLug58KPkg3yE
Lmr82cWjILUwKhVnWyOoYYF56QqFBonw9fRegkix55rzTxRMGRWNYwKCeM/G
IdovFNKiNVMHHQkuKuJzcvMpeOtKjF+ICOrsle8LSiisuvu61HxFoHy2MVhd
Q8FhIK4uJowgt4+W3dZJoePv23Ef8gkKK6LCM7oo2PJ19q1cJ6iIk4oOdVMo
SDqr87aY4IFh7rtuKYUI073VE+UEo7764f1/Udji3zbUVkfAnTIWTU5R8JgY
F1zuILBtTGRUyig02TlppXURCNJHlCEzFNjiqv7kHgJXbsndWTmFBXZkZHQf
QexpJmN+nkLeKWWJxzhBskOq8t4ihfXG4xHOEwTpOpMDcQoKYZuefiqaJrhW
X3F5dZXCZ9UZL3fLCcpTNMIevqNQtjxbROYIajxCnJLXKGw+6BbOeUvQyO4w
++IDhbMFd3d/skjweJGj3NigMDKjr2q0TPAPuPvJ5w==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Line[CompressedData["
1:eJwtxQ0w1HkAh3FvcWkNmzjC3u7GLrt+on9dZ4/bb/Z689KRl24oQl5OKI5O
uDs2L6UhdyfKS/LadUIaNdTpRV5y7OZwmPMyedmRnczkZbFF7m7mnpnPPKyg
M0dD1FRUVJz+9d+1izgmlfvVoPJ/OXrdvLKT6jj2dEkQO9siDBrxeqLeo4lv
dFYO8IvHhTHtaUFnuNoQHxB4rP8qFzacpXkaHdaBc9xRe9HNBWFZ0mm57TE9
dBdLe0P9V4Xi0jWPpTd0RD1gskcergtV+l/h90R9uI+ypNwfVMGJC03w4hnA
ois/h/61BqYVBT5bWgyRVbdcs0NVC86yiO9/jjHCbxvNriFTm3FkOpfPYGzH
tnaZKreJBvnzoJQXtSbQvbCmTz+uCxv6oJkowAzBPo+8rprSoS1UBI4uMpA+
M+f2IHYrDs75rrC9mciw6fvojEwfw62nVH2tWbhTL5eEeRjg/sU2f6aCBaPa
hGdLlYYI3RT/Sipl49TJpnPGBkYIjk26TyvcgZUrUb59kcbYGcaXugaao17p
c6i7ZTtebrXeEm9vgf3GCyt+fFM8qhMXWatzwLqvNpiSYoYkVZ57zxgH45rt
8Y4LDGiPJh6KbuQioGtMt8SGCVk1K6802RLfSvSTZUNM5FkaazR7W+HcHXbX
+Sss5BaGdgYyebhxOJIMC9jwzTshpc3wMKzemz84ycbql1XK0sd8qFynTTCv
78CUzCmhNdMabm8uOO0RmaPc0c5EEkiQtX0g7ep7c9Smx9PDiA3kmgHjT25Z
INM72EVdYYMTehqOWe4c7Bktu50p2YmWpdTkm1pcXLMqqpW42EJUIOhPucfF
j0+zr7k026JpW4927WlLuJl4V/1hbgdh/XcHz7OssC+6049+yQ6vtfyLdLut
UGoaZN6jsEPq52a982IezJ/fyj/itwtC8rHpDRs+ckkrr+/xLug58KPkg3yE
Lmr82cWjILUwKhVnWyOoYYF56QqFBonw9fRegkix55rzTxRMGRWNYwKCeM/G
IdovFNKiNVMHHQkuKuJzcvMpeOtKjF+ICOrsle8LSiisuvu61HxFoHy2MVhd
Q8FhIK4uJowgt4+W3dZJoePv23Ef8gkKK6LCM7oo2PJ19q1cJ6iIk4oOdVMo
SDqr87aY4IFh7rtuKYUI073VE+UEo7764f1/Udji3zbUVkfAnTIWTU5R8JgY
F1zuILBtTGRUyig02TlppXURCNJHlCEzFNjiqv7kHgJXbsndWTmFBXZkZHQf
QexpJmN+nkLeKWWJxzhBskOq8t4ihfXG4xHOEwTpOpMDcQoKYZuefiqaJrhW
X3F5dZXCZ9UZL3fLCcpTNMIevqNQtjxbROYIajxCnJLXKGw+6BbOeUvQyO4w
++IDhbMFd3d/skjweJGj3NigMDKjr2q0TPAPuPvJ5w==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Line[CompressedData["
1:eJwtxQ0w1HkAh3FvcWkNmzjC3u7GLrt+on9dZ4/bb/Z689KRl24oQl5OKI5O
uDs2L6UhdyfKS/LadUIaNdTpRV5y7OZwmPMyedmRnczkZbFF7m7mnpnPPKyg
M0dD1FRUVJz+9d+1izgmlfvVoPJ/OXrdvLKT6jj2dEkQO9siDBrxeqLeo4lv
dFYO8IvHhTHtaUFnuNoQHxB4rP8qFzacpXkaHdaBc9xRe9HNBWFZ0mm57TE9
dBdLe0P9V4Xi0jWPpTd0RD1gskcergtV+l/h90R9uI+ypNwfVMGJC03w4hnA
ois/h/61BqYVBT5bWgyRVbdcs0NVC86yiO9/jjHCbxvNriFTm3FkOpfPYGzH
tnaZKreJBvnzoJQXtSbQvbCmTz+uCxv6oJkowAzBPo+8rprSoS1UBI4uMpA+
M+f2IHYrDs75rrC9mciw6fvojEwfw62nVH2tWbhTL5eEeRjg/sU2f6aCBaPa
hGdLlYYI3RT/Sipl49TJpnPGBkYIjk26TyvcgZUrUb59kcbYGcaXugaao17p
c6i7ZTtebrXeEm9vgf3GCyt+fFM8qhMXWatzwLqvNpiSYoYkVZ57zxgH45rt
8Y4LDGiPJh6KbuQioGtMt8SGCVk1K6802RLfSvSTZUNM5FkaazR7W+HcHXbX
+Sss5BaGdgYyebhxOJIMC9jwzTshpc3wMKzemz84ycbql1XK0sd8qFynTTCv
78CUzCmhNdMabm8uOO0RmaPc0c5EEkiQtX0g7ep7c9Smx9PDiA3kmgHjT25Z
INM72EVdYYMTehqOWe4c7Bktu50p2YmWpdTkm1pcXLMqqpW42EJUIOhPucfF
j0+zr7k026JpW4927WlLuJl4V/1hbgdh/XcHz7OssC+6049+yQ6vtfyLdLut
UGoaZN6jsEPq52a982IezJ/fyj/itwtC8rHpDRs+ckkrr+/xLug58KPkg3yE
Lmr82cWjILUwKhVnWyOoYYF56QqFBonw9fRegkix55rzTxRMGRWNYwKCeM/G
IdovFNKiNVMHHQkuKuJzcvMpeOtKjF+ICOrsle8LSiisuvu61HxFoHy2MVhd
Q8FhIK4uJowgt4+W3dZJoePv23Ef8gkKK6LCM7oo2PJ19q1cJ6iIk4oOdVMo
SDqr87aY4IFh7rtuKYUI073VE+UEo7764f1/Udji3zbUVkfAnTIWTU5R8JgY
F1zuILBtTGRUyig02TlppXURCNJHlCEzFNjiqv7kHgJXbsndWTmFBXZkZHQf
QexpJmN+nkLeKWWJxzhBskOq8t4ihfXG4xHOEwTpOpMDcQoKYZuefiqaJrhW
X3F5dZXCZ9UZL3fLCcpTNMIevqNQtjxbROYIajxCnJLXKGw+6BbOeUvQyO4w
++IDhbMFd3d/skjweJGj3NigMDKjr2q0TPAPuPvJ5w==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.6, 0, 0.6], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], 
         PointBox[{{1., 0.}, {2., 1.2183831965664105`}, {3., 
          0.3891809299340975}, {4., 1.4212589601096166`}, {5., 
          2.4628585107148493`}, {6., 3.4895633949866802`}, {7., 
          4.511651011349366}, {8., 5.531773959500982}, {9., 
          6.550741823549049}, {10., 7.568929546687534}, {11., 
          8.586558084137197}, {12., 9.603771085784157}, {13., 
          10.62066670853927}, {14., 11.637314061240001`}, {15., 
          12.653731942077398`}, {16., 13.681343554382247`}, {17., 
          14.685537186566195`}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             
             Point[{{1., 0.}, {2., 1.2183831965664105`}, {3., 
              0.3891809299340975}, {4., 1.4212589601096166`}, {5., 
              2.4628585107148493`}, {6., 3.4895633949866802`}, {7., 
              4.511651011349366}, {8., 5.531773959500982}, {9., 
              6.550741823549049}, {10., 7.568929546687534}, {11., 
              8.586558084137197}, {12., 9.603771085784157}, {13., 
              10.62066670853927}, {14., 11.637314061240001`}, {15., 
              12.653731942077398`}, {16., 13.681343554382247`}, {17., 
              14.685537186566195`}}]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.6, 0, 0.6]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          
          Point[{{1., 0.}, {2., 1.2183831965664105`}, {3., 
           0.3891809299340975}, {4., 1.4212589601096166`}, {5., 
           2.4628585107148493`}, {6., 3.4895633949866802`}, {7., 
           4.511651011349366}, {8., 5.531773959500982}, {9., 
           6.550741823549049}, {10., 7.568929546687534}, {11., 
           8.586558084137197}, {12., 9.603771085784157}, {13., 
           10.62066670853927}, {14., 11.637314061240001`}, {15., 
           12.653731942077398`}, {16., 13.681343554382247`}, {17., 
           14.685537186566195`}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.6, 0, 0.6]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.6, 0, 0.6], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAHRU0VUcjA0AAAAAAAAAAAI4Qyyqh
YANA5Vpo94Mgnz9i21S/A8wGQOAo74IztN0/ccWEYm8nCkCaelz4YnrsP7Fw
DFMYSQ1AvNEHXR2Y9D+he2vqMFcQQFgC0BJIfPs/gp/8UfTsEUAnqv8GnfUA
QADT4EC8ehNARHjh6eIcBEAmdGZ4VCoVQHiUOjfIiAdA5PWXVgu9FkBXQUcn
EboKQErlan2ScRhASTzLgfkvDkBO5JArHh4aQDGuzGDXyhBA6sNigMitG0CU
hg3SY2ASQC4R1h1DXx1AAgaK+D8YFEAKP/Vh3PMeQMRNYPDNshVAR+1a9yJV
IECSPHKdq28XQNjCZAFaLCFA8z0pvW8kGUC1iMReIPUhQKgHOq7luxpAZgV1
4M7OIkBqeIZUq3UcQGNye7UMmiNAf7EszCISHkAvZyvOTGEkQCr9d7aAph9A
zxIsC3U5JUDvd/8ql64gQLuugpssAyZAdNVv40Z7IUB7ASpQzN0mQH4GfnYe
WSJACtx6SG60J0DRwN5C6TIjQOWmIZSffChAT1/s9wz+I0CUKBkEuVUpQFLR
l4dY2iRAkJpmx2EgKkCDJ/D//KclQFqUXc4M5ypA/AabsZRxJkD4RKX5n74r
QPi54z1UTCdA4+VCeMKHLEAiUdmybBgoQKI9MRvNYS1A0LtsAq31KECthXUR
Zy0uQKoKrTpGxClAh1VjSwP1LkDN4j+s0o4qQDXcoamHzS9AdY5w+IZqK0CY
KZutzUswQEoeTi2UNyxAf8CNmEu5MECjgck8yRUtQE0bVaXKJDFARG6XhfHv
LUCgFN4RtCwxQAAAAAAAAC5As78Cug==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAHRU0VUcjA0AAAAAAAAAAAI4Qyyqh
YANA5Vpo94Mgnz9i21S/A8wGQOAo74IztN0/ccWEYm8nCkCaelz4YnrsP7Fw
DFMYSQ1AvNEHXR2Y9D+he2vqMFcQQFgC0BJIfPs/gp/8UfTsEUAnqv8GnfUA
QADT4EC8ehNARHjh6eIcBEAmdGZ4VCoVQHiUOjfIiAdA5PWXVgu9FkBXQUcn
EboKQErlan2ScRhASTzLgfkvDkBO5JArHh4aQDGuzGDXyhBA6sNigMitG0CU
hg3SY2ASQC4R1h1DXx1AAgaK+D8YFEAKP/Vh3PMeQMRNYPDNshVAR+1a9yJV
IECSPHKdq28XQNjCZAFaLCFA8z0pvW8kGUC1iMReIPUhQKgHOq7luxpAZgV1
4M7OIkBqeIZUq3UcQGNye7UMmiNAf7EszCISHkAvZyvOTGEkQCr9d7aAph9A
zxIsC3U5JUDvd/8ql64gQLuugpssAyZAdNVv40Z7IUB7ASpQzN0mQH4GfnYe
WSJACtx6SG60J0DRwN5C6TIjQOWmIZSffChAT1/s9wz+I0CUKBkEuVUpQFLR
l4dY2iRAkJpmx2EgKkCDJ/D//KclQFqUXc4M5ypA/AabsZRxJkD4RKX5n74r
QPi54z1UTCdA4+VCeMKHLEAiUdmybBgoQKI9MRvNYS1A0LtsAq31KECthXUR
Zy0uQKoKrTpGxClAh1VjSwP1LkDN4j+s0o4qQDXcoamHzS9AdY5w+IZqK0CY
KZutzUswQEoeTi2UNyxAf8CNmEu5MECjgck8yRUtQE0bVaXKJDFARG6XhfHv
LUCgFN4RtCwxQAAAAAAAAC5As78Cug==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.6, 0, 0.6]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          Line[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAAHRU0VUcjA0AAAAAAAAAAAI4Qyyqh
YANA5Vpo94Mgnz9i21S/A8wGQOAo74IztN0/ccWEYm8nCkCaelz4YnrsP7Fw
DFMYSQ1AvNEHXR2Y9D+he2vqMFcQQFgC0BJIfPs/gp/8UfTsEUAnqv8GnfUA
QADT4EC8ehNARHjh6eIcBEAmdGZ4VCoVQHiUOjfIiAdA5PWXVgu9FkBXQUcn
EboKQErlan2ScRhASTzLgfkvDkBO5JArHh4aQDGuzGDXyhBA6sNigMitG0CU
hg3SY2ASQC4R1h1DXx1AAgaK+D8YFEAKP/Vh3PMeQMRNYPDNshVAR+1a9yJV
IECSPHKdq28XQNjCZAFaLCFA8z0pvW8kGUC1iMReIPUhQKgHOq7luxpAZgV1
4M7OIkBqeIZUq3UcQGNye7UMmiNAf7EszCISHkAvZyvOTGEkQCr9d7aAph9A
zxIsC3U5JUDvd/8ql64gQLuugpssAyZAdNVv40Z7IUB7ASpQzN0mQH4GfnYe
WSJACtx6SG60J0DRwN5C6TIjQOWmIZSffChAT1/s9wz+I0CUKBkEuVUpQFLR
l4dY2iRAkJpmx2EgKkCDJ/D//KclQFqUXc4M5ypA/AabsZRxJkD4RKX5n74r
QPi54z1UTCdA4+VCeMKHLEAiUdmybBgoQKI9MRvNYS1A0LtsAq31KECthXUR
Zy0uQKoKrTpGxClAh1VjSwP1LkDN4j+s0o4qQDXcoamHzS9AdY5w+IZqK0CY
KZutzUswQEoeTi2UNyxAf8CNmEu5MECjgck8yRUtQE0bVaXKJDFARG6XhfHv
LUCgFN4RtCwxQAAAAAAAAC5As78Cug==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 0}, {20, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 20}, {0, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 20}, {0, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{1, 0}, {1, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{2, 0}, {2, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{3, 0}, {3, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{4, 0}, {4, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{5, 0}, {5, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{6, 0}, {6, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{7, 0}, {7, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{8, 0}, {8, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{9, 0}, {9, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{10, 0}, {10, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{11, 0}, {11, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{12, 0}, {12, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{13, 0}, {13, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{14, 0}, {14, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{15, 0}, {15, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{16, 0}, {16, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{17, 0}, {17, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{18, 0}, {18, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{19, 0}, {19, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 5}, {0.6, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 10}, {0.6, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 15}, {0.6, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -4}, {0.24000000000000002`, -4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -3}, {0.24000000000000002`, -3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -2}, {0.24000000000000002`, -2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -1}, {0.24000000000000002`, -1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 1}, {0.24000000000000002`, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 2}, {0.24000000000000002`, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 3}, {0.24000000000000002`, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 4}, {0.24000000000000002`, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 6}, {0.24000000000000002`, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 7}, {0.24000000000000002`, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 8}, {0.24000000000000002`, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 9}, {0.24000000000000002`, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 11}, {0.24000000000000002`, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 12}, {0.24000000000000002`, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 13}, {0.24000000000000002`, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 14}, {0.24000000000000002`, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 16}, {0.24000000000000002`, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 17}, {0.24000000000000002`, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 18}, {0.24000000000000002`, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 19}, {0.24000000000000002`, 19}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 1}, {19.76, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 2}, {19.76, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 3}, {19.76, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 4}, {19.76, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 5}, {19.4, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 6}, {19.76, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 7}, {19.76, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 8}, {19.76, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 9}, {19.76, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 10}, {19.4, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 11}, {19.76, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 12}, {19.76, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 13}, {19.76, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 14}, {19.76, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 15}, {19.4, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 16}, {19.76, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 17}, {19.76, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 18}, {19.76, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 19}, {19.76, 19}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{None, None}, {None, None}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.1, 21.}, {-0.2, 20.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.957084532824068*^9, 3.957084569196493*^9, 3.9570846123341417`*^9, 
   3.957084646919326*^9, 3.957084681764603*^9, {3.9570847322313604`*^9, 
   3.9570847550098796`*^9}, {3.9570869042913494`*^9, 3.9570869138525915`*^9}, 
   3.957088071804941*^9, 3.9570885037271037`*^9, 3.957089727667281*^9, 
   3.9571576476788855`*^9},
 CellLabel->
  "Out[291]=",ExpressionUUID->"f2bad1c5-4406-44df-8e8a-5e5d119658c6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure S.I. - gradient dependence of t_esc
(c) Only the gradient and image potential are included (no surface effect)\
\>", "Section",
 CellChangeTimes->{{3.9570171298158393`*^9, 3.957017145665162*^9}, {
  3.957080152611906*^9, 3.957080167029992*^9}, {3.957080197719389*^9, 
  3.957080209671468*^9}, {3.957083561411101*^9, 3.9570835966446943`*^9}, {
  3.957083655604842*^9, 3.957083676212036*^9}, {3.9570881409183664`*^9, 
  3.9570881421723847`*^9}},ExpressionUUID->"424eaa86-f281-424f-9c19-\
8a61366c57c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Simulation", " ", "results", " ", "for", " ", "tesc_average", " ", "as", 
     " ", "a", " ", "function", " ", "of", " ", "the", " ", "layer", " ", 
     "thickness"}], ",", " ", 
    RowBox[{
     RowBox[{"without", " ", "gradient", " ", 
      RowBox[{"(", "tabg0", ")"}], " ", "and", " ", "for", " ", "a", " ", 
      "gradient", " ", "of"}], " ", "-", 
     RowBox[{"0.01", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg1", ")"}], " ", "to"}], " ", "-", 
     RowBox[{"0.06", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg6", ")"}]}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabg0", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5019624847157163`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.1941594667822297`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3.1378333989248226`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "4.378240364829347`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "5.950583755454865`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "7.883171856248698`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "10.19938957682391`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "12.918960775987522`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "16.058796047957227`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "19.633587093586534`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "23.656238344041398`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "28.138189503619614`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "33.089662336201975`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "38.5198532602662`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "46.45538723774001`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "50.84893568855107`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "57.76232721759256`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "65.18362005141444`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "73.1186761618861`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5028973828847625`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.287050870785365`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3.5315260849017447`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5.509071233623177`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8.632536625665312`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "13.506101315998302`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "21.0094352546123`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "32.432598609241886`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "49.67554029838429`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "75.54217014835562`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "114.17438508567808`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "171.69315743629053`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "257.14578029021703`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "383.9056326158113`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "643.9906673733733`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "849.8701151462662`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "1261.4810751936989`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "1870.4024899917474`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "2770.9659937598476`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5042776524645944`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.4246624007835305`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4.288719476163029`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "8.265602384733526`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "16.821697387780883`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "35.19630912022556`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "74.62048282221747`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "159.27264009720685`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "341.33218872669386`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "733.5941201853416`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1580.1851809935188`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "3409.9871365969584`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "7369.667029384466`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "15946.882928630132`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "40401.54590130039`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "74878.98047774065`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "162432.75010890386`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "352557.44901276875`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "765576.4055812671`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5063154616892662`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.6288502274518653`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5.689997971437563`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "14.798324098831166`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "42.433087683762054`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "127.26786759694359`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "390.2725481038879`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "1212.0259840121898`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "3794.7597352304433`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "11947.910525296295`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "37770.72388532552`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "119763.43480732171`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "380618.01634668146`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "1.21180247534865`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "4.500561388147244`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "1.2332628342083165`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "3.9403078531595565`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "1.2599340025203559`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "4.03138654051209`*^8"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5093240525448746`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3.0544384684898316`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "8.964396668390842`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "33.77010306336658`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "141.73197830463846`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "622.9018278087868`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "2802.3363112138813`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "12783.012254677331`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "58839.47928793297`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "272536.8945155961`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1.2681014548021555`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "5.920548948798631`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "2.7714708470407`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "1.3000427243046601`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "6.959193306895595`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "2.873988930986225`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "1.3537248553304718`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "6.3823697846188675`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "3.011499195529358`*^11"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg5", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5137658907831453`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3.7245082228018163`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "15.815281127289579`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "88.73315078580123`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "550.5056499721696`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "3563.874743677152`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "23602.61606678448`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "158516.53996001257`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "1.0745949132783345`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "7.332856354774108`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "5.0280335086819425`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "3.4602667477661055`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "2.3880955191548896`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "1.6518415130874992`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "1.2692948699859581`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "7.943440605567147`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "5.519766253105388`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "3.8396983112881586`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "2.6759654552743116`*^14"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg6", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.52032375387649`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4.724354817168456`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "30.02155501243483`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "251.87005941659865`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "2310.450491423829`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "22051.417722098016`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "215209.53322785985`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "2.1301505651950995`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "2.1286753947299078`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "2.1417121698463488`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "2.165666111967806`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2.1982490742670067`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "2.2379410200762158`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "2.283733933474989`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "2.524153421729594`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "2.3872377413441322`*^14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "2.436545302823064`*^15"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "2.360820546833275`*^16"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9570179772619314`*^9, 3.9570180953308115`*^9}, {
   3.957018130955658*^9, 3.957018215682221*^9}, {3.9570182483795967`*^9, 
   3.9570182498622723`*^9}, {3.9570182837986765`*^9, 
   3.9570182852908335`*^9}, {3.957018322219037*^9, 3.9570183250144663`*^9}, {
   3.957018363945951*^9, 3.9570183681405325`*^9}, {3.957018442196556*^9, 
   3.957018610886937*^9}, {3.9570186496028247`*^9, 3.9570187244844*^9}, {
   3.957018765810251*^9, 3.9570188498960905`*^9}, {3.957018918296104*^9, 
   3.9570189374221983`*^9}, {3.957019000142621*^9, 3.957019223719556*^9}, {
   3.9570192658838415`*^9, 3.9570193388030453`*^9}, {3.957019606873952*^9, 
   3.9570196071413164`*^9}, {3.9570196888161397`*^9, 3.957019689036353*^9}, {
   3.957019734845105*^9, 3.9570197589959383`*^9}, {3.9570197952984085`*^9, 
   3.9570197971588607`*^9}, {3.957019838683606*^9, 3.957019985227247*^9}, {
   3.957020038838397*^9, 3.9570201283874245`*^9}, 3.957020197149083*^9, {
   3.9570204733372583`*^9, 3.957020500620798*^9}, {3.9570205509616127`*^9, 
   3.95702066161045*^9}, {3.957020692895506*^9, 3.957020708878168*^9}, {
   3.9570207595181*^9, 3.9570208497017155`*^9}, {3.957020888824114*^9, 
   3.957020889060049*^9}, {3.9570209951649275`*^9, 3.9570210101170444`*^9}, {
   3.9570210550686293`*^9, 3.9570210588326006`*^9}, {3.9570210907714324`*^9, 
   3.957021265128262*^9}, {3.957021371426813*^9, 3.9570214149432645`*^9}, {
   3.9570214602954516`*^9, 3.9570214916352696`*^9}, {3.9570218346690845`*^9, 
   3.957021883427083*^9}, {3.957021916297*^9, 3.9570220552469535`*^9}, {
   3.9570221070400944`*^9, 3.957022185042626*^9}, {3.957022259364053*^9, 
   3.957022310992408*^9}, {3.9570224069747143`*^9, 3.9570226593058558`*^9}, {
   3.957022690348491*^9, 3.9570229809182606`*^9}, {3.9570803458809958`*^9, 
   3.9570804160235357`*^9}, 3.9570804900867395`*^9, 3.9570805508265257`*^9, {
   3.9570807836844387`*^9, 3.957080790237952*^9}, 3.9570808381222596`*^9, {
   3.957080879397051*^9, 3.9570808860910635`*^9}, {3.9570809282777843`*^9, 
   3.9570809451037183`*^9}, {3.957081122125296*^9, 3.9570811981441336`*^9}, {
   3.957081292736041*^9, 3.957081326686044*^9}, {3.9570816413830557`*^9, 
   3.9570817312476215`*^9}, {3.9570818055953684`*^9, 
   3.9570818835880594`*^9}, {3.9570826015912066`*^9, 
   3.9570826843652077`*^9}, {3.9570834465178623`*^9, 
   3.9570834564388247`*^9}, {3.9570835870720224`*^9, 3.957083606433529*^9}, {
   3.9570837420013647`*^9, 3.9570837563928175`*^9}, 3.957083792984332*^9, 
   3.957083838287492*^9, 3.9570838834220667`*^9, 3.957083928799616*^9, 
   3.9570839696759157`*^9, {3.957084008139803*^9, 3.9570840515430994`*^9}, {
   3.957084174804969*^9, 3.9570842146578255`*^9}, 3.9570868318936157`*^9, {
   3.9570868724562273`*^9, 3.957086878274432*^9}, 3.957088058671687*^9, {
   3.9570890063832207`*^9, 3.9570890176011086`*^9}, {3.957089066384276*^9, 
   3.95708910353302*^9}, {3.957089337309349*^9, 3.95708938515245*^9}, {
   3.9570899053009005`*^9, 3.957089905602076*^9}, {3.9570899595514374`*^9, 
   3.9570899697056212`*^9}, {3.9570900250219464`*^9, 
   3.9570900263049135`*^9}, {3.9570901129817*^9, 3.9570901130916185`*^9}, 
   3.9710064257956533`*^9, 
   3.971006511977461*^9},ExpressionUUID->"16c50d6d-67c2-4d13-b7fc-\
023b0ad471e6"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPNL9nj85Yeg4pzOJw6F86e8O8alC/g
4Do/qPpFx0MoX8Qhu/E/66ttz6F8CYfAqxVTbnx5C+XLOJwQ/bRgmdgnKF/B
4eLkrb9ma3yF8pUcrq0JNPqt8wPKV3HonSeXk6b8G8pXc/giHJwswPsPytdw
eKQ2e+KzUgYHCF/L4YvvbJ1jDxihfB2HrwcylXk8mKF8PYd2xaePatewQPkG
DrVFs25NrWCD8g0dBOOupwTks0P5Rg6Lz67qn3WOA8o3dtAwa/N+o8MF5Zs4
MNlVWDZ1cTsAADwtU5E=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPNL9nj85Yeg4pzOJw6F86e8O8alC/g
4Do/qPpFx0MoX8Qhu/E/66ttz6F8CYfAqxVTbnx5C+XLOJwQ/bRgmdgnKF/B
4eLkrb9ma3yF8pUcrq0JNPqt8wPKV3HonSeXk6b8G8pXc/giHJwswPsPytdw
eKQ2e+KzUgYHCF/L4YvvbJ1jDxihfB2HrwcylXk8mKF8PYd2xaePatewQPkG
DrVFs25NrWCD8g0dBOOupwTks0P5Rg6Lz67qn3WOA8o3dtAwa/N+o8MF5Zs4
MNlVWDZ1cTsAADwtU5E=
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
            "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
           "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPNL9nj85Yeg4pzOJw6F86e8O8alC/g
4Do/qPpFx0MoX8Qhu/E/66ttz6F8CYfAqxVTbnx5C+XLOJwQ/bRgmdgnKF/B
4eLkrb9ma3yF8pUcrq0JNPqt8wPKV3HonSeXk6b8G8pXc/giHJwswPsPytdw
eKQ2e+KzUgYHCF/L4YvvbJ1jDxihfB2HrwcylXk8mKF8PYd2xaePatewQPkG
DrVFs25NrWCD8g0dBOOupwTks0P5Rg6Lz67qn3WOA8o3dtAwa/N+o8MF5Zs4
MNlVWDZ1cTsAADwtU5E=
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
         "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwVzH9cy3kcwPHVlrTvQnlISmv9sLJqNl9R1/F5q7vjlOgXpygbtegXXXuc
WkJSxpmpLuvnpCuFRSz36O7EZZqK0Q+JIvpxKeVk7dr6tXN/vB7P/1523ITA
SEMCgbD1S/9bnMadx95fuMH40qP3sKESKdppfjtpyej2pxPRno2VSN9Yf5JG
EyKPjV7v2f5VqPj+OVsjWj7K6pMN2YdfRbHr+XGTtlVowjHnb1LaddQ+HZ37
ybYODXQwEwfCbyLj7j6nMdsm1LhLl1BZIkelzdLDH2xfIvE+UQyLehdV3xB2
xzJHkBWn4HLJQyXiodb80UQ1shZO146ueobiB1f2y6t1KDP6t9JDvA5Etstw
6vUgQG2oeeOPU11ItKiFUbqXCCrTW5YB6DXidgffIz6eB50HtK2d/7xFhx9m
cBOcyMAWU8M83PtRzSFKkOX3pkBYypvODBpEpYKYEdbORbDGSb/uF+kQSpfO
BEyMmkHPxbqzYsUwIrS/hT9TFsN4y5T9vTcfED0p6kgwYwnwhGd3yOgf0YDm
4g7srgVUBUm3Kxw+oS2DB49mH7aEbVdoCjPfceQ/IHahUq2genfkS23sZzTy
gHv8kcwavvX2StkhUCOmWaeNT4QNiEY9hnMuTSAy0nB61FRYqFT2b7qlQZvG
QiftQ2jgE5V2vfvVv6irYb9BqKsdMHlaC5O5SVR7WhFO09hBoIRoKjPVoSgj
/luVyh6cRWtbWWum0L5EQS2lwAE85FM0l03TaBXPReXHcYRZr3Tze8Ez6Km5
K8b3XAH80+y21cmz6I/q9EJXIh3oRok2NmfmkMCAsf3xazoIv3u1dqhGj8g9
KZvj5U7QNmGYvOIgAQYr7HKlqc4gCOcUZY8TINd5GakuZCWkXW2vSMgwAHFB
lJJDY0CJaMFklqkhhObuUVGGGJDv4GI5lmMI2m/KddJ6FxgrCKM1rCBC/6D3
kYYsV4i4GhzfJiPC5fVs6yccN3Au4pQFbiSB7BTfjOfGBFP6OuqCFhJkhezz
JWqY8GzvxwMWgUbg3lNalfVkFQwfrSsSDRiBZGWh7IkvCxzwrUu84+bBsfvn
JL51LLjdPJEUaWAMW61Dypsd2UBdnFb+PNsYNsYrw8yEbKhQP7U+YTUfpMu5
jo81bMi6455cJJsPjg+u5PmHrYZMs/3L1WtNQOzWwGirXw0RNknivLsmEKUm
tTYxcMjGJB+qtpGBW/OZJjyPw7sLGT9rX5AhNj1oZssFHAo9jFm7XpGBHyR/
QcnBIaRX2F7XQ4bTGr5InIdDs+t5K8E7MlR76qYvFuNwW5lfOTtCBt1f+s6K
azicnK1WGM6RQdxGOadQ4uBw4OUMxRGDgrK46MwmHHoX7r4UR8egLEnls7kF
B8mdNz4qZwzuWIinWlQ4UEgDZ867YdATuji6/TkOmpKPlubrMHDqX+bT149D
YwfRfekWDFjyFOqvgzgcE2R2/eSHwVenunWRQzh42Zukdvlj4OdUfHN4BAdZ
woIH+UEYJMbQqOPjOOSRlwUs34NB6tcndLfUOATUFE6kRmBwyrSvI0mDA/kH
quQ1BwPJjbKzWu2Xf7lDb0kUBpePk3i/T+Hg6VeRro/G4FpApHfqDA7qz870
vTEYyO0bbTbM4XA9/1rT/TgM6tV0nV6PAw+YcXaHMPgPie8quw==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Line[CompressedData["
1:eJwVzH9cy3kcwPHVlrTvQnlISmv9sLJqNl9R1/F5q7vjlOgXpygbtegXXXuc
WkJSxpmpLuvnpCuFRSz36O7EZZqK0Q+JIvpxKeVk7dr6tXN/vB7P/1523ITA
SEMCgbD1S/9bnMadx95fuMH40qP3sKESKdppfjtpyej2pxPRno2VSN9Yf5JG
EyKPjV7v2f5VqPj+OVsjWj7K6pMN2YdfRbHr+XGTtlVowjHnb1LaddQ+HZ37
ybYODXQwEwfCbyLj7j6nMdsm1LhLl1BZIkelzdLDH2xfIvE+UQyLehdV3xB2
xzJHkBWn4HLJQyXiodb80UQ1shZO146ueobiB1f2y6t1KDP6t9JDvA5Etstw
6vUgQG2oeeOPU11ItKiFUbqXCCrTW5YB6DXidgffIz6eB50HtK2d/7xFhx9m
cBOcyMAWU8M83PtRzSFKkOX3pkBYypvODBpEpYKYEdbORbDGSb/uF+kQSpfO
BEyMmkHPxbqzYsUwIrS/hT9TFsN4y5T9vTcfED0p6kgwYwnwhGd3yOgf0YDm
4g7srgVUBUm3Kxw+oS2DB49mH7aEbVdoCjPfceQ/IHahUq2genfkS23sZzTy
gHv8kcwavvX2StkhUCOmWaeNT4QNiEY9hnMuTSAy0nB61FRYqFT2b7qlQZvG
QiftQ2jgE5V2vfvVv6irYb9BqKsdMHlaC5O5SVR7WhFO09hBoIRoKjPVoSgj
/luVyh6cRWtbWWum0L5EQS2lwAE85FM0l03TaBXPReXHcYRZr3Tze8Ez6Km5
K8b3XAH80+y21cmz6I/q9EJXIh3oRok2NmfmkMCAsf3xazoIv3u1dqhGj8g9
KZvj5U7QNmGYvOIgAQYr7HKlqc4gCOcUZY8TINd5GakuZCWkXW2vSMgwAHFB
lJJDY0CJaMFklqkhhObuUVGGGJDv4GI5lmMI2m/KddJ6FxgrCKM1rCBC/6D3
kYYsV4i4GhzfJiPC5fVs6yccN3Au4pQFbiSB7BTfjOfGBFP6OuqCFhJkhezz
JWqY8GzvxwMWgUbg3lNalfVkFQwfrSsSDRiBZGWh7IkvCxzwrUu84+bBsfvn
JL51LLjdPJEUaWAMW61Dypsd2UBdnFb+PNsYNsYrw8yEbKhQP7U+YTUfpMu5
jo81bMi6455cJJsPjg+u5PmHrYZMs/3L1WtNQOzWwGirXw0RNknivLsmEKUm
tTYxcMjGJB+qtpGBW/OZJjyPw7sLGT9rX5AhNj1oZssFHAo9jFm7XpGBHyR/
QcnBIaRX2F7XQ4bTGr5InIdDs+t5K8E7MlR76qYvFuNwW5lfOTtCBt1f+s6K
azicnK1WGM6RQdxGOadQ4uBw4OUMxRGDgrK46MwmHHoX7r4UR8egLEnls7kF
B8mdNz4qZwzuWIinWlQ4UEgDZ867YdATuji6/TkOmpKPlubrMHDqX+bT149D
YwfRfekWDFjyFOqvgzgcE2R2/eSHwVenunWRQzh42Zukdvlj4OdUfHN4BAdZ
woIH+UEYJMbQqOPjOOSRlwUs34NB6tcndLfUOATUFE6kRmBwyrSvI0mDA/kH
quQ1BwPJjbKzWu2Xf7lDb0kUBpePk3i/T+Hg6VeRro/G4FpApHfqDA7qz870
vTEYyO0bbTbM4XA9/1rT/TgM6tV0nV6PAw+YcXaHMPgPie8quw==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Line[CompressedData["
1:eJwVzH9cy3kcwPHVlrTvQnlISmv9sLJqNl9R1/F5q7vjlOgXpygbtegXXXuc
WkJSxpmpLuvnpCuFRSz36O7EZZqK0Q+JIvpxKeVk7dr6tXN/vB7P/1523ITA
SEMCgbD1S/9bnMadx95fuMH40qP3sKESKdppfjtpyej2pxPRno2VSN9Yf5JG
EyKPjV7v2f5VqPj+OVsjWj7K6pMN2YdfRbHr+XGTtlVowjHnb1LaddQ+HZ37
ybYODXQwEwfCbyLj7j6nMdsm1LhLl1BZIkelzdLDH2xfIvE+UQyLehdV3xB2
xzJHkBWn4HLJQyXiodb80UQ1shZO146ueobiB1f2y6t1KDP6t9JDvA5Etstw
6vUgQG2oeeOPU11ItKiFUbqXCCrTW5YB6DXidgffIz6eB50HtK2d/7xFhx9m
cBOcyMAWU8M83PtRzSFKkOX3pkBYypvODBpEpYKYEdbORbDGSb/uF+kQSpfO
BEyMmkHPxbqzYsUwIrS/hT9TFsN4y5T9vTcfED0p6kgwYwnwhGd3yOgf0YDm
4g7srgVUBUm3Kxw+oS2DB49mH7aEbVdoCjPfceQ/IHahUq2genfkS23sZzTy
gHv8kcwavvX2StkhUCOmWaeNT4QNiEY9hnMuTSAy0nB61FRYqFT2b7qlQZvG
QiftQ2jgE5V2vfvVv6irYb9BqKsdMHlaC5O5SVR7WhFO09hBoIRoKjPVoSgj
/luVyh6cRWtbWWum0L5EQS2lwAE85FM0l03TaBXPReXHcYRZr3Tze8Ez6Km5
K8b3XAH80+y21cmz6I/q9EJXIh3oRok2NmfmkMCAsf3xazoIv3u1dqhGj8g9
KZvj5U7QNmGYvOIgAQYr7HKlqc4gCOcUZY8TINd5GakuZCWkXW2vSMgwAHFB
lJJDY0CJaMFklqkhhObuUVGGGJDv4GI5lmMI2m/KddJ6FxgrCKM1rCBC/6D3
kYYsV4i4GhzfJiPC5fVs6yccN3Au4pQFbiSB7BTfjOfGBFP6OuqCFhJkhezz
JWqY8GzvxwMWgUbg3lNalfVkFQwfrSsSDRiBZGWh7IkvCxzwrUu84+bBsfvn
JL51LLjdPJEUaWAMW61Dypsd2UBdnFb+PNsYNsYrw8yEbKhQP7U+YTUfpMu5
jo81bMi6455cJJsPjg+u5PmHrYZMs/3L1WtNQOzWwGirXw0RNknivLsmEKUm
tTYxcMjGJB+qtpGBW/OZJjyPw7sLGT9rX5AhNj1oZssFHAo9jFm7XpGBHyR/
QcnBIaRX2F7XQ4bTGr5InIdDs+t5K8E7MlR76qYvFuNwW5lfOTtCBt1f+s6K
azicnK1WGM6RQdxGOadQ4uBw4OUMxRGDgrK46MwmHHoX7r4UR8egLEnls7kF
B8mdNz4qZwzuWIinWlQ4UEgDZ867YdATuji6/TkOmpKPlubrMHDqX+bT149D
YwfRfekWDFjyFOqvgzgcE2R2/eSHwVenunWRQzh42Zukdvlj4OdUfHN4BAdZ
woIH+UEYJMbQqOPjOOSRlwUs34NB6tcndLfUOATUFE6kRmBwyrSvI0mDA/kH
quQ1BwPJjbKzWu2Xf7lDb0kUBpePk3i/T+Hg6VeRro/G4FpApHfqDA7qz870
vTEYyO0bbTbM4XA9/1rT/TgM6tV0nV6PAw+YcXaHMPgPie8quw==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0.8, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYN/g7XM+k3HoOIcDjUJB1IU5t2A8gUc
kuov6bDbPIHyRRw4KxYIBUS9hfIlHHQe863WnPsZypdx8LrZeKR43w8oX8Fh
1vvPjFbf/0L5Sg6BJ44Z/pnL6ADhqzi8f9Oa98mZBcpXc7gZdESm5A0blK/h
IFlhY/ZlGieUr+Wg/7LwnrAzD5Sv4zC1+Hhjxwc+KF/PweGMhH3XeQEo38Dh
9O6j0z/nCEH5hg5RVxVNI+qFoXwjh7+mpy7uui4C5Rs7OJbP5og1EIPyTRxu
/9rtZdIp7gAANxBQbw==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYN/g7XM+k3HoOIcDjUJB1IU5t2A8gUc
kuov6bDbPIHyRRw4KxYIBUS9hfIlHHQe863WnPsZypdx8LrZeKR43w8oX8Fh
1vvPjFbf/0L5Sg6BJ44Z/pnL6ADhqzi8f9Oa98mZBcpXc7gZdESm5A0blK/h
IFlhY/ZlGieUr+Wg/7LwnrAzD5Sv4zC1+Hhjxwc+KF/PweGMhH3XeQEo38Dh
9O6j0z/nCEH5hg5RVxVNI+qFoXwjh7+mpy7uui4C5Rs7OJbP5og1EIPyTRxu
/9rtZdIp7gAANxBQbw==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0.8, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYN/g7XM+k3HoOIcDjUJB1IU5t2A8gUc
kuov6bDbPIHyRRw4KxYIBUS9hfIlHHQe863WnPsZypdx8LrZeKR43w8oX8Fh
1vvPjFbf/0L5Sg6BJ44Z/pnL6ADhqzi8f9Oa98mZBcpXc7gZdESm5A0blK/h
IFlhY/ZlGieUr+Wg/7LwnrAzD5Sv4zC1+Hhjxwc+KF/PweGMhH3XeQEo38Dh
9O6j0z/nCEH5hg5RVxVNI+qFoXwjh7+mpy7uui4C5Rs7OJbP5og1EIPyTRxu
/9rtZdIp7gAANxBQbw==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0.8, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0.8, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtkX0w1HkAh9dLKq1Ytv15W9ZylvW6+71euPL7eJmOVjovqxuduygqdXU1
9pT05ji5khVFjDGIG+e8Zet6uaO8RGHvpNSdzRSJHFNe9ti8XTdzn5lnnv+e
fz420YdCYrQZDIb3B/6zXoW2n2BxGRj/L7ovrFGnUw9ujKH2iL3F9OHWlOhD
An1MHImb46fep+u+YYaaBhjgZtjTxY47PXTx8f2j7tuNkHZp/YTumIpOLpoP
nh5jwfhnI56mcYBm9LzAr4km8GRnB4VPv6bt42OPhgnXQJipuC5O+Zt+pc4N
X/UbBwsPzSVvWt/SW4biTlw8bIoOpvx8pmiSDnold7KyMkdagtkvkbJperQ5
+nR7lQVu+LTOml78h3Zl9XJ9v+LCP/dub7Zqltan1VGqKSsEBvZ3zC29pz8d
j5jhS3mo/0ESaRu8QD9r2q0V4WyD9PO0+GTuEn39bMuXPLUN9s0IDXf1MRC7
TPZCqeTDazyy57WWNnYdOX6dmW+LIBO+7Uu2Dtz2OCkDo+zALqhgy/i6+N3Y
eZXM4yNkDH/+eGTzMtypTi5w1rHHpt1XrHu26+G4lvCzzuf2KC7T8ig8tRz6
qkT/gwoBbvu7TDNKVmCo3CanKMkBqy1HPftqVyLHwUz3ltQRbIVy26Vefcjz
Y9uieEKEJPm9ax1ZhYicSCVzWIiA8hNiuZqJWb8yTVGDE97l9Pt4mq3G4JDP
0aY0Zzyq/6M/wtEQJZtEFl1RLrgmkV11cTBCVaqMtcfFFVeebLF+U/fhN+ku
iY7aFTuMtPdPbGBhraq4Iq3LDTKXrsJ9HSzkORZUdUncUT2wk8MNM8apuxl5
klvu8Epc8S1GjLHVQlr20E6En5qyymuPmcD7YNsOVroI4tJByy+02CiyjLbr
VItgHBuQmJDDhl3zj5eDdojBupfAVXLXQO7SJHzUIMZoZ1rW4atrEDul2/1A
SGB5p3IsZR0H0XWTvPRMggPeeRk9DRwcSA6d35JFIBgxF318jwNZqOIpM5vg
5YXCxznNHJxVyy7ILxNIVSUW4e0cVHto5nILCbwSqiqedXOgubfUW15JYFDV
1Pr8FQfyR8yMljaCGtPxhWF9CvmlX+/9/gFBXOOhYn8DCqXxSl//DgK72Em/
CkMKNzjy9x1Kgrz6mXNxbAqqCJO9PU8IzgRpm49zKQgGzXwHBgmCU6h1k+4U
3BWJVleHCPSd8v8MIRQ8U/s0McMErd2WJ+rXUggUFNa+GSXwsOa3xHtSOLKf
ZzUxQcC77Rwy40shaeMZzbUpAtXOGvX2zRRSDQYex6sJLi8XX7npTyGvpvTc
7CzBSun6F8e2Uig5rbvn9vsP/blb3/21jUJlcIxP0jzByZKNgk9CKCj497le
iwQbAhofFoRRaJiy1ywtEUy+9T44H07hX7lcxa4=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Line[CompressedData["
1:eJwtkX0w1HkAh9dLKq1Ytv15W9ZylvW6+71euPL7eJmOVjovqxuduygqdXU1
9pT05ji5khVFjDGIG+e8Zet6uaO8RGHvpNSdzRSJHFNe9ti8XTdzn5lnnv+e
fz420YdCYrQZDIb3B/6zXoW2n2BxGRj/L7ovrFGnUw9ujKH2iL3F9OHWlOhD
An1MHImb46fep+u+YYaaBhjgZtjTxY47PXTx8f2j7tuNkHZp/YTumIpOLpoP
nh5jwfhnI56mcYBm9LzAr4km8GRnB4VPv6bt42OPhgnXQJipuC5O+Zt+pc4N
X/UbBwsPzSVvWt/SW4biTlw8bIoOpvx8pmiSDnold7KyMkdagtkvkbJperQ5
+nR7lQVu+LTOml78h3Zl9XJ9v+LCP/dub7Zqltan1VGqKSsEBvZ3zC29pz8d
j5jhS3mo/0ESaRu8QD9r2q0V4WyD9PO0+GTuEn39bMuXPLUN9s0IDXf1MRC7
TPZCqeTDazyy57WWNnYdOX6dmW+LIBO+7Uu2Dtz2OCkDo+zALqhgy/i6+N3Y
eZXM4yNkDH/+eGTzMtypTi5w1rHHpt1XrHu26+G4lvCzzuf2KC7T8ig8tRz6
qkT/gwoBbvu7TDNKVmCo3CanKMkBqy1HPftqVyLHwUz3ltQRbIVy26Vefcjz
Y9uieEKEJPm9ax1ZhYicSCVzWIiA8hNiuZqJWb8yTVGDE97l9Pt4mq3G4JDP
0aY0Zzyq/6M/wtEQJZtEFl1RLrgmkV11cTBCVaqMtcfFFVeebLF+U/fhN+ku
iY7aFTuMtPdPbGBhraq4Iq3LDTKXrsJ9HSzkORZUdUncUT2wk8MNM8apuxl5
klvu8Epc8S1GjLHVQlr20E6En5qyymuPmcD7YNsOVroI4tJByy+02CiyjLbr
VItgHBuQmJDDhl3zj5eDdojBupfAVXLXQO7SJHzUIMZoZ1rW4atrEDul2/1A
SGB5p3IsZR0H0XWTvPRMggPeeRk9DRwcSA6d35JFIBgxF318jwNZqOIpM5vg
5YXCxznNHJxVyy7ILxNIVSUW4e0cVHto5nILCbwSqiqedXOgubfUW15JYFDV
1Pr8FQfyR8yMljaCGtPxhWF9CvmlX+/9/gFBXOOhYn8DCqXxSl//DgK72Em/
CkMKNzjy9x1Kgrz6mXNxbAqqCJO9PU8IzgRpm49zKQgGzXwHBgmCU6h1k+4U
3BWJVleHCPSd8v8MIRQ8U/s0McMErd2WJ+rXUggUFNa+GSXwsOa3xHtSOLKf
ZzUxQcC77Rwy40shaeMZzbUpAtXOGvX2zRRSDQYex6sJLi8XX7npTyGvpvTc
7CzBSun6F8e2Uig5rbvn9vsP/blb3/21jUJlcIxP0jzByZKNgk9CKCj497le
iwQbAhofFoRRaJiy1ywtEUy+9T44H07hX7lcxa4=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0.8, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Line[CompressedData["
1:eJwtkX0w1HkAh9dLKq1Ytv15W9ZylvW6+71euPL7eJmOVjovqxuduygqdXU1
9pT05ji5khVFjDGIG+e8Zet6uaO8RGHvpNSdzRSJHFNe9ti8XTdzn5lnnv+e
fz420YdCYrQZDIb3B/6zXoW2n2BxGRj/L7ovrFGnUw9ujKH2iL3F9OHWlOhD
An1MHImb46fep+u+YYaaBhjgZtjTxY47PXTx8f2j7tuNkHZp/YTumIpOLpoP
nh5jwfhnI56mcYBm9LzAr4km8GRnB4VPv6bt42OPhgnXQJipuC5O+Zt+pc4N
X/UbBwsPzSVvWt/SW4biTlw8bIoOpvx8pmiSDnold7KyMkdagtkvkbJperQ5
+nR7lQVu+LTOml78h3Zl9XJ9v+LCP/dub7Zqltan1VGqKSsEBvZ3zC29pz8d
j5jhS3mo/0ESaRu8QD9r2q0V4WyD9PO0+GTuEn39bMuXPLUN9s0IDXf1MRC7
TPZCqeTDazyy57WWNnYdOX6dmW+LIBO+7Uu2Dtz2OCkDo+zALqhgy/i6+N3Y
eZXM4yNkDH/+eGTzMtypTi5w1rHHpt1XrHu26+G4lvCzzuf2KC7T8ig8tRz6
qkT/gwoBbvu7TDNKVmCo3CanKMkBqy1HPftqVyLHwUz3ltQRbIVy26Vefcjz
Y9uieEKEJPm9ax1ZhYicSCVzWIiA8hNiuZqJWb8yTVGDE97l9Pt4mq3G4JDP
0aY0Zzyq/6M/wtEQJZtEFl1RLrgmkV11cTBCVaqMtcfFFVeebLF+U/fhN+ku
iY7aFTuMtPdPbGBhraq4Iq3LDTKXrsJ9HSzkORZUdUncUT2wk8MNM8apuxl5
klvu8Epc8S1GjLHVQlr20E6En5qyymuPmcD7YNsOVroI4tJByy+02CiyjLbr
VItgHBuQmJDDhl3zj5eDdojBupfAVXLXQO7SJHzUIMZoZ1rW4atrEDul2/1A
SGB5p3IsZR0H0XWTvPRMggPeeRk9DRwcSA6d35JFIBgxF318jwNZqOIpM5vg
5YXCxznNHJxVyy7ILxNIVSUW4e0cVHto5nILCbwSqiqedXOgubfUW15JYFDV
1Pr8FQfyR8yMljaCGtPxhWF9CvmlX+/9/gFBXOOhYn8DCqXxSl//DgK72Em/
CkMKNzjy9x1Kgrz6mXNxbAqqCJO9PU8IzgRpm49zKQgGzXwHBgmCU6h1k+4U
3BWJVleHCPSd8v8MIRQ8U/s0McMErd2WJ+rXUggUFNa+GSXwsOa3xHtSOLKf
ZzUxQcC77Rwy40shaeMZzbUpAtXOGvX2zRRSDQYex6sJLi8XX7npTyGvpvTc
7CzBSun6F8e2Uig5rbvn9vsP/blb3/21jUJlcIxP0jzByZKNgk9CKCj497le
iwQbAhofFoRRaJiy1ywtEUy+9T44H07hX7lcxa4=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 1, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOUOy/YPh89BhXncGDsfNxXePcWlC/g
0OD6//4DzRdQvoiDgEv4cYOdn6B8CYe9l+8yi3D/gvJlHC758Zwuu8bgAOEr
OEiveaYqv5sFyldy2O8zxZdjNQeUr+IgrbIqTnsRD5Sv5lB0eO98VX8BKF/D
we6V2FlGfyEoX8thZtdPK5MAEShfxyHc2O1MdpAYlK/nsE5lg3p+qASUb+Dw
72jRx49zpKB8Q4evF89vsI2VgfKNHNQ/KKy4lCgH5Rs7MLQGnkwwVoDyTRx+
/3kk/89U0QEAnxZOGw==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOUOy/YPh89BhXncGDsfNxXePcWlC/g
0OD6//4DzRdQvoiDgEv4cYOdn6B8CYe9l+8yi3D/gvJlHC758Zwuu8bgAOEr
OEiveaYqv5sFyldy2O8zxZdjNQeUr+IgrbIqTnsRD5Sv5lB0eO98VX8BKF/D
we6V2FlGfyEoX8thZtdPK5MAEShfxyHc2O1MdpAYlK/nsE5lg3p+qASUb+Dw
72jRx49zpKB8Q4evF89vsI2VgfKNHNQ/KKy4lCgH5Rs7MLQGnkwwVoDyTRx+
/3kk/89U0QEAnxZOGw==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 1, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOUOy/YPh89BhXncGDsfNxXePcWlC/g
0OD6//4DzRdQvoiDgEv4cYOdn6B8CYe9l+8yi3D/gvJlHC758Zwuu8bgAOEr
OEiveaYqv5sFyldy2O8zxZdjNQeUr+IgrbIqTnsRD5Sv5lB0eO98VX8BKF/D
we6V2FlGfyEoX8thZtdPK5MAEShfxyHc2O1MdpAYlK/nsE5lg3p+qASUb+Dw
72jRx49zpKB8Q4evF89vsI2VgfKNHNQ/KKy4lCgH5Rs7MLQGnkwwVoDyTRx+
/3kk/89U0QEAnxZOGw==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 1, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 1, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwdkn001XcAh13M69W6boTL9ftJ6OJ6+U6Otvp95mbzNofJdjDklquxmA4n
ocjyNtOul4NpdyrRtqLVtKaVCXl3i1DndJ15NxbnYPdwUVb7nPOc5zz/f2hx
4scx6mpqanjNG+upyl0j9uq8yf+X9PCcONFWD9mnxSNuuX8yN79kB5v4GABd
fu4xFUPMpfT4eedPt6NpR0LQqNM4k129GfTvCw4aJDL/Rz/MMmpPxnAvjYt/
1KMNwxcWGJtkSeohgRF+lBWMlIiXmSllxSf6942R71ve8bxUyfhOx50uSTJB
upcZ3a6rYgKmpPZ8vhnKYv4+fCpxk5lvE2d11fMQahwnKqnaYoScEQtRlAWq
vnbx3p3Dgh6jjFas8BExqI1fLTXw4ULYqlUIBfsHpgtShSaetR5lhTnQKGx9
zA4p1sLt/PZISknD85vxlz12OpC8lTIml1tB/aXjFemELo6cSL/NrtoF071D
PJ1MfTjF2sv9o63RdtZSS8I1wCNDB/0Uj904mVxXy+3Zhj8asi84aNigpUJU
2OSyHeksQWDfqA16uoL4xW9zoKdI805otAX/q1vz4XMcTNfRZdUZdpDRLdWZ
jYYoszPVbArZg4ul8U69Ui6kVZLOaEqAx3NtVxMjdyCsLELOnhXApzshVNvO
CGsHa1XVzfb4IOPOdIe6MSanPVNb8xyQyK0P+0tujMv7XXj90Y6wOIOfLa/v
RH1OCifWUYjVvqyJ39NMkBdyxE9DKQSvlnvIy8sUbopLP+X1O6Et8OBFFWWG
yj0X6vv9nFExRg9rLZohs6Wo0q/JGUsi2dS7fTx8xAup7bF2QYlzvOPROnO8
n9AZzilwwWesmcjpJAtUm4ut+5QuqK99FXc+gA/rtqvlAeGucBC2R0nNLSF1
bBUMNrtimVEU5cxYQrKiOdAtIKg29PEbOExBfHOZKviWIOzkuojdSeGL7OBN
32ICSfL3zUNdFFKCG5+ySwmSkg54yHoo5CtTzkvLCQris4VCOYUGD9VGhYzg
TpSeaeAwBdWDrZG6awRcb7PF0kkK0kF2UXsnQb/JvkqeGo2qmuPHcrsJnhkp
DKdYNGqS5SLvXoIpwzNF1zVo/GYsXe+VE2ywW7P3a9NQhHGPPRkmELB8j0dt
o2E7aSqamCTInQv1rDGn4dyYxr8yTVA8s3Evnk9jX85zVcwsgWxS5v4ORcPf
VvbL3DxB4+i4w8NdNE7EU/ylJYKJgc93zgpoZLx3VnVrhWBRrl9y4/Vvcwwm
hpKVBKreenaqkEbljZrCtTUCTscSS9eVxuUszdi76wTmbaUZA4TGtaAYz4xN
ArsWt9Xv3Gg0WnVYHHhFQO4/TRK702hesVFtbREwd0+9EHjQ+A/h/rd7
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Line[CompressedData["
1:eJwdkn001XcAh13M69W6boTL9ftJ6OJ6+U6Otvp95mbzNofJdjDklquxmA4n
ocjyNtOul4NpdyrRtqLVtKaVCXl3i1DndJ15NxbnYPdwUVb7nPOc5zz/f2hx
4scx6mpqanjNG+upyl0j9uq8yf+X9PCcONFWD9mnxSNuuX8yN79kB5v4GABd
fu4xFUPMpfT4eedPt6NpR0LQqNM4k129GfTvCw4aJDL/Rz/MMmpPxnAvjYt/
1KMNwxcWGJtkSeohgRF+lBWMlIiXmSllxSf6942R71ve8bxUyfhOx50uSTJB
upcZ3a6rYgKmpPZ8vhnKYv4+fCpxk5lvE2d11fMQahwnKqnaYoScEQtRlAWq
vnbx3p3Dgh6jjFas8BExqI1fLTXw4ULYqlUIBfsHpgtShSaetR5lhTnQKGx9
zA4p1sLt/PZISknD85vxlz12OpC8lTIml1tB/aXjFemELo6cSL/NrtoF071D
PJ1MfTjF2sv9o63RdtZSS8I1wCNDB/0Uj904mVxXy+3Zhj8asi84aNigpUJU
2OSyHeksQWDfqA16uoL4xW9zoKdI805otAX/q1vz4XMcTNfRZdUZdpDRLdWZ
jYYoszPVbArZg4ul8U69Ui6kVZLOaEqAx3NtVxMjdyCsLELOnhXApzshVNvO
CGsHa1XVzfb4IOPOdIe6MSanPVNb8xyQyK0P+0tujMv7XXj90Y6wOIOfLa/v
RH1OCifWUYjVvqyJ39NMkBdyxE9DKQSvlnvIy8sUbopLP+X1O6Et8OBFFWWG
yj0X6vv9nFExRg9rLZohs6Wo0q/JGUsi2dS7fTx8xAup7bF2QYlzvOPROnO8
n9AZzilwwWesmcjpJAtUm4ut+5QuqK99FXc+gA/rtqvlAeGucBC2R0nNLSF1
bBUMNrtimVEU5cxYQrKiOdAtIKg29PEbOExBfHOZKviWIOzkuojdSeGL7OBN
32ICSfL3zUNdFFKCG5+ySwmSkg54yHoo5CtTzkvLCQris4VCOYUGD9VGhYzg
TpSeaeAwBdWDrZG6awRcb7PF0kkK0kF2UXsnQb/JvkqeGo2qmuPHcrsJnhkp
DKdYNGqS5SLvXoIpwzNF1zVo/GYsXe+VE2ywW7P3a9NQhHGPPRkmELB8j0dt
o2E7aSqamCTInQv1rDGn4dyYxr8yTVA8s3Evnk9jX85zVcwsgWxS5v4ORcPf
VvbL3DxB4+i4w8NdNE7EU/ylJYKJgc93zgpoZLx3VnVrhWBRrl9y4/Vvcwwm
hpKVBKreenaqkEbljZrCtTUCTscSS9eVxuUszdi76wTmbaUZA4TGtaAYz4xN
ArsWt9Xv3Gg0WnVYHHhFQO4/TRK702hesVFtbREwd0+9EHjQ+A/h/rd7
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 1, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJwdkn001XcAh13M69W6boTL9ftJ6OJ6+U6Otvp95mbzNofJdjDklquxmA4n
ocjyNtOul4NpdyrRtqLVtKaVCXl3i1DndJ15NxbnYPdwUVb7nPOc5zz/f2hx
4scx6mpqanjNG+upyl0j9uq8yf+X9PCcONFWD9mnxSNuuX8yN79kB5v4GABd
fu4xFUPMpfT4eedPt6NpR0LQqNM4k129GfTvCw4aJDL/Rz/MMmpPxnAvjYt/
1KMNwxcWGJtkSeohgRF+lBWMlIiXmSllxSf6942R71ve8bxUyfhOx50uSTJB
upcZ3a6rYgKmpPZ8vhnKYv4+fCpxk5lvE2d11fMQahwnKqnaYoScEQtRlAWq
vnbx3p3Dgh6jjFas8BExqI1fLTXw4ULYqlUIBfsHpgtShSaetR5lhTnQKGx9
zA4p1sLt/PZISknD85vxlz12OpC8lTIml1tB/aXjFemELo6cSL/NrtoF071D
PJ1MfTjF2sv9o63RdtZSS8I1wCNDB/0Uj904mVxXy+3Zhj8asi84aNigpUJU
2OSyHeksQWDfqA16uoL4xW9zoKdI805otAX/q1vz4XMcTNfRZdUZdpDRLdWZ
jYYoszPVbArZg4ul8U69Ui6kVZLOaEqAx3NtVxMjdyCsLELOnhXApzshVNvO
CGsHa1XVzfb4IOPOdIe6MSanPVNb8xyQyK0P+0tujMv7XXj90Y6wOIOfLa/v
RH1OCifWUYjVvqyJ39NMkBdyxE9DKQSvlnvIy8sUbopLP+X1O6Et8OBFFWWG
yj0X6vv9nFExRg9rLZohs6Wo0q/JGUsi2dS7fTx8xAup7bF2QYlzvOPROnO8
n9AZzilwwWesmcjpJAtUm4ut+5QuqK99FXc+gA/rtqvlAeGucBC2R0nNLSF1
bBUMNrtimVEU5cxYQrKiOdAtIKg29PEbOExBfHOZKviWIOzkuojdSeGL7OBN
32ICSfL3zUNdFFKCG5+ySwmSkg54yHoo5CtTzkvLCQris4VCOYUGD9VGhYzg
TpSeaeAwBdWDrZG6awRcb7PF0kkK0kF2UXsnQb/JvkqeGo2qmuPHcrsJnhkp
DKdYNGqS5SLvXoIpwzNF1zVo/GYsXe+VE2ywW7P3a9NQhHGPPRkmELB8j0dt
o2E7aSqamCTInQv1rDGn4dyYxr8yTVA8s3Evnk9jX85zVcwsgWxS5v4ORcPf
VvbL3DxB4+i4w8NdNE7EU/ylJYKJgc93zgpoZLx3VnVrhWBRrl9y4/Vvcwwm
hpKVBKreenaqkEbljZrCtTUCTscSS9eVxuUszdi76wTmbaUZA4TGtaAYz4xN
ArsWt9Xv3Gg0WnVYHHhFQO4/TRK702hesVFtbREwd0+9EHjQ+A/h/rd7
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0.6, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPZQzeHiEfHoOIcDtd77BbKct6H8gUc
NuuolvJWv4PyRRwEKwQS7pX8gPIlHD43TjxmYsboAOHLOJxZXrfqRxQblK/g
wD7rQH3rFG4oX8khU97V0TBXAMpXcdjQbiagIiIM5as5FH7NV3ywVxTK13DI
cjtvvDBTAsrXclBUOs/3TEwaytdxKD7qfSv0qCyUr+dw9nLi8ggrBSjfwOGl
VtDD5PWKUL6hw3XvC337XilB+UYOy4S+fQ53VoHyjR20YjpnqM1RhfJNHBZJ
uDMrf1VzAADb70lZ
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPZQzeHiEfHoOIcDtd77BbKct6H8gUc
NuuolvJWv4PyRRwEKwQS7pX8gPIlHD43TjxmYsboAOHLOJxZXrfqRxQblK/g
wD7rQH3rFG4oX8khU97V0TBXAMpXcdjQbiagIiIM5as5FH7NV3ywVxTK13DI
cjtvvDBTAsrXclBUOs/3TEwaytdxKD7qfSv0qCyUr+dw9nLi8ggrBSjfwOGl
VtDD5PWKUL6hw3XvC337XilB+UYOy4S+fQ53VoHyjR20YjpnqM1RhfJNHBZJ
uDMrf1VzAADb70lZ
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0.6, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPZQzeHiEfHoOIcDtd77BbKct6H8gUc
NuuolvJWv4PyRRwEKwQS7pX8gPIlHD43TjxmYsboAOHLOJxZXrfqRxQblK/g
wD7rQH3rFG4oX8khU97V0TBXAMpXcdjQbiagIiIM5as5FH7NV3ywVxTK13DI
cjtvvDBTAsrXclBUOs/3TEwaytdxKD7qfSv0qCyUr+dw9nLi8ggrBSjfwOGl
VtDD5PWKUL6hw3XvC337XilB+UYOy4S+fQ53VoHyjR20YjpnqM1RhfJNHBZJ
uDMrf1VzAADb70lZ
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0.6, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0.6, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwdhwtQE3QAh4dggAxPEPEBjI1t/8l4CPxPPbDcTyA0eQQRWvPRMYURIvgA
H7xFQSciExUV0J0smcEBYsipFDdAmUtZpoUiM14SF0kBY8pEo+y7++67jyNJ
+SxuFoPBwH++r7RH1lw1Zvl+/2f33SOSFMEcPOw+En/tlUbUsIsZvegTW3yt
LFjeOaoXXc7YMeKzcR4Ol3CLXFXDojzF26jJl3Yorv4gucBlTMR43Ifv0+fj
pr2sYjBqUkRS4w98LlwAVVG1ubp/SvTCeG6DzQ+OyNDOu7CP+060figxq2T3
ItgwC+mGPgYiXsg9WKwl6NjnsJXHM8dIuyT3Xq0TjGvUil7Mhrddl0vQVy4o
KG3OEhdaYo7IGKs3sHA8tHtPW5011o6KX7vFsDEhC7EYmbHB07btZmJPDu4V
BnQHh8zFjWN3trKNHFjtvyrp8JuH+NlpfTqdG3qTesj6L+2wbU/GDWYZF6Ml
in3BSfZYJvXQhcXy8N0SQcLTg/Pxk72nTZo/H57SLkHYJQc01+WVe5oTPB90
3LuifgEyzISRD54TgJ9zgvHEEXP06euSGwUQ36teu920EENVnDOKzKWoK5ee
XG21GGeWLra4FeOO6zRMOeW1BPKyeE0sW4iJ6dYgdzhBfGaLjjksxDB/Ot8Q
5oyp4CsmRYsHihw2l17c5YLBocADbUc9sYtG+LXkslD5ka9TZ6wXzBcmVLSo
XFGbn2Yn9fJGwllrbdkWNo7GbAs1N3pD+FDtoHzBxnL95W+Pdi7Dx6OFa532
c3Devby2M9QH2ZWuat0MBznqovOht3wwN0DjOnHaDeFOMVd+5PniYF5kpITP
xZpkzSY7mS/MtlV22NZyoXCW8B4YfdHPt+K5gwdeu6o0YpMf+nJXaHK0PMi9
2oSPWvxw+0TIKm4kH/EGi5+1QoqX6YmlKwb4kDRMsGXFFKvMNq7MTyRIyot+
u/4UxWtV97OhJIK06MYnzNMU9RGbs0NSCI4Z007KSyl4FbF3LVMJ6vxN0+cu
UjBXJkUfzyIwtc50VdVQ/JZ0KKVYTiB/xCy6o6HIeVqjutBEUKbcmVCgpfDP
8Q59c5NAmaoLWnefwsBv+EvcTNDkKH9zX0ch3du03FlNoBfPT3j8K8Wnc1vb
L2kJBIOLgwYGKTjBXb1KPYFPYzrrmyGK7pEvDlv0EgTk95jihinOnuohcf0E
YYKL1/4YobDq7dtJfifYs4PNGh+nGD/45/TVvwkyPzxkum6gqGEnK6wnCPJt
B35JNVJs14wFJk4SnK9XFk5NUTxzeCXzMBFU5lpIb7+hON18wOvENEFNVFxg
5luKcMn0w5fvCBrdOlxW/0NhaZ2dGs4QoMVATDMzFK31jEV1swT4F5FhwGw=

           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Line[CompressedData["
1:eJwdhwtQE3QAh4dggAxPEPEBjI1t/8l4CPxPPbDcTyA0eQQRWvPRMYURIvgA
H7xFQSciExUV0J0smcEBYsipFDdAmUtZpoUiM14SF0kBY8pEo+y7++67jyNJ
+SxuFoPBwH++r7RH1lw1Zvl+/2f33SOSFMEcPOw+En/tlUbUsIsZvegTW3yt
LFjeOaoXXc7YMeKzcR4Ol3CLXFXDojzF26jJl3Yorv4gucBlTMR43Ifv0+fj
pr2sYjBqUkRS4w98LlwAVVG1ubp/SvTCeG6DzQ+OyNDOu7CP+060figxq2T3
ItgwC+mGPgYiXsg9WKwl6NjnsJXHM8dIuyT3Xq0TjGvUil7Mhrddl0vQVy4o
KG3OEhdaYo7IGKs3sHA8tHtPW5011o6KX7vFsDEhC7EYmbHB07btZmJPDu4V
BnQHh8zFjWN3trKNHFjtvyrp8JuH+NlpfTqdG3qTesj6L+2wbU/GDWYZF6Ml
in3BSfZYJvXQhcXy8N0SQcLTg/Pxk72nTZo/H57SLkHYJQc01+WVe5oTPB90
3LuifgEyzISRD54TgJ9zgvHEEXP06euSGwUQ36teu920EENVnDOKzKWoK5ee
XG21GGeWLra4FeOO6zRMOeW1BPKyeE0sW4iJ6dYgdzhBfGaLjjksxDB/Ot8Q
5oyp4CsmRYsHihw2l17c5YLBocADbUc9sYtG+LXkslD5ka9TZ6wXzBcmVLSo
XFGbn2Yn9fJGwllrbdkWNo7GbAs1N3pD+FDtoHzBxnL95W+Pdi7Dx6OFa532
c3Devby2M9QH2ZWuat0MBznqovOht3wwN0DjOnHaDeFOMVd+5PniYF5kpITP
xZpkzSY7mS/MtlV22NZyoXCW8B4YfdHPt+K5gwdeu6o0YpMf+nJXaHK0PMi9
2oSPWvxw+0TIKm4kH/EGi5+1QoqX6YmlKwb4kDRMsGXFFKvMNq7MTyRIyot+
u/4UxWtV97OhJIK06MYnzNMU9RGbs0NSCI4Z007KSyl4FbF3LVMJ6vxN0+cu
UjBXJkUfzyIwtc50VdVQ/JZ0KKVYTiB/xCy6o6HIeVqjutBEUKbcmVCgpfDP
8Q59c5NAmaoLWnefwsBv+EvcTNDkKH9zX0ch3du03FlNoBfPT3j8K8Wnc1vb
L2kJBIOLgwYGKTjBXb1KPYFPYzrrmyGK7pEvDlv0EgTk95jihinOnuohcf0E
YYKL1/4YobDq7dtJfifYs4PNGh+nGD/45/TVvwkyPzxkum6gqGEnK6wnCPJt
B35JNVJs14wFJk4SnK9XFk5NUTxzeCXzMBFU5lpIb7+hON18wOvENEFNVFxg
5luKcMn0w5fvCBrdOlxW/0NhaZ2dGs4QoMVATDMzFK31jEV1swT4F5FhwGw=

              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0.6, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Line[CompressedData["
1:eJwdhwtQE3QAh4dggAxPEPEBjI1t/8l4CPxPPbDcTyA0eQQRWvPRMYURIvgA
H7xFQSciExUV0J0smcEBYsipFDdAmUtZpoUiM14SF0kBY8pEo+y7++67jyNJ
+SxuFoPBwH++r7RH1lw1Zvl+/2f33SOSFMEcPOw+En/tlUbUsIsZvegTW3yt
LFjeOaoXXc7YMeKzcR4Ol3CLXFXDojzF26jJl3Yorv4gucBlTMR43Ifv0+fj
pr2sYjBqUkRS4w98LlwAVVG1ubp/SvTCeG6DzQ+OyNDOu7CP+060figxq2T3
ItgwC+mGPgYiXsg9WKwl6NjnsJXHM8dIuyT3Xq0TjGvUil7Mhrddl0vQVy4o
KG3OEhdaYo7IGKs3sHA8tHtPW5011o6KX7vFsDEhC7EYmbHB07btZmJPDu4V
BnQHh8zFjWN3trKNHFjtvyrp8JuH+NlpfTqdG3qTesj6L+2wbU/GDWYZF6Ml
in3BSfZYJvXQhcXy8N0SQcLTg/Pxk72nTZo/H57SLkHYJQc01+WVe5oTPB90
3LuifgEyzISRD54TgJ9zgvHEEXP06euSGwUQ36teu920EENVnDOKzKWoK5ee
XG21GGeWLra4FeOO6zRMOeW1BPKyeE0sW4iJ6dYgdzhBfGaLjjksxDB/Ot8Q
5oyp4CsmRYsHihw2l17c5YLBocADbUc9sYtG+LXkslD5ka9TZ6wXzBcmVLSo
XFGbn2Yn9fJGwllrbdkWNo7GbAs1N3pD+FDtoHzBxnL95W+Pdi7Dx6OFa532
c3Devby2M9QH2ZWuat0MBznqovOht3wwN0DjOnHaDeFOMVd+5PniYF5kpITP
xZpkzSY7mS/MtlV22NZyoXCW8B4YfdHPt+K5gwdeu6o0YpMf+nJXaHK0PMi9
2oSPWvxw+0TIKm4kH/EGi5+1QoqX6YmlKwb4kDRMsGXFFKvMNq7MTyRIyot+
u/4UxWtV97OhJIK06MYnzNMU9RGbs0NSCI4Z007KSyl4FbF3LVMJ6vxN0+cu
UjBXJkUfzyIwtc50VdVQ/JZ0KKVYTiB/xCy6o6HIeVqjutBEUKbcmVCgpfDP
8Q59c5NAmaoLWnefwsBv+EvcTNDkKH9zX0ch3du03FlNoBfPT3j8K8Wnc1vb
L2kJBIOLgwYGKTjBXb1KPYFPYzrrmyGK7pEvDlv0EgTk95jihinOnuohcf0E
YYKL1/4YobDq7dtJfifYs4PNGh+nGD/45/TVvwkyPzxkum6gqGEnK6wnCPJt
B35JNVJs14wFJk4SnK9XFk5NUTxzeCXzMBFU5lpIb7+hON18wOvENEFNVFxg
5luKcMn0w5fvCBrdOlxW/0NhaZ2dGs4QoMVATDMzFK31jEV1swT4F5FhwGw=

           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYOBWc8vTZ7jUHEOB/8oh1gjt0dQvoDD
6qDjbtn6n6F8EYf1nhvkY7T/Q/kSDilZes0ib1kdIHwZB+4p1/zCsnigfAWH
z08KnV/WCkL5Sg6Gm/iiHpwRgfJVHDLu71j4T14CyldzuCD1X5urTBrK13Ao
OvU50PqcHJSv5eDpvEObTUQRytdx0Jp682//QSUoX89h5TP+3pn5KlC+gcNW
k02qbKZqUL6hwydepfdnz6hD+UYOoT627HerNaF8Y4ccg/S/GtraUL6Jw94V
pTvv3dJxAACA/UoL
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYOBWc8vTZ7jUHEOB/8oh1gjt0dQvoDD
6qDjbtn6n6F8EYf1nhvkY7T/Q/kSDilZes0ib1kdIHwZB+4p1/zCsnigfAWH
z08KnV/WCkL5Sg6Gm/iiHpwRgfJVHDLu71j4T14CyldzuCD1X5urTBrK13Ao
OvU50PqcHJSv5eDpvEObTUQRytdx0Jp682//QSUoX89h5TP+3pn5KlC+gcNW
k02qbKZqUL6hwydepfdnz6hD+UYOoT627HerNaF8Y4ccg/S/GtraUL6Jw94V
pTvv3dJxAACA/UoL
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYOBWc8vTZ7jUHEOB/8oh1gjt0dQvoDD
6qDjbtn6n6F8EYf1nhvkY7T/Q/kSDilZes0ib1kdIHwZB+4p1/zCsnigfAWH
z08KnV/WCkL5Sg6Gm/iiHpwRgfJVHDLu71j4T14CyldzuCD1X5urTBrK13Ao
OvU50PqcHJSv5eDpvEObTUQRytdx0Jp682//QSUoX89h5TP+3pn5KlC+gcNW
k02qbKZqUL6hwydepfdnz6hD+UYOoT627HerNaF8Y4ccg/S/GtraUL6Jw94V
pTvv3dJxAACA/UoL
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwdhw80FHYAxyk9Xq5GhxQud7jj/HD8XnKG+/qz9c9qQnrXW+2u0B/L8ude
j9Yi/4rTtRG5NX/OqXgnevRWw1p/pHAW6VbRs7j1oj8zbrsry9Y+733e533Y
0tQtiQvMzMzwn++rSy3ndQRbvt//OXgrT5rKWwzd6nrLgZ4hUeuXjFjH9Usw
1xGi/iN7QlSbvX9SkGCDhUtX319jfC3KrZ6LmX1hC1VNyoeKbQaR2dAYOrKY
GK472W5R9UbEzUg6FMe3B7pCnF5wzTBhqNhq3ekAteq7oHcDC7BBv++rbw46
4tbszoeiS4uwaULhzWKthOBqcal5oRUmb0iP9micwD9UVzPFt4av7QOXyJ0u
eFLrHLjIaikWiwySkRkWmE9R5ia2wdqX4r858a5genlsHumzxa/Xd5uLCRvC
xlC74SAm2otu7nA1sKE+12spLbFD0qLMMa2Wg2mxdWfBnD12pWW3M6rckHfi
Wo0objn8kr210RJ3hMxeKA1SO2JgGbHOFHpgkPlR2J1lK/Fjc66SLOSi9WK8
86tkJ2Sb8z/tG+Vin7ljR+NDZyweyVp3oI2HaPnSpHNRLOgb2GXVhz2RXp4V
FlSxCmWeKyyuxHuh0ys6RXDMFYqqpNsSVz703eW/lPqyIS77TMt4xseqHJNQ
/oANY5TaVN3ljbUOgXm6Eg7G9RGHrhcSlO3V6KcC3VAX6u/UL/HBvYp/eNGv
3aDJz7RN9vGFIK8oR6Z0R2H8ro0LDb6ol/uMIcoDq0dqLxT2+8EirWlVwlsP
VHopNf0bBSi22y1b08DF19fklRuvCDB/yqDZtZOHT5zi1Xfd/ZFPaif97D0R
fuD2dtvj/vDLLwzr7vJEtbPUvc/gj54fPk4/L/OC+41zpzdtD0BBI36K4/Ch
8LnOH+wKwNYrcTa1d/lImrG4d4dPYa8KjxDmeEPa+qfr8ZMUxg17i5XeBCm5
sXMbTlFIlH0JZb4EmbFtOsa3FD1Tfu5yf4IiQ2ap4jSFsuSvjiNrCJqFprcV
ZylCtcdeSSIJTD/PP2hoosiN+T7GczuBYpAhv3mbgrFtaHn7CYIq1Rd7Cu5Q
yM4HTmjkBKoMbeS6XopR45mWBgXBZQfFm14tRcuZz9dXniYYETP3DA1TbHn8
Miu7joA3viLy6ThF+Q6rJ+FXCQRtWax6PcW75v2NwZ0EwfmPTYnPKPbMa2X0
GkE072zL80kKYU35Bx7dBGn7XVnT0xSPfuOEWw0SHA7JMV2aoYgKKFhiPkyQ
v+Tp/QwDhSb3+UOTjqDyoqrYaKQ44taSNjVKUHfUIvnqG4pn6UzRxBhBU0xi
xOE5is03Zdaj4wRtnG6XsHcUl+0e6YZ/J+ia4Zrm5ynYiaH12ucE/wL+lL9K

           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Line[CompressedData["
1:eJwdhw80FHYAxyk9Xq5GhxQud7jj/HD8XnKG+/qz9c9qQnrXW+2u0B/L8ude
j9Yi/4rTtRG5NX/OqXgnevRWw1p/pHAW6VbRs7j1oj8zbrsry9Y+733e533Y
0tQtiQvMzMzwn++rSy3ndQRbvt//OXgrT5rKWwzd6nrLgZ4hUeuXjFjH9Usw
1xGi/iN7QlSbvX9SkGCDhUtX319jfC3KrZ6LmX1hC1VNyoeKbQaR2dAYOrKY
GK472W5R9UbEzUg6FMe3B7pCnF5wzTBhqNhq3ekAteq7oHcDC7BBv++rbw46
4tbszoeiS4uwaULhzWKthOBqcal5oRUmb0iP9micwD9UVzPFt4av7QOXyJ0u
eFLrHLjIaikWiwySkRkWmE9R5ia2wdqX4r858a5genlsHumzxa/Xd5uLCRvC
xlC74SAm2otu7nA1sKE+12spLbFD0qLMMa2Wg2mxdWfBnD12pWW3M6rckHfi
Wo0objn8kr210RJ3hMxeKA1SO2JgGbHOFHpgkPlR2J1lK/Fjc66SLOSi9WK8
86tkJ2Sb8z/tG+Vin7ljR+NDZyweyVp3oI2HaPnSpHNRLOgb2GXVhz2RXp4V
FlSxCmWeKyyuxHuh0ys6RXDMFYqqpNsSVz703eW/lPqyIS77TMt4xseqHJNQ
/oANY5TaVN3ljbUOgXm6Eg7G9RGHrhcSlO3V6KcC3VAX6u/UL/HBvYp/eNGv
3aDJz7RN9vGFIK8oR6Z0R2H8ro0LDb6ol/uMIcoDq0dqLxT2+8EirWlVwlsP
VHopNf0bBSi22y1b08DF19fklRuvCDB/yqDZtZOHT5zi1Xfd/ZFPaif97D0R
fuD2dtvj/vDLLwzr7vJEtbPUvc/gj54fPk4/L/OC+41zpzdtD0BBI36K4/Ch
8LnOH+wKwNYrcTa1d/lImrG4d4dPYa8KjxDmeEPa+qfr8ZMUxg17i5XeBCm5
sXMbTlFIlH0JZb4EmbFtOsa3FD1Tfu5yf4IiQ2ap4jSFsuSvjiNrCJqFprcV
ZylCtcdeSSIJTD/PP2hoosiN+T7GczuBYpAhv3mbgrFtaHn7CYIq1Rd7Cu5Q
yM4HTmjkBKoMbeS6XopR45mWBgXBZQfFm14tRcuZz9dXniYYETP3DA1TbHn8
Miu7joA3viLy6ThF+Q6rJ+FXCQRtWax6PcW75v2NwZ0EwfmPTYnPKPbMa2X0
GkE072zL80kKYU35Bx7dBGn7XVnT0xSPfuOEWw0SHA7JMV2aoYgKKFhiPkyQ
v+Tp/QwDhSb3+UOTjqDyoqrYaKQ44taSNjVKUHfUIvnqG4pn6UzRxBhBU0xi
xOE5is03Zdaj4wRtnG6XsHcUl+0e6YZ/J+ia4Zrm5ynYiaH12ucE/wL+lL9K

              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Line[CompressedData["
1:eJwdhw80FHYAxyk9Xq5GhxQud7jj/HD8XnKG+/qz9c9qQnrXW+2u0B/L8ude
j9Yi/4rTtRG5NX/OqXgnevRWw1p/pHAW6VbRs7j1oj8zbrsry9Y+733e533Y
0tQtiQvMzMzwn++rSy3ndQRbvt//OXgrT5rKWwzd6nrLgZ4hUeuXjFjH9Usw
1xGi/iN7QlSbvX9SkGCDhUtX319jfC3KrZ6LmX1hC1VNyoeKbQaR2dAYOrKY
GK472W5R9UbEzUg6FMe3B7pCnF5wzTBhqNhq3ekAteq7oHcDC7BBv++rbw46
4tbszoeiS4uwaULhzWKthOBqcal5oRUmb0iP9micwD9UVzPFt4av7QOXyJ0u
eFLrHLjIaikWiwySkRkWmE9R5ia2wdqX4r858a5genlsHumzxa/Xd5uLCRvC
xlC74SAm2otu7nA1sKE+12spLbFD0qLMMa2Wg2mxdWfBnD12pWW3M6rckHfi
Wo0objn8kr210RJ3hMxeKA1SO2JgGbHOFHpgkPlR2J1lK/Fjc66SLOSi9WK8
86tkJ2Sb8z/tG+Vin7ljR+NDZyweyVp3oI2HaPnSpHNRLOgb2GXVhz2RXp4V
FlSxCmWeKyyuxHuh0ys6RXDMFYqqpNsSVz703eW/lPqyIS77TMt4xseqHJNQ
/oANY5TaVN3ljbUOgXm6Eg7G9RGHrhcSlO3V6KcC3VAX6u/UL/HBvYp/eNGv
3aDJz7RN9vGFIK8oR6Z0R2H8ro0LDb6ol/uMIcoDq0dqLxT2+8EirWlVwlsP
VHopNf0bBSi22y1b08DF19fklRuvCDB/yqDZtZOHT5zi1Xfd/ZFPaif97D0R
fuD2dtvj/vDLLwzr7vJEtbPUvc/gj54fPk4/L/OC+41zpzdtD0BBI36K4/Ch
8LnOH+wKwNYrcTa1d/lImrG4d4dPYa8KjxDmeEPa+qfr8ZMUxg17i5XeBCm5
sXMbTlFIlH0JZb4EmbFtOsa3FD1Tfu5yf4IiQ2ap4jSFsuSvjiNrCJqFprcV
ZylCtcdeSSIJTD/PP2hoosiN+T7GczuBYpAhv3mbgrFtaHn7CYIq1Rd7Cu5Q
yM4HTmjkBKoMbeS6XopR45mWBgXBZQfFm14tRcuZz9dXniYYETP3DA1TbHn8
Miu7joA3viLy6ThF+Q6rJ+FXCQRtWax6PcW75v2NwZ0EwfmPTYnPKPbMa2X0
GkE072zL80kKYU35Bx7dBGn7XVnT0xSPfuOEWw0SHA7JMV2aoYgKKFhiPkyQ
v+Tp/QwDhSb3+UOTjqDyoqrYaKQ44taSNjVKUHfUIvnqG4pn6UzRxBhBU0xi
xOE5is03Zdaj4wRtnG6XsHcUl+0e6YZ/J+ia4Zrm5ynYiaH12ucE/wL+lL9K

           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.6, 0, 0.6], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEf7BlQgcM2JZHydZ7HoeIcDsqTXu8xm/IUyhdw
+O3g92vC4u9QvogDd1sEzxxTZgcIX8JhgqbfmZsvuKB8GQfLttJLa+MFoXwF
B+cNjUtvhohC+UoOB8XdTnkFSEL5Kg49M868/u0vC+WrORSz/W2JXKkA5Ws4
NE82XHZptRKUr+UwI5B7i8p6FShfx4Eh1ytGfrMalK/nEHDHNGnBdg0o38Ch
Ma1T9tFZLSjf0MFNYEFX9UEdKN/IIXpShB/7MT0o39jhd50SX2O8gQMATYJH
Dw==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEf7BlQgcM2JZHydZ7HoeIcDsqTXu8xm/IUyhdw
+O3g92vC4u9QvogDd1sEzxxTZgcIX8JhgqbfmZsvuKB8GQfLttJLa+MFoXwF
B+cNjUtvhohC+UoOB8XdTnkFSEL5Kg49M868/u0vC+WrORSz/W2JXKkA5Ws4
NE82XHZptRKUr+UwI5B7i8p6FShfx4Eh1ytGfrMalK/nEHDHNGnBdg0o38Ch
Ma1T9tFZLSjf0MFNYEFX9UEdKN/IIXpShB/7MT0o39jhd50SX2O8gQMATYJH
Dw==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.6, 0, 0.6]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQBmIQDQEf7BlQgcM2JZHydZ7HoeIcDsqTXu8xm/IUyhdw
+O3g92vC4u9QvogDd1sEzxxTZgcIX8JhgqbfmZsvuKB8GQfLttJLa+MFoXwF
B+cNjUtvhohC+UoOB8XdTnkFSEL5Kg49M868/u0vC+WrORSz/W2JXKkA5Ws4
NE82XHZptRKUr+UwI5B7i8p6FShfx4Eh1ytGfrMalK/nEHDHNGnBdg0o38Ch
Ma1T9tFZLSjf0MFNYEFX9UEdKN/IIXpShB/7MT0o39jhd50SX2O8gQMATYJH
Dw==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.6, 0, 0.6]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.6, 0, 0.6], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtxQ04FHYAx/G7GEvOk5R5vR3OnTt33N+/PCXrftHTkpdHcbfSG4ejF4lY
3opqUtuDKx4URlSrhLWHSisayvLWUlmNJBxP2taLuzgp255n3+f5PF87Rez6
yDkMBmPlv/57nqC0ND3FAIz/U/QFN+l1GqDALTrhYfUZadztbxSxfCOc75HP
+PU+lV7eYxxk4cPC4hMD0o/lL6WnU3eOS76aj/rkq48u1Gmkh8pm1mn+NMXF
jtHfih3eSxkPBnEjxQwaKuswa2CAl6BMChYuglNgjYWOq48RbaF83k1zGHy4
/qmX3BBr1Tv2n4izwPTkinBhpxECRlTObLYVFlqwKp8RE4y3KDJ+rbZGTESb
V1rNfLiY9tp6b7PFk2Hv7RuUC2Ak1Yb1T7BR4mwVNspYiC//Cpm0l3Gw00pk
0npzER43RzBDRHZotx4WH43/DPVHW7dytHY4qJ5gf5xrCeUniYPd3fZYKcft
lhYrhMen1hufcsCG3FHP5aE2cI1y7vYL44LZR/gnNba4t0A0L3GZI+q7rt1Z
XfU5fq45VCzS42Fba6d1UAUHqUxhYOdTHrZr/6gRZtjBqD9lze46Pm7ULk/V
brSH+pxdflmaEzwDfCSWjg7Id7LUb5AJgFuapggmF6pTyrYwjhCx5v5L597j
IiR/S7fxmBBj2skX5UWOmFp1VlfW6Az1eXwdupeHYbVXUnOWCCZwf5kk5aPi
C2LdFSbGjYt3PRpsnFCdmWgaJXZBoW7u3vUvnZAlC/fV07rg+v2SkYF6AZb0
n76Q1eUKxf4uSd5xIYoExdVdvhK4s6oiy7c6I/1WdpFvgwQ5e3iJjzxF8LeW
nW3nEpAtmpsfzMVYubttk+kxghlx7KsDQ2KU2Si4nVqCgJ6s9/wmF3BbfigI
2OSGjhD/14JsV6jEzcKeRjf4XHHLzXWWQDmhf/+ukOLV+Wwz9kkJFJffco7l
UlxkSY03zkqw61DQzNrjFFeNnh+xYxIkBtX9bpxH0Wx4mDk+h+CoNjFHVUDx
hNn2LsWAoGaZ7n1hKYXhu4DnJSwC3S+zveeqKCIGtl4ZtCZQ9Rhnt7ZR2NYe
CI1eSnCqMib6yF0KwSVOn8SDoDKh23tNB8XiC80y3XKCK+aq6Y5uCr9KA99v
pQT9IWbRDx5RJBfmLLm0moA/bOk9NEzRm/690etgAkldCvuMmmIoDZnX5AQe
mX26yDGKv5OHZjM2EPjxS398MU6hl8DTmm4miN/JYb95Q+EWXfOMhhOkeR7U
/TRBsSIyMGQmgiCTNfQwQUuxVvH2YauSoKi28rupKYqwze7tsh0EFRn6Uden
KWI2Pl7F3kVQtS7SK22GYp88pWk0hqDO/o7tio8Uh4NsPGpjCRoneLrZWYrc
wMa6fXEE/wClxcMy
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             Line[CompressedData["
1:eJwtxQ04FHYAx/G7GEvOk5R5vR3OnTt33N+/PCXrftHTkpdHcbfSG4ejF4lY
3opqUtuDKx4URlSrhLWHSisayvLWUlmNJBxP2taLuzgp255n3+f5PF87Rez6
yDkMBmPlv/57nqC0ND3FAIz/U/QFN+l1GqDALTrhYfUZadztbxSxfCOc75HP
+PU+lV7eYxxk4cPC4hMD0o/lL6WnU3eOS76aj/rkq48u1Gmkh8pm1mn+NMXF
jtHfih3eSxkPBnEjxQwaKuswa2CAl6BMChYuglNgjYWOq48RbaF83k1zGHy4
/qmX3BBr1Tv2n4izwPTkinBhpxECRlTObLYVFlqwKp8RE4y3KDJ+rbZGTESb
V1rNfLiY9tp6b7PFk2Hv7RuUC2Ak1Yb1T7BR4mwVNspYiC//Cpm0l3Gw00pk
0npzER43RzBDRHZotx4WH43/DPVHW7dytHY4qJ5gf5xrCeUniYPd3fZYKcft
lhYrhMen1hufcsCG3FHP5aE2cI1y7vYL44LZR/gnNba4t0A0L3GZI+q7rt1Z
XfU5fq45VCzS42Fba6d1UAUHqUxhYOdTHrZr/6gRZtjBqD9lze46Pm7ULk/V
brSH+pxdflmaEzwDfCSWjg7Id7LUb5AJgFuapggmF6pTyrYwjhCx5v5L597j
IiR/S7fxmBBj2skX5UWOmFp1VlfW6Az1eXwdupeHYbVXUnOWCCZwf5kk5aPi
C2LdFSbGjYt3PRpsnFCdmWgaJXZBoW7u3vUvnZAlC/fV07rg+v2SkYF6AZb0
n76Q1eUKxf4uSd5xIYoExdVdvhK4s6oiy7c6I/1WdpFvgwQ5e3iJjzxF8LeW
nW3nEpAtmpsfzMVYubttk+kxghlx7KsDQ2KU2Si4nVqCgJ6s9/wmF3BbfigI
2OSGjhD/14JsV6jEzcKeRjf4XHHLzXWWQDmhf/+ukOLV+Wwz9kkJFJffco7l
UlxkSY03zkqw61DQzNrjFFeNnh+xYxIkBtX9bpxH0Wx4mDk+h+CoNjFHVUDx
hNn2LsWAoGaZ7n1hKYXhu4DnJSwC3S+zveeqKCIGtl4ZtCZQ9Rhnt7ZR2NYe
CI1eSnCqMib6yF0KwSVOn8SDoDKh23tNB8XiC80y3XKCK+aq6Y5uCr9KA99v
pQT9IWbRDx5RJBfmLLm0moA/bOk9NEzRm/690etgAkldCvuMmmIoDZnX5AQe
mX26yDGKv5OHZjM2EPjxS398MU6hl8DTmm4miN/JYb95Q+EWXfOMhhOkeR7U
/TRBsSIyMGQmgiCTNfQwQUuxVvH2YauSoKi28rupKYqwze7tsh0EFRn6Uden
KWI2Pl7F3kVQtS7SK22GYp88pWk0hqDO/o7tio8Uh4NsPGpjCRoneLrZWYrc
wMa6fXEE/wClxcMy
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 18.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 18.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.6, 0, 0.6]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          Line[CompressedData["
1:eJwtxQ04FHYAx/G7GEvOk5R5vR3OnTt33N+/PCXrftHTkpdHcbfSG4ejF4lY
3opqUtuDKx4URlSrhLWHSisayvLWUlmNJBxP2taLuzgp255n3+f5PF87Rez6
yDkMBmPlv/57nqC0ND3FAIz/U/QFN+l1GqDALTrhYfUZadztbxSxfCOc75HP
+PU+lV7eYxxk4cPC4hMD0o/lL6WnU3eOS76aj/rkq48u1Gmkh8pm1mn+NMXF
jtHfih3eSxkPBnEjxQwaKuswa2CAl6BMChYuglNgjYWOq48RbaF83k1zGHy4
/qmX3BBr1Tv2n4izwPTkinBhpxECRlTObLYVFlqwKp8RE4y3KDJ+rbZGTESb
V1rNfLiY9tp6b7PFk2Hv7RuUC2Ak1Yb1T7BR4mwVNspYiC//Cpm0l3Gw00pk
0npzER43RzBDRHZotx4WH43/DPVHW7dytHY4qJ5gf5xrCeUniYPd3fZYKcft
lhYrhMen1hufcsCG3FHP5aE2cI1y7vYL44LZR/gnNba4t0A0L3GZI+q7rt1Z
XfU5fq45VCzS42Fba6d1UAUHqUxhYOdTHrZr/6gRZtjBqD9lze46Pm7ULk/V
brSH+pxdflmaEzwDfCSWjg7Id7LUb5AJgFuapggmF6pTyrYwjhCx5v5L597j
IiR/S7fxmBBj2skX5UWOmFp1VlfW6Az1eXwdupeHYbVXUnOWCCZwf5kk5aPi
C2LdFSbGjYt3PRpsnFCdmWgaJXZBoW7u3vUvnZAlC/fV07rg+v2SkYF6AZb0
n76Q1eUKxf4uSd5xIYoExdVdvhK4s6oiy7c6I/1WdpFvgwQ5e3iJjzxF8LeW
nW3nEpAtmpsfzMVYubttk+kxghlx7KsDQ2KU2Si4nVqCgJ6s9/wmF3BbfigI
2OSGjhD/14JsV6jEzcKeRjf4XHHLzXWWQDmhf/+ukOLV+Wwz9kkJFJffco7l
UlxkSY03zkqw61DQzNrjFFeNnh+xYxIkBtX9bpxH0Wx4mDk+h+CoNjFHVUDx
hNn2LsWAoGaZ7n1hKYXhu4DnJSwC3S+zveeqKCIGtl4ZtCZQ9Rhnt7ZR2NYe
CI1eSnCqMib6yF0KwSVOn8SDoDKh23tNB8XiC80y3XKCK+aq6Y5uCr9KA99v
pQT9IWbRDx5RJBfmLLm0moA/bOk9NEzRm/690etgAkldCvuMmmIoDZnX5AQe
mX26yDGKv5OHZjM2EPjxS398MU6hl8DTmm4miN/JYb95Q+EWXfOMhhOkeR7U
/TRBsSIyMGQmgiCTNfQwQUuxVvH2YauSoKi28rupKYqwze7tsh0EFRn6Uden
KWI2Pl7F3kVQtS7SK22GYp88pWk0hqDO/o7tio8Uh4NsPGpjCRoneLrZWYrc
wMa6fXEE/wClxcMy
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 18.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 0}, {20, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 20}, {0, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 20}, {0, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{1, 0}, {1, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{2, 0}, {2, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{3, 0}, {3, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{4, 0}, {4, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{5, 0}, {5, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{6, 0}, {6, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{7, 0}, {7, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{8, 0}, {8, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{9, 0}, {9, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{10, 0}, {10, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{11, 0}, {11, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{12, 0}, {12, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{13, 0}, {13, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{14, 0}, {14, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{15, 0}, {15, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{16, 0}, {16, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{17, 0}, {17, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{18, 0}, {18, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{19, 0}, {19, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 5}, {0.6, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 10}, {0.6, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 15}, {0.6, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -4}, {0.24000000000000002`, -4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -3}, {0.24000000000000002`, -3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -2}, {0.24000000000000002`, -2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -1}, {0.24000000000000002`, -1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 1}, {0.24000000000000002`, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 2}, {0.24000000000000002`, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 3}, {0.24000000000000002`, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 4}, {0.24000000000000002`, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 6}, {0.24000000000000002`, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 7}, {0.24000000000000002`, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 8}, {0.24000000000000002`, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 9}, {0.24000000000000002`, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 11}, {0.24000000000000002`, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 12}, {0.24000000000000002`, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 13}, {0.24000000000000002`, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 14}, {0.24000000000000002`, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 16}, {0.24000000000000002`, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 17}, {0.24000000000000002`, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 18}, {0.24000000000000002`, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 19}, {0.24000000000000002`, 19}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 1}, {19.76, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 2}, {19.76, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 3}, {19.76, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 4}, {19.76, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 5}, {19.4, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 6}, {19.76, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 7}, {19.76, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 8}, {19.76, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 9}, {19.76, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 10}, {19.4, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 11}, {19.76, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 12}, {19.76, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 13}, {19.76, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 14}, {19.76, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 15}, {19.4, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 16}, {19.76, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 17}, {19.76, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 18}, {19.76, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 19}, {19.76, 19}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{None, None}, {None, None}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.1, 21.}, {-0.2, 20.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.9570837946080813`*^9, 3.957083839859324*^9, 3.9570838871697793`*^9, 
   3.957083930449354*^9, 3.9570839711823273`*^9, {3.9570840196447077`*^9, 
   3.957084052855567*^9}, {3.9570841756693497`*^9, 3.957084215730362*^9}, 
   3.957086836510303*^9, 3.9570868793421116`*^9, 3.9570880603317704`*^9, 
   3.9570885752910786`*^9, {3.957089007859604*^9, 3.9570890180878267`*^9}, {
   3.9570890681522193`*^9, 3.9570891045231*^9}, {3.9570893642158113`*^9, 
   3.957089386116357*^9}, 3.957089737125898*^9, 3.9570899069659367`*^9, {
   3.9570899608949347`*^9, 3.9570899704943953`*^9}, 3.957090027210146*^9, 
   3.9570901141469297`*^9},
 CellLabel->
  "Out[28600]=",ExpressionUUID->"85abbbe8-1bf5-4580-8eb8-bfb2c748f1f0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure S.I. - gradient dependence of t_esc
(d) Gradient, image potential and surface effect included\
\>", "Section",
 CellChangeTimes->{{3.9570171298158393`*^9, 3.957017145665162*^9}, {
  3.957080152611906*^9, 3.957080167029992*^9}, {3.957088094067566*^9, 
  3.9570880962230043`*^9}},ExpressionUUID->"0533327c-2576-40b7-8fab-\
957d29e5cc95"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Simulation", " ", "results", " ", "for", " ", "tesc_average", " ", "as", 
     " ", "a", " ", "function", " ", "of", " ", "the", " ", "layer", " ", 
     "thickness"}], ",", " ", 
    RowBox[{
     RowBox[{"without", " ", "gradient", " ", 
      RowBox[{"(", "tabg0", ")"}], " ", "and", " ", "for", " ", "a", " ", 
      "gradient", " ", "of"}], " ", "-", 
     RowBox[{"0.01", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg1", ")"}], " ", "to"}], " ", "-", 
     RowBox[{"0.06", " ", 
      RowBox[{"eV", "/", "nm"}], " ", 
      RowBox[{"(", "tabg6", ")"}]}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tabg0", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5019624847157163`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.002697115827517`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.5125345097289395`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3.251332890259796`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "4.300567184663317`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "5.691032559404824`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "7.446120159004741`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "9.585992214787527`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "12.128412598795256`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "15.089127932593867`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "18.482155763292596`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "22.32002893128987`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "26.614004078811902`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "31.374238133474567`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "36.61317808540139`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "42.329479736215696`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "48.540524934670216`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "55.25009802267729`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "62.46466702832168`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5028973828847625`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.003982145079407`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.5185546107495758`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3.374470686699672`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "4.793641976841744`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "7.079326571248822`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "10.675596819330098`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "16.217116878632122`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "24.629687068032734`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "37.271153559762254`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "56.13792390940768`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "84.16916899620125`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "125.69550936476097`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "187.10112102455292`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "277.87460715756856`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "411.6834416810846`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "609.2397899930969`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "900.7082572040429`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1330.715751483756`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5042776524645944`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.0058795362523907`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.52750047238524`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3.560381893038183`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "5.805835202024725`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "10.603763626678862`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "20.697840187962864`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "41.87334352259097`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "86.42769017047632`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "180.63232119953244`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "380.81703092565294`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "808.0966925327452`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "1723.4439254375795`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "3690.152557819152`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "7933.076971883466`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "17064.62757970948`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "36812.54872351982`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "79536.26584921926`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "172057.11347288988`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5063154616892662`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.008681237424267`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.540834706785799`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3.844031252655399`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "7.733226074675715`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "19.04063905687117`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "52.231778314138275`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "151.48095795832182`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "453.3170190633182`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "1383.3027556307516`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "4276.151857998275`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "13337.343230938479`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "41864.32617539251`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "132017.57252383855`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "418801.3296233974`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "1.3254682127491527`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "4.214186443744839`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "1.34206685323947`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "4.279702401602784`*^7"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5093240525448746`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.0128185454088827`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.560799099990483`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "4.522131514182109`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "12.350594503377206`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "43.96885498676414`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "176.98100025542132`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "755.9528029494486`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "3336.239561468056`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "15018.828841229632`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "68485.84059933909`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "315045.62117316003`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "1.4583175697895589`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "6.781435459066454`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "3.183065499494348`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "1.4806256335935143`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "6.942522092356426`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "3.2608769475356817`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1.5337690336563353`*^10"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg5", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.5137658907831453`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.0189288068183124`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.590885711053154`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5.669943262627025`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "22.496247068074325`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "119.67123155782373`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "716.5806402132728`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "4536.048393828645`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "29606.39977967759`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "196880.78607808612`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "1.3253500993808126`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "8.997577347094381`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "6.145572169146202`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4.216635838021383`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "2.940087369796396`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "2.004284734098239`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "1.3866973299466476`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "9.610842162143396`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "6.673470923925734`*^12"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tabg6", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.52032375387649`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "2.027954268974061`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.636656242005148`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "7.542413892609325`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "45.29864082624303`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7", ",", "363.3908495628778`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8", ",", "3243.0058990945645`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "30440.55335485074`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "293937.46000301006`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11", ",", "2.888552512145384`*^6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "2.871899382025086`*^7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "2.878712089157049`*^8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "2.9026946472324266`*^9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15", ",", "2.9399220092312935`*^10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "3.064074319122509`*^11"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "3.0445455374372305`*^12"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"18", ",", "3.1135468642213855`*^13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"19", ",", "3.112551273636625`*^14"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "2.949348706643631`*^15"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9570179772619314`*^9, 3.9570180953308115`*^9}, {
   3.957018130955658*^9, 3.957018215682221*^9}, {3.9570182483795967`*^9, 
   3.9570182498622723`*^9}, {3.9570182837986765`*^9, 
   3.9570182852908335`*^9}, {3.957018322219037*^9, 3.9570183250144663`*^9}, {
   3.957018363945951*^9, 3.9570183681405325`*^9}, {3.957018442196556*^9, 
   3.957018610886937*^9}, {3.9570186496028247`*^9, 3.9570187244844*^9}, {
   3.957018765810251*^9, 3.9570188498960905`*^9}, {3.957018918296104*^9, 
   3.9570189374221983`*^9}, {3.957019000142621*^9, 3.957019223719556*^9}, {
   3.9570192658838415`*^9, 3.9570193388030453`*^9}, {3.957019606873952*^9, 
   3.9570196071413164`*^9}, {3.9570196888161397`*^9, 3.957019689036353*^9}, {
   3.957019734845105*^9, 3.9570197589959383`*^9}, {3.9570197952984085`*^9, 
   3.9570197971588607`*^9}, {3.957019838683606*^9, 3.957019985227247*^9}, {
   3.957020038838397*^9, 3.9570201283874245`*^9}, 3.957020197149083*^9, {
   3.9570204733372583`*^9, 3.957020500620798*^9}, {3.9570205509616127`*^9, 
   3.95702066161045*^9}, {3.957020692895506*^9, 3.957020708878168*^9}, {
   3.9570207595181*^9, 3.9570208497017155`*^9}, {3.957020888824114*^9, 
   3.957020889060049*^9}, {3.9570209951649275`*^9, 3.9570210101170444`*^9}, {
   3.9570210550686293`*^9, 3.9570210588326006`*^9}, {3.9570210907714324`*^9, 
   3.957021265128262*^9}, {3.957021371426813*^9, 3.9570214149432645`*^9}, {
   3.9570214602954516`*^9, 3.9570214916352696`*^9}, {3.9570218346690845`*^9, 
   3.957021883427083*^9}, {3.957021916297*^9, 3.9570220552469535`*^9}, {
   3.9570221070400944`*^9, 3.957022185042626*^9}, {3.957022259364053*^9, 
   3.957022310992408*^9}, {3.9570224069747143`*^9, 3.9570226593058558`*^9}, {
   3.957022690348491*^9, 3.9570229809182606`*^9}, {3.9570807332642946`*^9, 
   3.9570807389187856`*^9}, {3.9570832592634125`*^9, 
   3.9570833158374405`*^9}, {3.957083356859758*^9, 3.9570833570177145`*^9}, {
   3.957086269295518*^9, 3.957086306209256*^9}, {3.9570875636342883`*^9, 
   3.9570875858415146`*^9}, {3.957087626605941*^9, 3.9570876638939085`*^9}, {
   3.9570877278520327`*^9, 3.9570878108153224`*^9}, {3.957087879678118*^9, 
   3.9570878903657827`*^9}, {3.95708792188787*^9, 3.9570879659007607`*^9}, 
   3.957089748737265*^9, {3.9570898193102446`*^9, 3.9570898195309496`*^9}, {
   3.9570899864611244`*^9, 3.9570899867594094`*^9}, {3.9570901548315215`*^9, 
   3.957090155631817*^9}, {3.95709019066789*^9, 3.9570901915436087`*^9}, 
   3.971006441597277*^9, 
   3.9710064969860353`*^9},ExpressionUUID->"21c05836-feea-42b5-85f3-\
d4ce9719039b"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPNL9nj85Yeg4pzOOzxOTTJKugylC/g
sKZG/VzZmptQvojD/zVhffzPH0D5Eg53e2eZMZ94CuXLOKwK3u2vZPwayldw
MLmZFO5dArNXyUF76+xg3pjPUL6KQ5nVlrQs529QvprDip7U6+EqP6F8DYeq
2f6WX/78hvK1HGbaM7jlnv0H5es4bP56RSPjNIMDhK/nkHX9VpKZLhOUb+Bw
/cXphQy9zFC+ocPHBhPzBa9YoHwjh9uu+oL27mxQvrHDg4tMzH8XsUP5Jg7s
VTvyFP5xOAAA319SRA==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPNL9nj85Yeg4pzOOzxOTTJKugylC/g
sKZG/VzZmptQvojD/zVhffzPH0D5Eg53e2eZMZ94CuXLOKwK3u2vZPwayldw
MLmZFO5dArNXyUF76+xg3pjPUL6KQ5nVlrQs529QvprDip7U6+EqP6F8DYeq
2f6WX/78hvK1HGbaM7jlnv0H5es4bP56RSPjNIMDhK/nkHX9VpKZLhOUb+Bw
/cXphQy9zFC+ocPHBhPzBa9YoHwjh9uu+oL27mxQvrHDg4tMzH8XsUP5Jg7s
VTvyFP5xOAAA319SRA==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
            "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
            "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
           "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPNL9nj85Yeg4pzOOzxOTTJKugylC/g
sKZG/VzZmptQvojD/zVhffzPH0D5Eg53e2eZMZ94CuXLOKwK3u2vZPwayldw
MLmZFO5dArNXyUF76+xg3pjPUL6KQ5nVlrQs529QvprDip7U6+EqP6F8DYeq
2f6WX/78hvK1HGbaM7jlnv0H5es4bP56RSPjNIMDhK/nkHX9VpKZLhOUb+Bw
/cXphQy9zFC+ocPHBhPzBa9YoHwjh9uu+oL27mxQvrHDg4tMzH8XsUP5Jg7s
VTvyFP5xOAAA319SRA==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{-0.1, 21.}, {-0.2, 20.1}}, 
         "Frame" -> {{None, None}, {None, None}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {False, False}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtxQ841HcAx/Hj0A9XsVYrfw8XOUf0257RyvcTevInlcrWg/44f84TMR7X
0+5uixZSD52t8KCp/Gl4onI8s0oLC+Eat/5siPm7RNJ13Dl/tj3P3s/zet42
/IT9UboMBsPnX/+d8aN5he5+NWH8X/yo47CsWkM6NZ1zIZIsYmRz1mHAnQGl
IOptnraOZJt0cK8dY8LJLOlKekYz4fcefMDsNMBY2XQtaeskib+e5Sc4GKHS
2mdy6E0Puf0l68B6v5UIcH7KS3F6Tq6JYydcvzBBTaB+eVFzLzlTvBD0ftIU
KR/dL283GCQMxSDuidbgcsDSdjV7iNgnR586yF0LluHFxLGYETKiyvvc+P46
zNp73XuYOUb8R49//V3ienjLfUrCXvxN9oxInayszLDsLu/iWrwmE838lLab
5nDWE60ec58iLqbPLL2PWqLxkHDq2LfTxIiowvuUVvgr3S8xUvGW7JoKmbMN
ZmOtPWOrWjtDXjRF6oTwbKDjICrdaK0kdedajrBVNuAcSitod3lPovWFg3K5
LbSBPx0JDFaRiCRxHavADkbJkupdMbNks8BJvjucg24t82qvcI48+YBnLPTY
CF/f2qN7C9TkbvWZQh7THpoWZaVHlYaIdbj7OvvtEWYQ1sJUzBOjPpFvvMwB
JysyTgtUWjJabnOpWLIJrRKfRzv0FsmlTRv0GoIdIf/QsVfruESkBdGt4Wwu
VvX/IOZtWyYhlw7LWeNcpDInj4g5DKh9yjTFjU54JrIQ7KtnYHjU61RTBg++
59fWHfPUwfXtbuZd4c4wkdhODHbr4Gaa0FTg7IJZfXVkUaguMoIjApgqFzSg
5lbpkC4+6btWkdG1GYrDomELIRP5joU3uwJcwVqzKuy3RSZO/5KVH9DgiqLK
urvKHD0EmgeXPea4YYXSczLCTh874ltDTTPdcFEh5a+u0kexBZ/TqXJDQu7s
A66nATjNN3L3hG5B/AwnIrXVAFLnJm5P4xb4LX78nLNnBaKVet3tXBqi14e2
uA+uAP/2O3bmRRrtiTsV6TEU4s4cWPDPoZG2vu3k+HEKwgOy56zvaWx/4G/m
e4LCOZUwW5pL4w5rX7hhEoVqD4027wqNwhsh0xfEFDQPl5+VV9GI608wzsmm
IO1hZbW00ljpV+BdKKNQUHIiJr2dRtu0xbi2nkJJstzbt4NGam7x+bAGCvXr
pPMdchqzw6Xdlo0U+kLWxCie0nj5Tc3Rq60UHIY3eA8N06iRtYjL/qTgKhNZ
lY7SEITusjbop7A1rVcTNU7DTvdxU/QAhd0OV269mqCRu/eJ4aYRCkmxbKuZ
GRqnJ/7Iq5yiINmWqrmjpOGRE/aZ8VsKaSuHfk9W0VB+OvAy9h2F/JqSC2o1
jZi0kY3OcxSup+gJfp6nYcsTtGdpKFQFRXlJFmj09ryKe6OlILN9ZOm5ROPy
V3Eme5coNCrtNcvLNILY07U1DEP8A2fK7Kc=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]], 
             Line[CompressedData["
1:eJwtxQ841HcAx/Hj0A9XsVYrfw8XOUf0257RyvcTevInlcrWg/44f84TMR7X
0+5uixZSD52t8KCp/Gl4onI8s0oLC+Eat/5siPm7RNJ13Dl/tj3P3s/zet42
/IT9UboMBsPnX/+d8aN5he5+NWH8X/yo47CsWkM6NZ1zIZIsYmRz1mHAnQGl
IOptnraOZJt0cK8dY8LJLOlKekYz4fcefMDsNMBY2XQtaeskib+e5Sc4GKHS
2mdy6E0Puf0l68B6v5UIcH7KS3F6Tq6JYydcvzBBTaB+eVFzLzlTvBD0ftIU
KR/dL283GCQMxSDuidbgcsDSdjV7iNgnR586yF0LluHFxLGYETKiyvvc+P46
zNp73XuYOUb8R49//V3ienjLfUrCXvxN9oxInayszLDsLu/iWrwmE838lLab
5nDWE60ec58iLqbPLL2PWqLxkHDq2LfTxIiowvuUVvgr3S8xUvGW7JoKmbMN
ZmOtPWOrWjtDXjRF6oTwbKDjICrdaK0kdedajrBVNuAcSitod3lPovWFg3K5
LbSBPx0JDFaRiCRxHavADkbJkupdMbNks8BJvjucg24t82qvcI48+YBnLPTY
CF/f2qN7C9TkbvWZQh7THpoWZaVHlYaIdbj7OvvtEWYQ1sJUzBOjPpFvvMwB
JysyTgtUWjJabnOpWLIJrRKfRzv0FsmlTRv0GoIdIf/QsVfruESkBdGt4Wwu
VvX/IOZtWyYhlw7LWeNcpDInj4g5DKh9yjTFjU54JrIQ7KtnYHjU61RTBg++
59fWHfPUwfXtbuZd4c4wkdhODHbr4Gaa0FTg7IJZfXVkUaguMoIjApgqFzSg
5lbpkC4+6btWkdG1GYrDomELIRP5joU3uwJcwVqzKuy3RSZO/5KVH9DgiqLK
urvKHD0EmgeXPea4YYXSczLCTh874ltDTTPdcFEh5a+u0kexBZ/TqXJDQu7s
A66nATjNN3L3hG5B/AwnIrXVAFLnJm5P4xb4LX78nLNnBaKVet3tXBqi14e2
uA+uAP/2O3bmRRrtiTsV6TEU4s4cWPDPoZG2vu3k+HEKwgOy56zvaWx/4G/m
e4LCOZUwW5pL4w5rX7hhEoVqD4027wqNwhsh0xfEFDQPl5+VV9GI608wzsmm
IO1hZbW00ljpV+BdKKNQUHIiJr2dRtu0xbi2nkJJstzbt4NGam7x+bAGCvXr
pPMdchqzw6Xdlo0U+kLWxCie0nj5Tc3Rq60UHIY3eA8N06iRtYjL/qTgKhNZ
lY7SEITusjbop7A1rVcTNU7DTvdxU/QAhd0OV269mqCRu/eJ4aYRCkmxbKuZ
GRqnJ/7Iq5yiINmWqrmjpOGRE/aZ8VsKaSuHfk9W0VB+OvAy9h2F/JqSC2o1
jZi0kY3OcxSup+gJfp6nYcsTtGdpKFQFRXlJFmj09ryKe6OlILN9ZOm5ROPy
V3Eme5coNCrtNcvLNILY07U1DEP8A2fK7Kc=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]], 
          Line[CompressedData["
1:eJwtxQ841HcAx/Hj0A9XsVYrfw8XOUf0257RyvcTevInlcrWg/44f84TMR7X
0+5uixZSD52t8KCp/Gl4onI8s0oLC+Eat/5siPm7RNJ13Dl/tj3P3s/zet42
/IT9UboMBsPnX/+d8aN5he5+NWH8X/yo47CsWkM6NZ1zIZIsYmRz1mHAnQGl
IOptnraOZJt0cK8dY8LJLOlKekYz4fcefMDsNMBY2XQtaeskib+e5Sc4GKHS
2mdy6E0Puf0l68B6v5UIcH7KS3F6Tq6JYydcvzBBTaB+eVFzLzlTvBD0ftIU
KR/dL283GCQMxSDuidbgcsDSdjV7iNgnR586yF0LluHFxLGYETKiyvvc+P46
zNp73XuYOUb8R49//V3ienjLfUrCXvxN9oxInayszLDsLu/iWrwmE838lLab
5nDWE60ec58iLqbPLL2PWqLxkHDq2LfTxIiowvuUVvgr3S8xUvGW7JoKmbMN
ZmOtPWOrWjtDXjRF6oTwbKDjICrdaK0kdedajrBVNuAcSitod3lPovWFg3K5
LbSBPx0JDFaRiCRxHavADkbJkupdMbNks8BJvjucg24t82qvcI48+YBnLPTY
CF/f2qN7C9TkbvWZQh7THpoWZaVHlYaIdbj7OvvtEWYQ1sJUzBOjPpFvvMwB
JysyTgtUWjJabnOpWLIJrRKfRzv0FsmlTRv0GoIdIf/QsVfruESkBdGt4Wwu
VvX/IOZtWyYhlw7LWeNcpDInj4g5DKh9yjTFjU54JrIQ7KtnYHjU61RTBg++
59fWHfPUwfXtbuZd4c4wkdhODHbr4Gaa0FTg7IJZfXVkUaguMoIjApgqFzSg
5lbpkC4+6btWkdG1GYrDomELIRP5joU3uwJcwVqzKuy3RSZO/5KVH9DgiqLK
urvKHD0EmgeXPea4YYXSczLCTh874ltDTTPdcFEh5a+u0kexBZ/TqXJDQu7s
A66nATjNN3L3hG5B/AwnIrXVAFLnJm5P4xb4LX78nLNnBaKVet3tXBqi14e2
uA+uAP/2O3bmRRrtiTsV6TEU4s4cWPDPoZG2vu3k+HEKwgOy56zvaWx/4G/m
e4LCOZUwW5pL4w5rX7hhEoVqD4027wqNwhsh0xfEFDQPl5+VV9GI608wzsmm
IO1hZbW00ljpV+BdKKNQUHIiJr2dRtu0xbi2nkJJstzbt4NGam7x+bAGCvXr
pPMdchqzw6Xdlo0U+kLWxCie0nj5Tc3Rq60UHIY3eA8N06iRtYjL/qTgKhNZ
lY7SEITusjbop7A1rVcTNU7DTvdxU/QAhd0OV269mqCRu/eJ4aYRCkmxbKuZ
GRqnJ/7Iq5yiINmWqrmjpOGRE/aZ8VsKaSuHfk9W0VB+OvAy9h2F/JqSC2o1
jZi0kY3OcxSup+gJfp6nYcsTtGdpKFQFRXlJFmj09ryKe6OlILN9ZOm5ROPy
V3Eme5coNCrtNcvLNILY07U1DEP8A2fK7Kc=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 0.8, 0.8], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYN/g7XM+k3HoOIcDveSluV9i7gM5Qs4
vPqb0LDx6E0oX8ShIPmm5p2lD6F8CQdbg9yUKYUvoHwZh5NnP5zwyIDZo+BQ
cykgnZ3vK5Sv5BAly/io5PNPKF/FwVeB61D7n39QvpqDzuEpx1/xMjlA+BoO
600uzPNbygLlazlsdPdWqnFih/J1HNwOpBmqPOGE8vUcSj2LO/w6eaB8Awev
zZqVfEb8UL6hg2ToxJOr3gpA+UYOc9MYcqc4C0H5xg7/EqMP684ShvJNHD55
LdcK+SjiAAADMU8X
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYN/g7XM+k3HoOIcDveSluV9i7gM5Qs4
vPqb0LDx6E0oX8ShIPmm5p2lD6F8CQdbg9yUKYUvoHwZh5NnP5zwyIDZo+BQ
cykgnZ3vK5Sv5BAly/io5PNPKF/FwVeB61D7n39QvpqDzuEpx1/xMjlA+BoO
600uzPNbygLlazlsdPdWqnFih/J1HNwOpBmqPOGE8vUcSj2LO/w6eaB8Awev
zZqVfEb8UL6hg2ToxJOr3gpA+UYOc9MYcqc4C0H5xg7/EqMP684ShvJNHD55
LdcK+SjiAAADMU8X
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 0.8, 0.8]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYN/g7XM+k3HoOIcDveSluV9i7gM5Qs4
vPqb0LDx6E0oX8ShIPmm5p2lD6F8CQdbg9yUKYUvoHwZh5NnP5zwyIDZo+BQ
cykgnZ3vK5Sv5BAly/io5PNPKF/FwVeB61D7n39QvpqDzuEpx1/xMjlA+BoO
600uzPNbygLlazlsdPdWqnFih/J1HNwOpBmqPOGE8vUcSj2LO/w6eaB8Awev
zZqVfEb8UL6hg2ToxJOr3gpA+UYOc9MYcqc4C0H5xg7/EqMP684ShvJNHD55
LdcK+SjiAAADMU8X
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 0.8, 0.8]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0.8, 0.8], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJw1jGkwnHcAh52prE117VtNXLPY7MY6gr8eMnh/sSpKEomzWalm3S2RJrFl
kFaIIEfrmlBqKCLtBKmWqESlSLHBRlyRonFtNGZQMTt20WzTD31mnnm+PRbh
p/yjtDQ0NFxf+V9vZzuPejkZQuN/hqfRlsIG+9tBrmf3XZqXGJ0cKHgTM6ZJ
jz9gDdLziuJg/V+NcKlIqNVSNE77yD89V3B6J57u5PvlL0zTh+fzbMzNjRGy
7FJjd0pOL3aFp/fWm6DpQj6/5vvntD1rzEz4sRlG7XLmvnFbphm0Qjy5Zo6V
vplnzh6r9IEl0bplEAchDL/k44Vr9HhnpKbI1gK2TOGhlicKujnnfhhHYQFJ
wjEXtXKdjtaVTMtkluCI7nVs89qgI86kNjNLreBee0C8GbdF742xkR0Uc9Hf
HOxplf2Sfmhoqy9x2Y2wG3+IdWM1cLcho8xWmwcDrkn9SrImUjUFR/qneDgb
ldndWqkFxmSKd0ITH1f0bp0369KGvNaiqCJtD6Yn4nrXH+mgaM8undYga8jP
HplqXNdFXml0j5gjANe1+9zs9tcgKvpIxlwQwDhafa/OSA9Kz+uqinYbdASe
GAzetx1zco/kzmxb1Jz1j0/yYaDKzdFkQGyHd0Lix5JO66M+S8KKsbOHdtxb
/csXmMgOivDVVtgjdzorQl2wA29PfvdD9sBetBmbSldaXkeJdVn9gK8D7LKE
d4KlBvjyt6slvq0O4IukbbLkN3DIJOj6A64jCqr8l9wZLOxP6All5TrCOLMm
YjGfhQrTcG6/whGb7zM6dHcbgtt149rhUCeoKt+LPN5giDy7TsFQuxOG67zH
1c5sRK/pPJIKCLaVxRN2DxvhjS84uV8TBFkcGxH7UYjPCNjyyScw6J1I6jxK
QRLQ9JhZSCBNCDOxCqSQo5B8lXeNwK0tInz+QwoNLqrN4nICXkjC39HhFFQd
6rHamwTrVzKZ8RIKeUPMq/d7CIqV9Z6fl1EorT4Ze1FKEFDh8NdYOYXqRJnQ
u4+A6fXz5XcrKdw2ytvokxGkF/4ypKyhMClixw6PEnxi33UitYECf26XcHaO
wCVyPC29g4JDU4p5jZxgjRHKmemisC9rQhW1QNDQONW1v5vCQX75j88XCSzU
swztPgpn4jjmq6sEjNKlkqwRCmmu51U/rRH8js9cn41RyNoxO5KoIPhi4cVT
rycUSm5VX1YqX/2dlTy9PylUpevE3NkgqJtIeRA7TeHm0SiPtC2CmIx/Tkpn
KTRZdpu5vyTgWKezBHIK7Ws8lVpNMPFQq/nSAoV/ASghquw=
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]], 
             Line[CompressedData["
1:eJw1jGkwnHcAh52prE117VtNXLPY7MY6gr8eMnh/sSpKEomzWalm3S2RJrFl
kFaIIEfrmlBqKCLtBKmWqESlSLHBRlyRonFtNGZQMTt20WzTD31mnnm+PRbh
p/yjtDQ0NFxf+V9vZzuPejkZQuN/hqfRlsIG+9tBrmf3XZqXGJ0cKHgTM6ZJ
jz9gDdLziuJg/V+NcKlIqNVSNE77yD89V3B6J57u5PvlL0zTh+fzbMzNjRGy
7FJjd0pOL3aFp/fWm6DpQj6/5vvntD1rzEz4sRlG7XLmvnFbphm0Qjy5Zo6V
vplnzh6r9IEl0bplEAchDL/k44Vr9HhnpKbI1gK2TOGhlicKujnnfhhHYQFJ
wjEXtXKdjtaVTMtkluCI7nVs89qgI86kNjNLreBee0C8GbdF742xkR0Uc9Hf
HOxplf2Sfmhoqy9x2Y2wG3+IdWM1cLcho8xWmwcDrkn9SrImUjUFR/qneDgb
ldndWqkFxmSKd0ITH1f0bp0369KGvNaiqCJtD6Yn4nrXH+mgaM8undYga8jP
HplqXNdFXml0j5gjANe1+9zs9tcgKvpIxlwQwDhafa/OSA9Kz+uqinYbdASe
GAzetx1zco/kzmxb1Jz1j0/yYaDKzdFkQGyHd0Lix5JO66M+S8KKsbOHdtxb
/csXmMgOivDVVtgjdzorQl2wA29PfvdD9sBetBmbSldaXkeJdVn9gK8D7LKE
d4KlBvjyt6slvq0O4IukbbLkN3DIJOj6A64jCqr8l9wZLOxP6All5TrCOLMm
YjGfhQrTcG6/whGb7zM6dHcbgtt149rhUCeoKt+LPN5giDy7TsFQuxOG67zH
1c5sRK/pPJIKCLaVxRN2DxvhjS84uV8TBFkcGxH7UYjPCNjyyScw6J1I6jxK
QRLQ9JhZSCBNCDOxCqSQo5B8lXeNwK0tInz+QwoNLqrN4nICXkjC39HhFFQd
6rHamwTrVzKZ8RIKeUPMq/d7CIqV9Z6fl1EorT4Ze1FKEFDh8NdYOYXqRJnQ
u4+A6fXz5XcrKdw2ytvokxGkF/4ypKyhMClixw6PEnxi33UitYECf26XcHaO
wCVyPC29g4JDU4p5jZxgjRHKmemisC9rQhW1QNDQONW1v5vCQX75j88XCSzU
swztPgpn4jjmq6sEjNKlkqwRCmmu51U/rRH8js9cn41RyNoxO5KoIPhi4cVT
rycUSm5VX1YqX/2dlTy9PylUpevE3NkgqJtIeRA7TeHm0SiPtC2CmIx/Tkpn
KTRZdpu5vyTgWKezBHIK7Ws8lVpNMPFQq/nSAoV/ASghquw=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0.8, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0.8, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]], 
          Line[CompressedData["
1:eJw1jGkwnHcAh52prE117VtNXLPY7MY6gr8eMnh/sSpKEomzWalm3S2RJrFl
kFaIIEfrmlBqKCLtBKmWqESlSLHBRlyRonFtNGZQMTt20WzTD31mnnm+PRbh
p/yjtDQ0NFxf+V9vZzuPejkZQuN/hqfRlsIG+9tBrmf3XZqXGJ0cKHgTM6ZJ
jz9gDdLziuJg/V+NcKlIqNVSNE77yD89V3B6J57u5PvlL0zTh+fzbMzNjRGy
7FJjd0pOL3aFp/fWm6DpQj6/5vvntD1rzEz4sRlG7XLmvnFbphm0Qjy5Zo6V
vplnzh6r9IEl0bplEAchDL/k44Vr9HhnpKbI1gK2TOGhlicKujnnfhhHYQFJ
wjEXtXKdjtaVTMtkluCI7nVs89qgI86kNjNLreBee0C8GbdF742xkR0Uc9Hf
HOxplf2Sfmhoqy9x2Y2wG3+IdWM1cLcho8xWmwcDrkn9SrImUjUFR/qneDgb
ldndWqkFxmSKd0ITH1f0bp0369KGvNaiqCJtD6Yn4nrXH+mgaM8undYga8jP
HplqXNdFXml0j5gjANe1+9zs9tcgKvpIxlwQwDhafa/OSA9Kz+uqinYbdASe
GAzetx1zco/kzmxb1Jz1j0/yYaDKzdFkQGyHd0Lix5JO66M+S8KKsbOHdtxb
/csXmMgOivDVVtgjdzorQl2wA29PfvdD9sBetBmbSldaXkeJdVn9gK8D7LKE
d4KlBvjyt6slvq0O4IukbbLkN3DIJOj6A64jCqr8l9wZLOxP6All5TrCOLMm
YjGfhQrTcG6/whGb7zM6dHcbgtt149rhUCeoKt+LPN5giDy7TsFQuxOG67zH
1c5sRK/pPJIKCLaVxRN2DxvhjS84uV8TBFkcGxH7UYjPCNjyyScw6J1I6jxK
QRLQ9JhZSCBNCDOxCqSQo5B8lXeNwK0tInz+QwoNLqrN4nICXkjC39HhFFQd
6rHamwTrVzKZ8RIKeUPMq/d7CIqV9Z6fl1EorT4Ze1FKEFDh8NdYOYXqRJnQ
u4+A6fXz5XcrKdw2ytvokxGkF/4ypKyhMClixw6PEnxi33UitYECf26XcHaO
wCVyPC29g4JDU4p5jZxgjRHKmemisC9rQhW1QNDQONW1v5vCQX75j88XCSzU
swztPgpn4jjmq6sEjNKlkqwRCmmu51U/rRH8js9cn41RyNoxO5KoIPhi4cVT
rycUSm5VX1YqX/2dlTy9PylUpevE3NkgqJtIeRA7TeHm0SiPtC2CmIx/Tkpn
KTRZdpu5vyTgWKezBHIK7Ws8lVpNMPFQq/nSAoV/ASghquw=
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 0.8, 0.8]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0, 1, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOUOy/YPh89BhXncIhn9nn1JOkylC/g
EKhcYqD0+iaUL+Lgy7uUc/K2R1C+hIPFzX15xblvoHwZB9noipDJlV+gfAWH
y0G7zFbW/IbylRyq5ff3xRcyOkD4Kg4/tkRu8XdghfLVHO62ClrMVOCE8jUc
rjD+nZzKwwvlazm03m7QEWoQgPJ1HCYENWw+UiME5es5KLhZPW6rFoHyDRzu
rz649n2NGJRv6HDs081Ev1oJKN/IgffXma9b6qWgfGMHk0cCVtebZKB8E4dL
KbnuE9vkHAD8ek+V
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOUOy/YPh89BhXncIhn9nn1JOkylC/g
EKhcYqD0+iaUL+Lgy7uUc/K2R1C+hIPFzX15xblvoHwZB9noipDJlV+gfAWH
y0G7zFbW/IbylRyq5ff3xRcyOkD4Kg4/tkRu8XdghfLVHO62ClrMVOCE8jUc
rjD+nZzKwwvlazm03m7QEWoQgPJ1HCYENWw+UiME5es5KLhZPW6rFoHyDRzu
rz649n2NGJRv6HDs081Ev1oJKN/IgffXma9b6qWgfGMHk0cCVtebZKB8E4dL
KbnuE9vkHAD8ek+V
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0, 1, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcOUOy/YPh89BhXncIhn9nn1JOkylC/g
EKhcYqD0+iaUL+Lgy7uUc/K2R1C+hIPFzX15xblvoHwZB9noipDJlV+gfAWH
y0G7zFbW/IbylRyq5ff3xRcyOkD4Kg4/tkRu8XdghfLVHO62ClrMVOCE8jUc
rjD+nZzKwwvlazm03m7QEWoQgPJ1HCYENWw+UiME5es5KLhZPW6rFoHyDRzu
rz649n2NGJRv6HDs081Ev1oJKN/IgffXma9b6qWgfGMHk0cCVtebZKB8E4dL
KbnuE9vkHAD8ek+V
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0, 1, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 1, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJw1kn1Q03UAh1HGebwUjpfBBvsJNAfyuvG1Dgj9fWRmHG/hy7oamQ0C7AU0
jxkCEVKInghLJhDyJogcGlgEpYQ7eZOAbRAIKaw7AuYQDxNhB1Neoj/63D33
/P/cxzX22IH4zSYmJsEb/OdbNzNV0ihbmPy/4Qm0pdmiNeh4kiqriOanJKQe
8rTH/MzJZZGfhp42FL9reYcFg3tyW7d2nA7TffrVxS8c8bc5XUjGpumoabkX
RXHAChu3qah9Qs92xmb93uCEQfE/T/Srz2hf5ihXdISL64dmAqqSFmkL2iDV
LlAQTCs82qqX6LfnJEtuYheo2m9lf+n8kn7Q8fEmibcrznfxO9Zz1uiWs10f
uhhcserFG5KNmSDBTDah0bjhTtnx1DcVmxF3Ir3FqvQ1DI+wnjUJGPBL9NJE
SHnIdI0d29pthgEbb0tZ4HYI7R6fUqZvwW+N2Ze9TfkIHuid5dqbI32TZ7Tq
Lz6ihY+2qgctYKFNC01udoehtq4+9lsr6K65KiozPLA42WF7nfMqFB5sxm3x
DqzcY5M9w9aQlyb0SF080RioY77161ZIFIc1VnpP8NnyTm0WE8t7a42VSi/w
VA/eKYuxwZQuJLUj1xuRcZquZndbVO8SOqmlPlhRS+0MDDs05MiYiT6+uO9c
HZE/bIdccVy4qcEXy4s7lZwKe7yuvVKfq/ZDVVW8xcApFkp2XG5QhwsgE4ho
7T4HfH33Qkn4bQHUhcoo5nZHRDqJa/t4QiRn5RUHrjtiT3JPDPOcEEH7t/S2
9rFR6RzLUxmEyDNsG4mr44DXWVcUFeMP80xdb7zMCXKfDs8hpT8GClaXJLQz
EhYYf/R6EnBkP5ukcriI/em5y7kCAvlu1vO5R1x8nn1wJew7gvoAiT5zlgvZ
weY/rQoJ2v0rtNZPuThrkOXLiwjm+PweoYG70c34sricIML6jTKZKQVj+/ro
tRsEZhPifavbKMiHrC509RCcPH2p1Op9CqU1SUfP9BIUpD8sKP+AQk2KRhTa
T3BVxs3x/YjCLyz5i34NwfAntceiEyloJbZHh0cIBAda9ipkFNyn2KLJKYIZ
t5GnThc3fticRl3VEaw7s6d/uEQhKGfcGK8ncHA4/HDX9xQi3Mt/fDxLILLU
dR6ponDiMxdqfp7gysJiSU0jhYzg08amBYLWuYD8nU0Ucl6ZvJ9iIBjQZ3zT
3UKh5GbN+eVlgrVxRrK+jUJ1FiOx9QWB/WhoXOpdCjf2x4dkrBB4D+a9Z95F
odntHnf3GkFI32BkaQ8F5QLfuL5OENNlJ/Lqp/Av4Wmt8A==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Line[CompressedData["
1:eJw1kn1Q03UAh1HGebwUjpfBBvsJNAfyuvG1Dgj9fWRmHG/hy7oamQ0C7AU0
jxkCEVKInghLJhDyJogcGlgEpYQ7eZOAbRAIKaw7AuYQDxNhB1Neoj/63D33
/P/cxzX22IH4zSYmJsEb/OdbNzNV0ihbmPy/4Qm0pdmiNeh4kiqriOanJKQe
8rTH/MzJZZGfhp42FL9reYcFg3tyW7d2nA7TffrVxS8c8bc5XUjGpumoabkX
RXHAChu3qah9Qs92xmb93uCEQfE/T/Srz2hf5ihXdISL64dmAqqSFmkL2iDV
LlAQTCs82qqX6LfnJEtuYheo2m9lf+n8kn7Q8fEmibcrznfxO9Zz1uiWs10f
uhhcserFG5KNmSDBTDah0bjhTtnx1DcVmxF3Ir3FqvQ1DI+wnjUJGPBL9NJE
SHnIdI0d29pthgEbb0tZ4HYI7R6fUqZvwW+N2Ze9TfkIHuid5dqbI32TZ7Tq
Lz6ihY+2qgctYKFNC01udoehtq4+9lsr6K65KiozPLA42WF7nfMqFB5sxm3x
DqzcY5M9w9aQlyb0SF080RioY77161ZIFIc1VnpP8NnyTm0WE8t7a42VSi/w
VA/eKYuxwZQuJLUj1xuRcZquZndbVO8SOqmlPlhRS+0MDDs05MiYiT6+uO9c
HZE/bIdccVy4qcEXy4s7lZwKe7yuvVKfq/ZDVVW8xcApFkp2XG5QhwsgE4ho
7T4HfH33Qkn4bQHUhcoo5nZHRDqJa/t4QiRn5RUHrjtiT3JPDPOcEEH7t/S2
9rFR6RzLUxmEyDNsG4mr44DXWVcUFeMP80xdb7zMCXKfDs8hpT8GClaXJLQz
EhYYf/R6EnBkP5ukcriI/em5y7kCAvlu1vO5R1x8nn1wJew7gvoAiT5zlgvZ
weY/rQoJ2v0rtNZPuThrkOXLiwjm+PweoYG70c34sricIML6jTKZKQVj+/ro
tRsEZhPifavbKMiHrC509RCcPH2p1Op9CqU1SUfP9BIUpD8sKP+AQk2KRhTa
T3BVxs3x/YjCLyz5i34NwfAntceiEyloJbZHh0cIBAda9ipkFNyn2KLJKYIZ
t5GnThc3fticRl3VEaw7s6d/uEQhKGfcGK8ncHA4/HDX9xQi3Mt/fDxLILLU
dR6ponDiMxdqfp7gysJiSU0jhYzg08amBYLWuYD8nU0Ucl6ZvJ9iIBjQZ3zT
3UKh5GbN+eVlgrVxRrK+jUJ1FiOx9QWB/WhoXOpdCjf2x4dkrBB4D+a9Z95F
odntHnf3GkFI32BkaQ8F5QLfuL5OENNlJ/Lqp/Av4Wmt8A==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 1, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJw1kn1Q03UAh1HGebwUjpfBBvsJNAfyuvG1Dgj9fWRmHG/hy7oamQ0C7AU0
jxkCEVKInghLJhDyJogcGlgEpYQ7eZOAbRAIKaw7AuYQDxNhB1Neoj/63D33
/P/cxzX22IH4zSYmJsEb/OdbNzNV0ihbmPy/4Qm0pdmiNeh4kiqriOanJKQe
8rTH/MzJZZGfhp42FL9reYcFg3tyW7d2nA7TffrVxS8c8bc5XUjGpumoabkX
RXHAChu3qah9Qs92xmb93uCEQfE/T/Srz2hf5ihXdISL64dmAqqSFmkL2iDV
LlAQTCs82qqX6LfnJEtuYheo2m9lf+n8kn7Q8fEmibcrznfxO9Zz1uiWs10f
uhhcserFG5KNmSDBTDah0bjhTtnx1DcVmxF3Ir3FqvQ1DI+wnjUJGPBL9NJE
SHnIdI0d29pthgEbb0tZ4HYI7R6fUqZvwW+N2Ze9TfkIHuid5dqbI32TZ7Tq
Lz6ihY+2qgctYKFNC01udoehtq4+9lsr6K65KiozPLA42WF7nfMqFB5sxm3x
DqzcY5M9w9aQlyb0SF080RioY77161ZIFIc1VnpP8NnyTm0WE8t7a42VSi/w
VA/eKYuxwZQuJLUj1xuRcZquZndbVO8SOqmlPlhRS+0MDDs05MiYiT6+uO9c
HZE/bIdccVy4qcEXy4s7lZwKe7yuvVKfq/ZDVVW8xcApFkp2XG5QhwsgE4ho
7T4HfH33Qkn4bQHUhcoo5nZHRDqJa/t4QiRn5RUHrjtiT3JPDPOcEEH7t/S2
9rFR6RzLUxmEyDNsG4mr44DXWVcUFeMP80xdb7zMCXKfDs8hpT8GClaXJLQz
EhYYf/R6EnBkP5ukcriI/em5y7kCAvlu1vO5R1x8nn1wJew7gvoAiT5zlgvZ
weY/rQoJ2v0rtNZPuThrkOXLiwjm+PweoYG70c34sricIML6jTKZKQVj+/ro
tRsEZhPifavbKMiHrC509RCcPH2p1Op9CqU1SUfP9BIUpD8sKP+AQk2KRhTa
T3BVxs3x/YjCLyz5i34NwfAntceiEyloJbZHh0cIBAda9ipkFNyn2KLJKYIZ
t5GnThc3fticRl3VEaw7s6d/uEQhKGfcGK8ncHA4/HDX9xQi3Mt/fDxLILLU
dR6ponDiMxdqfp7gysJiSU0jhYzg08amBYLWuYD8nU0Ucl6ZvJ9iIBjQZ3zT
3UKh5GbN+eVlgrVxRrK+jUJ1FiOx9QWB/WhoXOpdCjf2x4dkrBB4D+a9Z95F
odntHnf3GkFI32BkaQ8F5QLfuL5OENNlJ/Lqp/Av4Wmt8A==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0, 1, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0.6, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPZQzeHiEfHoOIcDp+v5XzpKLwM5Qs4
rDsbz35Z6RaUL+JQttLdfdKPJ1C+hMNp/ciNveUfoXwZh+uHHCYHef2C8hUc
GOW5vx/4zegA4Ss5qB2xttBgZ4fyVRyq/njXLNTngfLVHI4J3BV9sEUAytdw
OM55affycGEoX8vh1Ko3s0P/iUL5Og6/k2/cOLFcAsrXc9AIS/3lGiwN5Rs4
KOiEfn7JJAflGzo8aGaZ5RKuAOUbOcQzs0fdXqcI5Rs7fFk76chlNmUo38Th
g7P8O+l4FQcAVDVP2A==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPZQzeHiEfHoOIcDp+v5XzpKLwM5Qs4
rDsbz35Z6RaUL+JQttLdfdKPJ1C+hMNp/ciNveUfoXwZh+uHHCYHef2C8hUc
GOW5vx/4zegA4Ss5qB2xttBgZ4fyVRyq/njXLNTngfLVHI4J3BV9sEUAytdw
OM55affycGEoX8vh1Ko3s0P/iUL5Og6/k2/cOLFcAsrXc9AIS/3lGiwN5Rs4
KOiEfn7JJAflGzo8aGaZ5RKuAOUbOcQzs0fdXqcI5Rs7fFk76chlNmUo38Th
g7P8O+l4FQcAVDVP2A==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0.6, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYPZQzeHiEfHoOIcDp+v5XzpKLwM5Qs4
rDsbz35Z6RaUL+JQttLdfdKPJ1C+hMNp/ciNveUfoXwZh+uHHCYHef2C8hUc
GOW5vx/4zegA4Ss5qB2xttBgZ4fyVRyq/njXLNTngfLVHI4J3BV9sEUAytdw
OM55affycGEoX8vh1Ko3s0P/iUL5Og6/k2/cOLFcAsrXc9AIS/3lGiwN5Rs4
KOiEfn7JJAflGzo8aGaZ5RKuAOUbOcQzs0fdXqcI5Rs7fFk76chlNmUo38Th
g7P8O+l4FQcAVDVP2A==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0.6, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0.6, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJw1jH0w23cAh1Oiq5e01cxbQuTlO2+Jl/id7Tjks+iuHapK7a6x0cS8nKHH
ydbzVrUptrWN1mG0c6rqVtPWLnSis3mpd0qLveCm1ehY1xcRpGxmf+y5e+75
7+EpTkTEG9FoNP9t/+sCd111RsgE7X8ezOFOFhOrEqMIzeB1iVNmwsmjblbQ
UL0L/ZWTksf6ivfMf7BGYann1+OH5yXB2uTcC+m20Hj4+QV8/lQS9lgl5HBY
mHzquawZXpYsdSvy+5vYEH9apBTvXJN4WE45BMU6IEqUJ3au3pCYSfTyGR0H
75e3sdcebkkO/CVb40dxUW4a7CiQGuGXrg93yEQ8pJgHruQW09FS3BPD1fOg
Tj06d7dhJxJMlHOjo3zEHtMkjazsQlxGdotFlQB59dJdXSxzeCYKR0PlBKYt
R/5c9GHg3j6RudL3DWweupU8nrcH7TcKqkXGTrhZV0mLHNuL7B1u4cOzTtin
pbEc1i1hNpN1ME3tDGGxaDKfxYT2Gq+sJscFp6IX2dGur6PMxY7eFuWKQt2I
l9VhK6iqEvrkXDd0tweNvyO3hqzsg1GLJ25o0+Yw96bZYH1/vaGmQwj5xKxA
U2qLea30ZFeRCPt19378rdYOVwLE7BG5O6amFl2n+1loKlRaJrp74OpSmWPE
DBtFUXEhxnoPuBw3vq1YsofPTO03RSOeiKn6yj5yDweVrtVNIyFeGKJ3MjRc
R5z66WxlSJsXVu2KE/IJF4fYUfWDRAyFwrLiRQsXb6f1RVuWiLEojWNcCuCh
xl5BhvViDJoMJN8e44F0N5SHRXuj//gaY7eMD5V7l9v9Dm/UpbxW0DzHR4KO
Pj7gRmFSJpztyRBA0bzMLTlPgTy0yWNuCJBSELkZXErh96IqXubfAigj1T9b
XKRQ6eFwd2JLgGK98pyqnAIjh29RTie44WvYqLhMYdXavcp2N4Ghc2vqWiOF
3lBpqwOPQHXf4mxPH4XE71OeOR8gqKpLTTozQIEf+7y0+F2CuszRoINDFKZN
MnwWQwharVWvhkYphEd+knM9nGBGxkx6MEnB99lpM3cZgfO8XdCjeQqmpMLJ
O5XAS53Fuaql0DVoN3jhBIFf4bQh/gmF3PRLqbp0glDny7cWlyi86KhVqz8m
yPiIy3n5ksKvx76VvpVPkON/2vCdjkIZzXOhooCgkPFoIlNPIayhuWT9M4LK
m3VfrK9v/1dax9pKCK7k0xM1r7b/1b6ZrC8JGo/ES3M2KbwpvWOTfY5Aze91
CPyHwvM/AtunVQQdOifD1haFxvOdMf4XCf4Ff/mhHQ==
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]], 
             Line[CompressedData["
1:eJw1jH0w23cAh1Oiq5e01cxbQuTlO2+Jl/id7Tjks+iuHapK7a6x0cS8nKHH
ydbzVrUptrWN1mG0c6rqVtPWLnSis3mpd0qLveCm1ehY1xcRpGxmf+y5e+75
7+EpTkTEG9FoNP9t/+sCd111RsgE7X8ezOFOFhOrEqMIzeB1iVNmwsmjblbQ
UL0L/ZWTksf6ivfMf7BGYann1+OH5yXB2uTcC+m20Hj4+QV8/lQS9lgl5HBY
mHzquawZXpYsdSvy+5vYEH9apBTvXJN4WE45BMU6IEqUJ3au3pCYSfTyGR0H
75e3sdcebkkO/CVb40dxUW4a7CiQGuGXrg93yEQ8pJgHruQW09FS3BPD1fOg
Tj06d7dhJxJMlHOjo3zEHtMkjazsQlxGdotFlQB59dJdXSxzeCYKR0PlBKYt
R/5c9GHg3j6RudL3DWweupU8nrcH7TcKqkXGTrhZV0mLHNuL7B1u4cOzTtin
pbEc1i1hNpN1ME3tDGGxaDKfxYT2Gq+sJscFp6IX2dGur6PMxY7eFuWKQt2I
l9VhK6iqEvrkXDd0tweNvyO3hqzsg1GLJ25o0+Yw96bZYH1/vaGmQwj5xKxA
U2qLea30ZFeRCPt19378rdYOVwLE7BG5O6amFl2n+1loKlRaJrp74OpSmWPE
DBtFUXEhxnoPuBw3vq1YsofPTO03RSOeiKn6yj5yDweVrtVNIyFeGKJ3MjRc
R5z66WxlSJsXVu2KE/IJF4fYUfWDRAyFwrLiRQsXb6f1RVuWiLEojWNcCuCh
xl5BhvViDJoMJN8e44F0N5SHRXuj//gaY7eMD5V7l9v9Dm/UpbxW0DzHR4KO
Pj7gRmFSJpztyRBA0bzMLTlPgTy0yWNuCJBSELkZXErh96IqXubfAigj1T9b
XKRQ6eFwd2JLgGK98pyqnAIjh29RTie44WvYqLhMYdXavcp2N4Ghc2vqWiOF
3lBpqwOPQHXf4mxPH4XE71OeOR8gqKpLTTozQIEf+7y0+F2CuszRoINDFKZN
MnwWQwharVWvhkYphEd+knM9nGBGxkx6MEnB99lpM3cZgfO8XdCjeQqmpMLJ
O5XAS53Fuaql0DVoN3jhBIFf4bQh/gmF3PRLqbp0glDny7cWlyi86KhVqz8m
yPiIy3n5ksKvx76VvpVPkON/2vCdjkIZzXOhooCgkPFoIlNPIayhuWT9M4LK
m3VfrK9v/1dax9pKCK7k0xM1r7b/1b6ZrC8JGo/ES3M2KbwpvWOTfY5Aze91
CPyHwvM/AtunVQQdOifD1haFxvOdMf4XCf4Ff/mhHQ==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0.6, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0.6, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]], 
          Line[CompressedData["
1:eJw1jH0w23cAh1Oiq5e01cxbQuTlO2+Jl/id7Tjks+iuHapK7a6x0cS8nKHH
ydbzVrUptrWN1mG0c6rqVtPWLnSis3mpd0qLveCm1ehY1xcRpGxmf+y5e+75
7+EpTkTEG9FoNP9t/+sCd111RsgE7X8ezOFOFhOrEqMIzeB1iVNmwsmjblbQ
UL0L/ZWTksf6ivfMf7BGYann1+OH5yXB2uTcC+m20Hj4+QV8/lQS9lgl5HBY
mHzquawZXpYsdSvy+5vYEH9apBTvXJN4WE45BMU6IEqUJ3au3pCYSfTyGR0H
75e3sdcebkkO/CVb40dxUW4a7CiQGuGXrg93yEQ8pJgHruQW09FS3BPD1fOg
Tj06d7dhJxJMlHOjo3zEHtMkjazsQlxGdotFlQB59dJdXSxzeCYKR0PlBKYt
R/5c9GHg3j6RudL3DWweupU8nrcH7TcKqkXGTrhZV0mLHNuL7B1u4cOzTtin
pbEc1i1hNpN1ME3tDGGxaDKfxYT2Gq+sJscFp6IX2dGur6PMxY7eFuWKQt2I
l9VhK6iqEvrkXDd0tweNvyO3hqzsg1GLJ25o0+Yw96bZYH1/vaGmQwj5xKxA
U2qLea30ZFeRCPt19378rdYOVwLE7BG5O6amFl2n+1loKlRaJrp74OpSmWPE
DBtFUXEhxnoPuBw3vq1YsofPTO03RSOeiKn6yj5yDweVrtVNIyFeGKJ3MjRc
R5z66WxlSJsXVu2KE/IJF4fYUfWDRAyFwrLiRQsXb6f1RVuWiLEojWNcCuCh
xl5BhvViDJoMJN8e44F0N5SHRXuj//gaY7eMD5V7l9v9Dm/UpbxW0DzHR4KO
Pj7gRmFSJpztyRBA0bzMLTlPgTy0yWNuCJBSELkZXErh96IqXubfAigj1T9b
XKRQ6eFwd2JLgGK98pyqnAIjh29RTie44WvYqLhMYdXavcp2N4Ghc2vqWiOF
3lBpqwOPQHXf4mxPH4XE71OeOR8gqKpLTTozQIEf+7y0+F2CuszRoINDFKZN
MnwWQwharVWvhkYphEd+knM9nGBGxkx6MEnB99lpM3cZgfO8XdCjeQqmpMLJ
O5XAS53Fuaql0DVoN3jhBIFf4bQh/gmF3PRLqbp0glDny7cWlyi86KhVqz8m
yPiIy3n5ksKvx76VvpVPkON/2vCdjkIZzXOhooCgkPFoIlNPIayhuWT9M4LK
m3VfrK9v/1dax9pKCK7k0xM1r7b/1b6ZrC8JGo/ES3M2KbwpvWOTfY5Aze91
CPyHwvM/AtunVQQdOifD1haFxvOdMf4XCf4Ff/mhHQ==
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0.6, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.8, 0, 0], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYOBWc8vTZ7jUHEOh98K+g5S7ZehfAGH
Nwoxa96X3oLyRRzCnD5JBcq+gPIlHK5msenYLfoK5cs4ME0pkdg5n8EBwldw
YK5dYDb1OhuUr+RgwqJi9cCBF8pXcXCyF3yx6ZEglK/m8K9w8mJnXVEoX8NB
cNUsG5daCShfy6EoM96H7aI0lK/j4Pp648MadXkoX8+BITq677e9IpRv4LAw
aMvLM++VoHxDh4bs4zmzZqlA+UYOCVtmXdrooQblGzss7RZu0vmuDuWbODCU
1OcLLtN0AADfE0ic
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYOBWc8vTZ7jUHEOh98K+g5S7ZehfAGH
Nwoxa96X3oLyRRzCnD5JBcq+gPIlHK5msenYLfoK5cs4ME0pkdg5n8EBwldw
YK5dYDb1OhuUr+RgwqJi9cCBF8pXcXCyF3yx6ZEglK/m8K9w8mJnXVEoX8NB
cNUsG5daCShfy6EoM96H7aI0lK/j4Pp648MadXkoX8+BITq677e9IpRv4LAw
aMvLM++VoHxDh4bs4zmzZqlA+UYOCVtmXdrooQblGzss7RZu0vmuDuWbODCU
1OcLLtN0AADfE0ic
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.8, 0, 0]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgYOBWc8vTZ7jUHEOh98K+g5S7ZehfAGH
Nwoxa96X3oLyRRzCnD5JBcq+gPIlHK5msenYLfoK5cs4ME0pkdg5n8EBwldw
YK5dYDb1OhuUr+RgwqJi9cCBF8pXcXCyF3yx6ZEglK/m8K9w8mJnXVEoX8NB
cNUsG5daCShfy6EoM96H7aI0lK/j4Pp648MadXkoX8+BITq677e9IpRv4LAw
aMvLM++VoHxDh4bs4zmzZqlA+UYOCVtmXdrooQblGzss7RZu0vmuDuWbODCU
1OcLLtN0AADfE0ic
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.8, 0, 0]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.8, 0, 0], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJw1kH04FHYAxxlrjYs5j5O3647j/M4Rfk/P0tJ9i8eM0pA9i6ZhDvPSo8eZ
pMJCUpwyPGQWqfUYOtRisbxE4m5RrIfb8pIR26jbPd0VWftjn+f5PJ//P9zI
Q0HRb+no6Gx/43/dtLjqU3yfCZ3/eTCJW+mmiDPuuVu50iVySBGn7ROYIfzv
9fOV8seiJ+qyTww7WOhinIxjFSyI/Ga/PHYueSNqv/dNNTJQiQKeSJ3YbEuk
0u8mi1s0ooWeyMy7DVaIb5Lri1+tilxMxmy8DtogXneqbGhcFwYidYRSxYbM
zue0UZ4+Pvwr9IVtCAfNMiOdzIR38Kj7C91QIRerLaLTyd4GuH6qN5yj5mKs
MSy5YJEB8duSSYXCFolmExMPB40RdfjodUaFHT5qrwms9TTB5hgnxe4IHnR5
Z0QXCpn4hSk0lHjYo8yLvyRcMcVPjdmVQj0HSB6/Lw8MNMNRXcHHQ785wM3t
ZYJRDwsGynTfpFY+mB3LLEOXjZi9zC2pznDEtjsHliozLVDiaKHfFkKw8+v0
/N4lS0grxP0RHAGKOjYEZflYI7TkMwVjTgBd91He8VIbaLzrtNWdTgg+ENDG
1NuEmdldad15QnyVxe6scuKgxtPNSh7hjJamJJ3XMxw05EhMYpxdYHpBu99R
ykVeSJS/ntoFuXXf3ny+1RZblBev5sk3Yy7fWrN+2RblpLJB7u+KROFowNM3
H07cPlvu3+aK6aviXLN9POyxCqm7x3NDrDezZ+pde+xM6g8zyXcDs0rDSmux
R7V1JG9I7Yb6+z/6h8Y7gNdzpTQgzB1x3bKydeZ8SJ27BSOd7vAYvjMf9DMf
YpX+8ICAQtPebLkocUSk7Dknv4hiInI8ag+HICE7eMWvmMK7xdPVx45AEtz6
K+M8xQ96F1d2OBCcUksKpaUUxy/FfOMqJGj00L4qq6Lg/PFPn+lWAm3X2tjl
eoroOGPB+F4C6QjjbG8/xdIh72XxCYKK2sTY3AGK/bev3DqYTVCbovDyHaTo
es8w/9Mcghss6ctBBcU52TDXr4BAGWoa+2CUYosqPNi5jIA/Y+E1PUNxJPXI
DVUjgWtrOvvSLMVUnzL7TxnBtpwJbfQchZ859s62EuzmV117ukBheXPd/Fg7
weF4DvvZM4pO7XmL9j6CjO1Z2mYVBd/vxWzzAEHOhumHKWqKoorQ5vohgvKm
2gKNhuLzD7j+VSMENZn6Me0vKe4VnDQvHSWoD4zelbFC4a6cmyl8RNBq22ez
4zVFhdD/Wt4EQafKQbu2RqF3rDEj83eCfwH/ZqZf
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]], 
             Line[CompressedData["
1:eJw1kH04FHYAxxlrjYs5j5O3647j/M4Rfk/P0tJ9i8eM0pA9i6ZhDvPSo8eZ
pMJCUpwyPGQWqfUYOtRisbxE4m5RrIfb8pIR26jbPd0VWftjn+f5PJ//P9zI
Q0HRb+no6Gx/43/dtLjqU3yfCZ3/eTCJW+mmiDPuuVu50iVySBGn7ROYIfzv
9fOV8seiJ+qyTww7WOhinIxjFSyI/Ga/PHYueSNqv/dNNTJQiQKeSJ3YbEuk
0u8mi1s0ooWeyMy7DVaIb5Lri1+tilxMxmy8DtogXneqbGhcFwYidYRSxYbM
zue0UZ4+Pvwr9IVtCAfNMiOdzIR38Kj7C91QIRerLaLTyd4GuH6qN5yj5mKs
MSy5YJEB8duSSYXCFolmExMPB40RdfjodUaFHT5qrwms9TTB5hgnxe4IHnR5
Z0QXCpn4hSk0lHjYo8yLvyRcMcVPjdmVQj0HSB6/Lw8MNMNRXcHHQ785wM3t
ZYJRDwsGynTfpFY+mB3LLEOXjZi9zC2pznDEtjsHliozLVDiaKHfFkKw8+v0
/N4lS0grxP0RHAGKOjYEZflYI7TkMwVjTgBd91He8VIbaLzrtNWdTgg+ENDG
1NuEmdldad15QnyVxe6scuKgxtPNSh7hjJamJJ3XMxw05EhMYpxdYHpBu99R
ykVeSJS/ntoFuXXf3ny+1RZblBev5sk3Yy7fWrN+2RblpLJB7u+KROFowNM3
H07cPlvu3+aK6aviXLN9POyxCqm7x3NDrDezZ+pde+xM6g8zyXcDs0rDSmux
R7V1JG9I7Yb6+z/6h8Y7gNdzpTQgzB1x3bKydeZ8SJ27BSOd7vAYvjMf9DMf
YpX+8ICAQtPebLkocUSk7Dknv4hiInI8ag+HICE7eMWvmMK7xdPVx45AEtz6
K+M8xQ96F1d2OBCcUksKpaUUxy/FfOMqJGj00L4qq6Lg/PFPn+lWAm3X2tjl
eoroOGPB+F4C6QjjbG8/xdIh72XxCYKK2sTY3AGK/bev3DqYTVCbovDyHaTo
es8w/9Mcghss6ctBBcU52TDXr4BAGWoa+2CUYosqPNi5jIA/Y+E1PUNxJPXI
DVUjgWtrOvvSLMVUnzL7TxnBtpwJbfQchZ859s62EuzmV117ukBheXPd/Fg7
weF4DvvZM4pO7XmL9j6CjO1Z2mYVBd/vxWzzAEHOhumHKWqKoorQ5vohgvKm
2gKNhuLzD7j+VSMENZn6Me0vKe4VnDQvHSWoD4zelbFC4a6cmyl8RNBq22ez
4zVFhdD/Wt4EQafKQbu2RqF3rDEj83eCfwH/ZqZf
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.8, 0, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 15.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.8, 0, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]], 
          Line[CompressedData["
1:eJw1kH04FHYAxxlrjYs5j5O3647j/M4Rfk/P0tJ9i8eM0pA9i6ZhDvPSo8eZ
pMJCUpwyPGQWqfUYOtRisbxE4m5RrIfb8pIR26jbPd0VWftjn+f5PJ//P9zI
Q0HRb+no6Gx/43/dtLjqU3yfCZ3/eTCJW+mmiDPuuVu50iVySBGn7ROYIfzv
9fOV8seiJ+qyTww7WOhinIxjFSyI/Ga/PHYueSNqv/dNNTJQiQKeSJ3YbEuk
0u8mi1s0ooWeyMy7DVaIb5Lri1+tilxMxmy8DtogXneqbGhcFwYidYRSxYbM
zue0UZ4+Pvwr9IVtCAfNMiOdzIR38Kj7C91QIRerLaLTyd4GuH6qN5yj5mKs
MSy5YJEB8duSSYXCFolmExMPB40RdfjodUaFHT5qrwms9TTB5hgnxe4IHnR5
Z0QXCpn4hSk0lHjYo8yLvyRcMcVPjdmVQj0HSB6/Lw8MNMNRXcHHQ785wM3t
ZYJRDwsGynTfpFY+mB3LLEOXjZi9zC2pznDEtjsHliozLVDiaKHfFkKw8+v0
/N4lS0grxP0RHAGKOjYEZflYI7TkMwVjTgBd91He8VIbaLzrtNWdTgg+ENDG
1NuEmdldad15QnyVxe6scuKgxtPNSh7hjJamJJ3XMxw05EhMYpxdYHpBu99R
ykVeSJS/ntoFuXXf3ny+1RZblBev5sk3Yy7fWrN+2RblpLJB7u+KROFowNM3
H07cPlvu3+aK6aviXLN9POyxCqm7x3NDrDezZ+pde+xM6g8zyXcDs0rDSmux
R7V1JG9I7Yb6+z/6h8Y7gNdzpTQgzB1x3bKydeZ8SJ27BSOd7vAYvjMf9DMf
YpX+8ICAQtPebLkocUSk7Dknv4hiInI8ag+HICE7eMWvmMK7xdPVx45AEtz6
K+M8xQ96F1d2OBCcUksKpaUUxy/FfOMqJGj00L4qq6Lg/PFPn+lWAm3X2tjl
eoroOGPB+F4C6QjjbG8/xdIh72XxCYKK2sTY3AGK/bev3DqYTVCbovDyHaTo
es8w/9Mcghss6ctBBcU52TDXr4BAGWoa+2CUYosqPNi5jIA/Y+E1PUNxJPXI
DVUjgWtrOvvSLMVUnzL7TxnBtpwJbfQchZ859s62EuzmV117ukBheXPd/Fg7
weF4DvvZM4pO7XmL9j6CjO1Z2mYVBd/vxWzzAEHOhumHKWqKoorQ5vohgvKm
2gKNhuLzD7j+VSMENZn6Me0vKe4VnDQvHSWoD4zelbFC4a6cmyl8RNBq22ez
4zVFhdD/Wt4EQafKQbu2RqF3rDEj83eCfwH/ZqZf
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 15.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.8, 0, 0]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[0.6, 0, 0.6], PointSize[0.012833333333333334`], 
         AbsoluteThickness[2], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcM2JZHydZ7HoeIcDjZCjxyvL7sM5Qs4
hFUtze36dAvKF3E4bbZ+9gSRN1C+hEOyhrJWcP0vKF/G4ffZtOil1SwOEL6C
A5fVnCPZYjxQvpLDTuXPenzvBaF8FQfL4EcWdfdFoXw1h57q1Il7rktC+RoO
Crce+WtdlYXytRxU066xy7xWgPJ1HL441ft8eaME5es5yL4Q2nbyvQqUb+Bw
IHS+xZ8falC+ocNxg9+OE75rQPlGDouUmX92/9GC8o0dru7qOVL5RwfKN3GI
mOjwsf6DngMA9XNRVA==
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{
           Annotation[{
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcM2JZHydZ7HoeIcDjZCjxyvL7sM5Qs4
hFUtze36dAvKF3E4bbZ+9gSRN1C+hEOyhrJWcP0vKF/G4ffZtOil1SwOEL6C
A5fVnCPZYjxQvpLDTuXPenzvBaF8FQfL4EcWdfdFoXw1h57q1Il7rktC+RoO
Crce+WtdlYXytRxU066xy7xWgPJ1HL441ft8eaME5es5yL4Q2nbyvQqUb+Bw
IHS+xZ8falC+ocNxg9+OE75rQPlGDouUmX92/9GC8o0dru7qOVL5RwfKN3GI
mOjwsf6DngMA9XNRVA==
              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               PointSize[0.012833333333333334`], 
               AbsoluteThickness[2], 
               RGBColor[0.6, 0, 0.6]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListPlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              PointSize[0.012833333333333334`], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListPlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}]},
     Annotation[{{
        Annotation[{
          Directive[
           PointSize[0.012833333333333334`], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          Point[CompressedData["
1:eJxTTMoPSmViYGAQAWIQDQEf7BlQgcM2JZHydZ7HoeIcDjZCjxyvL7sM5Qs4
hFUtze36dAvKF3E4bbZ+9gSRN1C+hEOyhrJWcP0vKF/G4ffZtOil1SwOEL6C
A5fVnCPZYjxQvpLDTuXPenzvBaF8FQfL4EcWdfdFoXw1h57q1Il7rktC+RoO
Crce+WtdlYXytRxU066xy7xWgPJ1HL441ft8eaME5es5yL4Q2nbyvQqUb+Bw
IHS+xZ8falC+ocNxg9+OE75rQPlGDouUmX92/9GC8o0dru7qOVL5RwfKN3GI
mOjwsf6DngMA9XNRVA==
           "]]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PlotRange" -> {{0., 21.}, {-1., 15.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[2], 
            RGBColor[0.6, 0, 0.6]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, 
   InterpretationBox[{
     TagBox[{{{}, {}, 
        TagBox[
         {RGBColor[0.6, 0, 0.6], AbsoluteThickness[2], Opacity[1.], 
          LineBox[CompressedData["
1:eJw1xX1Q03UAx/ExiVSgmDwIEmubY4ON/X6Mr2QKso+iiWCYAXGMhBs2IJSh
sBUHqMQdAnniLASCQ3IggR5QHugRSgQUImwSBHQFyPHkyWUXrenGg6v+6H33
ujc3KeNdJZPBYAT/67+v99sws05tAeP/RmdwN8cZEdWjVyPmhmUCdXJ2tMgV
mSEG2yDuomzeVPGe/T03PM/OT6KzlmXhC2lnPjvtjmlV8VZGolkWOa8Vs9nb
wGrlV6SJrLKl3qT8+82eOLLRhYrsZoJijXuFJnrB92XHXDt/O2yWmRSTRjZa
yzvSeMpNOPhU/pwXw0GYeqpvatoBv/R8YCP346Kw05tJ+E5oL+5L4Ji4CCp8
w9jYyULyS5oZg4GHdVPBFyqNM45n5rY7VG2HM+3LWmS5gk4RGw4r+LiXo14N
bXDDwy1+9ppd3jidvlq1/L47OlsKqv02CJDrM2l/9JkHcm1E7wxNCVD6qVnK
uOWJzZM5Yao2IQKtHQ+uKL2w0MAtq83zQUDw2I6pVTbKfDxsO2J84eXkJtot
50Bbldyv4IgQmazSTQu5kJcdMzg8FuGHAx7RHy1zYd5/3VLbJUavWTETOMTD
3MK+7J4iP/x+KTYmsnI7dHuknnqFBNUrS/WlGj6aCzWsFAmFrEPiKeF+bxTF
HI/YYKJQwe2KbHtFgMDJa01Fehoy/R9VqUsCVPpWN+sj/OFybOih5o4Q57ov
VkZ0+ONk98FHN6744G3PmOsP+FI4Nrv6jGb4Yq+qP55VIsWvZ7Rx0UEi1L6W
xB8ySSHmNSnXt4rB7/2qPDI+AI03VHLrghhaSY9opCsAGXfPF//d6odko+1P
AyKCzmvBl1kXJEj65i9OySUC6YnagqJYCicLotbCLxOEK+c+do+noIlqm3D4
nECRKExvSqBQbNKUassJtFGtsYNKCi27LKsVNQRPg77ze1VNwfK9dbzhJkG9
w6Pxci0F7YjDxb5+ArcWtrhhgEJVXXrq+QECujGJs1NPoU5tCA0bJDiga3C9
P0zhtpt2ZdBAkFVOMZYmKEzKnVNHxwiGz4aMSRYpCOc8QmfnCEqOJJxrZ9Lw
b8th1y8QfHlIp37Ljsbuwt8syscEd0IXP5zYROOwsObrJ0sE8ztV0RYnGpkn
OOzlZYK9nLO+e16nkRf8ieWWkSBuWw/bwKNR6Dj7s9pEcMrFziVRQKOyte6C
2UxwdWPpi3wJDV2+bcq3KwS3mSNGlpTGzaPKfXlrBPo11ye6HTTaeD96hbwg
mH0WN03epNFlFFisVoLVP2tG+4Jo/AMEWJpc
           "]]},
         Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]], 
             Line[CompressedData["
1:eJw1xX1Q03UAx/ExiVSgmDwIEmubY4ON/X6Mr2QKso+iiWCYAXGMhBs2IJSh
sBUHqMQdAnniLASCQ3IggR5QHugRSgQUImwSBHQFyPHkyWUXrenGg6v+6H33
ujc3KeNdJZPBYAT/67+v99sws05tAeP/RmdwN8cZEdWjVyPmhmUCdXJ2tMgV
mSEG2yDuomzeVPGe/T03PM/OT6KzlmXhC2lnPjvtjmlV8VZGolkWOa8Vs9nb
wGrlV6SJrLKl3qT8+82eOLLRhYrsZoJijXuFJnrB92XHXDt/O2yWmRSTRjZa
yzvSeMpNOPhU/pwXw0GYeqpvatoBv/R8YCP346Kw05tJ+E5oL+5L4Ji4CCp8
w9jYyULyS5oZg4GHdVPBFyqNM45n5rY7VG2HM+3LWmS5gk4RGw4r+LiXo14N
bXDDwy1+9ppd3jidvlq1/L47OlsKqv02CJDrM2l/9JkHcm1E7wxNCVD6qVnK
uOWJzZM5Yao2IQKtHQ+uKL2w0MAtq83zQUDw2I6pVTbKfDxsO2J84eXkJtot
50Bbldyv4IgQmazSTQu5kJcdMzg8FuGHAx7RHy1zYd5/3VLbJUavWTETOMTD
3MK+7J4iP/x+KTYmsnI7dHuknnqFBNUrS/WlGj6aCzWsFAmFrEPiKeF+bxTF
HI/YYKJQwe2KbHtFgMDJa01Fehoy/R9VqUsCVPpWN+sj/OFybOih5o4Q57ov
VkZ0+ONk98FHN6744G3PmOsP+FI4Nrv6jGb4Yq+qP55VIsWvZ7Rx0UEi1L6W
xB8ySSHmNSnXt4rB7/2qPDI+AI03VHLrghhaSY9opCsAGXfPF//d6odko+1P
AyKCzmvBl1kXJEj65i9OySUC6YnagqJYCicLotbCLxOEK+c+do+noIlqm3D4
nECRKExvSqBQbNKUassJtFGtsYNKCi27LKsVNQRPg77ze1VNwfK9dbzhJkG9
w6Pxci0F7YjDxb5+ArcWtrhhgEJVXXrq+QECujGJs1NPoU5tCA0bJDiga3C9
P0zhtpt2ZdBAkFVOMZYmKEzKnVNHxwiGz4aMSRYpCOc8QmfnCEqOJJxrZ9Lw
b8th1y8QfHlIp37Ljsbuwt8syscEd0IXP5zYROOwsObrJ0sE8ztV0RYnGpkn
OOzlZYK9nLO+e16nkRf8ieWWkSBuWw/bwKNR6Dj7s9pEcMrFziVRQKOyte6C
2UxwdWPpi3wJDV2+bcq3KwS3mSNGlpTGzaPKfXlrBPo11ye6HTTaeD96hbwg
mH0WN03epNFlFFisVoLVP2tG+4Jo/AMEWJpc
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PlotRange" -> {{5., 21.}, {0., 16.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {5.000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0.6, 0, 0.6]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PlotRange" -> {{5., 21.}, {0., 16.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {5.000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0.6, 0, 0.6]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}]},
    Annotation[{{{{}, {}, 
        Annotation[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]], 
          Line[CompressedData["
1:eJw1xX1Q03UAx/ExiVSgmDwIEmubY4ON/X6Mr2QKso+iiWCYAXGMhBs2IJSh
sBUHqMQdAnniLASCQ3IggR5QHugRSgQUImwSBHQFyPHkyWUXrenGg6v+6H33
ujc3KeNdJZPBYAT/67+v99sws05tAeP/RmdwN8cZEdWjVyPmhmUCdXJ2tMgV
mSEG2yDuomzeVPGe/T03PM/OT6KzlmXhC2lnPjvtjmlV8VZGolkWOa8Vs9nb
wGrlV6SJrLKl3qT8+82eOLLRhYrsZoJijXuFJnrB92XHXDt/O2yWmRSTRjZa
yzvSeMpNOPhU/pwXw0GYeqpvatoBv/R8YCP346Kw05tJ+E5oL+5L4Ji4CCp8
w9jYyULyS5oZg4GHdVPBFyqNM45n5rY7VG2HM+3LWmS5gk4RGw4r+LiXo14N
bXDDwy1+9ppd3jidvlq1/L47OlsKqv02CJDrM2l/9JkHcm1E7wxNCVD6qVnK
uOWJzZM5Yao2IQKtHQ+uKL2w0MAtq83zQUDw2I6pVTbKfDxsO2J84eXkJtot
50Bbldyv4IgQmazSTQu5kJcdMzg8FuGHAx7RHy1zYd5/3VLbJUavWTETOMTD
3MK+7J4iP/x+KTYmsnI7dHuknnqFBNUrS/WlGj6aCzWsFAmFrEPiKeF+bxTF
HI/YYKJQwe2KbHtFgMDJa01Fehoy/R9VqUsCVPpWN+sj/OFybOih5o4Q57ov
VkZ0+ONk98FHN6744G3PmOsP+FI4Nrv6jGb4Yq+qP55VIsWvZ7Rx0UEi1L6W
xB8ySSHmNSnXt4rB7/2qPDI+AI03VHLrghhaSY9opCsAGXfPF//d6odko+1P
AyKCzmvBl1kXJEj65i9OySUC6YnagqJYCicLotbCLxOEK+c+do+noIlqm3D4
nECRKExvSqBQbNKUassJtFGtsYNKCi27LKsVNQRPg77ze1VNwfK9dbzhJkG9
w6Pxci0F7YjDxb5+ArcWtrhhgEJVXXrq+QECujGJs1NPoU5tCA0bJDiga3C9
P0zhtpt2ZdBAkFVOMZYmKEzKnVNHxwiGz4aMSRYpCOc8QmfnCEqOJJxrZ9Lw
b8th1y8QfHlIp37Ljsbuwt8syscEd0IXP5zYROOwsObrJ0sE8ztV0RYnGpkn
OOzlZYK9nLO+e16nkRf8ieWWkSBuWw/bwKNR6Dj7s9pEcMrFziVRQKOyte6C
2UxwdWPpi3wJDV2+bcq3KwS3mSNGlpTGzaPKfXlrBPo11ye6HTTaeD96hbwg
mH0WN03epNFlFFisVoLVP2tG+4Jo/AMEWJpc
           "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PlotRange" -> {{5., 21.}, {0., 16.}}, 
        "Frame" -> {{False, False}, {False, False}}, 
        "AxesOrigin" -> {5.000000000000011, 0}, 
        "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
          Directive[
           Opacity[1.], 
           AbsoluteThickness[2], 
           RGBColor[0.6, 0, 0.6]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 0}, {20, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 20}, {0, 20}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 20}, {0, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 0}, {20, 0}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{1, 0}, {1, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{2, 0}, {2, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{3, 0}, {3, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{4, 0}, {4, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{5, 0}, {5, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{6, 0}, {6, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{7, 0}, {7, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{8, 0}, {8, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{9, 0}, {9, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{10, 0}, {10, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{11, 0}, {11, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{12, 0}, {12, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{13, 0}, {13, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{14, 0}, {14, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{15, 0}, {15, 1.2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{16, 0}, {16, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{17, 0}, {17, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{18, 0}, {18, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{19, 0}, {19, 0.6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 5}, {0.6, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 10}, {0.6, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{0, 15}, {0.6, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -4}, {0.24000000000000002`, -4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -3}, {0.24000000000000002`, -3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -2}, {0.24000000000000002`, -2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, -1}, {0.24000000000000002`, -1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 1}, {0.24000000000000002`, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 2}, {0.24000000000000002`, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 3}, {0.24000000000000002`, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 4}, {0.24000000000000002`, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 6}, {0.24000000000000002`, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 7}, {0.24000000000000002`, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 8}, {0.24000000000000002`, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 9}, {0.24000000000000002`, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 11}, {0.24000000000000002`, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 12}, {0.24000000000000002`, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 13}, {0.24000000000000002`, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 14}, {0.24000000000000002`, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 16}, {0.24000000000000002`, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 17}, {0.24000000000000002`, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 18}, {0.24000000000000002`, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], 
    LineBox[{{0, 19}, {0.24000000000000002`, 19}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 1}, {19.76, 1}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 2}, {19.76, 2}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 3}, {19.76, 3}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 4}, {19.76, 4}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 5}, {19.4, 5}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 6}, {19.76, 6}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 7}, {19.76, 7}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 8}, {19.76, 8}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 9}, {19.76, 9}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 10}, {19.4, 10}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 11}, {19.76, 11}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 12}, {19.76, 12}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 13}, {19.76, 13}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 14}, {19.76, 14}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 15}, {19.4, 15}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 16}, {19.76, 16}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 17}, {19.76, 17}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 18}, {19.76, 18}}]}, 
   {GrayLevel[0], Thickness[0.005], LineBox[{{20, 19}, {19.76, 19}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{None, None}, {None, None}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "IncludeHighlighting" -> "CurrentPoint", 
    "HighlightStyle" -> Automatic, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.1, 21.}, {-0.2, 20.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9570185936056232`*^9, 3.9570186118519783`*^9}, {
   3.9570186523994875`*^9, 3.9570187249554567`*^9}, {3.957018843193242*^9, 
   3.9570188522815638`*^9}, {3.957018920278881*^9, 3.9570189411018744`*^9}, 
   3.9570190345090275`*^9, {3.9570191177331467`*^9, 3.9570191271852474`*^9}, 
   3.95701922521577*^9, {3.95701932985336*^9, 3.9570193415364275`*^9}, 
   3.9570196084133425`*^9, {3.9570197257794304`*^9, 3.9570197615905523`*^9}, 
   3.9570197988752737`*^9, 3.957019840363449*^9, 3.9570198851712885`*^9, {
   3.957019944221252*^9, 3.957019986472224*^9}, {3.957020071331391*^9, 
   3.957020129518885*^9}, 3.9570201991760144`*^9, {3.9570204850349207`*^9, 
   3.95702050139015*^9}, {3.957020576296116*^9, 3.9570206623583636`*^9}, {
   3.957020694598106*^9, 3.9570207096045294`*^9}, {3.957020775151439*^9, 
   3.957020798002926*^9}, {3.957020834870054*^9, 3.9570208510530634`*^9}, 
   3.957020889972268*^9, {3.957020996752306*^9, 3.957021010854918*^9}, 
   3.957021168370688*^9, 3.957021266126385*^9, {3.9570214036445365`*^9, 
   3.9570214192209063`*^9}, {3.9570214750374765`*^9, 3.95702149275321*^9}, {
   3.9570218278944836`*^9, 3.957021856398041*^9}, 3.9570218871628313`*^9, 
   3.9570219176642733`*^9, 3.9570219505837836`*^9, 3.957022109423764*^9, 
   3.957022186224201*^9, {3.957022295287128*^9, 3.957022312311948*^9}, {
   3.957022433856651*^9, 3.9570224569807053`*^9}, 3.957022701845372*^9, {
   3.9570227697427197`*^9, 3.957022837353387*^9}, 3.957022920999872*^9, 
   3.9570229820024786`*^9, 3.9570833227508917`*^9, 3.957083358184591*^9, 
   3.957086332773363*^9, {3.9570877894178123`*^9, 3.9570878136598406`*^9}, 
   3.9570879671003437`*^9, 3.957089750429146*^9, 3.9570898214001255`*^9, 
   3.957089987750513*^9, 3.957090156652458*^9, 3.9570901927144756`*^9},
 CellLabel->
  "Out[28822]=",ExpressionUUID->"96c736a3-163d-4c5a-97b9-c1faf12879ed"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1141.2, 568.8},
WindowMargins->{{-0.6, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"8a02d738-c0cf-4376-a086-00cb4d2235a5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 250, 4, 67, "Section",ExpressionUUID->"6d6ab418-5536-4b14-9fde-eb1b7ae47925"],
Cell[811, 26, 508, 15, 53, "Section",ExpressionUUID->"db752163-ba70-4898-90b0-471b75baa474"],
Cell[CellGroupData[{
Cell[1344, 45, 471, 8, 53, "Section",ExpressionUUID->"04d765f3-d06f-4dee-bcfd-7b332d9ea2e0"],
Cell[CellGroupData[{
Cell[1840, 57, 15454, 360, 657, "Input",ExpressionUUID->"d0018850-ab64-4461-94e5-df8544c105f1"],
Cell[17297, 419, 94591, 1930, 239, "Output",ExpressionUUID->"92ce8663-b077-4f44-b7a2-70b5ae31e4b9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111937, 2355, 568, 10, 105, "Section",ExpressionUUID->"b0231352-eb09-4dfc-aeb2-d2cc7cba0c3d"],
Cell[CellGroupData[{
Cell[112530, 2369, 16339, 373, 657, "Input",ExpressionUUID->"934a6ecb-cac7-497a-bdc7-ff39d31ee8a4"],
Cell[128872, 2744, 93484, 1914, 239, "Output",ExpressionUUID->"f2bad1c5-4406-44df-8e8a-5e5d119658c6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[222405, 4664, 517, 9, 105, "Section",ExpressionUUID->"424eaa86-f281-424f-9c19-8a61366c57c1"],
Cell[CellGroupData[{
Cell[222947, 4677, 16598, 378, 676, "Input",ExpressionUUID->"16c50d6d-67c2-4d13-b7fc-023b0ad471e6"],
Cell[239548, 5057, 94126, 1930, 239, "Output",ExpressionUUID->"85abbbe8-1bf5-4580-8eb8-bfb2c748f1f0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[333723, 6993, 352, 7, 105, "Section",ExpressionUUID->"0533327c-2576-40b7-8fab-957d29e5cc95"],
Cell[CellGroupData[{
Cell[334100, 7004, 15962, 370, 657, "Input",ExpressionUUID->"21c05836-feea-42b5-85f3-d4ce9719039b"],
Cell[350065, 7376, 93371, 1908, 239, "Output",ExpressionUUID->"96c736a3-163d-4c5a-97b9-c1faf12879ed"]
}, Open  ]]
}, Open  ]]
}
]
*)

