(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    190318,       4802]
NotebookOptionsPosition[    189347,       4776]
NotebookOutlinePosition[    189781,       4793]
CellTagsIndexPosition[    189738,       4790]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Figure 3", "Title",
 CellChangeTimes->{{3.8510551467809277`*^9, 3.8510551638900614`*^9}, {
   3.8512562628138685`*^9, 3.851256266924469*^9}, {3.8512683216422997`*^9, 
   3.8512683230613003`*^9}, {3.8512749880798616`*^9, 3.851274992160311*^9}, {
   3.852179657158142*^9, 3.852179657496433*^9}, {3.8522648835258236`*^9, 
   3.852264895503807*^9}, {3.9539098323881783`*^9, 3.9539098594810305`*^9}, {
   3.953909902272316*^9, 3.9539099208441963`*^9}, {3.9568505357688203`*^9, 
   3.9568505440183935`*^9}, 
   3.9709958230634704`*^9},ExpressionUUID->"4db28663-3797-4aad-9051-\
57d37be2ea72"],

Cell[TextData[{
 StyleBox["LUMO energy profile for 10 and 15 nm films and for three values of \
the gradient ", "Subsection"],
 StyleBox["g\n", "Subsection",
  FontSlant->"Italic"],
 StyleBox["Data format: {distance from the substrate (nm), relative LUMO \
energy (eV)}", "Subsection"]
}], "Section",
 CellChangeTimes->{{3.9709959112945414`*^9, 3.9709959153962846`*^9}, {
  3.970995961394369*^9, 3.9709960205265436`*^9}, {3.9709962295164385`*^9, 
  3.9709963095506353`*^9}},ExpressionUUID->"e5b331c0-6828-4b1d-aed4-\
1109a543edce"],

Cell[CellGroupData[{

Cell["Fig. 3(a) Non-charged film", "Section",
 CellChangeTimes->{{3.9709959112945414`*^9, 3.9709959153962846`*^9}, {
  3.970995961394369*^9, 3.970995997298113*^9}, {3.9709960489619017`*^9, 
  3.970996052602476*^9}, {3.9709977635005846`*^9, 
  3.9709977640572376`*^9}},ExpressionUUID->"1c6ad435-09d2-4551-8b34-\
9a9ea195289a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"10", " ", "nm"}], ",", " ", 
    RowBox[{"no", " ", "gradient"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tab10nm000", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.437999996192505`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.8379999954333054`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.6379999945227243`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.5379999934305768`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.4779999921206595`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.43799999054954974`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.4094285600937382`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.38799998640504524`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.37133331702759764`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.3579999804429641`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.3470908856342765`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.3379999718662063`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.3303076585641298`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.3237142452423884`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.31799995145816407`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.3129999417791113`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.30858816546421064`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.3046665829129484`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.30115779428295886`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.29799987951600404`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.29514271263482206`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.29254528122308054`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.2901737051612985`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.28799975066692385`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.2859997009508804`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.2841534874754978`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.2824440142470315`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.2808566268800427`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.27937869148390493`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.2779992577406217`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.2767087871563498`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.27549893222202193`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.27436235567489164`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.27329258159397046`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.2722838719496276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.27133112364261236`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.27042978213799496`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.2695757686156035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.2687654181854921`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.26799542720192515`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.26726280808674047`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.26656485036814137`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.265899086872805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.2652632641917473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.26465531668422604`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.2640733433970417`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.26351558736491837`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.262980416825723`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.262466307935474`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.26197182860487306`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.26149562310320174`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.26103639708802195`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.2605929027208432`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.2601639235199744`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.2597482585819521`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.2593447057715958`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.25895204343687617`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.2585690101469026`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.25819428187751936`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.25782644597675036`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.2574639711285628`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.25710517239431535`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.2567481702421643`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.2563908422699784`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.2560307660801347`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.255665151466698`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.2552907597170274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.2549038073988781`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.254499851486267`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.2540736520555549`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.2536190080367175`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.25312856060888245`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.25259355775416015`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.2520035721939532`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.2513461633845058`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.250606472392148`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.24976673624194223`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.24880570566243182`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.24769794694536262`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.2464130047963878`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.24491439844347657`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.2431584177412238`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.24109267937822854`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.23865439534135546`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.23576829625135848`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.23234414074281035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.2282737283382574`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.22342731680709935`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.21764932525826253`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.2107531805378713`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.20251513610393568`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.19266685848814127`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.1808865356010393`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.16678821213701783`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.14990899856508516`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.1296937297025437`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.1054765643244159`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.07645891585946377`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.04168298260241682`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"15", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.00"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm000", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.441999999999571`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.8419999999994854`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.6419999999993827`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.5419999999992597`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.4819999999991121`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.4419999999989351`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.4134285714272941`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.391999999998468`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.3753333333314959`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.3619999999977962`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.35109090908826585`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.34199999999682973`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.33430769230388985`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.3277142857097251`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.32199999999453`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.3169999999934393`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.3125882352862488`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.3086666666572288`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.30515789472552235`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.3019999999864232`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.2991428571265732`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.2965454545259236`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.2941739130200529`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.29199999997190373`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.28999999996630144`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.28815384611342826`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.2864444443959674`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.28485714279899965`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.2833793102750909`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.28199999991635805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.280709677319035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.27949999987967683`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.2783636362193212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.27729411747396776`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.27628571407810953`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.27533333308433305`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.27443243213378243`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.27357894701022145`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.27276923033960754`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.2719999994847116`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.2712682920648919`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.2705714278301599`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.2699069758551113`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.2692727262063745`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.2686666653876873`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.26808695498773627`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.26753191305373997`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.2669999977932586`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.2664897932716104`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.26599999682548997`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.2655294079572109`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.26507691851022847`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.26464150395668656`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.26422221565279913`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.2638181739388413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.2634285619781212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.2630526202441142`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.26268964157745905`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.26233896674511176`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.26199998044296413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.26167210769090843`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.2613548105758837`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.2610475853040566`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.2607499595281027`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.2604614899197026`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.26018175996092946`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.259910377931287`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.25964697506981116`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.2593912038939429`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.2591427366588612`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.2589012639426691`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.25866649334429265`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.2584381482822038`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.2582159668831401`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.25799970095088043`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.25778911500586216`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.25758398538700267`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.2573840994075152`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.25718925455679886`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.25699925774062166`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.25681392455180974`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.2566330785634854`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.2564565506365565`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.25628417823262595`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.2561158047227369`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.255951278681372`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.2557904531538384`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.2556331848835461`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.255479333483677`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.2553287605352585`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.2551813285906268`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.2550369000575824`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.2548953359350706`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.25475649436582853`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.2546202289649278`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.25448638687530256`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.2543548064919199`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.2542253147849066`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.25409772413831877`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", 
         RowBox[{"-", "0.25397182860487305`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.1`", ",", 
         RowBox[{"-", "0.2538473994573077`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.200000000000001`", ",", 
         RowBox[{"-", "0.25372417989345186`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.3`", ",", 
         RowBox[{"-", "0.2536018787237741`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.4`", ",", 
         RowBox[{"-", "0.2534801628362137`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.5`", ",", 
         RowBox[{"-", "0.2533586481923417`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.6`", ",", 
         RowBox[{"-", "0.2532368890600055`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.700000000000001`", ",", 
         RowBox[{"-", "0.2531143651289568`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.8`", ",", 
         RowBox[{"-", "0.25299046608559994`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.9`", ",", 
         RowBox[{"-", "0.2528644731385985`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", 
         RowBox[{"-", "0.25273553688584127`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.1`", ",", 
         RowBox[{"-", "0.25260265079183264`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.200000000000001`", ",", 
         RowBox[{"-", "0.2524646193989237`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.3`", ",", 
         RowBox[{"-", "0.2523200202210939`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.4`", ",", 
         RowBox[{"-", "0.25216715805945206`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.5`", ",", 
         RowBox[{"-", "0.25200401022729185`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.6`", ",", 
         RowBox[{"-", "0.25182816087108667`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.700000000000001`", ",", 
         RowBox[{"-", "0.25163672221224365`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.8`", ",", 
         RowBox[{"-", "0.25142624010077236`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.9`", ",", 
         RowBox[{"-", "0.25119258075188633`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", 
         RowBox[{"-", "0.25093079491269776`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.1`", ",", 
         RowBox[{"-", "0.2506349549579141`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.200000000000001`", ",", 
         RowBox[{"-", "0.25029795951598627`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.3`", ",", 
         RowBox[{"-", "0.2499112991507522`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.4`", ",", 
         RowBox[{"-", "0.24946477533257566`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.5`", ",", 
         RowBox[{"-", "0.24894616338450581`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.6`", ",", 
         RowBox[{"-", "0.24834080823174703`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.700000000000001`", ",", 
         RowBox[{"-", "0.24763113955516444`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.8`", ",", 
         RowBox[{"-", "0.24679609027781643`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.9`", ",", 
         RowBox[{"-", "0.24581039910903646`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", 
         RowBox[{"-", "0.24464377402715703`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.1`", ",", 
         RowBox[{"-", "0.2432598889721732`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.200000000000001`", ",", 
         RowBox[{"-", "0.24161518049066943`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.3`", ",", 
         RowBox[{"-", "0.2396574044439048`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.4`", ",", 
         RowBox[{"-", "0.2373239049362382`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.5`", ",", 
         RowBox[{"-", "0.23453953808142383`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.6`", ",", 
         RowBox[{"-", "0.23121418178248204`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.700000000000001`", ",", 
         RowBox[{"-", "0.2272397489775727`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.8`", ",", 
         RowBox[{"-", "0.22248660534464876`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.9`", ",", 
         RowBox[{"-", "0.21679927271602664`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", 
         RowBox[{"-", "0.20999127577596652`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.1`", ",", 
         RowBox[{"-", "0.2018389612149948`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.200000000000001`", ",", 
         RowBox[{"-", "0.19207408445262364`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.3`", ",", 
         RowBox[{"-", "0.18037491818619608`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.4`", ",", 
         RowBox[{"-", "0.16635558802354267`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.5`", ",", 
         RowBox[{"-", "0.14955328168668225`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.6`", ",", 
         RowBox[{"-", "0.12941290778473546`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.700000000000001`", ",", 
         RowBox[{"-", "0.10526869560991978`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.8`", ",", 
         RowBox[{"-", "0.0763221260083882`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.9`", ",", 
         RowBox[{"-", "0.041615461756372485`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"10", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.02"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab10nm002", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.239999996192505`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.6419999954333053`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.44399999452272426`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.34599999343057686`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.2879999921206595`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.24999999054954977`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.2234285600937382`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.2039999864050452`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.1893333170275976`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.1779999804429641`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.1690908856342765`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.1619999718662063`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.15630765856412981`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.15171424524238838`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.14799995145816408`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.14499994177911124`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.1425881654642106`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.14066658291294837`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.13915779428295888`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.13799987951600404`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.13714271263482203`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.13654528122308052`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.13617370516129845`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.13599975066692388`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.13599970095088038`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.13615348747549777`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.1364440142470315`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.1368566268800427`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.1373786914839049`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.13799925774062166`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.13870878715634977`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.13949893222202192`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.1403623556748916`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.14129258159397046`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.1422838719496276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.14333112364261233`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.14442978213799496`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.1455757686156035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.1467654181854921`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.14799542720192513`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.14926280808674042`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.15056485036814138`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.15189908687280498`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.1532632641917473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.15465531668422602`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.15607334339704165`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.15751558736491833`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.15898041682572295`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.16046630793547398`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.16197182860487302`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.1634956231032017`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.16503639708802198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.16659290272084315`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.16816392351997442`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.16974825858195206`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.17134470577159577`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.17295204343687615`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.17456901014690257`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.17619428187751937`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.17782644597675032`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.1794639711285628`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.1811051723943154`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.18274817024216425`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.18439084226997837`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.18603076608013466`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.187665151466698`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.1892907597170274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.19090380739887805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.19249985148626703`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.19407365205555488`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.1956190080367175`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.19712856060888245`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.19859355775416013`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.20000357219395318`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.20134616338450578`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.20260647239214802`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.20376673624194222`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.2048057056624318`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.20569794694536261`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.20641300479638777`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.20691439844347656`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.20715841774122376`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.20709267937822853`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.2066543953413555`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.20576829625135848`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.20434414074281035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.20227372833825738`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.19942731680709938`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.19564932525826254`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.19075318053787127`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.18451513610393566`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.17666685848814126`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.16688653560103933`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.15478821213701782`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.13990899856508515`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.1216937297025437`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.09947656432441593`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.07245891585946376`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.039682982602416816`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"15", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.02"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm002", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.143999999999571`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.5459999999994853`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.34799999999938275`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.2499999999992597`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.1919999999991121`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.1539999999989351`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.12742857142729413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.10799999999846802`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.0933333333314959`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.0819999999977962`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.07309090908826588`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.06599999999682973`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.06030769230388988`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.055714285709725114`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.05199999999453002`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.04899999999343935`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.04658823528624882`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.04466666665722882`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.043157894725522394`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.0419999999864232`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.041142857126573174`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.04054545452592362`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.04017391302005294`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.03999999997190376`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.03999999996630148`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.040153846113428274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.04044444439596741`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.040857142798999685`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.04137931027509088`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.04199999991635808`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.042709677319035036`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.04349999987967683`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.0443636362193212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.04529411747396779`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.04628571407810958`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.04733333308433306`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.04843243213378248`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.04957894701022145`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.05076923033960758`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.051999999484711595`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.05326829206489192`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.05457142783015992`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.05590697585511131`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.05727272620637451`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.058666665387687306`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.06008695498773628`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.061531913053739964`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.06299999779325864`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.06448979327161035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.06599999682548999`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.06752940795721096`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.06907691851022851`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.07064150395668659`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.07222221565279913`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.07381817393884135`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.0754285619781212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.07705262024411419`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.07868964157745903`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.08033896674511176`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.08199998044296414`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.08367210769090841`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.08535481057588376`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.08704758530405657`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.08874995952810269`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.09046148991970263`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.09218175996092948`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.09391037793128704`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.09564697506981118`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.0973912038939429`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.0991427366588612`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.10090126394266913`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.10266649334429268`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.10443814828220377`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.10621596688314014`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.1079997009508804`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.10978911500586216`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.1115839853870027`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.11338409940751526`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.11518925455679888`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.11699925774062167`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.11881392455180975`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.12063307856348535`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.1224565506365565`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.12428417823262597`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.1261158047227369`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.12795127868137204`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.12979045315383841`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.13163318488354614`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.13347933348367708`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.13532876053525847`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.13718132859062682`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.1390369000575824`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.14089533593507061`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.14275649436582855`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.1446202289649278`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.14648638687530258`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.14835480649191995`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.15022531478490667`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.1520977241383188`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", 
         RowBox[{"-", "0.15397182860487307`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.1`", ",", 
         RowBox[{"-", "0.15584739945730772`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.200000000000001`", ",", 
         RowBox[{"-", "0.15772417989345186`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.3`", ",", 
         RowBox[{"-", "0.15960187872377413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.4`", ",", 
         RowBox[{"-", "0.16148016283621375`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.5`", ",", 
         RowBox[{"-", "0.1633586481923417`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.6`", ",", 
         RowBox[{"-", "0.1652368890600055`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.700000000000001`", ",", 
         RowBox[{"-", "0.16711436512895686`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.8`", ",", 
         RowBox[{"-", "0.16899046608559995`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.9`", ",", 
         RowBox[{"-", "0.17086447313859854`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", 
         RowBox[{"-", "0.17273553688584126`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.1`", ",", 
         RowBox[{"-", "0.17460265079183265`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.200000000000001`", ",", 
         RowBox[{"-", "0.17646461939892372`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.3`", ",", 
         RowBox[{"-", "0.17832002022109392`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.4`", ",", 
         RowBox[{"-", "0.1801671580594521`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.5`", ",", 
         RowBox[{"-", "0.18200401022729187`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.6`", ",", 
         RowBox[{"-", "0.1838281608710867`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.700000000000001`", ",", 
         RowBox[{"-", "0.18563672221224367`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.8`", ",", 
         RowBox[{"-", "0.1874262401007724`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.9`", ",", 
         RowBox[{"-", "0.18919258075188633`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", 
         RowBox[{"-", "0.19093079491269777`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.1`", ",", 
         RowBox[{"-", "0.1926349549579141`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.200000000000001`", ",", 
         RowBox[{"-", "0.19429795951598633`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.3`", ",", 
         RowBox[{"-", "0.19591129915075223`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.4`", ",", 
         RowBox[{"-", "0.19746477533257573`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.5`", ",", 
         RowBox[{"-", "0.19894616338450583`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.6`", ",", 
         RowBox[{"-", "0.20034080823174705`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.700000000000001`", ",", 
         RowBox[{"-", "0.20163113955516448`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.8`", ",", 
         RowBox[{"-", "0.20279609027781648`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.9`", ",", 
         RowBox[{"-", "0.20381039910903648`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", 
         RowBox[{"-", "0.20464377402715705`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.1`", ",", 
         RowBox[{"-", "0.20525988897217323`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.200000000000001`", ",", 
         RowBox[{"-", "0.20561518049066946`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.3`", ",", 
         RowBox[{"-", "0.2056574044439048`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.4`", ",", 
         RowBox[{"-", "0.2053239049362382`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.5`", ",", 
         RowBox[{"-", "0.20453953808142383`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.6`", ",", 
         RowBox[{"-", "0.20321418178248207`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.700000000000001`", ",", 
         RowBox[{"-", "0.20123974897757274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.8`", ",", 
         RowBox[{"-", "0.1984866053446488`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.9`", ",", 
         RowBox[{"-", "0.1947992727160267`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", 
         RowBox[{"-", "0.18999127577596656`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.1`", ",", 
         RowBox[{"-", "0.18383896121499482`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.200000000000001`", ",", 
         RowBox[{"-", "0.17607408445262368`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.3`", ",", 
         RowBox[{"-", "0.16637491818619615`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.4`", ",", 
         RowBox[{"-", "0.15435558802354274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.5`", ",", 
         RowBox[{"-", "0.13955328168668224`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.6`", ",", 
         RowBox[{"-", "0.12141290778473551`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.700000000000001`", ",", 
         RowBox[{"-", "0.09926869560991983`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.8`", ",", 
         RowBox[{"-", "0.07232212600838822`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.9`", ",", 
         RowBox[{"-", "0.03961546175637251`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"10", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.04"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab10nm004", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.041999996192505`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.4459999954333054`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.24999999452272426`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.15399999343057685`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.09799999212065952`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.061999990549549744`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.037428560093738183`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.019999986405045217`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.007333317027597597`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.0020000195570358814`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", "0.00890911436572353`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", "0.014000028133793724`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", "0.0176923414358702`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", "0.02028575475761163`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", "0.022000048541835904`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", "0.02300005822088874`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", "0.023411834535789405`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", "0.02333341708705161`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", "0.022842205717041153`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0.022000120483995966`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", "0.020857287365178`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", "0.019454718776919483`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", "0.017826294838701545`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", "0.016000249333076116`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", "0.014000299049119591`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", "0.011846512524502223`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", "0.009555985752968482`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", "0.0071433731199573025`"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", "0.004621308516095074`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", "0.002000742259378352`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.000708787156349755`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.003498932222021911`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.006362355674891601`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.00929258159397045`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.0122838719496276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.015331123642612327`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.018429782137994982`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.021575768615603508`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.024765418185492077`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.027995427201925105`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.031262808086740396`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.03456485036814136`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.037899086872804966`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.04126326419174728`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.04465531668422601`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.04807334339704167`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.05151558736491835`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.05498041682572294`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.05846630793547397`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.06197182860487302`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.06549562310320167`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.06903639708802198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.07259290272084312`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.07616392351997442`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.07974825858195206`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.08334470577159575`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.08695204343687615`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.09056901014690255`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.09419428187751933`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.09782644597675033`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.10146397112856276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.10510517239431538`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.10874817024216427`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.11239084226997836`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.11603076608013468`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.11966515146669798`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.12329075971702746`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.12690380739887808`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.13049985148626703`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.13407365205555488`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.13761900803671745`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.14112856060888246`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.1445935577541601`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.14800357219395321`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.1513461633845058`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.15460647239214798`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.1577667362419422`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.1608057056624318`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.16369794694536266`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.16641300479638782`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.16891439844347655`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.17115841774122376`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.17309267937822853`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.17465439534135546`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.17576829625135848`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.1763441407428103`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.17627372833825738`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.17542731680709933`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.17364932525826254`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.1707531805378712`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.16651513610393565`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.16066685848814122`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.15288653560103932`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.14278821213701787`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.12990899856508514`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.11369372970254371`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.09347656432441598`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.06845891585946373`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.03768298260241684`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"15", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.04"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm004", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "0.845999999999571`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.2499999999994854`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.053999999999382764`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", "0.04200000000074028`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", "0.09800000000088788`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", "0.1340000000010649`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", "0.15857142857270587`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", "0.17600000000153196`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", "0.18866666666850407`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.19800000000220377`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", "0.20490909091173412`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", "0.21000000000317026`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", "0.21369230769611008`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", "0.21628571429027488`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", "0.21800000000546996`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", "0.2190000000065606`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", "0.21941176471375118`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", "0.21933333334277116`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", "0.2188421052744776`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0.21800000001357678`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", "0.21685714287342683`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", "0.21545454547407636`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", "0.21382608697994704`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", "0.2120000000280962`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", "0.21000000003369848`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", "0.2078461538865717`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", "0.2055555556040326`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", "0.2031428572010003`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", "0.20062068972490907`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", "0.1980000000836419`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", "0.19529032268096494`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", "0.19250000012032314`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", "0.18963636378067877`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", "0.1867058825260322`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", "0.1837142859218904`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", "0.18066666691566693`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", "0.1775675678662175`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", "0.17442105298977853`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", "0.17123076966039238`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", "0.16800000051528838`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", "0.16473170793510808`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", "0.16142857216984008`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", "0.15809302414488868`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", "0.1547272737936255`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", "0.1513333346123127`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", "0.1479130450122637`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", "0.14446808694626`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", "0.14100000220674136`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", "0.13751020672838962`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", "0.13400000317451`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", "0.13047059204278905`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", "0.12692308148977147`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", "0.12335849604331342`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", "0.11977778434720085`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", "0.11618182606115862`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", "0.1125714380218788`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", "0.10894737975588578`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", "0.10531035842254094`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", "0.10166103325488823`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", "0.09800001955703586`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", "0.09432789230909161`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", "0.0906451894241162`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", "0.08695241469594345`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", "0.08325004047189727`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", "0.07953851008029739`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", "0.0758182400390705`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", "0.07208962206871289`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", "0.0683530249301888`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", "0.06460879610605708`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", "0.06085726334113878`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", "0.0570987360573309`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", "0.0533335066557073`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", "0.04956185171779626`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", "0.04578403311685986`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", "0.04200029904911956`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", "0.03821088499413783`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", "0.034416014612997314`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", "0.030615900592484757`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", "0.026810745443201056`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", "0.02300074225937826`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", "0.019186075448190176`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", "0.015366921436514636`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", "0.011543449363443481`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", "0.007715821767374009`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", "0.003884195277263136`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", "0.000048721318627986676`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.0037904531538384134`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.00763318488354614`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.011479333483677134`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.015328760535258446`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.019181328590626823`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.023036900057582355`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.026895335935070652`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.030756494365828557`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.034620228964927835`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.03848638687530259`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.04235480649192003`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.04622531478490666`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.05009772413831881`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", 
         RowBox[{"-", "0.053971828604873096`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.1`", ",", 
         RowBox[{"-", "0.05784739945730771`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.200000000000001`", ",", 
         RowBox[{"-", "0.061724179893451914`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.3`", ",", 
         RowBox[{"-", "0.06560187872377415`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.4`", ",", 
         RowBox[{"-", "0.06948016283621383`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.5`", ",", 
         RowBox[{"-", "0.07335864819234167`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.6`", ",", 
         RowBox[{"-", "0.07723688906000553`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.700000000000001`", ",", 
         RowBox[{"-", "0.08111436512895692`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.8`", ",", 
         RowBox[{"-", "0.08499046608560001`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.9`", ",", 
         RowBox[{"-", "0.08886447313859852`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", 
         RowBox[{"-", "0.0927355368858413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.1`", ",", 
         RowBox[{"-", "0.09660265079183267`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.200000000000001`", ",", 
         RowBox[{"-", "0.10046461939892376`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.3`", ",", 
         RowBox[{"-", "0.10432002022109399`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.4`", ",", 
         RowBox[{"-", "0.1081671580594521`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.5`", ",", 
         RowBox[{"-", "0.1120040102272919`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.6`", ",", 
         RowBox[{"-", "0.11582816087108672`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.700000000000001`", ",", 
         RowBox[{"-", "0.11963672221224375`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.8`", ",", 
         RowBox[{"-", "0.12342624010077247`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.9`", ",", 
         RowBox[{"-", "0.12719258075188639`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", 
         RowBox[{"-", "0.13093079491269777`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.1`", ",", 
         RowBox[{"-", "0.1346349549579141`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.200000000000001`", ",", 
         RowBox[{"-", "0.13829795951598634`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.3`", ",", 
         RowBox[{"-", "0.14191129915075223`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.4`", ",", 
         RowBox[{"-", "0.14546477533257574`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.5`", ",", 
         RowBox[{"-", "0.14894616338450595`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.6`", ",", 
         RowBox[{"-", "0.152340808231747`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.700000000000001`", ",", 
         RowBox[{"-", "0.1556311395551645`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.8`", ",", 
         RowBox[{"-", "0.1587960902778165`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.9`", ",", 
         RowBox[{"-", "0.1618103991090365`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", 
         RowBox[{"-", "0.16464377402715713`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.1`", ",", 
         RowBox[{"-", "0.16725988897217325`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.200000000000001`", ",", 
         RowBox[{"-", "0.16961518049066948`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.3`", ",", 
         RowBox[{"-", "0.17165740444390487`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.4`", ",", 
         RowBox[{"-", "0.17332390493623828`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.5`", ",", 
         RowBox[{"-", "0.17453953808142386`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.6`", ",", 
         RowBox[{"-", "0.17521418178248205`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.700000000000001`", ",", 
         RowBox[{"-", "0.17523974897757277`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.8`", ",", 
         RowBox[{"-", "0.17448660534464877`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.9`", ",", 
         RowBox[{"-", "0.1727992727160267`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", 
         RowBox[{"-", "0.16999127577596662`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.1`", ",", 
         RowBox[{"-", "0.16583896121499475`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.200000000000001`", ",", 
         RowBox[{"-", "0.16007408445262372`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.3`", ",", 
         RowBox[{"-", "0.15237491818619608`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.4`", ",", 
         RowBox[{"-", "0.14235558802354276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.5`", ",", 
         RowBox[{"-", "0.12955328168668218`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.6`", ",", 
         RowBox[{"-", "0.11341290778473545`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.700000000000001`", ",", 
         RowBox[{"-", "0.0932686956099199`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.8`", ",", 
         RowBox[{"-", "0.06832212600838833`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.9`", ",", 
         RowBox[{"-", "0.037615461756372426`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.9564884420194798`*^9, 3.9564889832312512`*^9}, {
   3.956489016026162*^9, 3.9564890194559927`*^9}, {3.956489058320901*^9, 
   3.9564890590870314`*^9}, {3.9564890925148983`*^9, 3.956489183893927*^9}, {
   3.9564892999958577`*^9, 3.956489342882608*^9}, {3.9564893940901575`*^9, 
   3.956489394421526*^9}, {3.956489435199221*^9, 3.9564894355140076`*^9}, {
   3.956490010452118*^9, 3.9564900107038374`*^9}, {3.9564901595503645`*^9, 
   3.9564901599387875`*^9}, {3.9564901975123205`*^9, 
   3.9564902037627463`*^9}, {3.9564902548109093`*^9, 3.956490288012805*^9}, 
   3.9564903244619584`*^9, {3.95649036269415*^9, 3.956490386960354*^9}, {
   3.9564904432686825`*^9, 3.9564904450161543`*^9}, 3.956490516008398*^9, {
   3.9564905594311047`*^9, 3.9564906172848206`*^9}, {3.9564906851654997`*^9, 
   3.95649068563673*^9}, {3.9564907524592247`*^9, 3.9564907526963234`*^9}, {
   3.956491078476263*^9, 3.9564910938638115`*^9}, {3.956492580443443*^9, 
   3.9564925808055573`*^9}, {3.9564926543959627`*^9, 
   3.9564927697404127`*^9}, {3.956492830872707*^9, 3.956492893238429*^9}, {
   3.956492939421028*^9, 3.9564929471972375`*^9}, {3.956492980810219*^9, 
   3.956493003591419*^9}, {3.9564930439662457`*^9, 3.956493091118867*^9}, {
   3.9564931351795373`*^9, 3.9564934359883604`*^9}, 3.9565063779278193`*^9, {
   3.9565065100639677`*^9, 3.9565065373758264`*^9}, {3.9565066149842634`*^9, 
   3.9565066247834377`*^9}, {3.956506902914467*^9, 3.9565069338799133`*^9}, {
   3.9565069896515274`*^9, 3.9565070073772993`*^9}, {3.9565071815161467`*^9, 
   3.956507183035981*^9}, {3.9565072485735736`*^9, 3.9565072489363413`*^9}, {
   3.9565073746397433`*^9, 3.956507375109722*^9}, {3.9565074736648846`*^9, 
   3.9565074741988153`*^9}, 3.956843733497467*^9, {3.9568437701701155`*^9, 
   3.9568437704841423`*^9}, {3.9568440254896293`*^9, 
   3.9568442138934946`*^9}, {3.956844277400137*^9, 3.9568443179139967`*^9}, {
   3.9568443894472933`*^9, 3.9568444254015627`*^9}, {3.956844459255171*^9, 
   3.956844602596071*^9}, {3.9568446656264877`*^9, 3.9568446657685924`*^9}, {
   3.9568456875589685`*^9, 3.956845867773332*^9}, {3.9568459443592277`*^9, 
   3.9568459723450966`*^9}, {3.956846041594984*^9, 3.9568461818641253`*^9}, {
   3.956846222555933*^9, 3.9568463006484613`*^9}, {3.956846381098793*^9, 
   3.956846524766116*^9}, {3.95684659132864*^9, 3.9568468257559137`*^9}, {
   3.956847045708389*^9, 3.9568470912220936`*^9}, {3.9568471250858803`*^9, 
   3.956847166332547*^9}, {3.9568472052530174`*^9, 3.956847329490451*^9}, {
   3.956847398223239*^9, 3.956847532984585*^9}, {3.956847576285572*^9, 
   3.9568476665540824`*^9}, {3.9568477072434263`*^9, 3.956847726330923*^9}, 
   3.956847796594507*^9, {3.9568478434081078`*^9, 3.9568478444466267`*^9}, {
   3.9568492281255026`*^9, 3.9568492627862864`*^9}, {3.956850041492967*^9, 
   3.9568500613219147`*^9}, {3.956850428120492*^9, 3.956850430841503*^9}, {
   3.9568506804523225`*^9, 3.9568506833590016`*^9}, {3.956850745043082*^9, 
   3.9568508214318123`*^9}, {3.9568508581783857`*^9, 
   3.9568509085051584`*^9}, {3.9568509529637403`*^9, 3.956850982636723*^9}, {
   3.9568510288679895`*^9, 3.9568510318931856`*^9}, {3.956851063748371*^9, 
   3.956851163594142*^9}, {3.9568511980558214`*^9, 3.956851198353567*^9}, {
   3.956851255427369*^9, 3.9568513683977456`*^9}, {3.956851444444462*^9, 
   3.956851727705621*^9}, {3.956851777290783*^9, 3.9568518807235346`*^9}, 
   3.9568519175029354`*^9, 3.9568519610055437`*^9, {3.9568520190890703`*^9, 
   3.956852064297407*^9}, {3.9568522417842703`*^9, 3.95685224192539*^9}, {
   3.956852302823823*^9, 3.9568523932082405`*^9}, {3.9568524420002027`*^9, 
   3.9568525085546484`*^9}, {3.9568525703913517`*^9, 
   3.9568525732691207`*^9}, {3.956852632219328*^9, 3.956852632738966*^9}, {
   3.956852706699481*^9, 3.9568527070452785`*^9}, {3.956852796030713*^9, 
   3.956852835660355*^9}, {3.956852879723462*^9, 3.956852879971566*^9}, 
   3.9568529212673616`*^9, {3.9568529766549697`*^9, 3.9568529778219013`*^9}, {
   3.9568531056053815`*^9, 3.9568531183731675`*^9}, {3.9568531865974283`*^9, 
   3.9568532069779587`*^9}, {3.9568532556009645`*^9, 3.956853373611284*^9}, {
   3.9568534039305363`*^9, 3.9568534664392757`*^9}, {3.956853649312219*^9, 
   3.956853761099674*^9}, {3.956853791427327*^9, 3.9568538077530127`*^9}, {
   3.9568539239871035`*^9, 3.9568539328976784`*^9}, {3.95685400583936*^9, 
   3.9568540061232777`*^9}, {3.9709958720506053`*^9, 
   3.9709958965792427`*^9}, {3.9709960870950704`*^9, 
   3.9709961725811853`*^9}, {3.97099620465654*^9, 3.970996204834508*^9}, {
   3.9709963341316376`*^9, 3.9709963463204536`*^9}, {3.970996413663994*^9, 
   3.9709964848198853`*^9}, {3.9709965523446703`*^9, 3.970996679425022*^9}, {
   3.970996747918202*^9, 3.9709969589812193`*^9}, {3.970997698884133*^9, 
   3.970997779464656*^9}},ExpressionUUID->"6137106e-4985-4fd4-80d5-\
f6abfa43274b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Fig. 3(b) Charged film, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "tr"], " ", "=", " ", 
    RowBox[{
     SuperscriptBox["10", "24"], " ", 
     SuperscriptBox[
      StyleBox["m",
       FontSlant->"Plain"], 
      RowBox[{"-", "3"}]]}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "5f71d146-24a9-4c89-8047-c0a512e32408"]
}], "Section",
 CellChangeTimes->{{3.9709959112945414`*^9, 3.9709959153962846`*^9}, {
  3.970995961394369*^9, 3.970995997298113*^9}, {3.9709960489619017`*^9, 
  3.970996052602476*^9}, {3.970997024511449*^9, 
  3.9709970709676123`*^9}},ExpressionUUID->"41f87859-03b9-4b51-8ebd-\
9e3c421e3dd1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"10", " ", "nm"}], ",", " ", 
    RowBox[{"no", " ", "gradient"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tab10nm000", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.7336911826331831`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "1.127747792043475`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.9218647402854363`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.8160420273288821`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.7502796531376088`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.7045776176681939`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.6703644922971281`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.6433545626762318`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.6211668763496316`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.6023728617988965`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.5860634280071579`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.5716325142390878`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.5586605399200621`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.5468478045644224`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.5359745277293506`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.5258758739825012`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.5164257925828548`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.5075262439298976`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.4990998281812641`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.491084625278716`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.48343050924499165`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.47609646766375857`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.4690486204155358`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.4622587337177714`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.45570309078138893`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.4493616230687182`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.4432172345860147`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.4372552709478394`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.431463098263566`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.42582976621519797`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.42034573630889216`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.41500266103558137`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.4097932031325188`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.40471088667871635`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.3997499736445429`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.394905360930748`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.39017249400240184`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.3855472940393324`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.3810260961515939`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.3766055966934506`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.3722828080867405`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.3680550198596669`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.36391976483890676`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.35987478961547625`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.35591802854863286`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.35204758068517733`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.3482616890598337`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.34455872191046877`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.3409371553931012`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.3373955574184324`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.33393257225574413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.33054690556259836`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.3272373095005042`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.3240025675877711`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.32084147892093523`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.3177528413648162`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.31473543326738473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.31178799319775014`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.30890919713175674`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.3060976324174284`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.3033517677387323`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.30066991815702726`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.2980502041404694`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.2954905032869276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.29298839319877884`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.2905410836700879`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.288145335988214`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.285797366720912`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.2834927328421993`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.2812261944284363`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.27899155040959894`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.2767814419648147`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.2745871170761941`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.2723981484651397`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.2702020955878957`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.2679840995107921`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.26572639725889147`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.263407739560737`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.2610026927080745`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.2584808014065574`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.2558055848841546`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.25293333299546117`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.2498116624290761`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.24637778517186398`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.2425564318445788`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.23825736108179346`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.23337237240605402`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.22777172358676046`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.22129983373283885`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.21377012969041365`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.204958864917495`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.19459770594576836`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.18236484068578512`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.1678743138319332`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.15066323585322083`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.13017644156695057`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.1057480897481447`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.07657959382556556`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.041713152093942274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"15", " ", "nm"}], ",", " ", 
     RowBox[{"no", " ", "gradient"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm000", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "2.1117928813555036`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "1.502832542372367`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "1.2939325423722643`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "1.1850928813551922`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "1.1163135593211462`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "1.0675945762701218`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "1.030364503630684`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "1.0003376271171123`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.9751329943484452`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.9533220338961015`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.9339956548509779`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.9165477966069994`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.900558878744568`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.8857292009639626`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.8718389830453777`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.858723389823948`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.8462563708794694`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.834339886996212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.8228965387933191`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.8118644067660844`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.8011933656011496`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.7908424036784661`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.7807776418336124`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.7709708474295309`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.7613983050510473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.7520399478083437`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.7428786816841031`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.7338998546634066`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.7250908356988198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.7164406778824599`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.7079398468105607`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.699579999879677`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.6913538057108467`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.6832547954400696`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.6752772395018385`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.6674160449487401`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.6596666694219182`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.6520250487051369`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.6444875354243534`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.6370508469423388`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.6297120208784515`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.6224683769827024`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.6153174843296877`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.6082571329860358`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.6012853094554841`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.5944001753267194`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.5876000486469605`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.5808833876237672`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.574248776322458`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.5676949120797274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.561220594397889`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.554824715120398`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.5485062497193987`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.5422642495511043`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.5360978349557906`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.5300061890967653`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.5239885524475041`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.5180442178486455`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.5121725260671457`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.5063728617988964`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.5006446500637898`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.49498735294876517`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.4894004666599888`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.4838835188501367`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.47843606619088913`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.4730576921643194`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.4677480050499312`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.46250663608676046`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.45733323779224805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.4522274824215731`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.4471890605528387`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.44221767978497073`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.43731306353644106`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.43247494993398766`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.427703090781389`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.4229972505990825`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.4183572057259859`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.41378274347531185`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.4092736613364599`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.40482976621519806`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.4004508737043522`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.3961368073770448`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.3918873980941836`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.3877024833173718`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.3835819064176522`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.3795255159695077`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.3755331650182453`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.37160471030727504`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.36774001144977886`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.363938930026784`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.3602013285906269`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.35652706954910784`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.35291601390117244`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.34936801978955745`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.3458829408293348`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.34246062416343803`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.33910090818683514`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.3358036198696527`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.3325685715959459`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", 
         RowBox[{"-", "0.3293955574184325`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.1`", ",", 
         RowBox[{"-", "0.3262843486098501`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.200000000000001`", ",", 
         RowBox[{"-", "0.32323468836802793`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.3`", ",", 
         RowBox[{"-", "0.32024628550343526`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.4`", ",", 
         RowBox[{"-", "0.3173188069040105`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.5`", ",", 
         RowBox[{"-", "0.3144518685313249`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.6`", ",", 
         RowBox[{"-", "0.31164502465322597`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.700000000000001`", ",", 
         RowBox[{"-", "0.30889775495946514`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.8`", ",", 
         RowBox[{"-", "0.3062094491364473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.9`", ",", 
         RowBox[{"-", "0.3035793883928358`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", 
         RowBox[{"-", "0.30100672332651934`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.1`", ",", 
         RowBox[{"-", "0.29849044740200215`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.200000000000001`", ",", 
         RowBox[{"-", "0.29602936516163536`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.3`", ",", 
         RowBox[{"-", "0.293622054119399`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.4`", ",", 
         RowBox[{"-", "0.2912668190764014`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.5`", ",", 
         RowBox[{"-", "0.28896163734593594`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.6`", ",", 
         RowBox[{"-", "0.28670409307447664`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.700000000000001`", ",", 
         RowBox[{"-", "0.28449129848343`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.8`", ",", 
         RowBox[{"-", "0.2823197994228064`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.9`", ",", 
         RowBox[{"-", "0.2801854621078186`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", 
         RowBox[{"-", "0.2780833372855792`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.1`", ",", 
         RowBox[{"-", "0.27600749733079555`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.200000000000001`", ",", 
         RowBox[{"-", "0.27395084087191846`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.3`", ",", 
         RowBox[{"-", "0.2719048584727861`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.4`", ",", 
         RowBox[{"-", "0.2698593516037622`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.5`", ",", 
         RowBox[{"-", "0.2678020955878958`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.6`", ",", 
         RowBox[{"-", "0.2657184353503911`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.700000000000001`", ",", 
         RowBox[{"-", "0.2635908005721136`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.8`", ",", 
         RowBox[{"-", "0.26139812417612174`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.9`", ",", 
         RowBox[{"-", "0.25911514487174836`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", 
         RowBox[{"-", "0.25671157063732664`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.1`", ",", 
         RowBox[{"-", "0.2541510754128512`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.200000000000001`", ",", 
         RowBox[{"-", "0.2513900957449068`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.3`", ",", 
         RowBox[{"-", "0.24837638749475244`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.4`", ",", 
         RowBox[{"-", "0.2450472947667467`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.5`", ",", 
         RowBox[{"-", "0.24132767367464425`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.6`", ",", 
         RowBox[{"-", "0.237127402121465`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.700000000000001`", ",", 
         RowBox[{"-", "0.2323383930453693`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.8`", ",", 
         RowBox[{"-", "0.2268310121243099`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.9`", ",", 
         RowBox[{"-", "0.220449781190603`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", 
         RowBox[{"-", "0.21300822492850902`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.1`", ",", 
         RowBox[{"-", "0.20428269002855415`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.200000000000001`", ",", 
         RowBox[{"-", "0.1940049319102508`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.3`", ",", 
         RowBox[{"-", "0.1818532232709419`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.4`", ",", 
         RowBox[{"-", "0.16744168971845796`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.5`", ",", 
         RowBox[{"-", "0.15030751897481787`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.6`", ",", 
         RowBox[{"-", "0.1298956196491422`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.700000000000001`", ",", 
         RowBox[{"-", "0.10554022103364857`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.8`", ",", 
         RowBox[{"-", "0.0764428039744901`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.9`", ",", 
         RowBox[{"-", "0.041645631247897996`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"10", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.02"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab10nm002", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.5356911826331832`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.9317477920434749`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.7278647402854362`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.624042027328882`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.5602796531376087`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.516577617668194`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.4843644922971282`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.45935456267623176`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.4391668763496316`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.42237286179889644`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.40806342800715795`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.39563251423908774`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.3846605399200621`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.37484780456442235`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.36597452772935063`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.3578758739825012`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.3504257925828548`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.3435262439298976`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.33709982818126405`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.33108462527871596`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.3254305092449916`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.3200964676637586`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.31504862041553583`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.3102587337177714`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.3057030907813889`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.30136162306871817`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.2972172345860147`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.29325527094783943`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.289463098263566`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.285829766215198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.2823457363088922`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.27900266103558136`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.2757932031325188`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.27271088667871635`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.2697499736445429`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.266905360930748`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.26417249400240184`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.2615472940393324`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.2590260961515939`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.2566055966934506`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.25428280808674053`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.2520550198596669`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.24991976483890674`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.24787478961547624`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.24591802854863287`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.24404758068517735`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.2422616890598337`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.24055872191046876`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.23893715539310117`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.2373955574184324`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.23593257225574413`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.23454690556259833`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.23323730950050423`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.23200256758777107`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.2308414789209352`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.2297528413648162`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.2287354332673847`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.2277879931977501`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.22690919713175672`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.22609763241742833`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.2253517677387323`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.22466991815702728`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.2240502041404694`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.2234905032869276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.22298839319877883`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.2225410836700879`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.22214533598821398`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.221797366720912`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.22149273284219928`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.22122619442843633`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.22099155040959895`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.2207814419648147`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.22058711707619408`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.22039814846513972`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.22020209558789566`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.2199840995107921`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.21972639725889145`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.21940773956073698`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.21900269270807454`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.21848080140655735`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.21780558488415458`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.21693333299546114`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.2158116624290761`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.21437778517186398`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.21255643184457884`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.21025736108179344`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.20737237240605397`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.2037717235867605`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.19929983373283885`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.19377012969041366`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.18695886491749497`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.17859770594576838`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.16836484068578517`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.15587431383193315`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.1406632358532208`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.12217644156695057`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.09974808974814472`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.07257959382556561`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.03971315209394227`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"15", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.02"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm002", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.8137928813555033`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "1.206832542372367`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.9999325423722643`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.8930928813551922`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.8263135593211461`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.7795945762701217`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.7443645036306841`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.7163376271171122`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.6931329943484452`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.6733220338961015`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.6559956548509779`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.6405477966069993`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.626558878744568`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.6137292009639626`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.6018389830453776`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.590723389823948`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.5802563708794692`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.570339886996212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.5608965387933191`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.5518644067660844`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.5431933656011496`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.5348424036784661`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.5267776418336123`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.5189708474295309`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.5113983050510473`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.5040399478083437`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.4968786816841031`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.4898998546634066`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.4830908356988198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.4764406778824598`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.46993984681056056`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.463579999879677`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.4573538057108467`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.4512547954400695`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.4452772395018384`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.43941604494874`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.4336666694219181`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.4280250487051368`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.4224875354243534`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.4170508469423388`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.41171202087845143`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.40646837698270233`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.4013174843296876`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.3962571329860357`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.391285309455484`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.3864001753267194`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.38160004864696045`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.37688338762376716`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.37224877632245795`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.3676949120797274`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.36322059439788895`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.35882471512039804`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.3545062497193986`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.35026424955110425`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.3460978349557906`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.3420061890967653`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.3379885524475041`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.3340442178486455`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.3301725260671457`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.32637286179889635`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.32264465006378984`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.3189873529487651`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.3154004666599888`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.31188351885013665`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.3084360661908891`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.3050576921643194`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.30174800504993116`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.2985066360867604`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.295333237792248`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.2922274824215731`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.28918906055283866`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.2862176797849707`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.28331306353644103`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.28047494993398764`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.27770309078138894`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.2749972505990824`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.2723572057259859`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.26978274347531184`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.2672736613364599`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.264829766215198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.2624508737043521`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.26013680737704475`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.2578873980941836`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.2557024833173718`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.25358190641765216`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.2515255159695077`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.24953316501824518`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.247604710307275`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.24574001144977886`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.24393893002678402`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.24220132859062693`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.24052706954910774`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.2389160139011724`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.23736801978955735`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.2358829408293347`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.23446062416343805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.23310090818683515`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.2318036198696526`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.2305685715959459`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", 
         RowBox[{"-", "0.22939555741843248`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.1`", ",", 
         RowBox[{"-", "0.22828434860985003`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.200000000000001`", ",", 
         RowBox[{"-", "0.22723468836802796`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.3`", ",", 
         RowBox[{"-", "0.22624628550343528`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.4`", ",", 
         RowBox[{"-", "0.22531880690401052`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.5`", ",", 
         RowBox[{"-", "0.22445186853132482`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.6`", ",", 
         RowBox[{"-", "0.2236450246532259`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.700000000000001`", ",", 
         RowBox[{"-", "0.22289775495946507`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.8`", ",", 
         RowBox[{"-", "0.22220944913644736`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.9`", ",", 
         RowBox[{"-", "0.22157938839283575`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", 
         RowBox[{"-", "0.22100672332651933`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.1`", ",", 
         RowBox[{"-", "0.22049044740200208`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.200000000000001`", ",", 
         RowBox[{"-", "0.2200293651616354`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.3`", ",", 
         RowBox[{"-", "0.219622054119399`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.4`", ",", 
         RowBox[{"-", "0.21926681907640133`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.5`", ",", 
         RowBox[{"-", "0.21896163734593588`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.6`", ",", 
         RowBox[{"-", "0.21870409307447658`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.700000000000001`", ",", 
         RowBox[{"-", "0.21849129848343002`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.8`", ",", 
         RowBox[{"-", "0.21831979942280644`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.9`", ",", 
         RowBox[{"-", "0.21818546210781858`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", 
         RowBox[{"-", "0.21808333728557916`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.1`", ",", 
         RowBox[{"-", "0.21800749733079544`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.200000000000001`", ",", 
         RowBox[{"-", "0.21795084087191846`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.3`", ",", 
         RowBox[{"-", "0.21790485847278607`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.4`", ",", 
         RowBox[{"-", "0.21785935160376219`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.5`", ",", 
         RowBox[{"-", "0.2178020955878957`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.6`", ",", 
         RowBox[{"-", "0.2177184353503911`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.700000000000001`", ",", 
         RowBox[{"-", "0.21759080057211355`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.8`", ",", 
         RowBox[{"-", "0.2173981241761217`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.9`", ",", 
         RowBox[{"-", "0.21711514487174832`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", 
         RowBox[{"-", "0.21671157063732654`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.1`", ",", 
         RowBox[{"-", "0.21615107541285122`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.200000000000001`", ",", 
         RowBox[{"-", "0.2153900957449068`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.3`", ",", 
         RowBox[{"-", "0.21437638749475235`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.4`", ",", 
         RowBox[{"-", "0.21304729476674666`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.5`", ",", 
         RowBox[{"-", "0.21132767367464428`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.6`", ",", 
         RowBox[{"-", "0.20912740212146502`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.700000000000001`", ",", 
         RowBox[{"-", "0.20633839304536922`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.8`", ",", 
         RowBox[{"-", "0.20283101212430993`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.9`", ",", 
         RowBox[{"-", "0.19844978119060303`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", 
         RowBox[{"-", "0.193008224928509`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.1`", ",", 
         RowBox[{"-", "0.18628269002855408`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.200000000000001`", ",", 
         RowBox[{"-", "0.1780049319102508`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.3`", ",", 
         RowBox[{"-", "0.16785322327094193`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.4`", ",", 
         RowBox[{"-", "0.155441689718458`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.5`", ",", 
         RowBox[{"-", "0.14030751897481786`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.6`", ",", 
         RowBox[{"-", "0.1218956196491422`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.700000000000001`", ",", 
         RowBox[{"-", "0.09954022103364857`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.8`", ",", 
         RowBox[{"-", "0.07244280397448999`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.9`", ",", 
         RowBox[{"-", "0.039645631247897994`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"10", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.04"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab10nm004", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.3376911826331832`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.735747792043475`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.5338647402854362`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.4320420273288821`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.3702796531376088`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.32857761766819393`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.29836449229712814`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.2753545626762318`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.2571668763496316`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.24237286179889644`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.23006342800715796`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.21963251423908775`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.21066053992006212`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.20284780456442236`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.19597452772935062`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.18987587398250122`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.18442579258285474`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.17952624392989763`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.17509982818126404`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.17108462527871598`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.1674305092449916`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.1640964676637586`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.1610486204155358`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.1582587337177714`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.15570309078138894`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.1533616230687182`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.15121723458601466`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.14925527094783939`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.14746309826356602`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.145829766215198`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.1443457363088922`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.14300266103558132`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.1417932031325188`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.1407108866787163`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.1397499736445429`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.13890536093074798`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.13817249400240184`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.13754729403933239`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.13702609615159386`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.1366055966934506`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.13628280808674048`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.13605501985966686`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.13591976483890672`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.13587478961547622`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.13591802854863286`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.13604758068517733`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.13626168905983368`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.13655872191046875`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.13693715539310117`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.1373955574184324`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.1379325722557441`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.13854690556259833`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.1392373095005042`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.14000256758777108`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.1408414789209352`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.14175284136481617`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.14273543326738472`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.14378799319775007`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.1449091971317567`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.14609763241742835`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.14735176773873226`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.1486699181570273`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.15005020414046938`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.1514905032869276`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.15298839319877883`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.1545410836700879`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.156145335988214`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.157797366720912`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.15949273284219928`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.16122619442843633`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.1629915504095989`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.1647814419648147`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.16658711707619406`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.16839814846513973`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.17020209558789567`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.17198409951079208`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.17372639725889144`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.17540773956073696`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.17700269270807456`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.17848080140655737`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.1798055848841546`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.1809333329954611`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.1818116624290761`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.18237778517186398`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.18255643184457881`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.1822573610817934`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.18137237240605397`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.17977172358676047`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.17729983373283886`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.1737701296904136`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.16895886491749496`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.16259770594576833`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.15436484068578515`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.14387431383193316`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.13066323585322082`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.11417644156695056`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.09374808974814475`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.06857959382556555`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.03771315209394227`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"15", " ", "nm"}], ",", " ", 
     RowBox[{"gradient", " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "0.04"}], " ", 
       RowBox[{"eV", "/", "nm"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tab15nm004", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.1`", ",", 
         RowBox[{"-", "1.5157928813555035`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2`", ",", 
         RowBox[{"-", "0.910832542372367`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30000000000000004`", ",", 
         RowBox[{"-", "0.7059325423722644`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4`", ",", 
         RowBox[{"-", "0.6010928813551921`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5`", ",", 
         RowBox[{"-", "0.5363135593211463`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6`", ",", 
         RowBox[{"-", "0.4915945762701217`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7000000000000001`", ",", 
         RowBox[{"-", "0.45836450363068415`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8`", ",", 
         RowBox[{"-", "0.4323376271171123`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9`", ",", 
         RowBox[{"-", "0.4111329943484453`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", 
         RowBox[{"-", "0.39332203389610154`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1`", ",", 
         RowBox[{"-", "0.37799565485097797`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2000000000000002`", ",", 
         RowBox[{"-", "0.36454779660699943`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.3000000000000003`", ",", 
         RowBox[{"-", "0.35255887874456804`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.4000000000000001`", ",", 
         RowBox[{"-", "0.3417292009639626`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5000000000000002`", ",", 
         RowBox[{"-", "0.3318389830453777`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6`", ",", 
         RowBox[{"-", "0.32272338982394805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7000000000000002`", ",", 
         RowBox[{"-", "0.31425637087946934`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.8000000000000003`", ",", 
         RowBox[{"-", "0.30633988699621206`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9000000000000001`", ",", 
         RowBox[{"-", "0.29889653879331923`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", 
         RowBox[{"-", "0.29186440676608444`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.1`", ",", 
         RowBox[{"-", "0.2851933656011496`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2`", ",", 
         RowBox[{"-", "0.27884240367846624`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3000000000000003`", ",", 
         RowBox[{"-", "0.2727776418336124`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4000000000000004`", ",", 
         RowBox[{"-", "0.26697084742953103`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5000000000000004`", ",", 
         RowBox[{"-", "0.26139830505104744`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6`", ",", 
         RowBox[{"-", "0.2560399478083437`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.7`", ",", 
         RowBox[{"-", "0.2508786816841032`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8000000000000003`", ",", 
         RowBox[{"-", "0.2458998546634066`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.9000000000000004`", ",", 
         RowBox[{"-", "0.24109083569881987`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.0000000000000004`", ",", 
         RowBox[{"-", "0.2364406778824599`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1`", ",", 
         RowBox[{"-", "0.23193984681056065`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2`", ",", 
         RowBox[{"-", "0.22757999987967706`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.3000000000000003`", ",", 
         RowBox[{"-", "0.22335380571084676`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4000000000000004`", ",", 
         RowBox[{"-", "0.2192547954400696`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5000000000000004`", ",", 
         RowBox[{"-", "0.2152772395018385`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.6`", ",", 
         RowBox[{"-", "0.21141604494874006`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.7`", ",", 
         RowBox[{"-", "0.2076666694219182`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8000000000000003`", ",", 
         RowBox[{"-", "0.20402504870513688`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.9000000000000004`", ",", 
         RowBox[{"-", "0.2004875354243535`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.`", ",", 
         RowBox[{"-", "0.19705084694233888`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.1`", ",", 
         RowBox[{"-", "0.1937120208784515`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2`", ",", 
         RowBox[{"-", "0.19046837698270241`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3`", ",", 
         RowBox[{"-", "0.18731748432968767`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3999999999999995`", ",", 
         RowBox[{"-", "0.18425713298603574`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5`", ",", 
         RowBox[{"-", "0.1812853094554841`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6`", ",", 
         RowBox[{"-", "0.17840017532671948`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7`", ",", 
         RowBox[{"-", "0.17560004864696052`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.8`", ",", 
         RowBox[{"-", "0.17288338762376723`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9`", ",", 
         RowBox[{"-", "0.17024877632245802`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.`", ",", 
         RowBox[{"-", "0.16769491207972745`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1`", ",", 
         RowBox[{"-", "0.165220594397889`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2`", ",", 
         RowBox[{"-", "0.16282471512039812`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.3`", ",", 
         RowBox[{"-", "0.1605062497193986`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.4`", ",", 
         RowBox[{"-", "0.15826424955110432`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.5`", ",", 
         RowBox[{"-", "0.15609783495579066`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.6`", ",", 
         RowBox[{"-", "0.1540061890967653`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.7`", ",", 
         RowBox[{"-", "0.15198855244750417`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.8`", ",", 
         RowBox[{"-", "0.15004421784864558`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.9`", ",", 
         RowBox[{"-", "0.14817252606714576`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.`", ",", 
         RowBox[{"-", "0.14637286179889641`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.1`", ",", 
         RowBox[{"-", "0.14464465006378985`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.2`", ",", 
         RowBox[{"-", "0.14298735294876525`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.3`", ",", 
         RowBox[{"-", "0.14140046665998884`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.4`", ",", 
         RowBox[{"-", "0.13988351885013672`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.5`", ",", 
         RowBox[{"-", "0.13843606619088916`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.6`", ",", 
         RowBox[{"-", "0.13705769216431946`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.7`", ",", 
         RowBox[{"-", "0.13574800504993123`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.8`", ",", 
         RowBox[{"-", "0.1345066360867605`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6.9`", ",", 
         RowBox[{"-", "0.1333332377922481`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.`", ",", 
         RowBox[{"-", "0.13222748242157317`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.1`", ",", 
         RowBox[{"-", "0.1311890605528387`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.2`", ",", 
         RowBox[{"-", "0.13021767978497079`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.3`", ",", 
         RowBox[{"-", "0.12931306353644106`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.4`", ",", 
         RowBox[{"-", "0.12847494993398773`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.5`", ",", 
         RowBox[{"-", "0.12770309078138903`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.6`", ",", 
         RowBox[{"-", "0.1269972505990825`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.7`", ",", 
         RowBox[{"-", "0.1263572057259859`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.8`", ",", 
         RowBox[{"-", "0.12578274347531193`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"7.9`", ",", 
         RowBox[{"-", "0.12527366133646`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.`", ",", 
         RowBox[{"-", "0.12482976621519809`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.1`", ",", 
         RowBox[{"-", "0.1244508737043522`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.2`", ",", 
         RowBox[{"-", "0.1241368073770448`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.3`", ",", 
         RowBox[{"-", "0.12388739809418364`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.4`", ",", 
         RowBox[{"-", "0.12370248331737188`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.5`", ",", 
         RowBox[{"-", "0.12358190641765221`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.6`", ",", 
         RowBox[{"-", "0.12352551596950773`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.7`", ",", 
         RowBox[{"-", "0.1235331650182453`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.8`", ",", 
         RowBox[{"-", "0.12360471030727505`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"8.9`", ",", 
         RowBox[{"-", "0.12374001144977892`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.`", ",", 
         RowBox[{"-", "0.12393893002678402`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.1`", ",", 
         RowBox[{"-", "0.12420132859062699`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.2`", ",", 
         RowBox[{"-", "0.1245270695491078`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.3`", ",", 
         RowBox[{"-", "0.12491601390117246`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.4`", ",", 
         RowBox[{"-", "0.12536801978955747`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.5`", ",", 
         RowBox[{"-", "0.12588294082933482`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.6`", ",", 
         RowBox[{"-", "0.12646062416343812`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.700000000000001`", ",", 
         RowBox[{"-", "0.12710090818683528`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.8`", ",", 
         RowBox[{"-", "0.12780361986965266`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9.9`", ",", 
         RowBox[{"-", "0.12856857159594598`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.`", ",", 
         RowBox[{"-", "0.12939555741843256`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.1`", ",", 
         RowBox[{"-", "0.1302843486098501`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.200000000000001`", ",", 
         RowBox[{"-", "0.13123468836802804`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.3`", ",", 
         RowBox[{"-", "0.1322462855034353`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.4`", ",", 
         RowBox[{"-", "0.1333188069040106`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.5`", ",", 
         RowBox[{"-", "0.13445186853132485`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.6`", ",", 
         RowBox[{"-", "0.13564502465322598`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.700000000000001`", ",", 
         RowBox[{"-", "0.1368977549594652`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.8`", ",", 
         RowBox[{"-", "0.13820944913644745`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10.9`", ",", 
         RowBox[{"-", "0.13957938839283585`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.`", ",", 
         RowBox[{"-", "0.14100672332651942`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.1`", ",", 
         RowBox[{"-", "0.14249044740200217`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.200000000000001`", ",", 
         RowBox[{"-", "0.1440293651616355`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.3`", ",", 
         RowBox[{"-", "0.1456220541193991`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.4`", ",", 
         RowBox[{"-", "0.14726681907640138`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.5`", ",", 
         RowBox[{"-", "0.14896163734593593`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.6`", ",", 
         RowBox[{"-", "0.15070409307447663`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.700000000000001`", ",", 
         RowBox[{"-", "0.15249129848343013`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.8`", ",", 
         RowBox[{"-", "0.1543197994228065`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.9`", ",", 
         RowBox[{"-", "0.1561854621078187`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.`", ",", 
         RowBox[{"-", "0.15808333728557922`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.1`", ",", 
         RowBox[{"-", "0.1600074973307955`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.200000000000001`", ",", 
         RowBox[{"-", "0.16195084087191852`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.3`", ",", 
         RowBox[{"-", "0.16390485847278613`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.4`", ",", 
         RowBox[{"-", "0.1658593516037623`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.5`", ",", 
         RowBox[{"-", "0.16780209558789583`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.6`", ",", 
         RowBox[{"-", "0.1697184353503911`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.700000000000001`", ",", 
         RowBox[{"-", "0.17159080057211362`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.8`", ",", 
         RowBox[{"-", "0.17339812417612177`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"12.9`", ",", 
         RowBox[{"-", "0.1751151448717484`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.`", ",", 
         RowBox[{"-", "0.17671157063732668`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.1`", ",", 
         RowBox[{"-", "0.17815107541285125`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.200000000000001`", ",", 
         RowBox[{"-", "0.17939009574490683`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.3`", ",", 
         RowBox[{"-", "0.1803763874947525`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.4`", ",", 
         RowBox[{"-", "0.18104729476674675`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.5`", ",", 
         RowBox[{"-", "0.1813276736746443`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.6`", ",", 
         RowBox[{"-", "0.18112740212146505`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.700000000000001`", ",", 
         RowBox[{"-", "0.18033839304536936`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.8`", ",", 
         RowBox[{"-", "0.17883101212430996`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13.9`", ",", 
         RowBox[{"-", "0.17644978119060306`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.`", ",", 
         RowBox[{"-", "0.1730082249285091`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.1`", ",", 
         RowBox[{"-", "0.16828269002855412`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.200000000000001`", ",", 
         RowBox[{"-", "0.1620049319102509`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.3`", ",", 
         RowBox[{"-", "0.15385322327094197`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.4`", ",", 
         RowBox[{"-", "0.14344168971845805`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.5`", ",", 
         RowBox[{"-", "0.13030751897481785`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.6`", ",", 
         RowBox[{"-", "0.11389561964914219`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.700000000000001`", ",", 
         RowBox[{"-", "0.09354022103364867`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.8`", ",", 
         RowBox[{"-", "0.06844280397449021`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14.9`", ",", 
         RowBox[{"-", "0.03764563124789799`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"15.`", ",", "0.`"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9564884420194798`*^9, 3.9564889832312512`*^9}, {
   3.956489016026162*^9, 3.9564890194559927`*^9}, {3.956489058320901*^9, 
   3.9564890590870314`*^9}, {3.9564890925148983`*^9, 3.956489183893927*^9}, {
   3.9564892999958577`*^9, 3.956489342882608*^9}, {3.9564893940901575`*^9, 
   3.956489394421526*^9}, {3.956489435199221*^9, 3.9564894355140076`*^9}, {
   3.956490010452118*^9, 3.9564900107038374`*^9}, {3.9564901595503645`*^9, 
   3.9564901599387875`*^9}, {3.9564901975123205`*^9, 
   3.9564902037627463`*^9}, {3.9564902548109093`*^9, 3.956490288012805*^9}, 
   3.9564903244619584`*^9, {3.95649036269415*^9, 3.956490386960354*^9}, {
   3.9564904432686825`*^9, 3.9564904450161543`*^9}, 3.956490516008398*^9, {
   3.9564905594311047`*^9, 3.9564906172848206`*^9}, {3.9564906851654997`*^9, 
   3.95649068563673*^9}, {3.9564907524592247`*^9, 3.9564907526963234`*^9}, {
   3.956491078476263*^9, 3.9564910938638115`*^9}, {3.956492580443443*^9, 
   3.9564925808055573`*^9}, {3.9564926543959627`*^9, 
   3.9564927697404127`*^9}, {3.956492830872707*^9, 3.956492893238429*^9}, {
   3.956492939421028*^9, 3.9564929471972375`*^9}, {3.956492980810219*^9, 
   3.956493003591419*^9}, {3.9564930439662457`*^9, 3.956493091118867*^9}, {
   3.9564931351795373`*^9, 3.9564934359883604`*^9}, 3.9565063779278193`*^9, {
   3.9565065100639677`*^9, 3.9565065373758264`*^9}, {3.9565066149842634`*^9, 
   3.9565066247834377`*^9}, {3.956506902914467*^9, 3.9565069338799133`*^9}, {
   3.9565069896515274`*^9, 3.9565070073772993`*^9}, {3.9565071815161467`*^9, 
   3.956507183035981*^9}, {3.9565072485735736`*^9, 3.9565072489363413`*^9}, {
   3.9565073746397433`*^9, 3.956507375109722*^9}, {3.9565074736648846`*^9, 
   3.9565074741988153`*^9}, 3.956843733497467*^9, {3.9568437701701155`*^9, 
   3.9568437704841423`*^9}, {3.9568440254896293`*^9, 
   3.9568442138934946`*^9}, {3.956844277400137*^9, 3.9568443179139967`*^9}, {
   3.9568443894472933`*^9, 3.9568444254015627`*^9}, {3.956844459255171*^9, 
   3.956844602596071*^9}, {3.9568446656264877`*^9, 3.9568446657685924`*^9}, {
   3.9568456875589685`*^9, 3.956845867773332*^9}, {3.9568459443592277`*^9, 
   3.9568459723450966`*^9}, {3.956846041594984*^9, 3.9568461818641253`*^9}, {
   3.956846222555933*^9, 3.9568463006484613`*^9}, {3.956846381098793*^9, 
   3.956846524766116*^9}, {3.95684659132864*^9, 3.9568468257559137`*^9}, {
   3.956847045708389*^9, 3.9568470912220936`*^9}, {3.9568471250858803`*^9, 
   3.956847166332547*^9}, {3.9568472052530174`*^9, 3.956847329490451*^9}, {
   3.956847398223239*^9, 3.956847532984585*^9}, {3.956847576285572*^9, 
   3.9568476665540824`*^9}, {3.9568477072434263`*^9, 3.956847726330923*^9}, 
   3.956847796594507*^9, {3.9568478434081078`*^9, 3.9568478444466267`*^9}, {
   3.9568492281255026`*^9, 3.9568492627862864`*^9}, {3.956850041492967*^9, 
   3.9568500613219147`*^9}, {3.956850428120492*^9, 3.956850430841503*^9}, {
   3.9568506804523225`*^9, 3.9568506833590016`*^9}, {3.956850745043082*^9, 
   3.9568508214318123`*^9}, {3.9568508581783857`*^9, 
   3.9568509085051584`*^9}, {3.9568509529637403`*^9, 3.956850982636723*^9}, {
   3.9568510288679895`*^9, 3.9568510318931856`*^9}, {3.956851063748371*^9, 
   3.956851163594142*^9}, {3.9568511980558214`*^9, 3.956851198353567*^9}, {
   3.956851255427369*^9, 3.9568513683977456`*^9}, {3.956851444444462*^9, 
   3.956851727705621*^9}, {3.956851777290783*^9, 3.9568518807235346`*^9}, 
   3.9568519175029354`*^9, 3.9568519610055437`*^9, {3.9568520190890703`*^9, 
   3.956852064297407*^9}, {3.9568522417842703`*^9, 3.95685224192539*^9}, {
   3.956852302823823*^9, 3.9568523932082405`*^9}, {3.9568524420002027`*^9, 
   3.9568525085546484`*^9}, {3.9568525703913517`*^9, 
   3.9568525732691207`*^9}, {3.956852632219328*^9, 3.956852632738966*^9}, {
   3.956852706699481*^9, 3.9568527070452785`*^9}, {3.956852796030713*^9, 
   3.956852835660355*^9}, {3.956852879723462*^9, 3.956852879971566*^9}, 
   3.9568529212673616`*^9, {3.9568529766549697`*^9, 3.9568529778219013`*^9}, {
   3.9568531056053815`*^9, 3.9568531183731675`*^9}, {3.9568531865974283`*^9, 
   3.9568532069779587`*^9}, {3.9568532556009645`*^9, 3.956853373611284*^9}, {
   3.9568534039305363`*^9, 3.9568534664392757`*^9}, {3.956853649312219*^9, 
   3.956853761099674*^9}, {3.956853791427327*^9, 3.9568538077530127`*^9}, {
   3.9568539239871035`*^9, 3.9568539328976784`*^9}, {3.95685400583936*^9, 
   3.9568540061232777`*^9}, {3.9709958720506053`*^9, 
   3.9709958965792427`*^9}, {3.9709960870950704`*^9, 
   3.9709961725811853`*^9}, {3.97099620465654*^9, 3.970996204834508*^9}, {
   3.9709963341316376`*^9, 3.9709963463204536`*^9}, {3.970996413663994*^9, 
   3.9709964848198853`*^9}, {3.9709965523446703`*^9, 3.970996679425022*^9}, {
   3.970996747918202*^9, 3.9709969589812193`*^9}, {3.9709970829086576`*^9, 
   3.970997299457261*^9}, {3.9709974656919966`*^9, 3.9709976744904957`*^9}, {
   3.9709977927298183`*^9, 
   3.970997793418785*^9}},ExpressionUUID->"7317f63f-9ba2-4a28-aba1-\
9c9b9a101f1f"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1140, 567.6},
WindowMargins->{{0.6, Automatic}, {Automatic, 0.6}},
Magnification:>0.95 Inherited,
FrontEndVersion->"13.3 for Microsoft Windows (64-bit) (July 24, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"97e23136-932c-4e17-9fb4-0b1dbd180ebe"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 592, 9, 93, "Title",ExpressionUUID->"4db28663-3797-4aad-9051-57d37be2ea72"],
Cell[1175, 33, 531, 11, 81, "Section",ExpressionUUID->"e5b331c0-6828-4b1d-aed4-1109a543edce"],
Cell[CellGroupData[{
Cell[1731, 48, 325, 5, 51, "Section",ExpressionUUID->"1c6ad435-09d2-4551-8b34-9a9ea195289a"],
Cell[2059, 55, 92202, 2310, 3787, "Input",ExpressionUUID->"6137106e-4985-4fd4-80d5-f6abfa43274b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94298, 2370, 681, 19, 64, "Section",ExpressionUUID->"41f87859-03b9-4b51-8ebd-9e3c421e3dd1"],
Cell[94982, 2391, 94337, 2381, 3823, "Input",ExpressionUUID->"7317f63f-9ba2-4a28-aba1-9c9b9a101f1f"]
}, Open  ]]
}, Open  ]]
}
]
*)

