#Non-host effect - GLM on Direct Flight

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 3")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(ggplot2)   #Used for graphs
library(reshape2)  #Used for preparing data frame
library(RColorBrewer)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp2_raw_data_210222_v01.xlsx") 

#Remove parasitoids that did not respond
ForagingData <- ForagingData[ForagingData$Response !="0",]

#Prepare data file for plot
For.ALL<-data.frame(row.names = c(1:426))
For.ALL$TrCode <- ForagingData$TreatmentCode
For.ALL$FirstPlant <- ForagingData$FirstPlant
For.ALL <- as.data.frame.matrix(table(For.ALL))
For.ALL$TrCode <- c("CCC", "CCD", "CCM", "CRC","CRD", "CRM", "RCC", "RCD","RCM","RRC", "RRD","RRM")
ALL <- melt(For.ALL)

#Change order of treatments and plants
ALL$TrCode <- factor(ALL$TrCode, levels=c("RRC","CRC","RCC", "CCC", "RRD","CRD","RCD", "CCD", "RRM","CRM","RCM", "CCM"))
ALL$variable <- factor(ALL$variable, levels=c("4", "3", "2", "1"))


#Stacked bar graph
ggplot(ALL, aes(fill=variable, y=value, x=TrCode)) + 
  geom_bar(position="fill", stat="identity") +
  scale_fill_manual(values = c("gray31", "gray60", "gray70", "gray80")) +
  theme_minimal(base_size = 25)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank())+
  geom_hline(yintercept = 0) + geom_hline(yintercept = 1)
