#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 3")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
#library(emmeans)   #Used for comparing treatments
library(ggplot2)
library(jtools)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp3_raw_data_210223_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Set foraging time of non-successful foragers to time until observation was terminated
ForagingData$FirstTimePlant4 <- ifelse(ForagingData$HostPlantFound == 0, 1800, ForagingData$FirstTimePlant4)


#Create variables for time until reaching the last plant (foraging time), time spend on plants 1, 2 and 3 (TimePlant123) and time between landing first on plant 4 and attacking caterpillars on plant 4 (attack latency)
ForagingData$ForagingTime <- ForagingData$FirstTimePlant4 - ForagingData$GlassCylinder
ForagingData$logForagingTime <- log(ForagingData$ForagingTime)
ForagingData$logDuration123 <- log(ForagingData$Duration123 + 1)
ForagingData$AttackTime <- ForagingData$DurationTotal - ForagingData$FirstTimePlant4
ForagingData$logAttackTime <- log(ForagingData$AttackTime)

#Make new variables
ForagingData$Delia <- ifelse(ForagingData$Treatment == "Delia", 1,0) 
ForagingData$Mamestra <- ifelse(ForagingData$Treatment == "Mamestra", 1, 0)
ForagingData$Cultivar123 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                     ForagingData$TreatmentCode == "RCC"|ForagingData$TreatmentCode == "RCD"|ForagingData$TreatmentCode == "RCM", 
                                   "Rivera","Christmas Drumhead")
ForagingData$Cultivar4 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                   ForagingData$TreatmentCode == "CRC"|ForagingData$TreatmentCode == "CRD"|ForagingData$TreatmentCode == "CRM", 
                                 "Rivera","Christmas Drumhead")

#Make Rivera the reference
ForagingData$Cultivar123 <- factor(ForagingData$Cultivar123, levels=c("Rivera","Christmas Drumhead"))
ForagingData$Cultivar4 <- factor(ForagingData$Cultivar4, levels=c("Rivera","Christmas Drumhead"))

### Response rate
#Generalized Linear Mixed Models (GLMM) - Response
myGLM <- glmer(ResponseVolatiles ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                 Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                 Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                 (1|Date), 
               family = binomial(link = "logit"), data = ForagingData, na.action = na.fail)
myDredge <- dredge(myGLM)
subset(myDredge, delta < 2)
Response <- get.models(myDredge, 3)[[1]]


### Direct Flight
#Remove non-responders
ForagingData <- ForagingData[ForagingData$ResponseVolatiles !="0",]
#Remove parasitoids that did not find host plant
ForagingData <- ForagingData[ForagingData$HostPlantFound !="0",]


##GLMM - Direct flight to induced plant
#Last plant R/CD and host yes/no
myGLM <- glmer(DirectFlight ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                 Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                 Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                 (1|Date), 
                  family = binomial(link = "logit"), data = ForagingData, na.action = na.fail)
myDredge <- dredge(myGLM, rank = "AIC")
subset(myDredge, delta < 2)
Direct <- get.models(myDredge, 2)[[1]]



### Foraging Time
#LMM foraging time
myLMM.For <- lmer(logForagingTime ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                    Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                    Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                    (1|Date), 
                     data = ForagingData, na.action = na.fail)
myDredge.For <- dredge(myLMM.For, rank = "AIC")
subset(myDredge.For, delta < 2)
Foraging <- get.models(myDredge.For, 4)[[1]]

### Stay on plant 123
#LMM Stay on other plants
myLMM.123 <- lmer(logDuration123 ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                    Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                    Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                    (1|Date), 
                     data = ForagingData, na.action = na.fail)
myDredge.123 <- dredge(myLMM.123, rank = "AIC")
subset(myDredge.123, delta < 2)
Plant123 <- get.models(myDredge.123, 4)[[1]]


### Attack Time
#Remove non-attackers
ForagingData$AttackHost[is.na(ForagingData$AttackHost)] <- 0
ForagingData <- ForagingData[ForagingData$AttackHost != 0,]

#LMM Attack time
myLMM <- lmer(logAttackTime ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                   Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                   Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                   (1|Date),
                 data = ForagingData, na.action = na.fail)
myDredge <- dredge(myLMM, rank = "AIC")
subset(myDredge, delta < 2)
Attack <- get.models(myDredge, 2)[[1]]

#Figure all behavioural parameters
plot_summs(Response, Direct, Foraging, Plant123, Attack,  scale = TRUE, 
           legend.title = "Behaviour", model.names = c("Response", "Direct Flight", "Foraging Time", "Time on plant 123", "Attack Time"))

