#Non-host effect - GLM on Direct Flight

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 3")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
library(lmerTest)  #Used to get significances for lmer
library(emmeans)   #Used for comparing treatments
library(multcomp)  #Used for "cld" function
library(ggplot2)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp3_raw_data_210223_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Order treatments
ForagingData$TreatmentCode <- factor(ForagingData$TreatmentCode, levels=c("RRC","CRC","RCC", "CCC", "RRD","CRD","RCD", "CCD", "RRM","CRM","RCM", "CCM"))

#Make new variables
ForagingData$Delia <- ifelse(ForagingData$Treatment == "Delia", 1,0) 
ForagingData$Mamestra <- ifelse(ForagingData$Treatment == "Mamestra", 1, 0)
ForagingData$Cultivar123 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                     ForagingData$TreatmentCode == "RCC"|ForagingData$TreatmentCode == "RCD"|ForagingData$TreatmentCode == "RCM", 
                                   "Rivera","Christmas Drumhead")
ForagingData$Cultivar4 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                   ForagingData$TreatmentCode == "CRC"|ForagingData$TreatmentCode == "CRD"|ForagingData$TreatmentCode == "CRM", 
                                 "Rivera","Christmas Drumhead")

#Make Rivera the reference
ForagingData$Cultivar123 <- factor(ForagingData$Cultivar123, levels=c("Rivera","Christmas Drumhead"))
ForagingData$Cultivar4 <- factor(ForagingData$Cultivar4, levels=c("Rivera","Christmas Drumhead"))

#Remove parasitoids that did not respond
ForagingData <- ForagingData[ForagingData$ResponseVolatiles !="0",]

#Set foraging time of non-successful foragers to time until observation was terminated
ForagingData$FirstTimePlant4 <- ifelse(ForagingData$HostPlantFound == 0, 1800, ForagingData$FirstTimePlant4)

#Create new variable for time spend from leaving the glass cylinder to landing first on the last plant.
ForagingData$ForagingTime <- ForagingData$FirstTimePlant4 - ForagingData$GlassCylinder

#LMM foraging time
myLMM.For <- lmer(log(ForagingTime) ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                  Delia*Cultivar123 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 + 
                  Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                  (1|Date), 
                 data = ForagingData, na.action = na.fail)
myDredge.For <- dredge(myLMM.For, rank = "AIC")
subset(myDredge.For, delta < 2)

#LMM Stay on other plants
myLMM.123 <- lmer(log(Duration123+1) ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                    Delia*Cultivar123 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 + 
                    Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                       (1|Date), 
                     data = ForagingData, na.action = na.fail)
myDredge.123 <- dredge(myLMM.123, rank = "AIC")
subset(myDredge.123, delta < 2)


#Results
summary(get.models(myDredge.For, 1)[[1]])
  #Delia, Mamestra and CD on all plants enhance foraging time

summary(get.models(myDredge.123, 2)[[1]])
  #Delia, Mamestra and CD as first three plants enhance time spend on these plants
  #Cultivar identity of last plant has no effect

## Foraging Time
#Generalized Linear Mixed Models (GLMM) - Treatment effects
myGLM.TR <- lmer(log(ForagingTime) ~ TreatmentCode + (1 | Date), 
                  data = ForagingData, na.action = na.fail)
HSD_test <- emmeans(ref_grid(myGLM.TR, transform = "response"), pairwise ~ TreatmentCode)

#Results models w/ treatments
HSD_test
cld(HSD_test$emmeans)

emm <- emmeans(myGLM.TR, pairwise ~ TreatmentCode)
cld(emm$emmeans)

#Figure parameter estimates per treatment
Estimates <- data.frame(HSD_test$emmeans)
Estimates$Groups <- c("AB","AB","A","AB","AB","AB","AB","AB","AB","AB","AB","B") #Based on direct post-hoc
Estimates$Groups <- c("AB","AB","A","BC","AB","ABC","ABC","BC","ABC","C","ABC","C") #Based on post-hoc on original data

ggplot(Estimates, aes(TreatmentCode, response, ymin = lower.CL, ymax = upper.CL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())+ 
  geom_text(data=Estimates,aes(TreatmentCode,lower.CL-5,label=Groups),vjust=0, size = 8)

## Stay on plant 123
#Generalized Linear Mixed Models (GLMM) - Treatment effects
myGLM.TR.123 <- lmer(log(Duration123 + 1) ~ TreatmentCode + (1 | Date), 
                 data = ForagingData, na.action = na.fail)
HSD_test.123 <- emmeans(ref_grid(myGLM.TR.123, transform = "response"), pairwise ~ TreatmentCode)

#Results models w/ treatments
HSD_test.123
cld(HSD_test.123$emmeans)

emm.123 <- emmeans(myGLM.TR.123, pairwise ~ TreatmentCode)
cld(emm.123$emmeans)

#Figure parameter estimates per treatment
Estimates.123 <- data.frame(HSD_test.123$emmeans)
Estimates.123$lower.CL <- ifelse(Estimates.123$lower.CL < 0, 0, Estimates.123$lower.CL)
Estimates.123$Groups <- c("A","A","A","A","A","A","A","A","A","A","A","A") #Based on direct post-hoc
Estimates.123$Groups <- c("A","A","A","AB","AB","AB","A","ABC","ABC","BC","BC","C") #Based on post-hoc on original data

ggplot(Estimates.123, aes(TreatmentCode, response, ymin = lower.CL, ymax = upper.CL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())+ 
  geom_text(data=Estimates.123,aes(TreatmentCode,lower.CL-5,label=Groups),vjust=0, size = 8)
