#Non-host effect - GLM on Direct Flight

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 3")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
library(emmeans)   #Used for comparing treatments
library(multcomp)  #Used for "cld" function
library(ggplot2)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp3_raw_data_210223_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Order treatments
ForagingData$TreatmentCode <- factor(ForagingData$TreatmentCode, levels=c("RRC","CRC","RCC", "CCC", "RRD","CRD","RCD", "CCD", "RRM","CRM","RCM", "CCM"))

#Make new variables
ForagingData$Delia <- ifelse(ForagingData$Treatment == "Delia", 1,0) 
ForagingData$Mamestra <- ifelse(ForagingData$Treatment == "Mamestra", 1, 0)
ForagingData$Cultivar123 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                     ForagingData$TreatmentCode == "RCC"|ForagingData$TreatmentCode == "RCD"|ForagingData$TreatmentCode == "RCM", 
                                      "Rivera","Christmas Drumhead")
ForagingData$Cultivar4 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                   ForagingData$TreatmentCode == "CRC"|ForagingData$TreatmentCode == "CRD"|ForagingData$TreatmentCode == "CRM", 
                                    "Rivera","Christmas Drumhead")

#Make Rivera the reference
ForagingData$Cultivar123 <- factor(ForagingData$Cultivar123, levels=c("Rivera","Christmas Drumhead"))
ForagingData$Cultivar4 <- factor(ForagingData$Cultivar4, levels=c("Rivera","Christmas Drumhead"))

#Remove parasitoids that did not respond
ForagingData <- ForagingData[ForagingData$ResponseVolatiles !="0",]

#Generalized Linear Mixed Models (GLMM) - Finding the induced plant
myGLM <- glmer(HostPlantFound ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                  (1|Date), family = binomial(link = "logit"), data = ForagingData, na.action = na.fail)
summary(myGLM)
myDredge <- dredge(myGLM, rank = "AIC")
subset(myDredge, delta < 2)
summary(get.models(myDredge, 5)[[1]])

#Remove parasitoids that did not find host plant
ForagingData1 <- ForagingData[ForagingData$HostPlantFound !="0",]

#GLMM - Direct flight to induced plant
myGLM1 <- glmer(DirectFlight ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                 Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                 Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                 (1|Date), 
                 family = binomial(link = "logit"), data = ForagingData1, na.action = na.fail)
summary(myGLM1)
myDredge1 <- dredge(myGLM1, rank = "AIC")
subset(myDredge1, delta < 2)
summary(get.models(myDredge1, 2)[[1]])

#GLM - Time to induced plant
ForagingData1$logTime4 <- log(ForagingData1$FirstTimePlant4)
myGLM2 <- glmer(logTime4 ~Delia + Mamestra + Cultivar123 + Cultivar4 +
                  Delia*Cultivar123 + Mamestra*Cultivar123 + Delia*Cultivar4 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 +
                  Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                  (1|Date), 
                  data = ForagingData1, na.action = na.fail, family = gaussian)
summary(myGLM2)
myDredge2 <- dredge(myGLM2, rank = "AIC")
subset(myDredge2, delta < 2)
summary(get.models(myDredge2, 1)[[1]])

#Generalized Linear Mixed Models (GLMM) - Treatment effects
myGLM.TR <- glmer(DirectFlight ~ TreatmentCode + (1 | Date), 
                  family = binomial(link = "logit"), data = ForagingData1, na.action = na.fail)
HSD_test <- emmeans(ref_grid(myGLM.TR, transform = "response"), pairwise ~ TreatmentCode)

#Results models w/ treatments
HSD_test
cld(HSD_test$emmeans)

#Figure parameter estimates per treatment
Estimates <- data.frame(HSD_test$emmeans)
Estimates$asymp.UCL <- ifelse(Estimates$asymp.UCL > 1, 1, Estimates$asymp.UCL)
Estimates$Groups <- c("C","C","BC","ABC","ABC","ABC","C","ABC","ABC","A","ABC","AB")

ggplot(Estimates, aes(TreatmentCode, prob, ymin = asymp.LCL, ymax = asymp.UCL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())+ 
  geom_text(data=Estimates,aes(TreatmentCode,asymp.UCL+0.02,label=Groups),vjust=0, size = 8)