#Non-host effect - GLM on Direct Flight

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 3")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
library(lmerTest)  #Used to get significances for lmer
library(emmeans)   #Used for comparing treatments
library(multcomp)  #Used for "cld" function
library(ggplot2)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp3_raw_data_210223_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Order treatments
ForagingData$TreatmentCode <- factor(ForagingData$TreatmentCode, levels=c("RRC","CRC","RCC", "CCC", "RRD","CRD","RCD", "CCD", "RRM","CRM","RCM", "CCM"))

#Make new variables
ForagingData$Delia <- ifelse(ForagingData$Treatment == "Delia", 1,0) 
ForagingData$Mamestra <- ifelse(ForagingData$Treatment == "Mamestra", 1, 0)
ForagingData$Cultivar123 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                     ForagingData$TreatmentCode == "RCC"|ForagingData$TreatmentCode == "RCD"|ForagingData$TreatmentCode == "RCM", 
                                   "Rivera","Christmas Drumhead")
ForagingData$Cultivar4 <- ifelse(ForagingData$TreatmentCode == "RRC" | ForagingData$TreatmentCode == "RRD" |ForagingData$TreatmentCode == "RRM" |
                                   ForagingData$TreatmentCode == "CRC"|ForagingData$TreatmentCode == "CRD"|ForagingData$TreatmentCode == "CRM", 
                                 "Rivera","Christmas Drumhead")

#Make Rivera the reference
ForagingData$Cultivar123 <- factor(ForagingData$Cultivar123, levels=c("Rivera","Christmas Drumhead"))
ForagingData$Cultivar4 <- factor(ForagingData$Cultivar4, levels=c("Rivera","Christmas Drumhead"))

#Remove parasitoids that did not respond and those that did not attack any caterpillars
ForagingData <- ForagingData[ForagingData$ResponseVolatiles !="0",]
ForagingData$AttackHost[is.na(ForagingData$AttackHost)] <- 0
ForagingData <- ForagingData[ForagingData$AttackHost != 0,]

#Create New Variables
ForagingData$AttackTime <- ForagingData$DurationTotal - ForagingData$FirstTimePlant4

#LMM foraging time
myLMM <- lmer(log(AttackTime) ~ Delia + Mamestra + Cultivar123 + Cultivar4 +
                  Delia*Cultivar123 + Mamestra*Cultivar4 + Cultivar123*Cultivar4 + 
                  Delia*Cultivar123*Cultivar4 + Mamestra*Cultivar123*Cultivar4 +
                  (1|Date), 
                 data = ForagingData, na.action = na.fail)
myDredge <- dredge(myLMM, rank = "AIC")
subset(myDredge, delta < 2)


#Results
summary(get.models(myDredge, 2)[[1]])
  #Delia reduced attack time
  #Cultivar identity of first three plants has no significant effect on attack time
  #Mamestra and Cultivar identity of fourth plant not retained


#Generalized Linear Mixed Models (GLMM) - Treatment effects
myGLM.TR <- lmer(log(AttackTime) ~ TreatmentCode + (1 | Date), 
                 data = ForagingData, na.action = na.fail)
HSD_test <- emmeans(ref_grid(myGLM.TR, transform = "response"), pairwise ~ TreatmentCode)

#Results models w/ treatments
HSD_test
cld(HSD_test$emmeans)

emm <- emmeans(myGLM.TR, pairwise ~ TreatmentCode)
cld(emm$emmeans)

#Figure parameter estimates per treatment
Estimates <- data.frame(HSD_test$emmeans)
#Estimates$Groups <- c("A","A","A","A","A","A","A","A","A","A","A","A") #Based on direct post-hoc
#Estimates$Groups <- c("A","A","A","A","A","A","A","A","A","A","A","A") #Based on post-hoc on original data

ggplot(Estimates, aes(TreatmentCode, response, ymin = lower.CL, ymax = upper.CL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())
