#Non-host effect - GLM on Direct Flight

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 1")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(ggplot2)   #Used for graphs
library(reshape2)  #Used for preparing data frame
library(RColorBrewer)

# Load the data sheets from excel ----
ForagingData <- read_xlsx("Wind_exp2_raw_data_210222_v01.xlsx") 

#Remove parastioids that did not respond
ForagingData <- ForagingData[ForagingData$Response !="0",]

#Make two subset: 
  #(LP: Last Plant) full factorial for cultivar identity and herbivore presence of the last plant; and 
  #(AP: All Plants) full factorial for cultivar identity of the first three and last plant, and herbivore presence on the first three plants. 
ForagingData.LP <- ForagingData[ForagingData$TrCode == "RR" | ForagingData$TrCode == "RC" | ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" , ]
ForagingData.AP <- ForagingData[ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" | ForagingData$TrCode == "CRH" | ForagingData$TrCode == "CCH" | ForagingData$TrCode == "RHRH" | ForagingData$TrCode == "RHCH" | ForagingData$TrCode == "CHRH" | ForagingData$TrCode == "CHCH", ]

#Prepare data file for plot
For.LP<-data.frame(row.names = c(1:72))
For.LP$TrCode <- ForagingData.LP$TrCode
For.LP$FirstPlant <- ForagingData.LP$`First plant landing`
For.LP <- as.data.frame.matrix(table(For.LP))
For.LP$TrCode <- c("RC", "RCH", "RR", "RRH")
LP <- melt(For.LP)

For.AP<-data.frame(row.names = c(1:186))
For.AP$TrCode <- ForagingData.AP$TrCode
For.AP$FirstPlant <- ForagingData.AP$`First plant landing`
For.AP <- as.data.frame.matrix(table(For.AP))
For.AP$TrCode <- c("CCH", "CHCH", "CHRH", "CRH", "RCH", "RHCH", "RHRH", "RRH")
AP <- melt(For.AP)

For.ALL<-data.frame(row.names = c(1:215))
For.ALL$TrCode <- ForagingData$TrCode
For.ALL$FirstPlant <- ForagingData$`First plant landing`
For.ALL <- as.data.frame.matrix(table(For.ALL))
For.ALL$TrCode <- c("CCH", "CHCH", "CHRH", "CRH","RC", "RCH", "RHCH", "RHRH","RR", "RRH")
ALL <- melt(For.ALL)

#Change order of treatments and plants
LP$TrCode <- factor(LP$TrCode, levels=c("RR", "RC", "RRH", "RCH"))
LP$variable <- factor(LP$variable, levels=c("4", "3", "2", "1"))

AP$TrCode <- factor(AP$TrCode, levels=c("RRH", "RCH", "CRH", "CCH","RHRH", "RHCH", "CHRH", "CHCH"))
AP$variable <- factor(AP$variable, levels=c("4", "3", "2", "1"))

ALL$TrCode <- factor(ALL$TrCode, levels=c("RR","RC","RRH", "RCH", "CRH", "CCH","RHRH", "RHCH", "CHRH", "CHCH"))
ALL$variable <- factor(ALL$variable, levels=c("4", "3", "2", "1"))


#Stacked bar graph
ggplot(LP, aes(fill=variable, y=value, x=TrCode)) + 
  geom_bar(position="fill", stat="identity") +
  scale_fill_manual(values = c("gray31", "gray60", "gray70", "gray80")) +
  theme_minimal(base_size = 25)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank())+
  geom_hline(yintercept = 0) + geom_hline(yintercept = 1) 

ggplot(AP, aes(fill=variable, y=value, x=TrCode)) + 
  geom_bar(position="fill", stat="identity") +
  scale_fill_manual(values = c("gray31", "gray60", "gray70", "gray80")) +
  theme_minimal(base_size = 25)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank())+
  geom_hline(yintercept = 0) + geom_hline(yintercept = 1) 

ggplot(ALL, aes(fill=variable, y=value, x=TrCode)) + 
  geom_bar(position="fill", stat="identity") +
  scale_fill_manual(values = c("gray31", "gray60", "gray70", "gray80")) +
  theme_minimal(base_size = 25)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank())+
  geom_hline(yintercept = 0) + geom_hline(yintercept = 1)
