#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 1")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
#library(ggplot2)
library(jtools)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp2_raw_data_210222_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Set foraging time of non-successful foragers to time until observation was terminated
ForagingData$`Time until reaching plant 4` <- ifelse(ForagingData$`Landing on plant 4` == 0, ForagingData$`Total duration`, ForagingData$`Time until reaching plant 4`)

#Create variables for time until reaching the last plant (foraging time), time spend on plants 1, 2 and 3 (TimePlant123) and time between landing first on plant 4 and attacking caterpillars on plant 4 (attack latency)
ForagingData$ForagingTime <- ForagingData$`Time until reaching plant 4` - ForagingData$`Total duration in glass cylinder`
ForagingData$logForagingTime <- log(ForagingData$ForagingTime)
ForagingData$TimePlant123 <- ForagingData$`Total duration of stays on a plant` - ForagingData$`Total duration stay on plant 4`
ForagingData$logTimePlant123 <- log(ForagingData$TimePlant123+1)
ForagingData$AttackTime <- ForagingData$`Time until attacking on plant 4` - ForagingData$`Time until reaching plant 4`
ForagingData$logAttackTime <- log(ForagingData$AttackTime)

#Make two subset: 
  #(LP: Last Plant) full factorial for cultivar identity and herbivore presence of the last plant; and 
  #(AP: All Plants) full factorial for cultivar identity of the first three and last plant, and herbivore presence on the first three plants. 
ForagingData.LP <- ForagingData[ForagingData$TrCode == "RR" | ForagingData$TrCode == "RC" | ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" , ]
ForagingData.1H <- ForagingData[ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" | ForagingData$TrCode == "CRH" | ForagingData$TrCode == "CCH", ]
ForagingData.4H <- ForagingData[ForagingData$TrCode == "RHRH" | ForagingData$TrCode == "RHCH" | ForagingData$TrCode == "CHRH" | ForagingData$TrCode == "CHCH",]

### Response rate
#Generalized Linear Models (GLM) - Last plant R/CD and host yes/no (Interaction AND random effect of date not possible)
myGLM.LP <- glm(Response ~ Cultivar4 + Host4 + 
                  Cultivar4*Host4, 
                family = binomial(link = "logit"), data = ForagingData.LP, na.action = na.fail)
myDredge.LP <- dredge(myGLM.LP, rank = AIC)
subset(myDredge.LP, delta < 2)
Response.LP <- get.models(myDredge.LP, 2)[[1]]

#Generalized Linear Mixed Models (GLMM) - First plants R/CD, First plants host yes/no, Last plant R/CD
myGLM.1H <- glmer(Response ~ Cultivar123 + Cultivar4 + 
                    Cultivar123*Cultivar4  +
                    (1 | Date), 
                  family = binomial(link = "logit"), data = ForagingData.1H, na.action = na.fail)
myDredge.1H <- dredge(myGLM.1H, rank = AIC)
subset(myDredge.1H, delta < 2)
Response.1H <- get.models(myDredge.1H, 2)[[1]]
summary(Response.1H)

myGLM.4H <- glmer(Response ~ Cultivar123 + Cultivar4 + 
                    Cultivar123*Cultivar4  +
                    (1 | Date), 
                  family = binomial(link = "logit"), data = ForagingData.4H, na.action = na.fail)
myDredge.4H <- dredge(myGLM.4H, rank = AIC)
subset(myDredge.4H, delta < 2)
Response.4H <- get.models(myDredge.4H, 3)[[1]]
summary(Response.4H)

### Direct Flight
#Remove non-responders
ForagingData.LP <- ForagingData.LP[ForagingData.LP$Response !="0",]
ForagingData.1H <- ForagingData.1H[ForagingData.1H$Response !="0",]
ForagingData.4H <- ForagingData.4H[ForagingData.4H$Response !="0",]

##GLMM - Direct flight to induced plant
#Last plant R/CD and host yes/no
myGLM.LP <- glmer(DirectFlight ~ Cultivar4 + Host4 +
                    Cultivar4*Host4 +
                    (1|Date), 
                  family = binomial(link = "logit"), data = ForagingData.LP, na.action = na.fail)
myDredge.LP <- dredge(myGLM.LP, rank = "AIC")
subset(myDredge.LP, delta < 2)
Direct.LP <- get.models(myDredge.LP, 1)[[1]]

#First plants R/CD, First plants host yes/no, Last plant R/CD
myGLM.1H <- glmer(DirectFlight ~ Cultivar123 + Cultivar4 + 
                    Cultivar123*Cultivar4  +
                    (1|Date), 
                  family = binomial(link = "logit"), data = ForagingData.1H, na.action = na.fail)
myDredge.1H <- dredge(myGLM.1H, rank = "AIC")
subset(myDredge.1H, delta < 2)
Direct.1H <- get.models(myDredge.1H, 1)[[1]]

myGLM.4H <- glmer(DirectFlight ~ Cultivar123 + Cultivar4 + 
                    Cultivar123*Cultivar4  +
                    (1|Date), 
                  family = binomial(link = "logit"), data = ForagingData.4H, na.action = na.fail)
myDredge.4H <- dredge(myGLM.4H, rank = "AIC")
subset(myDredge.4H, delta < 2)
Direct.4H <- get.models(myDredge.4H, 2)[[1]]


### Foraging Time
#LMM foraging time
myLMM.For.LP <- lmer(logForagingTime ~ Host4 + Cultivar4 +
                       Host4*Cultivar4 + 
                       (1|Date), 
                     data = ForagingData.LP, na.action = na.fail)
myDredge.For.LP <- dredge(myLMM.For.LP, rank = "AIC")
subset(myDredge.For.LP, delta < 2)
Foraging.LP <- get.models(myDredge.For.LP, 1)[[1]]

myLMM.For.1H <- lmer(logForagingTime ~ Cultivar123 + Cultivar4 + 
                       Cultivar123*Cultivar4  +
                       (1|Date), 
                     data = ForagingData.1H, na.action = na.fail)
myDredge.For.1H <- dredge(myLMM.For.1H, rank = "AIC")
subset(myDredge.For.1H, delta < 2)
Foraging.1H <- get.models(myDredge.For.1H, 1)[[1]]

myLMM.For.4H <- lmer(logForagingTime ~ Cultivar123 + Cultivar4 + 
                       Cultivar123*Cultivar4  +
                       (1|Date), 
                     data = ForagingData.4H, na.action = na.fail)
myDredge.For.4H <- dredge(myLMM.For.4H, rank = "AIC")
subset(myDredge.For.4H, delta < 2)
Foraging.4H <- get.models(myDredge.For.4H, 1)[[1]]


### Stay on plant 123
#LMM Stay on other plants
myLMM.123.LP <- lmer(logTimePlant123 ~ Host4 + Cultivar4 +
                       Host4*Cultivar4 + 
                       (1|Date), 
                     data = ForagingData.LP, na.action = na.fail)
myDredge.123.LP <- dredge(myLMM.123.LP, rank = "AIC")
subset(myDredge.123.LP, delta < 2)
Plant123.LP <- get.models(myDredge.123.LP, 3)[[1]]

myLMM.123.1H <- lmer(logTimePlant123 ~ Cultivar123 + Cultivar4 + 
                       Cultivar123*Cultivar4  +
                       (1|Date), 
                     data = ForagingData.1H, na.action = na.fail)
myDredge.123.1H <- dredge(myLMM.123.1H, rank = "AIC")
subset(myDredge.123.1H, delta < 2)
Plant123.1H <- get.models(myDredge.123.1H, 2)[[1]]

myLMM.123.4H <- lmer(logTimePlant123 ~ Cultivar123 + Cultivar4 + 
                       Cultivar123*Cultivar4  +
                       (1|Date), 
                     data = ForagingData.4H, na.action = na.fail)
myDredge.123.4H <- dredge(myLMM.123.4H, rank = "AIC")
subset(myDredge.123.4H, delta < 2)
Plant123.4H <- get.models(myDredge.123.4H, 2)[[1]]

### Attack Time
#Remove non-attackers
ForagingData.1H <- ForagingData.1H[ForagingData.1H$`Landing on plant 4` !="0",]
ForagingData.1H <- ForagingData.1H[ForagingData.1H$`Total number of attacks on plant 4` !="0",]

ForagingData.4H <- ForagingData.4H[ForagingData.4H$`Landing on plant 4` !="0",]
ForagingData.4H <- ForagingData.4H[ForagingData.4H$`Total number of attacks on plant 4` !="0",]

#LMM foraging time
myLMM.1H <- lmer(logAttackTime ~ Cultivar123 + Cultivar4 + 
                   Cultivar123*Cultivar4  +
                   (1|Date), 
                 data = ForagingData.1H, na.action = na.fail)
myDredge.1H <- dredge(myLMM.1H, rank = "AICc")
subset(myDredge.1H, delta < 2)
Attack.1H <- get.models(myDredge.1H, 4)[[1]]

myLMM.4H <- lmer(logAttackTime ~ Cultivar123 + Cultivar4 + 
                   Cultivar123*Cultivar4  +
                   (1|Date), 
                 data = ForagingData.4H, na.action = na.fail)
myDredge.4H <- dredge(myLMM.4H, rank = "AICc")
subset(myDredge.4H, delta < 2)
Attack.4H <- get.models(myDredge.4H, 1)[[1]]

#Figure all behavioural parameters
plot_summs(Response.LP, Direct.LP, Foraging.LP, Plant123.LP,  scale = TRUE, 
           legend.title = "Behaviour", model.names = c("Response", "Direct Flight", "Foraging Time", "Time on plant 123"))
          

plot_summs(Response.1H, Direct.1H, Foraging.1H, Plant123.1H, Attack.1H,  scale = TRUE, 
           legend.title = "Behaviour", model.names = c("Response", "Direct Flight", "Foraging Time", "Time on plant 123", "Attack Time"))


plot_summs(Response.4H, Direct.4H, Foraging.4H,  scale = TRUE, 
           legend.title = "Behaviour", model.names = c("Response", "Direct Flight", "Foraging Time"))

summary(Attack.4H)
