#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 1")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
#library(emmeans)   #Used for comparing treatments
library(ggplot2)
library(jtools)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp2_raw_data_210222_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Set foraging time of non-successful foragers to time until observation was terminated
ForagingData$`Time until reaching plant 4` <- ifelse(ForagingData$`Landing on plant 4` == 0, ForagingData$`Total duration`, ForagingData$`Time until reaching plant 4`)

#Create variables for time until reaching the last plant (foraging time), time spend on plants 1, 2 and 3 (TimePlant123) and time between landing first on plant 4 and attacking caterpillars on plant 4 (attack latency)
ForagingData$ForagingTime <- ForagingData$`Time until reaching plant 4` - ForagingData$`Total duration in glass cylinder`
ForagingData$logForagingTime <- log(ForagingData$ForagingTime)
ForagingData$TimePlant123 <- ForagingData$`Total duration of stays on a plant` - ForagingData$`Total duration stay on plant 4`
ForagingData$logTimePlant123 <- log(ForagingData$TimePlant123+1)
ForagingData$AttackTime <- ForagingData$`Time until attacking on plant 4` - ForagingData$`Time until reaching plant 4`
ForagingData$logAttackTime <- log(ForagingData$AttackTime)

#Make two subset: 
  #(LP: Last Plant) full factorial for cultivar identity and herbivore presence of the last plant; and 
  #(AP: All Plants) full factorial for cultivar identity of the first three and last plant, and herbivore presence on the first three plants. 
ForagingData.LP <- ForagingData[ForagingData$TrCode == "RR" | ForagingData$TrCode == "RC" | ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" , ]
ForagingData.AP <- ForagingData[ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" | ForagingData$TrCode == "CRH" | ForagingData$TrCode == "CCH" | ForagingData$TrCode == "RHRH" | ForagingData$TrCode == "RHCH" | ForagingData$TrCode == "CHRH" | ForagingData$TrCode == "CHCH", ]

### Response rate
#Generalized Linear Models (GLM) - Last plant R/CD and host yes/no (Interaction AND random effect of date not possible)
myGLM.LP <- glm(Response ~ Cultivar4 + Host4 + 
                  Cultivar4*Host4, 
                family = binomial(link = "logit"), data = ForagingData.LP, na.action = na.fail)
myDredge.LP <- dredge(myGLM.LP, rank = AIC)
subset(myDredge.LP, delta < 2)
Response.LP <- get.models(myDredge.LP, 2)[[1]]

#Generalized Linear Mixed Models (GLMM) - First plants R/CD, First plants host yes/no, Last plant R/CD
myGLM.AP <- glmer(Response ~ Cultivar123 + Host123 + Cultivar4 + 
                    Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                    Cultivar123*Host123*Cultivar4 + 
                    (1 | Date), 
                  family = binomial(link = "logit"), data = ForagingData.AP, na.action = na.fail)
myDredge.AP <- dredge(myGLM.AP, rank = AIC)
subset(myDredge.AP, delta < 2)
Response.AP <- get.models(myDredge.AP, 3)[[1]]


### Direct Flight
#Remove non-responders
ForagingData.LP <- ForagingData.LP[ForagingData.LP$Response !="0",]
ForagingData.AP <- ForagingData.AP[ForagingData.AP$Response !="0",]

##GLMM - Direct flight to induced plant
#Last plant R/CD and host yes/no
myGLM.LP <- glmer(DirectFlight ~ Cultivar4 + Host4 +
                    Cultivar4*Host4 +
                    (1|Date), 
                  family = binomial(link = "logit"), data = ForagingData.LP, na.action = na.fail)
myDredge.LP <- dredge(myGLM.LP, rank = "AIC")
subset(myDredge.LP, delta < 2)
Direct.LP <- get.models(myDredge.LP, 1)[[1]]
#Set-ups with hosts on plant 4 have higher direct flight
#Cultivar of plant 4 does not matter for direct flight


#First plants R/CD, First plants host yes/no, Last plant R/CD
myGLM.AP <- glmer(DirectFlight ~ Cultivar123 + Host123 + Cultivar4 + 
                    Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                    Cultivar123*Host123*Cultivar4 +
                    (1|Date), 
                  family = binomial(link = "logit"), data = ForagingData.AP, na.action = na.fail)
myDredge.AP <- dredge(myGLM.AP, rank = "AIC")
subset(myDredge.AP, delta < 2)
Direct.AP <- get.models(myDredge.AP, 1)[[1]]


### Foraging Time
#LMM foraging time
myLMM.For.LP <- lmer(logForagingTime ~ Host4 + Cultivar4 +
                       Host4*Cultivar4 + 
                       (1|Date), 
                     data = ForagingData.LP, na.action = na.fail)
myDredge.For.LP <- dredge(myLMM.For.LP, rank = "AIC")
subset(myDredge.For.LP, delta < 2)
Foraging.LP <- get.models(myDredge.For.LP, 1)[[1]]

myLMM.For.AP <- lmer(logForagingTime ~ Cultivar123 + Host123 + Cultivar4 +
                       Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                       Cultivar123*Host123*Cultivar4 +
                       (1|Date), 
                     data = ForagingData.AP, na.action = na.fail)
myDredge.For.AP <- dredge(myLMM.For.AP, rank = "AIC")
subset(myDredge.For.AP, delta < 2)
Foraging.AP <- get.models(myDredge.For.AP, 4)[[1]]

### Stay on plant 123
#LMM Stay on other plants
myLMM.123.LP <- lmer(logTimePlant123 ~ Host4 + Cultivar4 +
                       Host4*Cultivar4 + 
                       (1|Date), 
                     data = ForagingData.LP, na.action = na.fail)
myDredge.123.LP <- dredge(myLMM.123.LP, rank = "AIC")
subset(myDredge.123.LP, delta < 2)
Plant123.LP <- get.models(myDredge.123.LP, 2)[[1]]

myLMM.123.AP <- lmer(logTimePlant123 ~ Cultivar123 + Host123 + Cultivar4 +
                       Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                       Cultivar123*Host123*Cultivar4 +
                       (1|Date), 
                     data = ForagingData.AP, na.action = na.fail)
myDredge.123.AP <- dredge(myLMM.123.AP, rank = "AIC")
subset(myDredge.123.AP, delta < 2)
Plant123.AP <- get.models(myDredge.123.AP, 4)[[1]]


### Attack Time
#Remove non-attackers
ForagingData.AP <- ForagingData.AP[ForagingData.AP$`Landing on plant 4` !="0",]
ForagingData.AP <- ForagingData.AP[ForagingData.AP$`Total number of attacks on plant 4` !="0",]

#LMM foraging time
myLMM.AP <- lmer(logAttackTime ~ Cultivar123 + Host123 + Cultivar4 +
                   Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                   Cultivar123*Host123*Cultivar4 +
                   (1|Date), 
                 data = ForagingData.AP, na.action = na.fail)
myDredge.AP <- dredge(myLMM.AP, rank = "AICc")
subset(myDredge.AP, delta < 2)
Attack.AP <- get.models(myDredge.AP, 2)[[1]]

#Figure all behavioural parameters
plot_summs(Response.LP, Direct.LP, Foraging.LP, Plant123.LP,  scale = TRUE, 
           legend.title = "Behaviour", model.names = c("Response", "Direct Flight", "Foraging Time", "Time on plant 123"))
          

plot_summs(Response.AP, Direct.AP, Foraging.AP, Plant123.AP, Attack.AP,  scale = TRUE, 
           legend.title = "Behaviour", model.names = c("Response", "Direct Flight", "Foraging Time", "Time on plant 123", "Attack Time"))

