#Host and cultivar effect - GLM on Response

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 1")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
library(emmeans)   #Used for comparing treatments
library(multcomp)
library(ggplot2)

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp2_raw_data_210222_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Order treatments
ForagingData$TrCode <- factor(ForagingData$TrCode, levels=c("RR","RC","RRH", "RCH", "CRH", "CCH","RHRH", "RHCH", "CHRH", "CHCH"))

#Make two subset: 
  #(LP: Last Plant) full factorial for cultivar identity and herbivore presence of the last plant; and 
  #(AP: All Plants) full factorial for cultivar identity of the first three and last plant, and herbivore presence on the first three plants. 
ForagingData.LP <- ForagingData[ForagingData$TrCode == "RR" | ForagingData$TrCode == "RC" | ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" , ]
ForagingData.AP <- ForagingData[ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" | ForagingData$TrCode == "CRH" | ForagingData$TrCode == "CCH" | ForagingData$TrCode == "RHRH" | ForagingData$TrCode == "RHCH" | ForagingData$TrCode == "CHRH" | ForagingData$TrCode == "CHCH", ]

#Generalized Linear Models (GLM) - Last plant R/CD and host yes/no (Interaction AND random effect of date not possible)
myGLM.LP <- glm(Response ~ Cultivar4 + Host4 + 
                  Cultivar4*Host4, 
                  family = binomial(link = "logit"), data = ForagingData.LP, na.action = na.fail)
myDredge.LP <- dredge(myGLM.LP, rank = AIC)
subset(myDredge.LP, delta < 2)
Response.LP <- get.models(myDredge.LP, 2)[[1]]

#Generalized Linear Mixed Models (GLMM) - First plants R/CD, First plants host yes/no, Last plant R/CD
myGLM.AP <- glmer(Response ~ Cultivar123 + Host123 + Cultivar4 + 
                    Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +  
                    (1 | Date), 
                    family = binomial(link = "logit"), data = ForagingData.AP, na.action = na.fail)
myDredge.AP <- dredge(myGLM.AP, rank = AIC)
subset(myDredge.AP, delta < 2)
Response.AP <- get.models(myDredge.AP, 3)[[1]]

#Results models w/ dummy variables
summary(Response.LP)
summary(Response.AP)
summary(get.models(myDredge.AP, 3)[[1]])


#Generalized Linear Mixed Models (GLMM) - Treatment effects
myGLM.TR <- glmer(Response ~ TrCode + (1 | Date), 
                    family = binomial(link = "logit"), data = ForagingData, na.action = na.fail)
HSD_test <- emmeans(ref_grid(myGLM.TR, transform = "response"), pairwise ~ TrCode)

#Results models w/ treatments
HSD_test
cld(HSD_test$emmeans)

#Figure parameter estimates per treatment
Estimates <- data.frame(HSD_test$emmeans)
Estimates$Groups <- c("A","A","AB","BCD","ABCD","ABC","BCD","BCD","CD","D")

ggplot(Estimates, aes(TrCode, prob, ymin = asymp.LCL, ymax = asymp.UCL))+
    geom_pointrange(size = 1, shape = 3)+
    theme_classic(base_size = 30)+
    theme(axis.title.x = element_blank(), 
          axis.title.y = element_blank(), 
          panel.grid.major.x = element_blank(),
          panel.grid.minor.y = element_blank(),
          panel.grid.major.y = element_blank(),
          axis.line = element_line())+ 
    geom_text(data=Estimates,aes(TrCode,asymp.UCL+0.05,label=Groups),vjust=0, size = 8)
