#Non-host effect - GLM on Direct Flight

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 1")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
library(lmerTest)  #Used to get significances for lmer
library(emmeans)   #Used for comparing treatments
library(ggplot2)   #Used for graphs

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp2_raw_data_210222_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Order treatments
ForagingData$TrCode <- factor(ForagingData$TrCode, levels=c("RR","RC","RRH", "RCH", "CRH", "CCH","RHRH", "RHCH", "CHRH", "CHCH"))

#Remove parasitoids that did not respond
ForagingData <- ForagingData[ForagingData$Response !="0",]

#Set foraging time of non-successful foragers to time until observation was terminated
ForagingData$`Time until reaching plant 4` <- ifelse(ForagingData$`Landing on plant 4` == 0, ForagingData$`Total duration`, ForagingData$`Time until reaching plant 4`)

#Create variables for time until reaching the last plant (foraging time) and time spend on plants 1, 2 and 3 (TimePlant123)
ForagingData$ForagingTime <- ForagingData$`Time until reaching plant 4` - ForagingData$`Total duration in glass cylinder`

ForagingData$TimePlant123 <- ForagingData$`Total duration of stays on a plant` - ForagingData$`Total duration stay on plant 4`
ForagingData$LogTimePlant123 <- log(ForagingData$TimePlant123+1)

#Make two subset: 
#(LP: Last Plant) full factorial for cultivar identity and herbivore presence of the last plant; and 
#(AP: All Plants) full factorial for cultivar identity of the first three and last plant, and herbivore presence on the first three plants. 
ForagingData.LP <- ForagingData[ForagingData$TrCode == "RR" | ForagingData$TrCode == "RC" | ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" , ]
ForagingData.AP <- ForagingData[ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" | ForagingData$TrCode == "CRH" | ForagingData$TrCode == "CCH" | ForagingData$TrCode == "RHRH" | ForagingData$TrCode == "RHCH" | ForagingData$TrCode == "CHRH" | ForagingData$TrCode == "CHCH", ]

#LMM foraging time
myLMM.For.LP <- lmer(log(ForagingTime) ~ Host4 + Cultivar4 +
                  Host4*Cultivar4 + 
                  (1|Date), 
                 data = ForagingData.LP, na.action = na.fail)
myDredge.For.LP <- dredge(myLMM.For.LP, rank = "AIC")
subset(myDredge.For.LP, delta < 2)

myLMM.For.AP <- lmer(log(ForagingTime) ~ Cultivar123 + Host123 + Cultivar4 +
                   Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                   Cultivar123*Host123*Cultivar4 +
                   (1|Date), 
                 data = ForagingData.AP, na.action = na.fail)
myDredge.For.AP <- dredge(myLMM.For.AP, rank = "AIC")
subset(myDredge.For.AP, delta < 2)

#LMM Stay on other plants
myLMM.123.LP <- lmer(LogTimePlant123 ~ Host4 + Cultivar4 +
                       Host4*Cultivar4 + 
                       (1|Date), 
                     data = ForagingData.LP, na.action = na.fail)
myDredge.123.LP <- dredge(myLMM.123.LP, rank = "AIC")
subset(myDredge.123.LP, delta < 2)

myLMM.123.AP <- lmer(LogTimePlant123 ~ Cultivar123 + Host123 + Cultivar4 +
                       Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                       Cultivar123*Host123*Cultivar4 +
                       (1|Date), 
                     data = ForagingData.AP, na.action = na.fail)
myDredge.123.AP <- dredge(myLMM.123.AP, rank = "AIC")
subset(myDredge.123.AP, delta < 2)

#Results
Foraging.LP <- get.models(myDredge.For.LP, 1)[[1]]
summary(Foraging.LP)
  #Hosts on plant 4 significantly decreases foraging time, 
  #Identity cultivar 4 not retained

Foraging.AP <- get.models(myDredge.For.AP, 4)[[1]]
summary(Foraging.AP)
  #Hosts on plant 123 significantly increase foraging time, no effect for cultivar plant 4
  #Near significant increase of foraging time when first three plants are CD

Plant123.LP <- get.models(myDredge.123.LP, 2)[[1]]
summary(Plant123.LP)
  #Hosts on plant 4 significantly decreases time spent on plants 123
  #Cultivar of plant 4 had no significant effect on time spent on plants 123

Plant123.AP <- get.models(myDredge.123.AP, 4)[[1]]
summary(Plant123.AP)
  #Hosts on plant 123 significantly increases time spent on plants 123
  #Cultivar identity of both the first three or the last plant no significant effect
  #Interaction between cultivar of plant 4 and hosts on 123 not significant.


#Linear Mixed Models (LMM) - Treatment effects - Foraging Time
myLLM.TR.For <- lmer(log(ForagingTime) ~ TrCode + (1 | Date), 
                  data = ForagingData, na.action = na.fail)
HSD_test.For <- emmeans(ref_grid(myLLM.TR.For, transform = "response"), pairwise ~ TrCode)

#Results models w/ treatments
HSD_test.For
cld(HSD_test.For$emmeans)

emm.For <- emmeans(myLLM.TR.For, pairwise ~ TrCode)
cld(emm.For$emmeans)

#Figure parameter estimates per treatment
Estimates <- data.frame(HSD_test.For$emmeans)
Estimates$Groups <- c("BC","C","A","A","AB","A","C","C","C","C")

ggplot(Estimates, aes(TrCode, response, ymin = lower.CL, ymax = upper.CL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())+
  geom_text(data=Estimates,aes(TrCode,upper.CL+ 5,label=Groups),vjust=0, size = 8)


#Linear Mixed Models (LMM) - Treatment effects - Time on plant 123
myLLM.TR.123 <- lmer(log(TimePlant123 + 1) ~ TrCode + (1 | Date), 
                     data = ForagingData, na.action = na.fail)
HSD_test.123 <- emmeans(ref_grid(myLLM.TR.123, transform = "response"), pairwise ~ TrCode)

#Results models w/ treatments
HSD_test.123
cld(HSD_test.123$emmeans)

emm.123 <- emmeans(myLLM.TR.123, pairwise ~ TrCode)
cld(emm.123$emmeans)

#Figure parameter estimates per treatment
Estimates.123 <- data.frame(HSD_test.123$emmeans)
Estimates.123$lower.CL <- ifelse(Estimates.123$lower.CL < 0, 0, Estimates.123$lower.CL)
Estimates.123$Groups <- c("ABC","BCD","AB","A","AB","A","CD","CD","CD","D")

ggplot(Estimates.123, aes(TrCode, response, ymin = lower.CL, ymax = upper.CL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())+
  geom_text(data=Estimates.123,aes(TrCode,upper.CL+20,label=Groups),vjust=0, size = 8)
