#LMM on Attack Time 

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("C:/Users/croij001/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis/Exp. 1")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(MuMIn)     #Used for "dredge" function
library(lme4)      #Used for "glmer" function
library(lmerTest)  #Used to get significances for lmer
library(emmeans)   #Used for comparing treatments
library(ggplot2)   #Used for graphs
library(multcomp)  #Used for "cld' function

# Load the data sheets from excel ----
ForagingData <- read_xlsx( "Wind_exp2_raw_data_210222_v01.xlsx") 

#Transform data type
ForagingData$Date <- as.factor(ForagingData$Date)

#Order treatments
ForagingData$TrCode <- factor(ForagingData$TrCode, levels=c("RR","RC","RRH", "RCH", "CRH", "CCH","RHRH", "RHCH", "CHRH", "CHCH"))

#Remove parasitoids that did not respond and that did not attack
ForagingData <- ForagingData[ForagingData$Response !="0",]
ForagingData <- ForagingData[ForagingData$`Landing on plant 4` !="0",]
ForagingData <- ForagingData[ForagingData$`Total number of attacks on plant 4` !="0",]

#Create variables for attack latency --> the time between landing on plant 4 for the first time and attacking a caterpillar
ForagingData$AttackTime <- ForagingData$`Time until attacking on plant 4` - ForagingData$`Time until reaching plant 4`
ForagingData$LogAttackTime <- log(ForagingData$AttackTime)

#Remove treatments without any herbivores on the last plant
ForagingData.AP <- ForagingData[ForagingData$TrCode == "RRH" | ForagingData$TrCode == "RCH" | ForagingData$TrCode == "CRH" | ForagingData$TrCode == "CCH" | ForagingData$TrCode == "RHRH" | ForagingData$TrCode == "RHCH" | ForagingData$TrCode == "CHRH" | ForagingData$TrCode == "CHCH", ]

#Linear Mixed Models (LMM) - Effects of culitvar identity and host presence - Attack Latency
myLMM.AP <- lmer(LogAttackTime ~ Cultivar123 + Host123 + Cultivar4 +
                   Cultivar123*Host123 + Cultivar123*Cultivar4 + Host123*Cultivar4 +
                   Cultivar123*Host123*Cultivar4 +
                   (1|Date), 
                 data = ForagingData.AP, na.action = na.fail)
myDredge.AP <- dredge(myLMM.AP, rank = "AICc")
subset(myDredge.AP, delta < 2)


#Results models w/ cultivar identity and herbivore presence
Attack.AP <- get.models(myDredge.AP, 2)[[1]]
summary(Attack.AP)
  #Hosts on plant123 significantly reduced attack time on the last plant
  #Cultivar identity of plant 4 has no significant effect on attack time
  #Cultivar identity of first three plants not retained


#Linear Mixed Models (LMM) - Treatment effects - Attack Latency
myLLM.TR <- lmer(log(AttackTime) ~ TrCode + (1 | Date), 
                     data = ForagingData, na.action = na.fail)
HSD_test <- emmeans(ref_grid(myLLM.TR, transform = "response"), pairwise ~ TrCode)

#Results models w/ treatments
HSD_test
cld(HSD_test$emmeans)

emm.123 <- emmeans(myLLM.TR, pairwise ~ TrCode)
cld(emm.123$emmeans)

#Figure parameter estimates per treatment
Estimates <- data.frame(HSD_test$emmeans)
Estimates$lower.CL <- ifelse(Estimates$lower.CL < 0, 0, Estimates$lower.CL)
#Estimates$Groups <- c("ABC","BCD","AB","A","AB","A","CD","CD","CD","D")

ggplot(Estimates, aes(TrCode, response, ymin = lower.CL, ymax = upper.CL))+
  geom_pointrange(size = 1, shape = 3)+
  theme_classic(base_size = 30)+
  theme(axis.title.x = element_blank(), 
        axis.title.y = element_blank(), 
        panel.grid.major.x = element_blank(),
        panel.grid.minor.y = element_blank(),
        panel.grid.major.y = element_blank(),
        axis.line = element_line())
  #geom_text(data=Estimates.123,aes(TrCode,upper.CL+20,label=Groups),vjust=0)
