#Choice plots per subtreatment

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis")


#Open required libraries ----
library(readxl)    #Used to read excel file
library(ggplot2)   #Used for graphs
library(reshape2)  #Used for preparing data frame
library(RColorBrewer) #Used for colour options graph

#Load the data sheets from excel ----
choiceData <- read_xlsx( "Wind_exp1_raw_data_230629_v02.xlsx") 

#Remove observations made by Luuk, done because there were too few observations (definitely not from each treatment)
choiceData <- choiceData[choiceData$Observer != "Luuk", ]

#Remove parasitoids that did not respond
choiceData <- choiceData[choiceData$Response !="0",]

#Create new variables
choiceData$ChoseCD <- ifelse( choiceData$TrCode == "A0" & choiceData$InitialRowChoice == "RRRRH" |
                                choiceData$InitialRowChoice == "CRRRH" |
                                choiceData$InitialRowChoice == "RCRRH" |
                                choiceData$InitialRowChoice == "RRCRH" |
                                choiceData$InitialRowChoice == "CCRRH" |
                                choiceData$InitialRowChoice == "RCCRH" |
                                choiceData$InitialRowChoice == "CCCRH" , 1 , 0 )

#Remove variables not used in any analysis
choiceData$WaspFrom <- NULL
choiceData$PlantAge <- NULL
choiceData$Temp <- NULL
choiceData$RHlower <- NULL
choiceData$RHupper <- NULL
choiceData$TimeCat <- NULL
choiceData$Time <- NULL
choiceData$TimeLeavingVial <- NULL
choiceData$Response <- NULL
choiceData$TimeStartFlight <- NULL
choiceData$TimeChoice1 <- NULL
choiceData$InitialPlantChoice <- NULL
choiceData$InitialRowChoice <- NULL
choiceData$DirectFlight <- NULL
choiceData$Oviposition1 <- NULL
choiceData$RorL <- NULL

#Transform data type
choiceData$Observer <- as.factor(choiceData$Observer)
choiceData$Orientation <- as.factor(choiceData$Orientation)

#Make subsets for each treatment
choiceDataTrA3 <- choiceData[choiceData$TrCode == "A3" , ]
choiceDataTrA0 <- choiceData[choiceData$TrCode == "A0" , ]
choiceDataTrB3 <- choiceData[choiceData$TrCode == "B3" , ]

#Make subsets for each (sub-)treatment
choiceDataTrA1.1 <- choiceData[choiceData$TrCode == "A1" & choiceData$PlantPos == "1", ]
choiceDataTrA1.2 <- choiceData[choiceData$TrCode == "A1" & choiceData$PlantPos == "2", ]
choiceDataTrA1.3 <- choiceData[choiceData$TrCode == "A1" & choiceData$PlantPos == "3", ]
choiceDataTrA2.1 <- choiceData[choiceData$TrCode == "A2" & choiceData$PlantPos == "1", ]
  choiceDataTrA2.1 <- choiceDataTrA2.1[complete.cases(choiceDataTrA2.1), ]
choiceDataTrA2.2 <- choiceData[choiceData$TrCode == "A2" & choiceData$PlantPos == "2", ]
  choiceDataTrA2.2 <- choiceDataTrA2.2[complete.cases(choiceDataTrA2.2), ]
choiceDataTrB1.1 <- choiceData[choiceData$TrCode == "B1" & choiceData$PlantPos == "1", ]
choiceDataTrB1.2 <- choiceData[choiceData$TrCode == "B1" & choiceData$PlantPos == "2", ]
choiceDataTrB1.3 <- choiceData[choiceData$TrCode == "B1" & choiceData$PlantPos == "3", ]
choiceDataTrB2.1 <- choiceData[choiceData$TrCode == "B2" & choiceData$PlantPos == "1", ]
choiceDataTrB2.2 <- choiceData[choiceData$TrCode == "B2" & choiceData$PlantPos == "2", ]

#Prepare data file for plot
A <- data.frame(row.names = c("A0", "A1.1", "A1.2", "A1.3", "A2.1", "A2.2", "A3"))
A$TrCode <- c("A0", "A1.1", "A1.2", "A1.3", "A2.1", "A2.2", "A3")
A$RRRRH <- -(c(nrow(choiceDataTrA0),nrow(choiceDataTrA1.1),nrow(choiceDataTrA1.2),nrow(choiceDataTrA1.3),nrow(choiceDataTrA2.1),nrow(choiceDataTrA2.2),nrow(choiceDataTrA3))-
               c(sum(choiceDataTrA0$ChoseCD),sum(choiceDataTrA1.1$ChoseCD),sum(choiceDataTrA1.2$ChoseCD),sum(choiceDataTrA1.3$ChoseCD),sum(choiceDataTrA2.1$ChoseCD),sum(choiceDataTrA2.2$ChoseCD),sum(choiceDataTrA3$ChoseCD)))/
                c(nrow(choiceDataTrA0),nrow(choiceDataTrA1.1),nrow(choiceDataTrA1.2),nrow(choiceDataTrA1.3),nrow(choiceDataTrA2.1),nrow(choiceDataTrA2.2),nrow(choiceDataTrA3))
A$XRXCRH <- c(sum(choiceDataTrA0$ChoseCD),sum(choiceDataTrA1.1$ChoseCD),sum(choiceDataTrA1.2$ChoseCD),sum(choiceDataTrA1.3$ChoseCD),sum(choiceDataTrA2.1$ChoseCD),sum(choiceDataTrA2.2$ChoseCD),sum(choiceDataTrA3$ChoseCD))/
            c(nrow(choiceDataTrA0),nrow(choiceDataTrA1.1),nrow(choiceDataTrA1.2),nrow(choiceDataTrA1.3),nrow(choiceDataTrA2.1),nrow(choiceDataTrA2.2),nrow(choiceDataTrA3))
A <- melt(A, id = "TrCode")

B <- data.frame(row.names = c("B1.1","B1.2","B1.3","B2.1","B2.2", "B3"))
B$TrCode <- c("B1.1","B1.2","B1.3","B2.1","B2.2", "B3")
B$RRRCH <- -(c(nrow(choiceDataTrB1.1),nrow(choiceDataTrB1.2),nrow(choiceDataTrB1.3),nrow(choiceDataTrB2.1),nrow(choiceDataTrB2.2),nrow(choiceDataTrB3))-
               c(sum(choiceDataTrB1.1$ChoseCD),sum(choiceDataTrB1.2$ChoseCD),sum(choiceDataTrB1.3$ChoseCD),sum(choiceDataTrB2.1$ChoseCD),sum(choiceDataTrB2.2$ChoseCD),sum(choiceDataTrB3$ChoseCD)))/
                c(nrow(choiceDataTrB1.1),nrow(choiceDataTrB1.2),nrow(choiceDataTrB1.3),nrow(choiceDataTrB2.1),nrow(choiceDataTrB2.2),nrow(choiceDataTrB3))
B$XRXCRH <- c(sum(choiceDataTrB1.1$ChoseCD),sum(choiceDataTrB1.2$ChoseCD),sum(choiceDataTrB1.3$ChoseCD),sum(choiceDataTrB2.1$ChoseCD),sum(choiceDataTrB2.2$ChoseCD),sum(choiceDataTrB3$ChoseCD))/
            c(nrow(choiceDataTrB1.1),nrow(choiceDataTrB1.2),nrow(choiceDataTrB1.3),nrow(choiceDataTrB2.1),nrow(choiceDataTrB2.2),nrow(choiceDataTrB3))
B <- melt(B, id = "TrCode")

#Plot choice plots
ggplot(A, aes(fill = variable, y = value, x = TrCode)) +
  geom_bar(position = "stack", stat = "identity") + coord_flip() + 
  scale_fill_manual(values = c("#4DAF4A", "#377EB8")) +
  scale_y_continuous(name = "Proportion of parasitoids", 
                     breaks = seq(-1,1,0.25), 
                     limits = c(-0.75,0.75)) +
  theme(legend.position = "none", 
        panel.background = element_blank(),
        axis.title.y = element_blank(),
        axis.line.x = element_line(),
  ) + geom_hline(yintercept = 0) + geom_hline(yintercept = 0.5, linetype = "dashed") + geom_hline(yintercept = -0.5, linetype = "dashed")

ggplot(B, aes(fill = variable, y = value, x = TrCode)) +
  geom_bar(position = "stack", stat = "identity") + coord_flip() + 
  scale_fill_manual(values = c("#4DAF4A", "#377EB8")) +
  scale_y_continuous(name = "Proportion of parasitoids", 
                     breaks = seq(-1,1,0.25), 
                     limits = c(-0.75,0.75)) +
  theme(legend.position = "none", 
        panel.background = element_blank(),
        axis.title.y = element_blank(),
        axis.line.x = element_line(),
  ) + geom_hline(yintercept = 0) + geom_hline(yintercept = 0.5, linetype = "dashed") + geom_hline(yintercept = -0.5, linetype = "dashed")


