#Two choice experiment - GLM

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(lme4)      #Used for "glmer" function

#Load the data sheets from excel ----
choiceData <- read_xlsx( "Wind_exp1_raw_data_230629_v02.xlsx") 

#Remove observations made by Luuk, done because there were too few observations (definitely not from each treatment)
choiceData <- choiceData[choiceData$Observer != "Luuk", ]

#Remove parasitoids that did not respond
choiceData <- choiceData[choiceData$Response !="0",]

#Create new variables
choiceData$ChoseCD <- ifelse( choiceData$TrCode == "A0" & choiceData$InitialRowChoice == "RRRRH" |
                                choiceData$InitialRowChoice == "CRRRH" |
                                choiceData$InitialRowChoice == "RCRRH" |
                                choiceData$InitialRowChoice == "RRCRH" |
                                choiceData$InitialRowChoice == "CCRRH" |
                                choiceData$InitialRowChoice == "RCCRH" |
                                choiceData$InitialRowChoice == "CCCRH" , 1 , 0 )

#Remove variables not used in any analysis
choiceData$WaspFrom <- NULL
choiceData$WaspAge <- NULL
choiceData$Observer <- NULL
choiceData$PlantAge <- NULL
choiceData$Temp <- NULL
choiceData$RHlower <- NULL
choiceData$RHupper <- NULL
choiceData$TimeCat <- NULL
choiceData$Time <- NULL
choiceData$PlantPos <- NULL
choiceData$TimeLeavingVial <- NULL
choiceData$Response <- NULL
choiceData$TimeStartFlight <- NULL
choiceData$TimeChoice1 <- NULL
choiceData$InitialPlantChoice <- NULL
choiceData$InitialRowChoice <- NULL
choiceData$DirectFlight <- NULL
choiceData$Oviposition1 <- NULL
choiceData$RorL <- NULL

#Transform data type
choiceData$Orientation <- as.factor(choiceData$Orientation)
choiceData$Day <- as.factor(choiceData$Day)

#Make subsets for each (sub-)treatment and the treatment groups
choiceDataTrA1 <- choiceData[choiceData$TrCode == "A1" , ]
choiceDataTrA2 <- choiceData[choiceData$TrCode == "A2" , ]
choiceDataTrA3 <- choiceData[choiceData$TrCode == "A3" , ]
choiceDataTrA0 <- choiceData[choiceData$TrCode == "A0" , ]
choiceDataTrB1 <- choiceData[choiceData$TrCode == "B1" , ]
choiceDataTrB2 <- choiceData[choiceData$TrCode == "B2" , ]
choiceDataTrB3 <- choiceData[choiceData$TrCode == "B3" , ]
choiceDataTrA  <- choiceData[choiceData$TrCode == "A0" | choiceData$TrCode == "A1" | choiceData$TrCode == "A2" | choiceData$TrCode == "A3" , ]
choiceDataTrB  <- choiceData[                            choiceData$TrCode == "B1" | choiceData$TrCode == "B2" | choiceData$TrCode == "B3" , ]

#Create equally divided dataset (50 left, 50 right), to compare data with nul hypothesis that parastioids do not choose.
choiceDataFake <- data.frame(c(rep(0,50), rep(1,50)),
                             c(rep("Switched",25),rep("Normal",25),rep("Switched",25),rep("Normal",25)),
                             "0",
                             rep(0,100))
names(choiceDataFake) <- c("ChoseCD", "Orientation","TrCode","Day")

#Add created dataset to subsets
choiceDataTrA1.F <- rbind(choiceDataTrA1, choiceDataFake)
choiceDataTrA2.F <- rbind(choiceDataTrA2, choiceDataFake)
choiceDataTrA3.F <- rbind(choiceDataTrA3, choiceDataFake)
choiceDataTrB1.F <- rbind(choiceDataTrB1, choiceDataFake)
choiceDataTrB2.F <- rbind(choiceDataTrB2, choiceDataFake)
choiceDataTrB3.F <- rbind(choiceDataTrB3, choiceDataFake)
choiceDataTrA0.F <- rbind(choiceDataTrA0, choiceDataFake)


##Binomial test per treatment
binom.test(sum(choiceDataTrA1$ChoseCD),nrow(choiceDataTrA1), p = 0.5, alternative = "two.sided", conf.level = 0.95)
binom.test(sum(choiceDataTrA2$ChoseCD),nrow(choiceDataTrA2), p = 0.5, alternative = "two.sided", conf.level = 0.95)
binom.test(sum(choiceDataTrA3$ChoseCD),nrow(choiceDataTrA3), p = 0.5, alternative = "two.sided", conf.level = 0.95)
binom.test(sum(choiceDataTrA0$ChoseCD),nrow(choiceDataTrA0), p = 0.5, alternative = "two.sided", conf.level = 0.95)
binom.test(sum(choiceDataTrB1$ChoseCD),nrow(choiceDataTrB1), p = 0.5, alternative = "two.sided", conf.level = 0.95)
binom.test(sum(choiceDataTrB2$ChoseCD),nrow(choiceDataTrB2), p = 0.5, alternative = "two.sided", conf.level = 0.95)
binom.test(sum(choiceDataTrB3$ChoseCD),nrow(choiceDataTrB3), p = 0.5, alternative = "two.sided", conf.level = 0.95)


##Distribution within treatments separately
#GLM on choice per treatment
myGLM.A1 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA1.F, family = binomial(link = "logit"))
myGLM.A2 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA2.F, family = binomial(link = "logit"))
myGLM.A3 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA3.F, family = binomial(link = "logit"))
myGLM.A0 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA0.F, family = binomial(link = "logit"))
myGLM.B1 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB1.F, family = binomial(link = "logit"))
myGLM.B2 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB2.F, family = binomial(link = "logit"))
myGLM.B3 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB3.F, family = binomial(link = "logit"))

#Results
summary(myGLM.A1)
summary(myGLM.A2)
summary(myGLM.A3)
summary(myGLM.A0)
summary(myGLM.B1)
summary(myGLM.B2)
summary(myGLM.B3)


##Distribution between choice treatments
#GLM on effect treatment on choice - without random effects
myGLM.A <- glm(ChoseCD ~ TrCode, choiceDataTrA, family = binomial(link = "logit"))
choiceDataTrA$TrCode1 <- factor(choiceDataTrA$TrCode, levels=c("A3","A2","A1")) #To check difference between A2 and A3 --> No significant difference
myGLM.A.rev <- glm(ChoseCD ~ TrCode1, choiceDataTrA, family = binomial(link = "logit"))
myGLM.B <- glm(ChoseCD ~ TrCode, choiceDataTrB, family = binomial(link = "logit"))

#GLM on effect treatment on choice - with random effects
myGLMM.A <- glmer(ChoseCD ~ TrCode + (1|Orientation) + (1|Day), choiceDataTrA, family = binomial(link = "logit"))
myGLMM.A.rev <- glmer(ChoseCD ~ TrCode1 + (1 | Orientation) + (1 | Day), choiceDataTrA, family = binomial(link = "logit"))
myGLMM.B <- glmer(ChoseCD ~ TrCode + (1 | Orientation) + (1 | Day), choiceDataTrB, family = binomial(link = "logit"))

#Results
summary(myGLM.A) #Treatments A, no random effects, A1 reference
summary(myGLM.A.rev) #Treatments A, no random effects, A3 reference
summary(myGLM.B) #Treatments B, no random effects

summary(myGLMM.A) #Treatments A, with random effects, A1 reference
summary(myGLMM.A.rev) #Treatments A, with random effects, A3 reference
summary(myGLMM.B) #Treatments B, with random effects
