#Choice plots per subtreatment

#Create clean R workspace
rm(list=ls())
graphics.off()
gc(FALSE)
cat("\014") 
Sys.setenv(LANG = "en")

#Set working directory
setwd("D:/OneDrive - Wageningen University & Research/1. PhD/Wind Tunnel experiments/Data analysis")

#Open required libraries ----
library(readxl)    #Used to read excel file
library(lme4)      #Used for "glmer" function
library(emmeans)   #Used for "emmeans" function

#Load the data sheets from excel ----
choiceData <- read_xlsx( "Wind_exp1_raw_data_230629_v02.xlsx") 

#Remove observations made by Luuk, done because there were too few observations (definitely not from each treatment)
choiceData <- choiceData[choiceData$Observer != "Luuk", ]

#Remove parasitoids that did not respond
choiceData <- choiceData[choiceData$Response !="0",]

#Create new variables
choiceData$ChoseCD <- ifelse( choiceData$TrCode == "A0" & choiceData$InitialRowChoice == "RRRRH" |
                                choiceData$InitialRowChoice == "CRRRH" |
                                choiceData$InitialRowChoice == "RCRRH" |
                                choiceData$InitialRowChoice == "RRCRH" |
                                choiceData$InitialRowChoice == "CCRRH" |
                                choiceData$InitialRowChoice == "RCCRH" |
                                choiceData$InitialRowChoice == "CCCRH" , 1 , 0 )

#Change Treatment codes
choiceData$TrCode <- ifelse(choiceData$TrCode == "A1" & choiceData$PlantPos == "1", "A1.1", 
                            ifelse(choiceData$TrCode == "A1" & choiceData$PlantPos == "2", "A1.2", 
                            ifelse(choiceData$TrCode == "A1" & choiceData$PlantPos == "3", "A1.3",
                            ifelse(choiceData$TrCode == "A2" & choiceData$PlantPos == "1", "A2.1",
                            ifelse(choiceData$TrCode == "A2" & choiceData$PlantPos == "2", "A2.2",
                            ifelse(choiceData$TrCode == "B1" & choiceData$PlantPos == "1", "B1.1",
                            ifelse(choiceData$TrCode == "B1" & choiceData$PlantPos == "2", "B1.2",
                            ifelse(choiceData$TrCode == "B1" & choiceData$PlantPos == "3", "B1.3",
                            ifelse(choiceData$TrCode == "B2" & choiceData$PlantPos == "1", "B2.1",
                            ifelse(choiceData$TrCode == "B2" & choiceData$PlantPos == "2", "B2.2",
                            ifelse(choiceData$TrCode == "A0", "A0",
                            ifelse(choiceData$TrCode == "B3", "B3", "A3"))))))))))))

#Remove variables not used in any analysis
choiceData$WaspFrom <- NULL
choiceData$WaspAge <- NULL
choiceData$Observer <- NULL
choiceData$PlantAge <- NULL
choiceData$Temp <- NULL
choiceData$RHlower <- NULL
choiceData$RHupper <- NULL
choiceData$TimeCat <- NULL
choiceData$Time <- NULL
choiceData$TimeLeavingVial <- NULL
choiceData$Response <- NULL
choiceData$TimeStartFlight <- NULL
choiceData$TimeChoice1 <- NULL
choiceData$InitialPlantChoice <- NULL
choiceData$InitialRowChoice <- NULL
choiceData$DirectFlight <- NULL
choiceData$Oviposition1 <- NULL
choiceData$RorL <- NULL

#Remove parasitoids that did not make a choice
choiceData <- choiceData[complete.cases(choiceData$TrCode), ]

#Transform data type
choiceData$Orientation <- as.factor(choiceData$Orientation)
choiceData$Day <- as.factor(choiceData$Day)

#Make subsets for each (sub-)treatment and the treatment groups
choiceDataTrA1.1 <- choiceData[choiceData$TrCode == "A1.1", ]
choiceDataTrA1.2 <- choiceData[choiceData$TrCode == "A1.2", ]
choiceDataTrA1.3 <- choiceData[choiceData$TrCode == "A1.3", ]
choiceDataTrA2.1 <- choiceData[choiceData$TrCode == "A2.1", ]
choiceDataTrA2.2 <- choiceData[choiceData$TrCode == "A2.2", ]
choiceDataTrA3 <- choiceData[choiceData$TrCode == "A3" , ]
choiceDataTrA0 <- choiceData[choiceData$TrCode == "A0" , ]
choiceDataTrB1.1 <- choiceData[choiceData$TrCode == "B1.1", ]
choiceDataTrB1.2 <- choiceData[choiceData$TrCode == "B1.2", ]
choiceDataTrB1.3 <- choiceData[choiceData$TrCode == "B1.3", ]
choiceDataTrB2.1 <- choiceData[choiceData$TrCode == "B2.1", ]
choiceDataTrB2.2 <- choiceData[choiceData$TrCode == "B2.2", ]
choiceDataTrB3 <- choiceData[choiceData$TrCode == "B3" , ]

choiceDataTrA  <- choiceData[choiceData$TrCode == "A0" | choiceData$TrCode == "A1.1" | choiceData$TrCode == "A1.2" | choiceData$TrCode == "A1.3" | choiceData$TrCode == "A2.1" | choiceData$TrCode == "A2.2" | choiceData$TrCode == "A3" , ]
choiceDataTrB  <- choiceData[                            choiceData$TrCode == "B1.1" | choiceData$TrCode == "B1.2" | choiceData$TrCode == "B1.3" | choiceData$TrCode == "B2.1" | choiceData$TrCode == "B2.2" | choiceData$TrCode == "B3" , ]

#Create equally divided dataset (20 left, 20 right), to compare data with nul hypothesis that parastioids do not choose.
choiceDataFake <- data.frame(c(rep(0,20), rep(1,20)),
                             c(rep("Switched",10),rep("Normal",10),rep("Switched",10),rep("Normal",10)),
                             "0",
                             rep(0,40),
                             "0")
names(choiceDataFake) <- c("ChoseCD", "Orientation","TrCode","Day","PlantPos")

#Add created dataset to subsets
choiceDataTrA1.1.F <- rbind(choiceDataTrA1.1, choiceDataFake)
choiceDataTrA1.2.F <- rbind(choiceDataTrA1.2, choiceDataFake)
choiceDataTrA1.3.F <- rbind(choiceDataTrA1.3, choiceDataFake)
choiceDataTrA2.1.F <- rbind(choiceDataTrA2.1, choiceDataFake)
choiceDataTrA2.2.F <- rbind(choiceDataTrA2.2, choiceDataFake)
choiceDataTrB1.1.F <- rbind(choiceDataTrB1.1, choiceDataFake)
choiceDataTrB1.2.F <- rbind(choiceDataTrB1.2, choiceDataFake)
choiceDataTrB1.3.F <- rbind(choiceDataTrB1.3, choiceDataFake)
choiceDataTrB2.1.F <- rbind(choiceDataTrB2.1, choiceDataFake)
choiceDataTrB2.2.F <- rbind(choiceDataTrB2.2, choiceDataFake)

##Distribution within treatments separately
#GLM on choice per treatment
myGLM.A1.1 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA1.1.F, family = binomial(link = "logit"))
myGLM.A1.2 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA1.2.F, family = binomial(link = "logit"))
myGLM.A1.3 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA1.3.F, family = binomial(link = "logit"))
myGLM.A2.1 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA2.1.F, family = binomial(link = "logit"))
myGLM.A2.2 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrA2.2.F, family = binomial(link = "logit"))
myGLM.B1.1 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB1.1.F, family = binomial(link = "logit"))
myGLM.B1.2 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB1.2.F, family = binomial(link = "logit"))
myGLM.B1.3 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB1.3.F, family = binomial(link = "logit"))
myGLM.B2.1 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB2.1.F, family = binomial(link = "logit"))
myGLM.B2.2 <- glmer(ChoseCD ~ TrCode + (1|Orientation), choiceDataTrB2.2.F, family = binomial(link = "logit"))

#Results
summary(myGLM.A1.1)
summary(myGLM.A1.2)
summary(myGLM.A1.3)
summary(myGLM.A2.1)
summary(myGLM.A2.2)
summary(myGLM.B1.1)
summary(myGLM.B1.2)
summary(myGLM.B1.3)
summary(myGLM.B2.1)
summary(myGLM.B2.2)

#GLM on effect treatment on choice - with random effects
myGLMM.A <- glmer(ChoseCD ~ TrCode + (1|Orientation) + (1|Day), choiceDataTrA, family = binomial(link = "logit"))
myGLMM.A.rev <- glmer(ChoseCD ~ TrCode1 + (1 | Orientation) + (1 | Day), choiceDataTrA, family = binomial(link = "logit"))
myGLMM.B <- glmer(ChoseCD ~ TrCode + (1 | Orientation) + (1 | Day), choiceDataTrB, family = binomial(link = "logit"))

summary(myGLMM.A) #Treatments A, with random effects, A1 reference
summary(myGLMM.A.rev) #Treatments A, with random effects, A3 reference
summary(myGLMM.B) #Treatments B, with random effects

emm.A <- emmeans(myGLMM.A, ~ TrCode)
pairs(emm.A)

emm.B <- emmeans(myGLMM.B, ~ TrCode)
pairs(emm.B)
