%-------------------
%GENERAL INFORMATION
%-------------------

% 1. Dataset title: Supporting data belonging to publication: 
% "Experimental demonstration of regenerative wind farming using a high-density layout of VAWTs"

% 2. Authorship: 
    % Name: David Bensason
    % Institution: Delft University of Technology 
    % Email: d.y.bensason@tudelft.nl
    % ORCID: 0000-0002-0590-1524

%-------------------
% DESCRIPTION
%-------------------

% This is a README file for an experimental data repository
% on 4TU DOI: 10.4121/7bf33a69-6542-41ee-af6d-3fd621b802e1. The data concerns the
% experimental results presented in the manuscript titled 
% "Experimental demonstration of regenerative wind farming using a high-density layout of VAWTs". 
% A zip folder contains the .mat files for the time-averaged measurement
% planes entitled "mat_flow_global.zip".
% 
% Furthermore, CAD files for the wind turbine assembly is included in the 
% zipped folder 'CAD_4TU_Share.zip'.
% This includes parts (.ipt) that make up the assembly "Rotor_assembly" of
% the rotor and shaft. The pitch adapter parts are inluced as .stl files. 
 
%% Description of "mat_flow_global.zip"
%{
This zip folder includes data structures of the stitched flowfield volumes, 
discretized by their location in the farm and pitch case. The datafiles are already 
fully stiched following the method explained in the manuscript. 

File naming convention: 
"Wheel_Pos" is the wind farm measurement volume 
Wheel_Pos_ = 1 (infront of the first rotor)
Wheel_Pos_ = 2 (between the first and second rotor)
Wheel_Pos_ = 3 (between the second and third rotor)
Wheel_Pos_ = 4 (behind the third rotor)

"Pitch" is the pitch setting of all of the rotors in the farm 
Pitch_ = 0 (baseline case no passive pitch)
Pitch_ = 10 (pitched-in)
Pitch_ = -10 (picthed-out)

Example file: 
Wheel_Pos_1_Pitch_0.mat : Volume ahead of the first rotor, with all rotors
at 0 pitch (Baseline) 

When loading the mat structure using load('Wheel_Pos_1_Pitch_0.mat'), it will load
a 3D matrix structure named "Data_global". 
The definition of the entries of this structure is as follows: 
 
Data_global.x; % streamwise coordinate (mm)
Data_global.y; % lateral coordinate (mm)
Data_global.z; % axial coordinate (mm)
Data_global.Ux; % streamwise flow (m/s)
Data_global.Uy; % lateral flow (m/s)
Data_global.Uz; % axial flow (m/s)
Data_global.Vmag; % velocity magnitude (m/s)
Data_global.dudx; % Streamwise velocity gradient -x (1/s)
Data_global.dudz; % Streamwise velocity gradient -z (1/s)
Data_global.dudy; % Streamwise velocity gradient -y (1/s)
Data_global.dvdx; % Lateral velocity gradient -x (1/s)
Data_global.dvdy; % Lateral velocity gradient -y (1/s)
Data_global.dvdz; % Lateral velocity gradient -z (1/s)
Data_global.dwdx; % Axial velocity gradient -x (1/s)
Data_global.dwdy; % Axial velocity gradient -y (1/s)
Data_global.dwdz; % Axial velocity gradient -z (1/s)
Data_global.vort_x; % Streamwise vorticity (1/s)
Data_global.vort_y; % Lateral vorticity (1/s)
Data_global.vort_z; % Axial vorticity (1/s)
Data_global.Re_Rxx; % Reynolds stress streamwise-streamwise ((m/s)^2)
Data_global.Re_Rxy; % Reynolds stress streamwise-lateral ((m/s)^2)
Data_global.Re_Rxz; % Reynolds stress streamwise-axial ((m/s)^2)
Data_global.Re_Ryy; % Reynolds stress lateral-lateral ((m/s)^2)
Data_global.Re_Ryz; % Reynolds stress lateral-axial ((m/s)^2)
Data_global.Re_Rzz; % Reynolds stress axial-axial ((m/s)^2)
Data_global.Vortmag; % Vorticity magnitude (1/s)
Data_global.div_2D; % 2D Divergence (1/s)
Data_global.div_3D; % 3D Divergence (1/s)
Data_global.swirl_3D; % 2D Swirl Strength (1/s^2)
Data_global.AKE; % Average kinetic energy ((m/s)^2)
Data_global.num_particles; % n
Data_global.std_Vmag; % Standard deviation velocity magnitude  (m/s)
Data_global.std_Vx; % Standard deviation in streamwise velocity (m/s)
Data_global.std_Vy; % Standard deviation in lateral velocity (m/s)
Data_global.std_Vz; % Standard deviation in axial velocity (m/s)
Data_global.TKE; % Turbulent kinetic energy ((m/s)^2)
Data_global.turb_shear_stress; % Turbulent shear stress ((m/s)^2)
Data_global.Unc_Vmag; % Uncertainty magnitude velocity (m/s)
Data_global.Unc_Vx; % Uncertainty in streamwise velocity (m/s)
Data_global.Unc_Vy; % Uncertainty deviation in lateral velocity (m/s)
Data_global.Unc_Vz; % Uncertainty deviation in axial velocity (m/s)
Data_global.valid; % (=0, no data) (=1, data)


** Note, that the uncertainties (Data_global.Unc_V) are based on the
number of particles considered by the DaVis software within a given temporally
and spatially averaged bin. As described in Section 3.5 of the publication,
a more conservative estimate is to use the number of recordings (N=4600)
and equation (1) when evaluating the uncertainty of each velocity
component. 
%}

%% Description of 'CAD_4TU_Share.zip'
%{
This zip folder contains part (.ipt) and assembly files (.iam) for the
rotor and shaft system, along with .stl files for the pitch adapters that
were 3D printed. 

0_degree_adapter.stl = baseline case (no pitch) 
n10_degree_adapter.stl = negative pitch (pitch out) 
p10_degree_adapter.stl = posotive pitch (pitched in)

%}

