This data set contains all data used to generate the results, tables, and figures presented in the research paper titled "Contribution of PRIDE VLBI products to the joint JUICE-Europa Clipper moons’ ephemerides solution" (https://doi.org/10.1016/j.icarus.2024.116101). More detail on the exact analysis settings used to generate these results can therefore be found in the aforementioned paper. Five different types of files are provided, whose contents and file name conventions are described below.

### Baseline covariance files

These files contain the results of the covariance analysis in the baseline scenario, where only Doppler and range data included and no VLBI measurements are yet simulated (see publication for more detail). Are provided:
- the formal errors for all n estimated parameters, obtained with the coupled and decoupled estimation approaches (_errors_coupled_baseline.dat_ and _errors_decoupled_baseline.dat_), with the moons' initial state uncertainties in inertial (jovicentric) frame.
- Similar files containing the formal errors for all estimated parameters, but after converting the Galilean moons' initial state uncertainties to the RSW frame (_errorsRsw_coupled_baseline.dat_ and _errorsRsw_decoupled_baseline.dat_).
- The propagated formal errors in RSW for the Galilean moons' states, in the coupled estimation case (_propagatedErrorsRsw_coupled_baseline.dat_).

### Formal errors files

Two types of formal errors are provided: 
- if the filename starts with _errors\__, the file contains the formal errors resulting from a covariance analysis, for the n parameters to be estimated. The formal errors for the Galilean moons' estimated states are provided in inertial coordinates (centred at Jupiter). 
- if the filename starts with _errorsRsw\__, the file also contains the formal errors of all n parameters, but those associated to the Galilean moons' states have been converted to RSW frame (radial, tangential, and normal directions).

The rest of the filenaming convention is the following, and applies to both _errors_ and _errorsRsw_ file types: errors_/estimationModel_/vlbiQuality/vlbiType_/tracking_/biasStatus.dat. 

- _"estimationModel"_ is either set to _"coupled"_ or _"decoupled"_, and refers to the coupled and decoupled state estimation models described in the publication.

- _"vlbiQuality"_ can be set to _"poor"_, _"good"_, or _"ka"_ for nominal, single-spacecraft VLBI, and to _"poor"_ and _"good"_ for multi-spacecraft VLBI. It refers to the assumed quality of the VLBI measurements, following the nomenclature adopted in the accompanying paper. 

- _"vlbiType"_ is either _"Vlbi"_ (for single-spacecraft VLBI) or _"multiScVlbi"_ (for multi-spacecraft VLBI).

- _"tracking"_ describes some specifics of the VLBI tracking settings. For nominal (single-spacecraft) VLBI, it defines the cadence at which independent VLBI measurements are simulated (see more detail in the publication). For multi-spacecraft VLBI, it defines the duration and timing of the multi-spacecraft tracking. "_4hArcBounds_" and _"4hMidArc"_ for instance respectively refer to tracking arcs of 4 hours performed in the "arc bounds" and "mid-arc" configurations described in the paper.

- _"biasStatus"_ is either set to _"estBias"_ or "_considerBias_" depending on whether VLBI biases are included as estimated or consider parameters in the covariance analysis. 

### Flybys files

The file naming convention is "_flybys/spacecraft\_/flybyMoon.dat"_, where "_spacecraft_" is either _"Juice"_ or _"Clipper"_, and "_flybyMoon"_ defines the moon at which the flyby is taken place.

The file contains the times at which flybys of a given spacecraft around a given moon occur (first row, in seconds since 2000). The second row provides the distance between the spacecraft and the flyby moon at closest approach (in meters). 

### Calibrators files

Two files are provided:
- _selectedCalibrators_fullMission.dat_
- _selectedCalibrators_trackingArcs.dat_

Both files contain the relevant information regarding the selected phase calibrators for JUICE PRIDE VLBI tracking (see the accompanying publication for more detail on the calibrator selection). The first file spans the entire mission timeline, while the second one only lists the selected calibrators relevant for JUICE's tracking arcs.

The content of these files is organised as follows:
- row 1: time in seconds since 2000
- row 2: right ascension of the JUICE spacecraft
- row 3: declination of the JUICE spacecraft
- row 4: right ascension of the selected phase calibrator
- row 5: declination of the selected phase calibrator
- row 6: uncertainty in right ascension of the selected phase calibrator
- row 7: uncertainty in declination of the selected phase calibrator
- row 8: apparent distance between the JUICE spacecraft and phase calibrator (in radians)
- row 9: total flux density of the phase calibrator (in Jy)

### Propagated errors files

These files contain the propagated formal errors for the Galilean moons' states, expressed in the RSW frame. The file names start with _"propagatedErrorsRsw"_ and then follow the same naming convention as described for the formal errors files (see above). 
