package dist;

import java.util.Random;

public class ParetoDistribution extends Distribution {

	protected double xm, alpha;
	
	public ParetoDistribution(double xm, double alpha, Random random) {
		this.xm = xm;
		this.alpha = alpha;
		this.random = random;
	}
	
	
	@Override
	public double expectation() {
		return alpha <= 1 ? Double.POSITIVE_INFINITY : alpha*xm / (alpha - 1);
	}

	@Override
	public double variance() {
		return alpha <= 2 ? Double.POSITIVE_INFINITY : xm*xm*alpha / (alpha-1)/(alpha-1)/(alpha-2);
	}

	@Override
	public double nextRandom() {
		double u = random.nextDouble();
		return xm*Math.pow(u, -1/alpha);
	}

	
	public static void main(String[] arg) {
		int n = 100000000;
		double sumX = 0;
		double sumX2 = 0;
		ParetoDistribution dist = new ParetoDistribution(3, 2.5, new Random());
		for (int i = 0; i < n; i++) {
			double x = dist.nextRandom();
			sumX += x;
			sumX2 += x*x;
		}
		double mean = sumX / n;
		double var = sumX2/n - mean*mean;
		System.out.println("Simulated mean = "+mean+", var = "+var);
		System.out.println("theoretical mean = "+ dist.expectation() +", var = "+dist.variance());
	}
}
