package dist;
import java.util.*;


public class LogNormalDistribution extends Distribution{
    
    protected double mu;
    protected double sigma;
    
    public LogNormalDistribution(double mu, double sigma, Random random) {
        this.mu= mu;
        this.sigma = sigma;
        this.random = random;       
    }

    @Override
    public double expectation() {
        return Math.exp(mu+sigma*sigma/2);
    }

    @Override
    public double variance() {
        return (Math.exp(sigma*sigma) - 1)*Math.exp(2*mu + sigma*sigma);
    }

    @Override
    public double nextRandom() {
        double U = random.nextGaussian();
        return Math.exp(mu + sigma*U); 
    }
    
    
    
    
}
