package dist;
import java.util.Random;


public class BernoulliDistribution extends Distribution {

    protected double p;  // Success probability
    
    public BernoulliDistribution( double p, Random random ){
        this.p = p;
        this.random = random;
    }
    
    
    @Override
    public double expectation() {
        return p;
    }

    @Override
    public double variance() {
        return p*(1-p);
    }

    @Override
    public double nextRandom() {
        double U = random.nextDouble();
        if ( U > p ){
            return 0;
        }else{
            return 1;
        }
    }
    
    public static void main(String[] arg) {
        double m = 0;
        double m2 = 0;
        double p = 0.7;
        BernoulliDistribution b = new BernoulliDistribution(p,new Random());
        int n = 1000000;
        for (int i = 0; i < n; i++) {
            double r = b.nextRandom();
            m += r;
            m2 += r*r;
        }
        System.out.println("Mean: "+(m/n)+", var: "+(m2/n-m/n*m/n));
                
    }
    
}
