package DistanceMeasure;

import DiscreteEventSimulation.SimResults;

public class TimeSeriesData {
	
	/* The time series data to be stored, columns correspond to different samples
	 * rows are the different time points
	 */
	protected int[][] data;
	
	/**
	 * Arranges the data from SimResults into a matrix for further calcs
	 * This sample is used for simulation data
	 * @param results
	 * @param experiment corresponds to settling, Basal, Transition, Insulin
	 */
	
	public TimeSeriesData(SimResults[][] results, int experiment, int station) {
		int sampleSize = results.length;
		this.data = new int[results[0][experiment].getNumberOfTimePoints()][sampleSize];
		for (int i = 0; i < sampleSize; i++) {
			data[i] = results[i][experiment].getDataArray(station);
		}
		data = HelperFunctions.transposeMatrix(data);
	}
	
	public int[][] getData() {
		return data;
	}
	
	
}