package DistanceMeasure;

import java.io.*;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
//import java.util.Arrays;

/* For all the distance measures
 * The first element in each array is basal, 
 * then transition, then uptake 
 * (then internalisation if added
*/

public class MeasureResults {
	// A list of the parameter value sets as strings to be printed into csv format
	protected LinkedList<String[]> parameterSet;
	// The following set of distances are the mean distances
	/* The unsigned areas */
	protected LinkedList<double[]> unsignedAreas;
	// The signed areas
	protected LinkedList<double[]> signedAreas;
	// The squared areas
	protected LinkedList<double[]> squaredAreas;
	// The KS distance
	protected LinkedList<double[]> ksDistance;
	// The least squares distance
	protected LinkedList<double[]> quadraticDistance;
	// Repeat all the above but for the supremum of each distance
	protected LinkedList<double[]> unsignedAreasSup;
	protected LinkedList<double[]> signedAreasSup;
	// The squared areas
	protected LinkedList<double[]> squaredAreasSup;
	// The KS distance
	protected LinkedList<double[]> ksDistanceSup;
	protected LinkedList<double[]> quadraticDistanceSup;
	// The distances but combined by 2-Norm
	protected LinkedList<double[]> unsignedAreas2Norm;
	protected LinkedList<double[]> signedAreas2Norm;
	protected LinkedList<double[]> squaredAreas2Norm;
	protected LinkedList<double[]> ksDistance2Norm;
	protected LinkedList<double[]> quadraticDistance2Norm;
	// Distances to be combined by the minimum across timepoints
	protected LinkedList<double[]> unsignedAreasMin;
	protected LinkedList<double[]> signedAreasMin;
	protected LinkedList<double[]> squaredAreasMin;
	protected LinkedList<double[]> ksDistanceMin;
	protected LinkedList<double[]> quadraticDistanceMin;
	// The Kuiper distance
	protected LinkedList<double[]> kuiper;
	protected LinkedList<double[]> kuiperSup;
	protected LinkedList<double[]> kuiper2Norm;
	protected LinkedList<double[]> kuiperMin;
	// The Anderson Darling
	protected LinkedList<double[]> AD;
	protected LinkedList<double[]> ADSup;
	protected LinkedList<double[]> AD2Norm;
	protected LinkedList<double[]> ADMin;
	// The DTS distance
	protected LinkedList<double[]> DTS;
	protected LinkedList<double[]> DTSSup;
	protected LinkedList<double[]> DTS2Norm;
	protected LinkedList<double[]> DTSMin;
	// The weighted area distances mean
	protected LinkedList<double[]> unsignedAreasWeighted;
	protected LinkedList<double[]> signedAreasWeighted;
	protected LinkedList<double[]> squaredAreasWeighted;
	// The weighted area distances sup
	protected LinkedList<double[]> unsignedAreasWeightedSup;
	protected LinkedList<double[]> signedAreasWeightedSup;
	protected LinkedList<double[]> squaredAreasWeightedSup;
	// The weighted area distances 2norm
	protected LinkedList<double[]> unsignedAreasWeighted2Norm;
	protected LinkedList<double[]> signedAreasWeighted2Norm;
	protected LinkedList<double[]> squaredAreasWeighted2Norm;
	// The weighted area distances mean
	protected LinkedList<double[]> unsignedAreasWeightedMin;
	protected LinkedList<double[]> signedAreasWeightedMin;
	protected LinkedList<double[]> squaredAreasWeightedMin;
	// The headers to be written to the file. Should be a comma separated String
	protected String headers;
	
	public MeasureResults() {
		parameterSet = new LinkedList<String[]>();
		unsignedAreas = new LinkedList<double[]>();
		signedAreas = new LinkedList<double[]>();
		squaredAreas = new LinkedList<double[]>();
		unsignedAreasWeighted = new LinkedList<double[]>();
		signedAreasWeighted = new LinkedList<double[]>();
		squaredAreasWeighted = new LinkedList<double[]>();
		ksDistance = new LinkedList<double[]>();
		quadraticDistance = new LinkedList<double[]>();
		kuiper = new LinkedList<double[]>();
		AD = new LinkedList<double[]>();
		DTS = new LinkedList<double[]>();
		unsignedAreasSup = new LinkedList<double[]>();
		signedAreasSup = new LinkedList<double[]>();
		squaredAreasSup = new LinkedList<double[]>();
		unsignedAreasWeightedSup = new LinkedList<double[]>();
		signedAreasWeightedSup = new LinkedList<double[]>();
		squaredAreasWeightedSup = new LinkedList<double[]>();
		ksDistanceSup = new LinkedList<double[]>();
		quadraticDistanceSup = new LinkedList<double[]>();
		kuiperSup = new LinkedList<double[]>();
		ADSup = new LinkedList<double[]>();
		DTSSup = new LinkedList<double[]>();
		unsignedAreas2Norm = new LinkedList<double[]>();
		signedAreas2Norm = new LinkedList<double[]>();
		squaredAreas2Norm = new LinkedList<double[]>();
		unsignedAreasWeighted2Norm = new LinkedList<double[]>();
		signedAreasWeighted2Norm = new LinkedList<double[]>();
		squaredAreasWeighted2Norm = new LinkedList<double[]>();
		ksDistance2Norm = new LinkedList<double[]>();
		quadraticDistance2Norm = new LinkedList<double[]>();
		kuiper2Norm = new LinkedList<double[]>();
		AD2Norm = new LinkedList<double[]>();
		DTS2Norm = new LinkedList<double[]>();
		unsignedAreasMin = new LinkedList<double[]>();
		signedAreasMin = new LinkedList<double[]>();
		squaredAreasMin = new LinkedList<double[]>();
		unsignedAreasWeightedMin = new LinkedList<double[]>();
		signedAreasWeightedMin = new LinkedList<double[]>();
		squaredAreasWeightedMin = new LinkedList<double[]>();
		ksDistanceMin = new LinkedList<double[]>();
		quadraticDistanceMin = new LinkedList<double[]>();
		kuiperMin = new LinkedList<double[]>();
		ADMin = new LinkedList<double[]>();
		DTSMin = new LinkedList<double[]>();
		this.headers = "storeRate,microtubuleRate,fusionRate,membraneRate,activeProbability1,"
	    		+ "activeProbability2,numCustomer,numMicrotubule,microtubuleLength,"
	    		+ "numberOfRepeats,meanActivationTime,"
	    		+ "unsignedAreaBasal,unsignedAreaTransition,unsignedAreaInsulin,"
	    		+ "signedAreaBasal,signedAreaTransition,signedAreaInsulin,"
	    		+ "squaredAreaBasal,squaredAreaTransition,squaredAreaInsulin,"
	    		+ "unsignedAreaWeightedBasal,unsignedAreaWeightedTransition,unsignedAreaWeightedInsulin,"
	    		+ "signedAreaWeightedBasal,signedAreaWeightedTransition,signedAreaWeightedInsulin,"
	    		+ "squaredAreaWeightedBasal,squaredAreaWeightedTransition,squaredAreaWeightedInsulin,"
	    		+ "ksDistanceBasal,ksDistanceTransition,ksDistanceInsulin,"
	    		+ "quadraticDistanceBasal,quadraticDistanceTransition,quadraticDistanceInsulin,"
	    		+ "kuiperBasal,kuiperTransition,kuiperInsulin,"
	    		+ "ADBasal,ADTransition,ADInsulin,"
	    		+ "DTSBasal,DTSTransition,DTSInsulin,"
	    		+ "unsignedAreaSupBasal,unsignedAreaSupTransition,unsignedAreaSupInsulin,"
	    		+ "signedAreaSupBasal,signedAreaSupTransition,signedAreaSupInsulin,"
	    		+ "squaredAreaSupBasal,squaredAreaSupTransition,squaredAreaSupInsulin,"
	    		+ "unsignedAreaWeightedSupBasal,unsignedAreaWeightedSupTransition,unsignedAreaWeightedSupInsulin,"
	    		+ "signedAreaWeightedSupBasal,signedAreaWeightedSupTransition,signedAreaWeightedSupInsulin,"
	    		+ "squaredAreaWeightedSupBasal,squaredAreaWeightedSupTransition,squaredAreaWeightedSupInsulin,"
	    		+ "ksDistanceSupBasal,ksDistanceSupTransition,ksDistanceSupInsulin,"
	    		+ "quadraticDistanceSupBasal,quadraticDistanceSupTransition,quadraticDistanceSupInsulin,"
	    		+ "kuiperSupBasal,kuiperSupTransition,kuiperSupInsulin,"
	    		+ "ADSupBasal,ADSupTransition,ADSupInsulin,"
	    		+ "DTSSupBasal,DTSSupTransition,DTSSupInsulin,"
	    		+ "unsignedArea2NormBasal,unsignedArea2NormTransition,unsignedArea2NormInsulin,"
	    		+ "signedArea2NormBasal,signedArea2NormTransition,signedArea2NormInsulin,"
	    		+ "squaredArea2NormBasal,squaredArea2NormTransition,squaredArea2NormInsulin,"
	    		+ "unsignedAreaWeighted2NormBasal,unsignedAreaWeighted2NormTransition,unsignedAreaWeighted2NormInsulin,"
	    		+ "signedAreaWeighted2NormBasal,signedAreaWeighted2NormTransition,signedAreaWeighted2NormInsulin,"
	    		+ "squaredAreaWeighted2NormBasal,squaredAreaWeighted2NormTransition,squaredAreaWeighted2NormInsulin,"
	    		+ "ksDistance2NormBasal,ksDistance2NormTransition,ksDistance2NormInsulin,"
	    		+ "quadraticDistance2NormBasal,quadraticDistance2NormTransition,quadraticDistance2NormInsulin,"
	    		+ "kuiper2NormBasal,kuiper2NormTransition,kuiper2NormInsulin,"
	    		+ "AD2NormBasal,AD2NormTransition,AD2NormInsulin,"
	    		+ "DTS2NormBasal,DTS2NormTransition,DTS2NormInsulin,"
	    		+ "unsignedAreaMinBasal,unsignedAreaMinTransition,unsignedAreaMinInsulin,"
	    		+ "signedAreaMinBasal,signedAreaMinTransition,signedAreaMinInsulin,"
	    		+ "squaredAreaMinBasal,squaredAreaMinTransition,squaredAreaMinInsulin,"
	    		+ "unsignedAreaWeightedMinBasal,unsignedAreaWeightedMinTransition,unsignedAreaWeightedMinInsulin,"
	    		+ "signedAreaWeightedMinBasal,signedAreaWeightedMinTransition,signedAreaWeightedMinInsulin,"
	    		+ "squaredAreaWeightedMinBasal,squaredAreaWeightedMinTransition,squaredAreaWeightedMinInsulin,"
	    		+ "ksDistanceMinBasal,ksDistanceMinTransition,ksDistanceMinInsulin,"
				+ "quadraticDistanceMinBasal,quadraticDistanceMinTransition,quadraticDistanceMinInsulin,"
				+ "kuiperMinBasal,kuiperMinTransition,kuiperMinInsulin,"
	    		+ "ADMinBasal,ADMinTransition,ADMinInsulin,"
	    		+ "DTSMinBasal,DTSMinTransition,DTSMinInsulin";
	}
	
	public void  registerMeasures(String paramSet[], double[] unsignedArea, double[] signedArea,
			double[] squaredArea, double[] unsignedAreaWeighted, double[] signedAreaWeighted,
			double[] squaredAreaWeighted, double[] ks, double[] ls, double[] kuiperDist, double[] AndersonDarling,
			double[] DTS_twoSample, double[] unsignedSup, double[] signedSup, double[] squaredSup,
			double[] unsignedAreaWeightedSup, double[] signedAreaWeightedSup,
			double[] squaredAreaWeightedSup,
			double[] ksSup, double[] lsSup, double[] kuiperDistSup, double[] AndersonDarlingSup,
			double[] DTS_twoSampleSup, double[] unsignedArea2Norm, double[] signedArea2Norm,
			double[] squaredArea2Norm, double[] unsignedAreaWeighted2Norm, double[] signedAreaWeighted2Norm,
			double[] squaredAreaWeighted2Norm, double[] ksDistances2Norm, double[] ls2Norm, double[] kuiperDist2Norm, 
			double[] AndersonDarling2Norm, double[] DTS_twoSample2Norm, double[] unsignedAreaMin,
			double[] signedAreaMin, double[] squaredAreaMin, 
			double[] unsignedAreaWeightedMin, double[] signedAreaWeightedMin,
			double[] squaredAreaWeightedMin,double[] ksDistancesMin, double[] lsMin,
			double[] kuiperDistMin, double[] AndersonDarlingMin, double[] DTS_twoSampleMin) {
		parameterSet.add(paramSet);
		unsignedAreas.add(unsignedArea);
		signedAreas.add(signedArea);
		squaredAreas.add(squaredArea);
		unsignedAreasWeighted.add(unsignedAreaWeighted);
		signedAreasWeighted.add(signedAreaWeighted);
		squaredAreasWeighted.add(squaredAreaWeighted);
		ksDistance.add(ks);
		quadraticDistance.add(ls);
		kuiper.add(kuiperDist);
		AD.add(AndersonDarling);
		DTS.add(DTS_twoSample);
		unsignedAreasSup.add(unsignedSup);
		signedAreasSup.add(signedSup);
		squaredAreasSup.add(squaredSup);
		unsignedAreasWeightedSup.add(unsignedAreaWeightedSup);
		signedAreasWeightedSup.add(signedAreaWeightedSup);
		squaredAreasWeightedSup.add(squaredAreaWeightedSup);
		ksDistanceSup.add(ksSup);
		quadraticDistanceSup.add(lsSup);
		kuiperSup.add(kuiperDistSup);
		ADSup.add(AndersonDarlingSup);
		DTSSup.add(DTS_twoSampleSup);
		unsignedAreas2Norm.add(unsignedArea2Norm);
		signedAreas2Norm.add(signedArea2Norm);
		squaredAreas2Norm.add(squaredArea2Norm);
		unsignedAreasWeighted2Norm.add(unsignedAreaWeighted2Norm);
		signedAreasWeighted2Norm.add(signedAreaWeighted2Norm);
		squaredAreasWeighted2Norm.add(squaredAreaWeighted2Norm);
		ksDistance2Norm.add(ksDistances2Norm);
		quadraticDistance2Norm.add(ls2Norm);
		kuiper2Norm.add(kuiperDist2Norm);
		AD2Norm.add(AndersonDarling2Norm);
		DTS2Norm.add(DTS_twoSample2Norm);
		unsignedAreasMin.add(unsignedAreaMin);
		signedAreasMin.add(signedAreaMin);
		squaredAreasMin.add(squaredAreaMin);
		unsignedAreasWeightedMin.add(unsignedAreaWeightedMin);
		signedAreasWeightedMin.add(signedAreaWeightedMin);
		squaredAreasWeightedMin.add(squaredAreaWeightedMin);
		ksDistanceMin.add(ksDistancesMin);
		quadraticDistanceMin.add(lsMin);
		kuiperMin.add(kuiperDistMin);
		ADMin.add(AndersonDarlingMin);
		DTSMin.add(DTS_twoSampleMin);
	}
	
	public String convertToCSV(String[] data) {
	    return Stream.of(data)
	      .collect(Collectors.joining(","));
	}
	
	public String[] concat(String[]... arrays) {
	    int length = 0;
	    for (String[] array : arrays) {
	        length += array.length;
	    }
	    String[] result = new String[length];
	    int pos = 0;
	    for (String[] array : arrays) {
	        for (String element : array) {
	            result[pos] = element;
	            pos++;
	        }
	    }
	    return result;
	}
	
	public String[] toStringArray(double[] array) {
		String[] strArray = new String[array.length];
		 
        for (int i = 0; i < array.length; i++) {
            strArray[i] = String.valueOf(array[i]);
        }
        return strArray;
	}
	
	public void writeToFile(String filename) {
		
		File csvOutputFile = new File(filename);
		
		try (PrintWriter pw = new PrintWriter(csvOutputFile)) {
	        pw.println(headers);
	    } catch (Exception e) {
			System.out.println("File "+filename+" has not been created");
		}
		
		List<String[]> data = new ArrayList<>();
		//double t1 = System.currentTimeMillis();
		//System.out.println("Max iteration num: " + parameterSet.size());
		int iterationNum = parameterSet.size();
		for (int i = 0; i < iterationNum; i++) {
			//System.out.println("i: " + i);
			/*data.add(new String[] {double.toString(timeQueue.get(i)), 
					Integer.toString(storeQueue.poll()), Integer.toString(microtubuleQueue.poll()), 
					Integer.toString(fusionQueue.poll()), Integer.toString(membraneQueue.poll())});*/
			data.add(concat(parameterSet.poll(), toStringArray(unsignedAreas.poll()), 
					toStringArray(signedAreas.poll()),toStringArray(squaredAreas.poll()),
					toStringArray(unsignedAreasWeighted.poll()), 
					toStringArray(signedAreasWeighted.poll()),toStringArray(squaredAreasWeighted.poll()),
					toStringArray(ksDistance.poll()),toStringArray(quadraticDistance.poll()),
					toStringArray(kuiper.poll()), toStringArray(AD.poll()), toStringArray(DTS.poll()),
					toStringArray(unsignedAreasSup.poll()),
					toStringArray(signedAreasSup.poll()),
					toStringArray(squaredAreasSup.poll()),
					toStringArray(unsignedAreasWeightedSup.poll()), 
					toStringArray(signedAreasWeightedSup.poll()),toStringArray(squaredAreasWeightedSup.poll()),
					toStringArray(ksDistanceSup.poll()),
					toStringArray(quadraticDistanceSup.poll()),
					toStringArray(kuiperSup.poll()), toStringArray(ADSup.poll()), toStringArray(DTSSup.poll()),
					toStringArray(unsignedAreas2Norm.poll()),
					toStringArray(signedAreas2Norm.poll()), toStringArray(squaredAreas2Norm.poll()),
					toStringArray(unsignedAreasWeighted2Norm.poll()), 
					toStringArray(signedAreasWeighted2Norm.poll()),toStringArray(squaredAreasWeighted2Norm.poll()),
					toStringArray(ksDistance2Norm.poll()),toStringArray(quadraticDistance2Norm.poll()),
					toStringArray(kuiper2Norm.poll()), toStringArray(AD2Norm.poll()), toStringArray(DTS2Norm.poll()),
					toStringArray(unsignedAreasMin.poll()),
					toStringArray(signedAreasMin.poll()),toStringArray(squaredAreasMin.poll()),
					toStringArray(unsignedAreasWeightedMin.poll()), 
					toStringArray(signedAreasWeightedMin.poll()),toStringArray(squaredAreasWeightedMin.poll()),
					toStringArray(ksDistanceMin.poll()),toStringArray(quadraticDistanceMin.poll()),
					toStringArray(kuiperMin.poll()), toStringArray(ADMin.poll()), toStringArray(DTSMin.poll())));
		}
		//System.out.println("Size of Data: " + data.size());
		//double t2 = System.currentTimeMillis();
		//double dt = (t2-t1)/1000d;
	    //System.out.println("Time to make data structure: "+dt+" seconds.");
	    
	    //t1 = System.currentTimeMillis();
		try (PrintWriter pw = new PrintWriter(new FileOutputStream(csvOutputFile, true))) {
	        data.stream()
	          .map(this::convertToCSV)
	          .forEach(pw::println);
	    }
		catch (Exception e) {
			System.out.println("File "+filename+" has not been created");
		}
		//t2 = System.currentTimeMillis();
		//dt = (t2-t1)/1000d;
	    //System.out.println("Actual Write time: "+dt+" seconds.");
	}
	
}