package DistanceMeasure;

import java.lang.Math;

public class HelperFunctions {
	
	/* transpose the data so each row contains multiple samples from the same time point
	 * will make the ecdf section easier
	 */
	public static int[][] transposeMatrix(int[][] matrix){
	    int m = matrix.length;
	    int n = matrix[0].length;

	    int[][] transposedMatrix = new int[n][m];

	    for(int x = 0; x < n; x++) {
	        for(int y = 0; y < m; y++) {
	            transposedMatrix[x][y] = matrix[y][x];
	        }
	    }

	    return transposedMatrix;
	}
	
	public static double[][] transposeMatrix(double[][] matrix){
	    int m = matrix.length;
	    int n = matrix[0].length;
	    
	    double[][] transposedMatrix = new double[n][m];

	    for(int x = 0; x < n; x++) {
	        for(int y = 0; y < m; y++) {
	        	//System.out.println(x);
	    	    //System.out.println(7);
	            transposedMatrix[x][y] = matrix[y][x];
	        }
	    }
	    return transposedMatrix;
	}

	/**
	 * Concatenate two arrays horizontally
	 * @param data1
	 * @param data2
	 * @return
	 */
	/*
	public static double[][] arrayConcat(double[][] data1, double[][] data2) {
		// Easier to concatenate vertically so transpose the matrices to concatenate vertically and then transpose back
		data1 = transposeMatrix(data1);
		data2 =  transposeMatrix(data2);
		double[][] result = new double[data1.length][data1[0].length +data2[0].length];
		for(int j = 0; j < data1.length+data2.length; j++){
		    if (j < data1.length){
		        result[j] = data1[j];
		    } else {
		        result[j] = data2[j-(data1.length)];
		    }
		}
		return transposeMatrix(result);
	}
	*/
	
	public static double[][] arrayConcat(double[][] data1, double[][] data2){
		data1 = transposeMatrix(data1);
		data2 =  transposeMatrix(data2);
		
		double[][] result = new double[data1.length + data2.length][];
		
		System.arraycopy(data1, 0, result, 0, data1.length);
		System.arraycopy(data2, 0, result, data1.length, data2.length);
		return transposeMatrix(result);
	}
	
	/**
	 * returns the sum of a 1d array
	 * @param array
	 * @return
	 */
	public static double arraySum(double[] array) {
	    double sum = 0;
	    for (double value : array) {
	        sum += value;
	    }
	    return sum;
	}
	
	/**
	 * Given an array takes the sum of the square of each element
	 * @param array
	 * @return
	 */
	public static double squareSum(double[] array) {
		double sum = 0;
		for (double i : array) {
			sum += i*i;
		}
		return sum;
	}
	
	/**
	 * 
	 * @param x the x values from the data array
	 * @param limit - the value below which elements will be summed. if x[i] > limit then it doesn't contribute to the sum
	 * @return
	 */
	
	public static double ecdfSum(double[] x, double limit) {
		double sum = 0;
	    for (double value : x) {
	    	// Only contribute to sum if below the current value (limit)
	    	if (value <= limit) {
	    		sum++;
	    	}
	    }
	    return sum;
	}
	
	/*
	public static double ecdfSum(double[] x, double limit) {
		double sum = 0;
	    for (double value : x) {
	    	// Only contribute to sum if below the current value (limit)
	    	if (value <= limit) {
	    		sum += value;
	    	}
	    }
	    return sum;
	}
	*/
	
	/**
	 * Calculates the mean of an array
	 * @param x
	 * @return
	 */
	public static double mean(double[] x) {
		return arraySum(x) / x.length;
	}
	
	/**
	 * Returns the maximum value of some array x
	 * @param x
	 * @return
	 */
	
	public static double max(double[] x) {
		double max = x[0];
		for (int i = 0; i < x.length; i++) {
			if (x[i] > max) {
				max = x[i];
			}
		}
		return max;
	}
	
	/**
	 * Returns the minimum value of some array x
	 * @param x
	 * @return
	 */
	
	public static double min(double[] x) {
		double min = x[0];
		for (int i = 0; i < x.length; i++) {
			if (x[i] < min) {
				min = x[i];
			}
		}
		return min;
	}
	
	
	/**
	 * Given an array, x, the 2-norm is calculated
	 * @param x
	 * @return
	 */
	public static double twoNorm(double[] x) {
		double norm = squareSum(x);
		norm = Math.sqrt(norm);
		return norm;
	}

}