package DiscreteEventSimulation;
import java.util.PriorityQueue;


public class FES {
	/* Sorted list of events in the queue */
	  protected PriorityQueue<Event> events;
	  
	  /**
	   * Constructs an empty event queue
	   */
	  
	  public FES() {
	    events = new PriorityQueue<Event>();
	  }
	  
	  /**
	   * Adds an event to this queue
	   * @param newEvent the new event
	   */
	   
	  public void addEvent(Event newEvent) {
		  events.add(newEvent);
	  }

	  /**
	   * Returns and removes the first event from this queue
	   * @return the event that is removed from this queue.
	   */
	   
	  public Event nextEvent() {
		return events.poll();
	  }
	  
	  /**
	   * 
	   * @return the number of events currently scheduled
	   */
	  public int numberOfEvents() {
		  return events.size();
	  }
}