from Quantum_Network_Architecture.sessions import ApplicationSessionList

import matplotlib.pyplot as plt
import pickle

def test_compute_rolling_prop_min_service(sessions: ApplicationSessionList, end_time: int = 21600, update_period: int = 300):

    results = []
    x = []
    for t in range(0,end_time,update_period):

        sessions_submitted_in_interval = [s for s in sessions if t <= s.demand.submission_time < t+update_period and s.is_expired]

        sessions_submitted_with_minimal_service = [s for s in sessions_submitted_in_interval if s.minimal_service]

        if sessions_submitted_in_interval:
            results.append(len(sessions_submitted_with_minimal_service)/len(sessions_submitted_in_interval) if sessions_submitted_in_interval else 1)
            x.append(t)

    return x, results


if __name__ == '__main__':
    with open('/home/tbeauchamp/quantum-network-arx-evaluation/many-user-p2p-mda/20240425-1600/pickled_session_lists/0.001/0.0/0.pickle', 'rb') as F:
        S = pickle.load(F)

    x,y = test_compute_rolling_prop_min_service(S, update_period=300, end_time=216000)

    fig, ax = plt.subplots()

    ax.plot(x,y)
    fig.show()
