from Quantum_Network_Architecture.schedulers import ExactDemandsNetworkScheduler, NetworkScheduler
from Quantum_Network_Architecture.tasks import PacketGenerationTask
from Quantum_Network_Architecture.networks import HomogeneousStarNetwork

def test_scheduler():

    network = HomogeneousStarNetwork(4, scheduling_interval=300)

    task1 = PacketGenerationTask(
        "A",
        network.end_nodes[:2],
        5,
        1/7,
        session_ids={0:0,1:0},
        links=['1--255', '0--255']

    )
    task2 = PacketGenerationTask(
        "B",
        network.end_nodes[:2],
        4,
        1 / 8,
        session_ids={0: 1, 1: 1},
        links=['1--255', '0--255']
    )

    scheduler = NetworkScheduler([task1, task2], network, scheduling_interval=50, debug=True)
    scheduler.all_tasks.initialise_tasks(0)
    scheduler.all_tasks.get_full_link_ids(network)

    next(scheduler.compute_schedule(skipping=False))
    print(scheduler.all_tasks)



if __name__ == '__main__':
    test_scheduler()