# Quantum Network Architecture Simulation


## Name
Simulation Code for *Beauchamp et. al. "A Modular Quantum Network Architecture for Integrating Network
Scheduling with Local Program Execution" (2024)*  

## Description
This code simulates the operation of a quantum network with a star topology network, using the implementation described in [1].  

## Installation
Python package requirements can be found in requirements.txt

There is also a branch of the `Quantum_Network_Architectiure` submodule called `remove-qoala` which does not require the `Qoala` or `NetSQUID` package.

## Usage

### Running Simulations

The simulations can be run on a single machine with `run-sinulations.sh [-d do dummy scheduling] [-s seed_file] [-m max_child_processes] [-i start_iteration] <config file> <output folder>`". The arguments are:
- **-d** optional flag. If present then will use the dummy scheduler instead of actually computing network schedules. 
- **-s** optional argument to specify a file of seeds. Each line should be in the format "λ R i seed" where λ is the 
session renewal rate, R is the requested packet generation rate, i is the iteration and seed is the seed.   
- **-n** optional argument for how many cores to use to parallelise the simulation, defaults to 20
- **-i** optional argument for setting the starting iteration number, defaults to 0. 
- \<config file\> YAML file describing the simulations to run. See  `configuration_files/README.md` for the required format
- \<output folder\> Directory to write the output data to. The results from a given simulation will be written to `<output folder>/raw-data/λ/R/i.pickle`

For simulations on a HPC using PBS for resource management, simulations can be run using `run-simulations-pbs.sh [-s seed_file] [-d (sets do_scheduling to false)] [-t max_time] [-n partitions] [-i start_iteration] <config file> <output folder>`, where the extra parameters are
- **-n** The number of nodes to use. Will request 20 cores per node as default on the HPC cluster used for our simulations. Splits the simulations in to n partitions, each of which runs on a single node
- **-t** The max wall-time for each partition


The data in the main text was produced with the simulation config files `configuration_files/simulation_configs/many-user-p2p-mda.yaml` and `configuration_files/simulation_configs/many-user-cs-cka.yaml` for the MDA test application and CKA test application respectively.


### Data collation
To collate data from the simulations into a single pickle/csv file, use `python3 data_processing/combine_raw_data_files.py <output folder>/raw-data` This will write the combined files `raw-data.pickle` and `raw-data.csv` into `<output directory>`

### Plotting

Plots can be created with the functions in `data-processing/plotting.py` or with the `combined_plotting.py` script.

The plots in [1] where produced with the indicated lines in `combined_plotting.py`, although the data location
is for the local machine on which the plots were produced.

## Support
Queries should be directed to [t.r.beauchamp@tudelft.nl](t.r.beauchamp@tudelft.nl), or an issue opened in the repository.


## Authors and acknowledgment
Show your appreciation to those who have contributed to the project.

## License
This work has an MIT licence, for more information see the LICENSE file. 


## Bibliography
[1] Thomas Beauchamp, Hana Jirovská, Scarlett Gauthier and Stephanie Wehner *"A Modular Quantum Network Architecture for Integrating Network Scheduling with Local Program Execution"* (2024)