from __future__ import annotations

import logging
import os

from typing import Union, Optional

import os
import logging
from typing import Union, Optional

class LogManager:

    SCHEDULER_LOGGER: str = "NetworkScheduler"
    _SCHEDULER_LOGGER_HAS_BEEN_SET_UP: bool = False

    SESSION_GENERATOR_LOGGER: str = "SessionGenerator"
    _SESSION_GENERATOR_LOGGER_HAS_BEEN_SET_UP: bool = False

    PGASIMULATOR_LOGGER: str = "PGASimulator"
    _PGASIMULATOR_LOGGER_HAS_BEEN_SET_UP: bool = False

    _LOG_FOLDER: Optional[str] = None

    FORMATTER = logging.Formatter(
        "%(levelname)s:%(name)s:%(message)s"
    )

    # Scheduler Logger Methods
    @classmethod
    def _set_up_scheduler_logger(cls) -> None:
        logger = logging.getLogger(cls.SCHEDULER_LOGGER)
        syslog = logging.StreamHandler()  # Logs to stderr
        syslog.setFormatter(cls.FORMATTER)
        logger.addHandler(syslog)

        logger.setLevel(level="INFO")
        cls._SCHEDULER_LOGGER_HAS_BEEN_SET_UP = True

    @classmethod
    def get_scheduler_logger(cls) -> logging.Logger:
        if not cls._SCHEDULER_LOGGER_HAS_BEEN_SET_UP:
            cls._set_up_scheduler_logger()
        return logging.getLogger(cls.SCHEDULER_LOGGER)

    # Additional Scheduler Methods
    @classmethod
    def set_scheduler_log_level(cls, level: Union[int, str]) -> None:
        cls.get_scheduler_logger().setLevel(level)

    @classmethod
    def get_scheduler_log_level(cls) -> int:
        return cls.get_scheduler_logger().level

    # Session Generator Logger Methods
    @classmethod
    def _set_up_session_generator_logger(cls) -> None:
        logger = logging.getLogger(cls.SESSION_GENERATOR_LOGGER)
        syslog = logging.StreamHandler()  # Logs to stderr
        syslog.setFormatter(cls.FORMATTER)
        logger.addHandler(syslog)

        logger.setLevel(level="INFO")
        cls._SESSION_GENERATOR_LOGGER_HAS_BEEN_SET_UP = True

    @classmethod
    def get_session_generator_logger(cls) -> logging.Logger:
        if not cls._SESSION_GENERATOR_LOGGER_HAS_BEEN_SET_UP:
            cls._set_up_session_generator_logger()
        return logging.getLogger(cls.SESSION_GENERATOR_LOGGER)

    # Additional Session Generator Methods
    @classmethod
    def set_session_generator_log_level(cls, level: Union[int, str]) -> None:
        cls.get_session_generator_logger().setLevel(level)

    @classmethod
    def get_session_generator_log_level(cls) -> int:
        return cls.get_session_generator_logger().level

    # PGASimulator Logger Methods
    @classmethod
    def _set_up_pgasimulator_logger(cls) -> None:
        logger = logging.getLogger(cls.PGASIMULATOR_LOGGER)
        syslog = logging.StreamHandler()  # Logs to stderr
        syslog.setFormatter(cls.FORMATTER)
        logger.addHandler(syslog)

        logger.setLevel(level="INFO")
        cls._PGASIMULATOR_LOGGER_HAS_BEEN_SET_UP = True

    @classmethod
    def get_pgasimulator_logger(cls) -> logging.Logger:
        if not cls._PGASIMULATOR_LOGGER_HAS_BEEN_SET_UP:
            cls._set_up_pgasimulator_logger()
        return logging.getLogger(cls.PGASIMULATOR_LOGGER)

    # Additional PGASimulator Methods
    @classmethod
    def set_pgasimulator_log_level(cls, level: Union[int, str]) -> None:
        cls.get_pgasimulator_logger().setLevel(level)

    @classmethod
    def get_pgasimulator_log_level(cls) -> int:
        return cls.get_pgasimulator_logger().level

    # @classmethod
    # def set_log_folder(cls, folder: str) -> None:
    #     if not os.path.isdir(folder):
    #         os.makedirs(folder)
    #
    #     cls._LOG_FOLDER = folder

    @classmethod
    def log_to_file(cls, file: str, remove_syslog: bool = True):

        # if cls._LOG_FOLDER is None:
        #     raise AttributeError("No folder for log file specified")

        loggers = [cls.get_scheduler_logger(), cls.get_session_generator_logger(), cls.get_pgasimulator_logger()]

        # file = os.path.join(cls._LOG_FOLDER, "central-controller.log")

        for logger in loggers:
            if not logger.hasHandlers():
                syslog = logging.StreamHandler()  # Logs to stderr
                syslog.setFormatter(cls.FORMATTER)
                logger.addHandler(syslog)



            file_handler = logging.FileHandler(file, mode="w")
            file_handler.setFormatter(cls.FORMATTER)

            if remove_syslog and len(logger.handlers) > 0:
                if isinstance(logger.handlers[0], logging.StreamHandler):
                    logger.removeHandler(logger.handlers[0])

            logger.addHandler(file_handler)





