from Quantum_Network_Architecture.networks import Network
from Quantum_Network_Architecture.tasks import PacketGenerationTask, Taskset
from Quantum_Network_Architecture.sessions import ApplicationSessionList
from Quantum_Network_Architecture.utils.logging import LogManager

from datetime import timedelta

from numpy import random

from typing import Optional

def simple_simulation_of_pgas(
        sessions: ApplicationSessionList,
        start_time: float,
        end_time: float,
        time_slot_length: int,
        pga_success_probability: float,
        rng: Optional[random.Generator] = None,
        seed: Optional[int] = None,
) -> None:

    logger = LogManager().get_pgasimulator_logger()

    logger.info(f"Starting simple PGA simulation with parameters: "
                                                f"[sessions: {sessions.identifiers}, start_time: {timedelta(seconds=start_time/1e9)}, end_time: {timedelta(seconds=end_time/1e9)}, " 
                                                f"time_slot_length: {time_slot_length},"
                                                f" pga_success_probability: {pga_success_probability}, " 
                                                f"seed: {seed}]"
                                                )
    if rng is None:
        rng = random.default_rng(seed)

    start_time = start_time // time_slot_length
    end_time = end_time // time_slot_length

    for session in sessions:
        if session.demand.packet_generation_task is not None:
            pgas_to_test = [s for s in session.demand.packet_generation_task.end_times if start_time < s < end_time]

            successes = rng.binomial(len(pgas_to_test), pga_success_probability)
            session.executed_instances += successes


    pass

