import argparse


def p_int(N):
    try:
        value = int(N)
    except ValueError:
        msg = f"{N} is not a positive integer"
        raise argparse.ArgumentTypeError(msg)

    if value <= 0:
        msg = f"{N} is not a positive integer"
        raise argparse.ArgumentTypeError(msg)
    return value

def get_cmd_arg_parser(task_file: bool = True) -> argparse.ArgumentParser:

    cmd_argument_parser = argparse.ArgumentParser()

    cmd_argument_parser.add_argument('--solver', choices=["EDF", "CP", "REDF", "bEDF", "BEDF",'rEDF', 'redf', 'edf','cp', 'bedf', 'rbEDF','RBEDF', 'dEDF','DEDF'], default='CP', help='Which solver to use. rEDF is rate reducing EDF, bEDF is branching EDF, brEDF is branching rate reducing EDF')
    cmd_argument_parser.add_argument('--ignore-resource-requirements', '-r', action='store_true', help='neglect resource requirements')
    cmd_argument_parser.add_argument('--minsep', action='store_true', help="include minimum separation constraints")
    cmd_argument_parser.add_argument('--maxsep', action='store_true', help="include maximum separation constraints")
    cmd_argument_parser.add_argument('--continuation', '-c', action='store_true', help=" apply separation constraints 'into the next schedule'")
    cmd_argument_parser.add_argument('--periodic', '-p', action='store_true', help = "use forced periodic tasks")
    cmd_argument_parser.add_argument('--satisfy','-s',action='store_true', help= "Look for an optimal or satisfying solution")
    cmd_argument_parser.add_argument('--display-tasks', '-t', action='store_true', help="Show ingested tasks")
    if task_file:
        cmd_argument_parser.add_argument('task_file', action='store', help="location of the tasks yaml file")

    cmd_argument_parser.add_argument('--debug','-d', action='store_true', help='Show debug messages')
    cmd_argument_parser.add_argument('--time-limit', '--tl', type=p_int, help='Time limit for MiniZinc Solver in seconds', default=360)
    cmd_argument_parser.add_argument('--verification', '-v', action='store_true', help='Toggle verification mode')
    cmd_argument_parser.add_argument('--length-of-schedule', '-l', type=p_int, help="how many time steps to compute the network schedule for.", default=2000)
    cmd_argument_parser.add_argument("--hyperperiod", '--hyp', help="Set the schedule length to the hyperperiod. N.B. This will overwrite --length-of-schedule", action='store_true')
    cmd_argument_parser.add_argument('--supress-results', '--sr', action="store_true", help="Don't show result of schedule computation")
    cmd_argument_parser.add_argument('--display-length', '--dl', action="store", type=p_int, help="number of time steps for which to print schedules", default=50)
    cmd_argument_parser.add_argument('--rate-reduction-method', '--rrm', choices=["hr", "HR", "u", "U", 'S', 's'], help="Which method to use in rate reduction EDF. HR for highest rate, U for uniform, S for simultaneous.", default="HR")
    cmd_argument_parser.add_argument('--csv', type=str, action="store", help="CSV file to write data to")
    cmd_argument_parser.add_argument('--max-schedule-length', '--msl', type=p_int, help="Maximum permitted length of a network schedule.", default=2000)
    cmd_argument_parser.add_argument('--max-rate-reduction-iterations','--mrri', type=p_int, default=1000, help="Maximum number of iterations allowed in a rate reduction algorithm")
    cmd_argument_parser.add_argument("--output-folder", "--of", default="default", type=str, help = "root folder into which to put files. ")
    cmd_argument_parser.add_argument("--scheduling-interval", "--si", type=p_int, default=200, help="Number of time steps between computing the next portion of the network schedule.")

    #TODO: Add distinction between scheduling interval and schedule length.


    return cmd_argument_parser


# def get_continuous_cmd_args_parser():






class Cmd_Args:
    #Dummy class to help with autocompleting command line arguments
    def __init__(self):
        self.solver: str = ''
        self.ignore_resource_requirements: bool = False
        self.minsep: bool = True
        self.maxsep: bool = False
        self.satisfy: bool = True
        self.continuation: bool = False
        self.periodic: bool = False
        self.display_tasks: bool = False
        self.task_file: str = ''
        self.debug: bool = False
        self.time_limit: int = 360
        self.verification: bool = False
        self.length_of_schedule: int = -1
        self.hyperperiod: bool = False
        self.supress_results: bool = False
        self.display_length: int = 50
        self.rate_reduction_method: str = ''
        self.csv: str = ''
        self.max_schedule_length: int = 2000
        self.max_rate_reduction_iteration: int = 1000
        self.Lambda: float = 0.01
        self.iterations: int = 20
        self.output_folder: str = "default"
        self.scheduling_interval:int = 200



