# Quantum-Network-Architecture

Implementation of the network architecture in [1].

## Installation

The required packages can be found in requirements.txt

Qoala can be obtained from https://github.com/QuTech-Delft/qoala-sim.git

## Usage

To run simulations, the runner scripts in `simulations` should be used.
Note that the `run_qoala_sim.py` script is depreciated but retained for reference.

The `schedulers` submodule contains the network schedulers. There are three schedulers:

- `NetworkScheduler` - permits rate throttling
- `ExactDemandsNetworkScheduler` - used in evaluation of [1], does not permit throttling rates of PGTs
- `DummyNetworkScheduler` - Does not actually compute valid schedules, used in supplementary data collection.

The `networks` submodule contains classes representing the network in the scheduler. This has two classes:

- `nodes.Node` which represents end nodes in the network
- `Link` which represents a link between two end nodes
- `Network` which represents the network as a whole

The `demands` submodule contains the `NetworkDemand` class representing the demands submitted by end nodes, as well as
functions used to convert them to PGTs

The `tasks` submodule contains the `PacketGenerationTask` class which represents PGTs to be scheduled.

`schedules.py` contains the representation of the network schedule, and `sessions.py` the representation of schedules.

## Output from simulations

The function `simulation.runners.run_network_simulation_homogeneous_demands` outputs a pandas dataframe with the
following headings/index, and a single row of data from the simulation ran. :

<style type="text/css">
.tg  {border-collapse:collapse;border-spacing:0;}
.tg td{border-color:black;border-style:solid;border-width:1px;font-family:Arial, sans-serif;font-size:14px;
  overflow:hidden;padding:10px 5px;word-break:normal;}
.tg th{border-color:black;border-style:solid;border-width:1px;font-family:Arial, sans-serif;font-size:14px;
  font-weight:normal;overflow:hidden;padding:10px 5px;word-break:normal;}
.tg .tg-c3ow{border-color:inherit;text-align:center;vertical-align:top}
</style>
<table class="tg">
<thead>
  <tr>
    <th class="tg-c3ow" colspan="3">Index</th>
    <th class="tg-c3ow" colspan="3">Number of<br>Sessions</th>
    <th class="tg-c3ow" colspan="2">Prop. minimal service</th>
    <th class="tg-c3ow" colspan="4">Average Time for</th>
    <th class="tg-c3ow" colspan="2">Average PGT<br>statistics</th>
    <th class="tg-c3ow" colspan="2">Average Schedule<br>statistics</th>
    <th class="tg-c3ow">Average utilisation<br> of links...</th>
  </tr></thead>
<tbody>
  <tr>
    <td class="tg-c3ow">R</td>
    <td class="tg-c3ow">λ</td>
    <td class="tg-c3ow">i</td>
    <td class="tg-c3ow">total</td>
    <td class="tg-c3ow">expired</td>
    <td class="tg-c3ow">expired <br>no service</td>
    <td class="tg-c3ow">all</td>
    <td class="tg-c3ow">expired</td>
    <td class="tg-c3ow">queue</td>
    <td class="tg-c3ow"><span style="font-weight:400;font-style:normal;text-decoration:none">latency</span></td>
    <td class="tg-c3ow">sojourn</td>
    <td class="tg-c3ow">service</td>
    <td class="tg-c3ow">R^attempt</td>
    <td class="tg-c3ow">U</td>
    <td class="tg-c3ow">PGAs per SI</td>
    <td class="tg-c3ow">max resource utilisation</td>
    <td class="tg-c3ow">link_1, etc.</td>
  </tr>
</tbody>
</table>


## Bibliography

[1] Thomas Beauchamp, Hana Jirovská, Scarlett Gauthier and Stephanie Wehner *"A Modular Quantum Network Architecture for Integrating Network Scheduling with Local Program Execution"* (2025)
