import pandas as pd
from pathlib import Path
import xarray as xr
import os
import datetime

dataset = []

folder = 'max/'
# folder = '/NAS_Public/petros/mswep/max/'

for file in Path(folder).glob('*.nc'):
    filename = (os.path.splitext(os.path.split(file)[-1])[0])
    id = filename.split('-')[0]
    country = filename.split('-')[1]

    # Skip the file with id 481
    if id == '481':
        print(f"Skipping file with id {id}")
        continue

    ds = xr.open_dataset(file)
    
    # Drop the 'bnds' dimension if it exists
    if 'bnds' in ds.dims:
        ds = ds.isel(bnds=0)  # Keep only one value (e.g., first)
    
    # Convert the dataset to a dataframe and calculate the mean over lat/lon if dimensions exist
    df = ds.mean(dim=[dim for dim in ['lat', 'lon', 'latitude', 'longitude'] if dim in ds.dims]).to_dataframe().reset_index()
    print(df)

    # Check if the 'precipitation' column has fewer than 5 values, and handle it
    if len(df['precipitation']) < 5:
        print(f"File {filename} has less than 5 precipitation values, filling with 0.69.")
        # Fill missing values with 0.69
        missing_values = 5 - len(df['precipitation'])
        df['precipitation'] = df['precipitation'].tolist() + [0.69] * missing_values
        df = df.head(5)  # Make sure we have exactly 5 entries (filling the missing values)

    # Extract the first 5 values from precipitation
    d0 = df['precipitation'][0]
    d1 = df['precipitation'][1]
    d2 = df['precipitation'][2]
    d3 = df['precipitation'][3]
    d4 = df['precipitation'][4]

    # Get the date corresponding to the maximum precipitation
    date = df.loc[df.precipitation == df.precipitation.max(), 'time'].values[0]
    x = pd.to_datetime(date)
    maxT = str(x.date())

    # Store the results
    data = [id, d0, d1, d2, d3, d4, maxT]
    dataset.append(data)

# Create a DataFrame from the dataset
out = pd.DataFrame(columns=['id', 'Day-3', 'Day-2', 'Day-1', 'Day0', 'Day1', 'maxT'], data=dataset)

all = pd.read_excel('./points.xlsx')
print(all)
all.rename(columns={'fatality_id': 'id'}, inplace=True)
out['id'] = out['id'].astype(int)
all['id'] = all['id'].astype(int)

floods = pd.merge(all,out,how='left', on='id')
floods['maxT'] = pd.to_datetime(floods['maxT'])

floods.to_excel('Daily_R24.xlsx', header=True, index=False)

