import pandas as pd
from pathlib import Path
import xarray as xr
import os

# Directory containing the NetCDF files
folder = './'

# List to store the results
dataset = []

for file in Path(folder).glob('*.nc'):
    try:
        filename = os.path.splitext(os.path.split(file)[-1])[0]
        id = filename.split('-')[0]
        country = filename.split('-')[1]
        
        ds = xr.open_dataset(file)
        
        # Calculate rolling sums for 3, 6, 12, 24, and 48 hours
        max3 = ds['precipitation'].rolling(time=1, center=False).sum().max(dim='time')
        max6 = ds['precipitation'].rolling(time=2, center=False).sum().max(dim='time')
        max12 = ds['precipitation'].rolling(time=4, center=False).sum().max(dim='time')
        max24 = ds['precipitation'].rolling(time=8, center=False).sum().max(dim='time')
        max48 = ds['precipitation'].rolling(time=16, center=False).sum().max(dim='time')
        
        # Convert to DataFrame and calculate the overall maximum for each rolling window
        df_max3 = max3.to_dataframe().reset_index()
        df_max6 = max6.to_dataframe().reset_index()
        df_max12 = max12.to_dataframe().reset_index()
        df_max24 = max24.to_dataframe().reset_index()
        df_max48 = max48.to_dataframe().reset_index()
        
        max3_value = df_max3['precipitation'].max()
        max6_value = df_max6['precipitation'].max()
        max12_value = df_max12['precipitation'].max()
        max24_value = df_max24['precipitation'].max()
        max48_value = df_max48['precipitation'].max()
        
        data = [id,max3_value, max6_value, max12_value, max24_value, max48_value]
        dataset.append(data)

        # Print confirmation after processing each file
        print(f"{id} {country} OK")
    except Exception as e:
        print(f"Error processing {file}: {e}")

# Create a DataFrame from the results
out = pd.DataFrame(columns=['id', 'Max3h', 'Max6h', 'Max12h', 'Max24h', 'Max48h'], data=dataset)

# Save the results to an Excel file
#output_excel = 'floods_mswep3h.xlsx'
#out.to_excel(output_excel, header=True, index=False)
#print(f"Results saved to {output_excel}")

# If you need to merge with another DataFrame
all_data = pd.read_excel('points.xlsx')
all_data.rename(columns={'fatality_id': 'id'}, inplace=True)
out['id'] = out['id'].astype(int)
floods = pd.merge(all_data, out, how='left', on='id')

merged_output_excel = 'Max-rolling_R.xlsx'
floods.to_excel(merged_output_excel, header=True, index=False)
print(f"Merged results saved to {merged_output_excel}")
