# Annual damage maps of Antarctic Ice Shelves
Created by Dr. Maaike Izeboud (maaike.izeboud@vub.be) \
Created: 1/2024 \
Last updated: 17/7/2025

## Intro
This repository contains Annual Damage Maps of Antarctic Ice Shelves, obtained from processing remote sensing observations with the NormalisEd Radon Transform Damage (NeRD) Detection method.

The damage maps are discussed in the the article "Damage development on Antarctic ice shelves sensitive to climate warming" (in review at Nature Climate Change, 2025). Code used to process and analyse the data as discussed in the article, are provided at [github.com/mizeboud/antarctic-damage-change](https://github.com/mizeboud/antarctic-damage-change)

The NeRD method is discussed in the article "Damage detection on antarctic ice shelves using the Normalised Radon Transform" (doi: https://doi.org/10.1016/j.rse.2022.113359) and publicly available at [github.com/mizeboud/NormalisedRadonTransform](https://github.com/mizeboud/NormalisedRadonTransform).

## About the Damage Maps
We detect damage on Antarctic ice shelves from SAR remote sensing imagery, using the Normalised Radon Transform Detection method. Damage maps are created for the years 1997, 2000, 2015, 2016, 2017, 2018, 2019, 2020, 2021; obtained from SAR data from the Radarsat mission (1997 and 2000) and Sentinel-1 observations (2015-2021). For all data we utilise HH polarisation only and observations from the period September-October-November (SON) of each year.

The Sentinel-1 EW band data have native 40m spatial resolution. Damage detection with NeRD was done in two ways, to generate (a) 400 m resolution damage maps and (b) 1000 m resolution damage maps. The article discusses damage assessed at 1000m resolution.
The RAMP data are native 100m spatial resolution and damage maps were produced at 1000 m resolution.

The damage value is a continuous signal indicating the strength of the visibility of the feature between 0 (no damage) and 0.5 (high signal). It is not a physical interpretation of the depth of the fracture, though it is likely correlated.

## Damage Maps data format

The damage maps are available in three main formats:

1. Accessible as Google Earth Engine Asset
Code to view data: https://code.earthengine.google.com/1984c17a29c3720e7ad3327a79a81527 \
Asset IDs: \
``ee.ImageCollection("users/izeboudmaaike/damage_detection/S1_relorbs_40m_10px_dmg"), ee.ImageCollection("users/izeboudmaaike/damage_detection/S1_relorbs_40m_25px_dmg"), ee.ImageCollection("users/izeboudmaaike/damage_detection/S1_relorbs_40m_10px_dmg");`` \
With bands ``['crevSig', 'alphaC' , 'dmg']``, where ``crevSig`` is the raw signal including noise, `dmg` is the damage signal after noise removal and `alphaC` is the detected orientation of the damage feature with respect to the image horizontal axis.

2. Accessible as GeoTiff files in Antarctic Polar Stereographic projection (EPSG:3031), organised per year by tile number as defined in `gridTiles_iceShelves.shp`. Data is clipped to annual ice shelf boundaries as defined in `annual_iceshelf_polygons`

3. Accessible as NetCDF files in Antarctic Polar Stereographic projection (EPSG:3031), organised per year by sector (sectors defined in `AIS_outline_sectors.shp`)



## Advice when using the Damage Maps
A noise threshold is applied in the NeRD algorithm to convert the raw crevasse signal (`crevSig`) to damage (`dmg`). Due to high noise variability of SAR data some regions/years of the damage maps might still contain more noise than is preferred for the intended application. It is advice to check, and possibly adjust, the threshold (i.e. remove pixels with low damage signal values).


## File descriptions:


* `AIS_outline_sectors.zip`: shapefile containing geospatial outlines of defined sectors in Antarctica used for organising the files. Defined sectors are: Amundsen Sea Embayment (ASE), Bellingshausen Sea Embayment (BSE), Wedell Sea (WS), East Indian Sea Sector (EIS), West Indian Sea Sector (WIS), Ross Sea Sector (RS).

* `gridTiles_iceShelves_FTYPE`: contains geospatial outlines of defined regularised tiles used to process the Antarctic domain in smaller pieces. Available as geojson or shapefile. Tiles are numbered, 0 to 312.
![alt text](./gridTiles_sectors.png?raw=true)

* `damage_tiled_[400m, 1000m].zip`: contains geotiffs of annually detected damage, per tile. The 400m resolution damage maps are available for years 2015-2021; the 1000m resolution for 1997, 2000 and 2021. Files have naming convention dmg_YYYY-SON_tile_N.tif with YYYY the year and N the tile-number.

* `damage_sector_netcdf_[400m, 1000m]_netcdf.zip`: contains annually detected damage organised per sector instead of tile. Files have naming convention dmg_sector-XXX_YYYY-SON_RES with XXX the sector abbreviation, YYYY the year ( 1997, 2000 and 2015-2021), and RES resolution of 400m or 1000m.

* `nodata_masks.zip`: maps of no-data areas per sector per year for Sentinel-1 data, years 2015-2021. NB: the mask identifies areas with "nodata=1" and areas with valid data=0.
