########## about #############
# data inks: CV-PU1 dilution series (in Gink manuscript named Gink5)
# data pre-inks: LH-ESRF-M5 with SDC 2 mg/m2 (samples 106-108)

########### prelims #################
library(ggplot2)
library(latex2exp) # To use latex in plots
library(reshape2) # for reshaping my data into the long format.
library(scales)


################# Read data ####################################################
stephold_data <- read.csv(file="C:/Users/s168562/OneDrive - TU Eindhoven/PhD/1_StretchableGink/Data_analysis/Rheology/Step-hold/stephold_test.csv", 
                      header=F, sep=",",dec=".",skip=5)

outfolder <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/1_StretchableGink/Data_analysis/Rheology/Step-hold/Figures/"

################# color palettes ##############################################
### colorblind-friendly from https://jfly.uni-koeln.de/color/
# The palette with grey:
cbPalette <- c("#999999", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
               "#0072B2", "#D55E00", "#CC79A7")

# The palette with black:
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
                "#0072B2", "#D55E00", "#CC79A7")
TUred <- "#C81919"
# another palette with 15 colors (source: https://jacksonlab.agronomy.wisc.edu/2016/05/23/15-level-colorblind-friendly-palette/)
pal <- c("#000000","#004949","#009292","#ff6db6","#ffb6db",
         "#490092","#006ddb","#b66dff","#6db6ff","#b6dbff",
         "#920000","#924900","#db6d00","#24ff24","#ffff6d")
cbPalblue <- c("#f0f9e8", "#bae4bc", "#7bccc4", "#43a2ca","#0868ac")
cbPalblueyellow <- c("#ffffcc", "#a1dab4", "#41b6c4", "#2c7fb8","#253494")
cbPalVivid_correctorder <- c("#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC")
cbPalVivid <- c("#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75")
cm2inch <- 1/2.54

# To use for fills, add
# scale_fill_manual(values=cbPalette)

# To use for line and point colors, add
# scale_colour_manual(values=cbPalette)


################ step-hold test LH-PU20 ######################################
stephold_df <- data.frame(Time = stephold_data[,1],
                     Gink6 = stephold_data[,5]#, # LH-PU20
                     # Gink6_sd = stephold_data[,6]
)
stephold_sd_df <- data.frame(Time = stephold_data[,1],
                          Gink6 = stephold_data[,6]#, # LH-PU20
                          # Gink6_sd = stephold_data[,6]
)

figname <-  "LH-PU20"

# ## Reshape my data into a long-format with one column for the ink number and one for the viscosity value.
stephold_long <- melt(stephold_df, id.var = 1)
stephold_sd_long <- melt(stephold_sd_df, id.var = 1)
stephold_long$sd <- stephold_sd_long$value
stephold_long$min <- stephold_long$value - stephold_sd_long$value
stephold_long$max <- stephold_long$value + stephold_sd_long$value
colnames(stephold_long)[colnames(stephold_long) == "variable"] <- "Ink" # Rename column

## Plot pdf
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = Gink6 - Gink6_sd, ymax = Gink6 + Gink6_sd), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 500, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 200, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

## Plot tiff
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = Gink6 - Gink6_sd, ymax = Gink6 + Gink6_sd), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 500, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 200, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

## Plot tiff - TU red
tiff(paste(outfolder, figname, "_red.tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = Gink6 - Gink6_sd, ymax = Gink6 + Gink6_sd), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=TUred) +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 500, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 200, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

## Plot pdf 5.5 x 3.8 for 3x3 figures
pdf(paste(outfolder, figname, "_smaller.pdf", sep=""),
    width = 5.5*cm2inch, height = 3.8*cm2inch)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = min, ymax = max), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 600, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 300, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

## Plot tiff 5.5 x 3.8 for 3x3 figures
tiff(paste(outfolder, figname, "_smaller.tiff", sep=""),
     width = 5.5, height = 3.8, units = "cm", compression = "lzw", res = 800, pointsize = 8)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = min, ymax = max), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 600, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 300, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

## Plot pdf 5.5 x 3.8 for 3x3 figures blue
pdf(paste(outfolder, figname, "_smaller_blue.pdf", sep=""),
    width = 5.5*cm2inch, height = 3.8*cm2inch)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = min, ymax = max), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  # scale_colour_manual(values=cbPalVivid[3:5]) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = -1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3") +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 600, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 300, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

## Plot tiff 5.5 x 3.8 for 3x3 figures blue
tiff(paste(outfolder, figname, "_smaller_blue.tiff", sep=""),
     width = 5.5, height = 3.8, units = "cm", compression = "lzw", res = 800, pointsize = 8)
viscosity_plot <- ggplot(data = stephold_long, aes(x = Time, y = value, color = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = Time, ymin = min, ymax = max), width = 0.025) +
  scale_x_continuous(labels = label_number(accuracy = 1), breaks = c(0, 60, 120, 180, 240), limits = c(0, 240), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = c(0.01, 1, 100), breaks = c(0.01, 1, 100), limits = c(0.001, 1000)) + #scientific / label_number(accuracy = .1)
  scale_y_log10(labels = c(1, 10, 100, 1000), breaks = c(1, 10, 100, 1000), limits = c(1, 1000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(0.001, 0.01, .1, 1, 10, 100, 1000, 10000, 10000), limits = c(.001, 10000)) +
  annotation_logticks(sides = "rl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Time \\[s\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  # scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  # scale_colour_manual(values=cbPalVivid[3:5]) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = -1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3") +
  guides(color = F) + # remove legend for plot color
  theme_bw(base_size = 8) +
  # geom_text(x = 1, y = 30, label="test") + # doesn't work without legend?
  # annotate(geom = "text", x = 30, y = 200, label = TeX("\$\dot{\gamma}\$ = 0.1 s^{-1}"))
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) + #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
  annotate(geom = "text", x = 30, y = 600, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 90, y = 6, label = TeX("$\\dot{\\gamma}$ = 100 s^{-1}"),
           size = 2) +
  annotate(geom = "text", x = 180, y = 300, label = TeX("$\\dot{\\gamma}$ = 0.1 s^{-1}"),
           size = 2)
viscosity_plot
dev.off()

