########### prelims #################
library(ggplot2)
library(latex2exp) # To use latex in plots
library(reshape2) # for reshaping my data into the long format.


########### color palettes ###############
### colorblind-friendly from https://jfly.uni-koeln.de/color/
# The palette with grey:
cbPalette <- c("#999999", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
               "#0072B2", "#D55E00", "#CC79A7")

# The palette with black:
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
                "#0072B2", "#D55E00", "#CC79A7")

TUred <- "#C81919"

# another palette with 15 colors (source: https://jacksonlab.agronomy.wisc.edu/2016/05/23/15-level-colorblind-friendly-palette/)
pal <- c("#000000","#004949","#009292","#ff6db6","#ffb6db",
         "#490092","#006ddb","#b66dff","#6db6ff","#b6dbff",
         "#920000","#924900","#db6d00","#24ff24","#ffff6d")
cbPalblue <- c("#f0f9e8", "#bae4bc", "#7bccc4", "#43a2ca","#0868ac")
cbPalblueyellow <- c("#ffffcc", "#a1dab4", "#41b6c4", "#2c7fb8","#253494")
cbPalVivid_correctorder <- c("#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC")
cbPalVivid <- c("#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75")
cm2inch <- 1/2.54

#################### Define inputs #########################################
## Sample file
infile <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/DLS/LH-GNP6(tip)/LH-GNP6_2022-03-09.csv"
# infile <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/DLS/LH-GNP6(tip)/LH-GNP6_tip_2022-03-09.csv"
# infile <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/DLS/DMF/LH-GNP12_2022-03-09.csv"

## Sample name
sample <- "LH-GNP6"

## output folder
outfolder <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/DLS/LH-GNP6(tip)"
# outfolder <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/2_HR_printing/Data_analysis/DLS/DMF"


#################### Read data #############################################
DLS_data <- read.csv(file=infile, header=F, sep=",",dec=".",skip=4) # LH-GNP6

# DLS <- DLS_data[,6:9]
colnames(DLS_data) <- c("Particle_diameter", "Freq_int_weighted1", "Freq_vol_weighted1",
                 "Freq_num_weighted1", "Freq_int_weighted2", "Freq_vol_weighted2",
                 "Freq_num_weighted2", "Freq_int_weighted3", "Freq_vol_weighted3",
                 "Freq_num_weighted3")


##################### Plot ##################################################
plotname <- "_intensityweighted.pdf"
pdf(paste(outfolder, paste(sample, plotname, sep=""), sep="/"),
    width = 6.5*cm2inch, height = 4.5*cm2inch, bg = "transparent")
Freq_plot <- ggplot(data = DLS_data, aes(x = Particle_diameter, y = Freq_int_weighted1)) + # , color = variable
  geom_line(size = .75, color = cbPalVivid[2]) + #geom_point(size = 3)
  geom_line(aes(x = Particle_diameter, y = Freq_int_weighted2), color = cbPalVivid[3], size = 0.75) +
  geom_line(aes(x = Particle_diameter, y = Freq_int_weighted3), color = cbPalVivid[6], size = 0.75) +
  xlab(TeX("Hydrodynamic diameter \\[nm\\]")) +
  ylab(TeX("Frequency \\[%\\]")) +
  # xlim(0, 5000) +
  # ylim(0, 15) +
  scale_x_log10(limits = c(1, 10000)) +
  # annotation_logticks(sides = "b", size = 0.125,
  #                     short = unit(.25,"mm"),
  #                     mid = unit(.5,"mm"),
  #                     long = unit(.7,"mm")) + #0.125
  # labs(color = "Ink") + # legend label
  scale_colour_manual(values=cbPalVivid) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
Freq_plot
dev.off()

plotname <- "_intensityweighted.tiff"
tiff(paste(outfolder, paste(sample, plotname, sep=""), sep="/"),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
Freq_plot <- ggplot(data = DLS_data, aes(x = Particle_diameter, y = Freq_int_weighted1)) + # , color = variable
  geom_line(size = .75, color = cbPalVivid[2]) + #geom_point(size = 3)
  geom_line(aes(x = Particle_diameter, y = Freq_int_weighted2), color = cbPalVivid[3], size = 0.75) +
  geom_line(aes(x = Particle_diameter, y = Freq_int_weighted3), color = cbPalVivid[6], size = 0.75) +
  xlab(TeX("Hydrodynamic diameter \\[nm\\]")) +
  ylab(TeX("Frequency \\[%\\]")) +
  # xlim(0, 5000) +
  # ylim(0, 15) +
  scale_x_log10(limits = c(1, 10000)) +
  # annotation_logticks(sides = "b", size = 0.125,
  #                     short = unit(.25,"mm"),
  #                     mid = unit(.5,"mm"),
  #                     long = unit(.7,"mm")) + #0.125
  # labs(color = "Ink") + # legend label
  scale_colour_manual(values=cbPalVivid) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
Freq_plot
dev.off()

# plotname <- "_numberweighted.pdf"
# pdf(paste(outfolder, paste(sample, plotname, sep=""), sep="/"),
#     width = 6.5*cm2inch, height = 4.5*cm2inch, bg = "transparent")
# Freq_plot <- ggplot(data = DLS_data, aes(x = Particle_diameter, y = Freq_num_weighted1)) + # , color = variable
#   geom_line(size = .75, color = cbPalVivid[2]) + #geom_point(size = 3)
#   geom_line(aes(x = Particle_diameter, y = Freq_num_weighted2), color = cbPalVivid[3], size = 0.75) +
#   geom_line(aes(x = Particle_diameter, y = Freq_num_weighted3), color = cbPalVivid[6], size = 0.75) +
#   xlab(TeX("Hydrodynamic diameter \\[nm\\]")) +
#   ylab(TeX("Frequency \\[%\\]")) +
#   # xlim(0, 5000) +
#   # ylim(0, 15) +
#   scale_x_log10(limits = c(1, 10000)) +
#   # annotation_logticks(sides = "b", size = 0.125,
#   #                     short = unit(.25,"mm"),
#   #                     mid = unit(.5,"mm"),
#   #                     long = unit(.7,"mm")) + #0.125
#   # labs(color = "Ink") + # legend label
#   scale_colour_manual(values=cbPalVivid) +
#   theme_bw(base_size = 8) +
#   theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
#         axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
#         axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
#         legend.position = c(0.75, 0.75),
#         legend.spacing = unit(0.1, "cm"),
#         legend.key.size = unit(0.125, "cm"),
#         legend.background = element_rect(fill = "transparent"),
#         legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
# Freq_plot
# dev.off()
# 
# plotname <- "_numberweighted.tiff"
# tiff(paste(outfolder, paste(sample, plotname, sep=""), sep="/"),
#     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
# Freq_plot <- ggplot(data = DLS_data, aes(x = Particle_diameter, y = Freq_num_weighted1)) + # , color = variable
#   geom_line(size = .75, color = cbPalVivid[2]) + #geom_point(size = 3)
#   geom_line(aes(x = Particle_diameter, y = Freq_num_weighted2), color = cbPalVivid[3], size = 0.75) +
#   geom_line(aes(x = Particle_diameter, y = Freq_num_weighted3), color = cbPalVivid[6], size = 0.75) +
#   xlab(TeX("Hydrodynamic diameter \\[nm\\]")) +
#   ylab(TeX("Frequency \\[%\\]")) +
#   # xlim(0, 5000) +
#   # ylim(0, 15) +
#   scale_x_log10(limits = c(1, 10000)) +
#   # annotation_logticks(sides = "b", size = 0.125,
#   #                     short = unit(.25,"mm"),
#   #                     mid = unit(.5,"mm"),
#   #                     long = unit(.7,"mm")) + #0.125
#   # labs(color = "Ink") + # legend label
#   scale_colour_manual(values=cbPalVivid) +
#   theme_bw(base_size = 8) +
#   theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
#         axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
#         axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
#         legend.position = c(0.75, 0.75),
#         legend.spacing = unit(0.1, "cm"),
#         legend.key.size = unit(0.125, "cm"),
#         legend.background = element_rect(fill = "transparent"),
#         legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
# Freq_plot
# dev.off()
# 
# plotname <- "_volumeweighted.pdf"
# pdf(paste(outfolder, paste(sample, plotname, sep=""), sep="/"),
#     width = 6.5*cm2inch, height = 4.5*cm2inch, bg = "transparent")
# Freq_plot <- ggplot(data = DLS_data, aes(x = Particle_diameter, y = Freq_vol_weighted1)) + # , color = variable
#   geom_line(size = .75, color = cbPalVivid[2]) + #geom_point(size = 3)
#   geom_line(aes(x = Particle_diameter, y = Freq_vol_weighted2), color = cbPalVivid[3], size = 0.75) +
#   geom_line(aes(x = Particle_diameter, y = Freq_vol_weighted3), color = cbPalVivid[6], size = 0.75) +
#   xlab(TeX("Hydrodynamic diameter \\[nm\\]")) +
#   ylab(TeX("Frequency \\[%\\]")) +
#   # xlim(0, 5000) +
#   # ylim(0, 15) +
#   scale_x_log10(limits = c(1, 10000)) +
#   # annotation_logticks(sides = "b", size = 0.125,
#   #                     short = unit(.25,"mm"),
#   #                     mid = unit(.5,"mm"),
#   #                     long = unit(.7,"mm")) + #0.125
#   # labs(color = "Ink") + # legend label
#   scale_colour_manual(values=cbPalVivid) +
#   theme_bw(base_size = 8) +
#   theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
#         axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
#         axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
#         legend.position = c(0.75, 0.75),
#         legend.spacing = unit(0.1, "cm"),
#         legend.key.size = unit(0.125, "cm"),
#         legend.background = element_rect(fill = "transparent"),
#         legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
# Freq_plot
# dev.off()
# 
# plotname <- "_volumeweighted.tiff"
# tiff(paste(outfolder, paste(sample, plotname, sep=""), sep="/"),
#      width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
# Freq_plot <- ggplot(data = DLS_data, aes(x = Particle_diameter, y = Freq_vol_weighted1)) + # , color = variable
#   geom_line(size = .75, color = cbPalVivid[2]) + #geom_point(size = 3)
#   geom_line(aes(x = Particle_diameter, y = Freq_vol_weighted2), color = cbPalVivid[3], size = 0.75) +
#   geom_line(aes(x = Particle_diameter, y = Freq_vol_weighted3), color = cbPalVivid[6], size = 0.75) +
#   xlab(TeX("Hydrodynamic diameter \\[nm\\]")) +
#   ylab(TeX("Frequency \\[%\\]")) +
#   # xlim(0, 5000) +
#   # ylim(0, 15) +
#   scale_x_log10(limits = c(1, 10000)) +
#   # annotation_logticks(sides = "b", size = 0.125,
#   #                     short = unit(.25,"mm"),
#   #                     mid = unit(.5,"mm"),
#   #                     long = unit(.7,"mm")) + #0.125
#   # labs(color = "Ink") + # legend label
#   scale_colour_manual(values=cbPalVivid) +
#   theme_bw(base_size = 8) +
#   theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
#         axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
#         axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
#         legend.position = c(0.75, 0.75),
#         legend.spacing = unit(0.1, "cm"),
#         legend.key.size = unit(0.125, "cm"),
#         legend.background = element_rect(fill = "transparent"),
#         legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
# Freq_plot
# dev.off()
# 
