***Impact Aware Manipulation (I.AM.) archive***

Authors: M.J. Jongeneel, S. Dingemans

Dynamics & Control Group, Faculty of Mechanical Engineering, Eindhoven University of Technology

Corresponding author: M.J. Jongeneel 

Contact Information: m.j.jongeneel@tue.nl

Eindhoven University of Technology - Faculty of Mechanical Engineering

P.O. Box 513 5600 MB Eindhoven The Netherlands

***General Introduction***

This archive contains recordings of experiments that are executed in the I.AM. Project under the scenario of TOSS. In these recordings, Box007 is tossed on a stationary conveyor belt. The purpose of these experiments is to validate the nonsmooth modeling framework. This modeling framework is used within the H2020 I.AM. project (www.i-am-project.eu) to predict the end pose of a certain box on a conveyor belt, after it is tossed. This archive is being made public in order for other researchers to use this data in their own work.

All the recordings in the archive were performed at the Innovation Lab of Vanderlande, located within the TU/e campus, in December 2022.
This archive is published accompanying the deliverable ``I.AM. - D1.1 - Publication of I.AM. dataset - v1.0``, see [https://i-am-project.eu/index.php/results/deliverables](https://i-am-project.eu/index.php/results/deliverables) for more info.
This research project has received funding from the European Union’s Horizon 2020 research and innovation program under grant agreement No. 871899.

***Test equipment***

The experiments involve long range tosses of Box007 on a stationary conveyor. The box is tossed manually, and impacts and slides over the conveyor. Experiments where the box tumbles to another side are deleted from the dataset. Data was logged using an OptiTrack motion capture system, an Intel Realsense D415 reference camera, and sensors from the UR10 robot. Further details of the equipment are provided as metadata in each recording subfolder of the archive. 

***Description of the data in this archive***

This archive contains a total of 50 subfolders, each corresponding to a specific recording. Each folder follows the naming convention ``Rec_<timestamp>``, where the timestamp corresponds to the start time of the recording, expressed according to ISO 8601. The contents of these subfolders all have the same structure, which is described in the file called "recording_format".