%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%This is the software to make the images for the supplementary of the article:

%Requirements:
%   -change path into the path to your folder\supplementary\
%   -make sure the data are in the data folder inside the supplementary
%   folder
%   -make sure there is an image folder to save the images to
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------


clc;
clear;
close all;

path = 'N:\tnw\NS\kuiperslab\Irina\writing_articles\article_pyramids\open_data\supplementary\';

datapath = strcat(path,'data\');
figurepath = strcat(path,'images\');

%%
%Figure 1a
wavelength_flake = load(strcat(datapath,'wavelength_flake_fig1.txt'));
wavelength_pyramid595 = load(strcat(datapath,'wavelength_pyramid595_fig1.txt'));
wavelength_pyramid561_left = load(strcat(datapath,'wavelength_pyramid561left_fig1a.txt'));
wavelength_pyramid561_right = load(strcat(datapath,'wavelength_pyramid561right_fig1a.txt'));
spectrum_flake = load(strcat(datapath,'spectrum_flake_fig1a.txt'));
spectrum_pyramid595 = load(strcat(datapath,'spectrum_pyramid595_fig1a.txt'));
spectrum_pyramid561_left = load(strcat(datapath,'spectrum_pyramid561left_fig1a.txt'));
spectrum_pyramid561_right = load(strcat(datapath,'spectrum_pyramid561right_fig1a.txt'));

a = 0.3;
b = 2;

fg1 = figure(1); clf(fg1); set(gcf,'Color','w');

pl1=plot(wavelength_flake,spectrum_flake*a,'k--');
hold on
pl2=plot(wavelength_pyramid595,spectrum_pyramid595,'color',[1 0.5 0]);
hold on
pl3 = plot(wavelength_pyramid561_left,spectrum_pyramid561_left*b,'g');
hold on
pl4 = plot(wavelength_pyramid561_right,spectrum_pyramid561_right*b,'g');
hold off

xlim([570 660])
ylim([-1e2 1.8e4])

xlabel('wavelength [nm]')
ylabel('I [counts/10s]')
title('Comparing pyramid and monolayer at room temperature')
leg=legend(strcat('exciton*',num2str(0.1*a)),'595nm',strcat('561nm*',num2str(b)));
txt = text(0.1,0.9,'300K','units','normalized')

print(fg1,strcat(figurepath,'figure1a.png'),'-dpng');

%%
%Figure 1b
wavelength_pyramid561 = load(strcat(datapath,'wavelength_pyramid561_fig1.txt'));
spectrum_flake = load(strcat(datapath,'spectrum_flake_fig1b.txt'));
spectrum_pyramid595 = load(strcat(datapath,'spectrum_pyramid595_fig1b.txt'));
spectrum_pyramid561 = load(strcat(datapath,'spectrum_pyramid561_fig1b.txt'));

a = 0.5;
b = 2;

fg2 = figure(2); clf(fg2); set(gcf,'Color','w');

pl1=plot(wavelength_flake,spectrum_flake*a,'k--');
hold on
pl2=plot(wavelength_pyramid595,spectrum_pyramid595,'color',[1 0.5 0]);
hold on
pl3 = plot(wavelength_pyramid561,spectrum_pyramid561*b,'g');
hold off

xlim([570 660])
ylim([-1e2 2e4])

xlabel('wavelength [nm]')
ylabel('I [counts/10s]')
title('Comparing pyramid and monolayer at 200K')
leg=legend(strcat('exciton*',num2str(0.1*a)),'595nm',strcat('561nm*',num2str(b)));
txt = text(0.1,0.9,'200K','units','normalized')

print(fg2,strcat(figurepath,'figure1b.png'),'-dpng');

%%
%Figure 1c
exciton = load(strcat(datapath,'exciton_position_fig1c.txt'));
background = load(strcat(datapath,'background_position_fig1c.txt'));

fg3 = figure(3); clf(fg3); set(gcf,'Color','w');

temperature = [4 100 200 300];
temperature_short = [4 100 300];

pl1=plot(temperature_short, background,'o-g','MarkerFaceColor','g');
hold on
pl2=plot(temperature,exciton,'o--k','MarkerFaceColor','k');
hold off

ylim([610 650])

xlabel('Temperature [K]')
ylabel('Peak position [nm]')
title('Temperature dependence exciton and Raman background')
leg=legend('background pyramid','exciton');

print(fg3,strcat(figurepath,'figure1c.png'),'-dpng');

%%
%Figure 1d
spectrum_flake = load(strcat(datapath,'spectrum_flake_fig1d.txt'));
spectrum_pyramid595 = load(strcat(datapath,'spectrum_pyramid595_fig1d.txt'));
spectrum_pyramid561 = load(strcat(datapath,'spectrum_pyramid561_fig1d.txt'));

a = 3;
b = 4

fg4 = figure(4); clf(fg4); set(gcf,'Color','w');

pl1=plot(wavelength_flake,spectrum_flake*a,'k--');
hold on
pl2=plot(wavelength_pyramid595,spectrum_pyramid595,'color',[1 0.5 0]);
hold on
pl3 = plot(wavelength_pyramid561(1:1020),spectrum_pyramid561*b,'g');
hold off

xlim([570 660])
ylim([-1e2 4e4])

xlabel('wavelength [nm]')
ylabel('I [counts/10s]')
title('Comparing pyramid and monolayer at 100K')
leg=legend(strcat('exciton*',num2str(0.1*a)),'595nm',strcat('561nm*',num2str(b)));
txt = text(0.1,0.9,'100K','units','normalized')

print(fg4,strcat(figurepath,'figure1d.png'),'-dpng');

%%
%Figure 1e
spectrum_flake = load(strcat(datapath,'spectrum_flake_fig1e.txt'));
spectrum_pyramid595 = load(strcat(datapath,'spectrum_pyramid595_fig1e.txt'));
spectrum_pyramid561 = load(strcat(datapath,'spectrum_pyramid561_fig1e.txt'));

a = 2;
b = 4;

fg5 = figure(5); clf(fg5); set(gcf,'Color','w');

pl1=plot(wavelength_flake,spectrum_flake*a,'k--');
hold on
pl2=plot(wavelength_pyramid595,spectrum_pyramid595,'color',[1 0.5 0]);
hold on
pl3 = plot(wavelength_pyramid561,spectrum_pyramid561*b,'g');
hold off

xlim([570 660])
ylim([-1e2 6e4])
xlabel('wavelength [nm]')
ylabel('I [counts/10s]')
title('Comparing pyramid and monolayer at 4K')
leg=legend(strcat('exciton*',num2str(0.1*a)),'595nm',strcat('561nm*',num2str(b)));
txt = text(0.1,0.9,'4K','units','normalized')

print(fg5,strcat(figurepath,'figure1e.png'),'-dpng');

%%
%Figure 2a
x_axis = load(strcat(datapath,'asX_figS2a.txt'));
y_axis = load(strcat(datapath,'asY_figS2a.txt'));
maxima_peak = load(strcat(datapath,'maxima_figS2a.txt'));

fg6 = figure(6); clf(fg6); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
%caxis([0 9e3])
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 350cm^{-1} (300K)')

print(fg6,strcat(figurepath,'figure2a.png'),'-dpng');

%%
%Figure 2b
maxima_peak = load(strcat(datapath,'maxima_figS2b.txt'));

fg7 = figure(7); clf(fg7); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
caxis([0 0.35e4])
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 417cm^{-1} (300K)')

print(fg7,strcat(figurepath,'figure2b.png'),'-dpng');

%%
%Figure 2c
maxima_peak = load(strcat(datapath,'maxima_figS2c.txt'));

fg8 = figure(8); clf(fg8); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
caxis([0 9e2])
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 702cm^{-1} (300K)')

print(fg8,strcat(figurepath,'figure2c.png'),'-dpng');

%%
%Figure 2d
maxima_peak = load(strcat(datapath,'maxima_figS2d.txt'));

fg9 = figure(9); clf(fg9); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
caxis([0 6e2])
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 833cm^{-1} (300K)')

print(fg9,strcat(figurepath,'figure2d.png'),'-dpng');

%%
%Figure 2e
x_axis = load(strcat(datapath,'asX_figS2e.txt'));
y_axis = load(strcat(datapath,'asY_figS2e.txt'));
maxima_peak = load(strcat(datapath,'maxima_figS2e.txt'));

fg10 = figure(10); clf(fg10); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 350cm^{-1} (4K)')

print(fg10,strcat(figurepath,'figure2e.png'),'-dpng');

%%
%Figure 2f
maxima_peak = load(strcat(datapath,'maxima_figS2f.txt'));

fg11 = figure(11); clf(fg11); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 417cm^{-1} (4K)')

print(fg11,strcat(figurepath,'figure2f.png'),'-dpng');

%%
%Figure 2g
maxima_peak = load(strcat(datapath,'maxima_figS2g.txt'));

fg12 = figure(12); clf(fg12); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 769cm^{-1} (4K)')

print(fg12,strcat(figurepath,'figure2g.png'),'-dpng');

%%
%Figure 2h
maxima_peak = load(strcat(datapath,'maxima_figS2h.txt'));

fg13 = figure(13); clf(fg13); set(gcf,'Color','w');

imagesc(x_axis,y_axis,maxima_peak)

colormap parula
colorbar
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Raman maxima pyramid peak 1128cm^{-1} (4K)')

print(fg13,strcat(figurepath,'figure2h.png'),'-dpng');

%%
%Figure 3a
x_axis = load(strcat(datapath,'asX_figS3a.txt'));
y_axis = load(strcat(datapath,'asY_figS3a.txt'));
ratio_peak = load(strcat(datapath,'ratio_figS3a.txt'));
pntX = 2;
pntY = 2;

fg14 = figure(14); clf(fg14); set(gcf,'Color','w');

imagesc(x_axis,y_axis,ratio_peak)
hold on
plot(x_axis(pntX),y_axis(pntY),'*b','MarkerSize',15,'LineWidth',2)
hold off

colorbar
colormap hot

set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Ratio E_{2g} / A_{1g} of Raman monolayer')

print(fg14,strcat(figurepath,'figure3a.png'),'-dpng');

%%
%Figure 3b
x_axis = load(strcat(datapath,'asX_figS3b.txt'));
y_axis = load(strcat(datapath,'asY_figS3b.txt'));
ratio_peak = load(strcat(datapath,'ratio_figS3b.txt'));
pntX = 6;
pntY = 9;

fg15 = figure(15); clf(fg15); set(gcf,'Color','w');

imagesc(x_axis,y_axis,ratio_peak)
hold on
plot(x_axis(pntX),y_axis(pntY),'*b','MarkerSize',15,'LineWidth',2)
hold off

colorbar
caxis([1 7])
colormap hot

set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Ratio E_{2g} / A_{1g} of Raman monolayer')

print(fg15,strcat(figurepath,'figure3b.png'),'-dpng');

%%
%Figure 3c
x_axis = load(strcat(datapath,'asX_figS3c.txt'));
y_axis = load(strcat(datapath,'asY_figS3c.txt'));
ratio_peak = load(strcat(datapath,'ratio_figS3c.txt'));
pntX = 10;
pntY = 10;

fg16 = figure(16); clf(fg16); set(gcf,'Color','w');

imagesc(x_axis,y_axis,ratio_peak)
hold on
plot(x_axis(pntX),y_axis(pntY),'*b','MarkerSize',15,'LineWidth',2)
hold off

colorbar
caxis([1 3.5])
colormap hot

set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Ratio E_{2g} / A_{1g} of Raman monolayer')

print(fg16,strcat(figurepath,'figure3c.png'),'-dpng');

%%
%Figure 3d
frequencies = load(strcat(datapath,'frequencies_figS3d.txt'));
spectrum = load(strcat(datapath,'spectrum_figS3d.txt'));

fg17 = figure(17); clf(fg17); set(gcf,'Color','w');

plot(frequencies,spectrum,'b')

xlim([170 1000])
ylim([-3e2, 6e3])
xlabel('\Delta \nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Raman spectrum monolayer (561nm)')

print(fg17,strcat(figurepath,'figure3d.png'),'-dpng');

%%
%Figure 3e
frequencies = load(strcat(datapath,'frequencies_figS3e.txt'));
spectrum = load(strcat(datapath,'spectrum_figS3e.txt'));

fg18 = figure(18); clf(fg18); set(gcf,'Color','w');

plot(frequencies,spectrum,'b')

xlim([170 2000])
ylim([-1e2 3.5e3])
xlabel('\Delta \nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Raman spectrum dented pyramid (561nm)')

print(fg18,strcat(figurepath,'figure3e.png'),'-dpng');

%%
%Figure 3f
frequencies = load(strcat(datapath,'frequencies_figS3f.txt'));
spectrum = load(strcat(datapath,'spectrum_figS3f.txt'));

fg19 = figure(19); clf(fg19); set(gcf,'Color','w');

plot(frequencies,spectrum,'b')

xlim([100 1700])
ylim([-5e2 9e3])
xlabel('\Delta \nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Raman spectrum full pyramid (595nm)')

print(fg19,strcat(figurepath,'figure3f.png'),'-dpng');

%%
%Figure 4a
x_axis = load(strcat(datapath,'asX_figS3a.txt'));
y_axis = load(strcat(datapath,'asY_figS3a.txt'));
peak_positions = load(strcat(datapath,'peak_pos_figS4a.txt'));

fg20 = figure(20); clf(fg20); set(gcf,'Color','w');

imagesc(x_axis,y_axis,peak_positions)

colorbar
colormap bone
caxis([330 360])

set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Frequency first Raman peak (monolayer)')

print(fg20,strcat(figurepath,'figure4a.png'),'-dpng');

%%
%Figure 4b
x_axis = load(strcat(datapath,'asX_figS3c.txt'));
y_axis = load(strcat(datapath,'asY_figS3c.txt'));
peak_positions = load(strcat(datapath,'peak_pos_figS4b.txt'));

fg21 = figure(21); clf(fg21); set(gcf,'Color','w');

imagesc(x_axis,y_axis,peak_positions)

colorbar
colormap bone
caxis([330 360])

set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Frequency first Raman peak (full pyramid)')

print(fg21,strcat(figurepath,'figure4b.png'),'-dpng');

%%
%Figure 4c
averages = load(strcat(datapath,'averages_fig4c.txt'));
stds = load(strcat(datapath,'standard_devs_fig4c.txt'));

fg22 = figure(22); clf(fg22); set(gcf,'Color','w');

for ii = 1:12
    kleur = [ii/12 0 1-ii/12];
    pl{ii}=errorbar(ii,averages(ii),stds(ii),'o','color',kleur,'MarkerFaceColor',kleur);
    hold on 
end

leg=legend([pl{4},pl{10},pl{12}],{'dented pyramid','full pyramid','monolayer'});
set(leg,'location','northwest')

xlabel('measured pyramid')
ylabel('peak position [cm^{-1}]')
ylim([345 360])

print(fg22,strcat(figurepath,'figure4c.png'),'-dpng');

%%
%Figure 5a
frequencies_left = load(strcat(datapath,'frequencies_left_figS5a.txt'));
frequencies_right = load(strcat(datapath,'frequencies_right_figS5a.txt'));
spectra_left = load(strcat(datapath,'spectra_left_figS5a.txt'));
spectra_right = load(strcat(datapath,'spectra_right_figS5a.txt'));

fg23 = figure(23); clf(fg23); set(gcf,'Color','w');

plot(frequencies_left,spectra_left(2,:),'b')
hold on
plot(frequencies_left,spectra_left(1,:),'r')
hold on
plot(frequencies_right,spectra_right(2,:),'b')
hold on
plot(frequencies_right,spectra_right(1,:),'r')
hold off

xlim([180 1450])
ylim([-3e2 4e3])

xlabel('\Delta \nu [cm^{-1}]')
ylabel('I [counts/10s]')
legend('\sigma +','\sigma -')
title('Helicity resolved Raman spectra pyramid (300K)')

print(fg23,strcat(figurepath,'figure5a.png'),'-dpng');

%%
%Figure 5b
frequencies = load(strcat(datapath,'frequencies_figS5b.txt'));
spectra = load(strcat(datapath,'spectra_figS5b.txt'));

fg24 = figure(24); clf(fg24); set(gcf,'Color','w');

plot(frequencies,spectra(2,:),'b')
hold on
plot(frequencies,spectra(1,:),'r')
hold off

xlim([180 1450])
ylim([-1e3 1.5e4])

xlabel('\Delta \nu [cm^{-1}]')
ylabel('I [counts/10s]')
legend('\sigma +','\sigma -')
title('Helicity resolved Raman spectra pyramid (100K)')

print(fg24,strcat(figurepath,'figure5b.png'),'-dpng');





