%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%This is the software to make the images for article:

%Requirements:
%   -change path into the path to your folder
%   -make sure the data are in the data folder
%   -make sure there is an image folder to save the images to
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------

clc;
clear;
close all;

path = 'N:\tnw\NS\kuiperslab\Irina\writing_articles\article_pyramids\open_data\';

datapath = strcat(path,'data\');
figurepath = strcat(path,'images\');

%%
%Figure 1b: Import the crosscut and plot it

AFM = load(strcat(datapath,'AFM_crosscut.txt'));

fg1 = figure(1); clf(fg1); set(gcf,'Color','w');

pl=plot(AFM(:,1)*1e6,AFM(:,2)*1e9,'color',[0 0.8 1]);

xlabel('x [\mum]')
ylabel('z [nm]')

print(fg1,strcat(figurepath,'figure1b.png'),'-dpng');

%%
%Figure 1e: import the wavelength axes and the spectra and plot them in the
%same figure

wavelength_mono = load(strcat(datapath,'wavelength_mono_fig1.txt'));
wavelength595 = load(strcat(datapath,'wavelength595_fig1.txt'));
wavelength561 = load(strcat(datapath,'wavelength561_fig1.txt'));
monolayer  = load(strcat(datapath,'spectrum_monolayer_fig1.txt'));
pyramid595 = load(strcat(datapath,'spectrum_pyramid595_fig1.txt'));
pyramid561 = load(strcat(datapath,'spectrum_pyramid561_fig1.txt'));

fg2 = figure(2); clf(fg2); set(gcf,'Color','w');

plot(wavelength_mono,monolayer*2,'k--')
hold on
plot(wavelength595,pyramid595,'color',[1 0.5 0])
hold on
plot(wavelength561,pyramid561,'g')
hold off

xlim([570 690])
ylim([-1e2 4.6e4])
xlabel('wavelength (nm)')
ylabel('I (counts/10s)')
legend('monolayer','595nm','561nm')
title('Comparing pyramid and monolayer spectra')

print(fg2,strcat(figurepath,'figure1e.png'),'-dpng');

%%
%Figure 1f: import the new x-axes, that is converted to frequencies, and
%plot the spectra of figure 1e with these new x-axes.

frequency595 = load(strcat(datapath,'frequencies595_fig1.txt'));
frequency561 = load(strcat(datapath,'frequencies561_fig1.txt'));

fg3 = figure(3); clf(fg3); set(gcf,'Color','w');

plot(frequency595,pyramid595,'color',[1 0.5 0])
hold on
plot(frequency561,pyramid561,'g')
hold off

xlim([200 1500])
ylim([-1e2 1.8e4])
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
legend('595nm','561nm')
title('Pyramid spectra with different excitations')

print(fg3,strcat(figurepath,'figure1f.png'),'-dpng');

%%
%Figure 2a: import the x-axis, the spectrum and the results of the fit

frequency = load(strcat(datapath,'frequencies_fig2.txt'));
spectrum = load(strcat(datapath,'spectrum_fig2.txt'));
lorentzians = load(strcat(datapath,'lorentzians_fig2.txt'));
gauss = load(strcat(datapath,'gauss_fig2.txt'));

range = 120:1020;
total_fit = zeros(1,length(range));

%This will make sure that the arrows are placed at the correct position in
%the figure
arrow_X{1} = [0.223 0.223]; arrow_Y{1} = [0.86 0.76];
arrow_X{2} = [0.26 0.26]; arrow_Y{2} = [0.86 0.81];
arrow_X{3} = [0.3 0.3]; arrow_Y{3} = [0.68 0.42];
arrow_X{4} = [0.325 0.325]; arrow_Y{4} = [0.82 0.67];
arrow_X{5} = [0.36 0.36]; arrow_Y{5} = [0.6 0.38];
arrow_X{6} = [0.43 0.43]; arrow_Y{6} = [0.6 0.38];
arrow_X{7} = [0.472 0.472]; arrow_Y{7} = [0.65 0.4];
arrow_X{8} = [0.51 0.51]; arrow_Y{8} = [0.68 0.45];
arrow_X{9} = [0.58 0.58]; arrow_Y{9} = [0.64 0.4];
arrow_X{10} = [0.68 0.68]; arrow_Y{10} = [0.72 0.48];
arrow_X{11} = [0.54 0.54]; arrow_Y{11} = [0.55 0.38];
arrow_X{12} = [0.64 0.64]; arrow_Y{12} = [0.6 0.37];

fg4 = figure(4); clf(fg4); set(gcf,'Color','w');

pl1 = plot(frequency,spectrum,'color',[1 0.5 0],'LineWidth',2); %plot the data
hold on
for ii = 1:11
    plot(frequency(range),lorentzians(ii,:),'r')        %plot the lorentzian fits
    total_fit = total_fit + lorentzians(ii,:);
    hold on
end

for ii = [1,3]
    plot(frequency(range),gauss(ii,:),'color',[0.5 0.5 0.5]);   %plot the gaussian fit
    total_fit = total_fit + gauss(ii,:);
    hold on
end

pl2 = plot(frequency(range),total_fit,'k--','LineWidth',2);     %plot the sum of all fits
hold on

for ii = 1:9
    pijl=annotation('arrow',arrow_X{ii},arrow_Y{ii},'color','k')    %plot the black arrows
    hold on
end
for ii = 10
    pijl=annotation('arrow',arrow_X{ii},arrow_Y{ii},'color','b')    %plot the blue arrows
    hold on
end
for ii = 11:12
    pijl=annotation('arrow',arrow_X{ii},arrow_Y{ii},'color','b','LineStyle','--')
    hold on
end

%This will make sure the correct text will appear above every arrow
txt{1}=text(0.09,0.95,'350','units','normalized');
txt{2}=text(0.15,0.95,'417','units','normalized');
txt{3}=text(0.19,0.75,'475','units','normalized');
txt{4}=text(0.23,0.9,'520 ','units','normalized');
txt{5}=text(0.27,0.65,'580','units','normalized');
txt{6}=text(0.35,0.65,'702','units','normalized');
txt{7}=text(0.41,0.7,'769','units','normalized');
txt{8}=text(0.47,0.75,'833','units','normalized');
txt{9}=text(0.55,0.7,'958','units','normalized');
txt{10}=text(0.62,0.65,'1057','units','normalized','color','b');
txt{11}=text(0.68,0.8,'1128','units','normalized','color','b');
txt{12}=text(0.5,0.6,'880','units','normalized','color','b');

xlim([200 1500])
ylim([-1e2 2e4])
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
legend([pl1, pl2],'data','fit')
title('Fitted pyramid spectrum')

print(fg4,strcat(figurepath,'figure2a.png'),'-dpng');

%%
%Figure 2b: Plot the same spectrum as in figure 2a, but now with the arrows
%indicating a multiphonon response

%Lines above and below the spectrum
xline1 = [250 1200]; ylijn1 = [2e4 1.2e4];
xline2 = [425 1200]; ylijn2 = [3e3 -2.5e3];

%This will make sure that the arrows are placed at the correct position in
%the figure
arrow_X{1} = [0.223 0.223]; arrow_Y{1} = [0.86 0.76];
arrow_X{4} = [0.43 0.43]; arrow_Y{4} = [0.76 0.45];
arrow_X{10} = [0.65 0.65]; arrow_Y{10} = [0.66 0.45];
arrow_X{2} = [0.265 0.265]; arrow_Y{2} = [0.31 0.44];
arrow_X{3} = [0.36 0.36]; arrow_Y{3} = [0.28 0.35];
arrow_X{5} = [0.475 0.475]; arrow_Y{5} = [0.23 0.36];
arrow_X{11} = [0.68 0.68]; arrow_Y{11} = [0.15 0.35];

fg5 = figure(5); clf(fg5); set(gcf,'Color','w');

pl1 = plot(frequency,spectrum,'color',[1 0.5 0]);
hold on
lijn = line(xline1,ylijn1,'color','r');
hold on
lijn = line(xline2,ylijn2,'color','b');
hold on
pl3=plot(483,8e3,'d','color','k','MarkerFaceColor','k','MarkerSize',7);
hold on
pl4=plot(840,9e3,'*k','MarkerSize',10);
hold on

for ii = [1,4,10]
    pijl=annotation('arrow',arrow_X{ii},arrow_Y{ii},'color','r')    %plot the red arrows
    hold on
end
for ii = [2,5,11]
    pijl=annotation('arrow',arrow_X{ii},arrow_Y{ii},'color','b')    %plot the blue arrows
    hold on
end
for ii = [3]
    pijl=annotation('arrow',arrow_X{ii},arrow_Y{ii},'color','b','LineStyle','--')
    hold on    
end

xlim([200 1500])
ylim([-3e3 2.1e4])
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Pyramid spectrum with higher phononic orders')
legend([pl3,pl4],{'LA + 2ZA','2A_{1g}'});

%This will make sure the correct text will appear at every arrow
txt1 = text(505,1.45e4,'Si');
txt2 = text(930,7.5e3,'Si');
txt3 = text(0.78,0.63,'nLA','units','normalized')
txt4 = text(0.78,0.08,'A_{1g}+nLA','units','normalized','color','b')
txt5 = text(0.042,0.88,'n=2','units','normalized','color','r')
txt6 = text(0.355,0.75,'4','units','normalized','color','r')
txt7 = text(0.62,0.64,'6','units','normalized','color','r')
txt8 = text(0.12,0.2,'n=0','units','normalized','color','b');
txt9 = text(0.28,0.15,'1','units','normalized','color','b');
txt10 = text(0.43,0.1,'2','units','normalized','color','b');
txt11 = text(0.67,0.11,'4','units','normalized','color','b');

print(fg5,strcat(figurepath,'figure2b.png'),'-dpng');

%%
%Figure 3a: plot the results of the spectral fits as a function of x and y
%position 

x_axis = load(strcat(datapath,'asX_fig3.txt'));
y_axis = load(strcat(datapath,'asY_fig3.txt'));
maxima_peak1 = load(strcat(datapath,'maxima_peak1_fig3.txt'));

%This gives the colours and pixels of the stars, indicating the positions
%of the given spectra 
col{1} = 'r';
col{2} = 'k';
col{3} = 'g';
pntX(1) = 6; pntY(1) = 10;
pntX(2) = 9; pntY(2) = 12;
pntX(3) = 8; pntY(3) = 3;

fg6 = figure(6); clf(fg6); set(gcf,'Color','w');
imagesc(x_axis,y_axis,maxima_peak1)
hold on
for ii = 1:3
     plot(x_axis(pntX(ii)),y_axis(pntY(ii)),'*','color',col{ii},'MarkerSize',15,'LineWidth',2)
end

colormap parula
colorbar
caxis([0 9e3])
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Peak maxima first Raman peak WS_2')

print(fg6,strcat(figurepath,'figure3a.png'),'-dpng');

%%
%Figure 3b: the x and y axis are the same as in figure 3a, now with the
%results of the fits of the silicon peak
maxima_peakSi = load(strcat(datapath,'maxima_peakSi_fig3.txt'));

fg7 = figure(7); clf(fg7); set(gcf,'Color','w');
imagesc(x_axis,y_axis,maxima_peakSi)
hold on

for ii = 1:3
     plot(x_axis(pntX(ii)),y_axis(pntY(ii)),'*','color',col{ii},'MarkerSize',15,'LineWidth',2)
end

colormap parula
colorbar
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Peak maxima Raman peak Si')

print(fg7,strcat(figurepath,'figure3b.png'),'-dpng');

%%
%Figure 3d: plot the three spectra as a function of frequency
frequency = load(strcat(datapath,'frequencies_fig3d.txt'));
spectra300K = load(strcat(datapath,'spectra_fig3d.txt'));

kleur{1} = 'r';
kleur{2} = 'k';
kleur{3} = 'g';

fg8 = figure(8); clf(fg8); set(gcf,'Color','w');

for ii = 1:3
    plot(frequency,spectra300K(ii,:),'color',kleur{ii})
    hold on
end

xlim([100 1700])
ylim([-1e3 1.6e4])
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Pyramid spectra room temperature')

print(fg8,strcat(figurepath,'figure3d.png'),'-dpng');


%%
%Figure 3e: plot the three spectra as a function of frequency
frequency = load(strcat(datapath,'frequencies_fig3e.txt'));
spectra4K = load(strcat(datapath,'spectra_fig3e.txt'));

fg9 = figure(9); clf(fg9); set(gcf,'Color','w');

for ii = 1:3
    plot(frequency,spectra4K(ii,:),'color',kleur{ii})
    hold on
end

xlim([100 1700])
ylim([-1e3 4e4])
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Pyramid spectra 4K')

print(fg9,strcat(figurepath,'figure3e.png'),'-dpng');

%%
%Figure 3f: plot the results of the fitted spectra, e.g. the ratio of the
%two first Raman peaks, as a function of x and y position
x_axis = load(strcat(datapath,'asX_fig3f.txt'));
y_axis = load(strcat(datapath,'asY_fig3f.txt'));
ratio_peaks = load(strcat(datapath,'ratio_peaks_fig3f.txt'));

fg10 = figure(10); clf(fg10); set(gcf,'Color','w');
imagesc(x_axis,y_axis,ratio_peaks)

cl=colorbar;
colormap hot
caxis([0.5 1.1])
set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
xlabel('x (\mum)')
ylabel('y (\mum)')
title('Ratio first two Raman peaks')

print(fg10,strcat(figurepath,'figure3f.png'),'-dpng');


%%
%Figure 4a: plot the results of the fitted spectra, e.g. the frequency of the first Raman peak,
%as a function of x and y position

x_axis = load(strcat(datapath,'asX_fig4.txt'));
y_axis = load(strcat(datapath,'asY_fig4.txt'));
peak_pos = load(strcat(datapath,'peak_pos_fig4.txt'));

fg11 = figure(11); clf(fg11); set(gcf,'Color','w');

col{1} = [0 1 1];
col{2} = [0 0.5 1];
col{3} = [0 0 1];

imagesc(x_axis,y_axis,peak_pos)
hold on
for ii = 1:3
    plot(x_axis(ii),y_axis(14),'*','color',col{ii},'markersize',20,'linewidth',3)
    hold on
end
hold off

xlabel('x (\mum)')
ylabel('y (\mum)')

set(gca,'Xdir','reverse')
set(gca,'Ydir','normal')
colorbar
colormap bone; 
caxis([320 360])
title('Spectral position first Raman peak')

print(fg11,strcat(figurepath,'figure4a.png'),'-dpng');

%%
%Figure 4b: plot the three spectra as a function of frequency

frequencies = load(strcat(datapath,'frequencies_fig4.txt'));
spectra = load(strcat(datapath,'spectra_fig4.txt'));

fg12 = figure(12); clf(fg12); set(gcf,'Color','w');

for ii = 1:3
    pl=plot(frequencies,spectra(ii,:),'color',col{ii});
    hold on
end
ln1 = line([520 520],[-5e2 3.5e4],'color',[0.5 0.5 0.5]);
hold on
ln2 = line([355 355],[-5e2 3.5e4],'color',[0.5 0.5 0.5]);
hold on
ln3 = line([835 835],[-5e2 3.5e4],'color',[0.5 0.5 0.5]);
hold off

xlim([100 1700]) 
ylim([-5e2, 3.5e4])
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Pyramid spectra with shifting peak frequencies')

print(fg12,strcat(figurepath,'figure4b.png'),'-dpng');

%%
%Figure 5a: plot the four spectra as a function of frequency; they share
%the same frequency axis

frequency = load(strcat(datapath,'frequencies595_fig5a.txt'));
spectrum300K = load(strcat(datapath,'spectrum595_300K_fig5a.txt'));
spectrum200K = load(strcat(datapath,'spectrum595_200K_fig5a.txt'));
spectrum100K = load(strcat(datapath,'spectrum595_100K_fig5a.txt'));
spectrum4K = load(strcat(datapath,'spectrum595_4K_fig5a.txt'));

fg13 = figure(13); clf(fg13); set(gcf,'Color','w');

plot(frequency,spectrum300K,'color',[1 0 0])
hold on
plot(frequency,spectrum200K,'color',[0.7 0 0.3])
hold on
plot(frequency,spectrum100K,'color',[0.3 0 0.7])
hold on
plot(frequency,spectrum4K,'color',[0 0 1])
hold off

xlim([100 1700])
ylim([-5e2 2.8e4])
txt=text(0.02,0.9,'*','units','normalized','color','k','fontsize',40);
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Spectra of pyramid side')
legend('300K','200K','100K','4K')

print(fg13,strcat(figurepath,'figure5a.png'),'-dpng');

%%
%Figure 5b: plot the four spectra as a function of frequency; they share
%the same frequency axis

frequency = load(strcat(datapath,'frequencies595_fig5a.txt'));
spectrum300K = load(strcat(datapath,'spectrum595_300K_fig5b.txt'));
spectrum200K = load(strcat(datapath,'spectrum595_200K_fig5b.txt'));
spectrum100K = load(strcat(datapath,'spectrum595_100K_fig5b.txt'));
spectrum4K = load(strcat(datapath,'spectrum595_4K_fig5b.txt'));

fg14 = figure(14); clf(fg14); set(gcf,'Color','w');

plot(frequency,spectrum300K,'color',[1 0 0])
hold on
plot(frequency,spectrum200K,'color',[0.7 0 0.3])
hold on
plot(frequency,spectrum100K,'color',[0.3 0 0.7])
hold on
plot(frequency,spectrum4K,'color',[0 0 1])
hold off

xlim([100 1700])
ylim([-5e2 4e4])
txt=text(0.02,0.9,'*','units','normalized','color','r','fontsize',40);
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Spectra of pyramid crater')
legend('300K','200K','100K','4K')

print(fg14,strcat(figurepath,'figure5b.png'),'-dpng');


%%
%Figure 5c: plot the four spectra as a function of frequency; they share
%the same frequency axis

frequency = load(strcat(datapath,'frequencies561_fig5.txt'));
spectrum300K = load(strcat(datapath,'spectrum561_300K_fig5.txt'));
spectrum200K = load(strcat(datapath,'spectrum561_200K_fig5.txt'));
spectrum100K = load(strcat(datapath,'spectrum561_100K_fig5.txt'));
spectrum4K = load(strcat(datapath,'spectrum561_4K_fig5.txt'));

fg15 = figure(15); clf(fg15); set(gcf,'Color','w');

plot(frequency,spectrum300K,'color',[1 0 0])
hold on
plot(frequency,spectrum200K,'color',[0.7 0.3 0])
hold on
plot(frequency,spectrum100K,'color',[0.3 0.7 0])
hold on
plot(frequency,spectrum4K,'color',[0 1 0])
hold off

xlim([150 2000])
ylim([0 1e4])
txt=text(0.02,0.9,'*','units','normalized','color','r','fontsize',40);
xlabel('\Delta\nu [cm^{-1}]')
ylabel('I [counts/10s]')
title('Pyramid (crater) spectra with 561nm excitation')
legend('300K','200K','100K','4K')

print(fg15,strcat(figurepath,'figure5c.png'),'-dpng');

%%
%Figure 5d: plot the calculated average peak ratio as a function of
%temperature

kleur{1} = [0 0 1];
kleur{2} = [0.3 0 0.8];
kleur{3} = [0.8 0 0.3];
kleur{4} = [1 0 0];
kleur{5} = [0 1 0];
kleur{6} = [0.3 0.8 0];
kleur{7} = [0.8 0.3 0];
kleur{8} = [1 0 0];

temperatures = [4,100,200,300];
average_ratio = load(strcat(datapath,'temp_dependences_fig5.txt'));

fg16 = figure(16); clf(fg16); set(gcf,'Color','w');

for ii = 1:4
    pl1=plot(temperatures(ii),average_ratio(1,ii),'o','color',kleur{ii},'MarkerFaceColor',kleur{ii},'MarkerSize',15); 
    hold on
    pl2=plot(temperatures(ii),average_ratio(2,ii),'p','color',kleur{ii+4},'MarkerFaceColor',kleur{ii+4},'MarkerSize',20); 
    hold on
    pl3=plot(temperatures(ii),average_ratio(3,ii),'d','color',kleur{ii+4},'MarkerFaceColor',kleur{ii+4},'MarkerSize',10); 
    hold on
end

xlabel('temperature [K]');
ylabel('ratio E_{2g}/A_{1g}');
title('Temperature dependence Raman peak ratio')
legend([pl1,pl2,pl3],'595nm','561nm crater','561nm sides')

print(fg16,strcat(figurepath,'figure5d.png'),'-dpng');

