from pathlib import Path

import h5py
import matplotlib.gridspec as gridspec
import matplotlib.image as mpimg
import matplotlib.pyplot as plt
import numpy as np
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
from quantify_core.data.handling import (
    set_datadir,
)

set_datadir(Path("../data"))

with h5py.File("../data/20220804/2022-08-04_confocal_scan.h5", "r") as h5f:
    counts_large_map = h5f["cyclops_2d"][:]

fig = plt.figure(figsize=(7, 3))
panel = gridspec.GridSpec(1, 2, width_ratios=[1, 1], wspace=0.2, figure=fig)

ax_1 = plt.subplot(panel[0, 0])
ax_2 = plt.subplot(panel[0, 1])

ax_1.text(0, 1.1, "(a)", transform=ax_1.transAxes, fontsize=12, va="top")
ax_1.imshow(mpimg.imread(Path(r"../data/samples/MrOrange.png")))
ax_1.axis("off")

ax_2.text(-0.21, 1.1, "(b)", transform=ax_2.transAxes, fontsize=12, va="top")
img = ax_2.pcolormesh(
    np.linspace(0, 60, 600),
    np.linspace(0, 60, 600) - 10,
    counts_large_map.transpose(),
    vmax=42,
)
ax_2.set_xlim(0, 45)
ax_2.set_ylim(0, 45)
ax_2.set_xlabel("X Position (µm)", fontsize=12)
ax_2.set_ylabel("Y Position (µm)", fontsize=12)
axinset = inset_axes(
    ax_2,
    width="10%",
    height="30%",
    bbox_to_anchor=(-0.1, 0, 0.94, 0.92),
    bbox_transform=ax_2.transAxes,
    loc="upper right",
)
cbar = fig.colorbar(img, cax=axinset, orientation="vertical")
cbar.set_label("Counts (kCts/s)", color="white", fontsize=10)
cbar.ax.tick_params(color="white", labelsize=10, labelcolor="white")
cbar.outline.set_edgecolor("white")

fig.savefig(Path("../figures/fig_19_add.png"), dpi=250, bbox_inches="tight")
