from pathlib import Path

import h5py
import matplotlib.gridspec as gridspec
import matplotlib.image as mpimg
import matplotlib.pyplot as plt
import numpy as np
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

with h5py.File(
    "../data/20230213/135318_Measurement_autoNVsearch/Z_depth_52.4/141449_scan2d_.hdf5",
    "r",
) as h5f:
    x = h5f["x"][:]
    y = h5f["x"][:]
    counts = h5f["countrate"][:]

wavelength_spectrometer, counts_spectrometer = list(), list()
with open("../data/20230215/SnV_Spectrum_Vincent_Vega_p1.txt") as file:
    for line in file:
        wavelength_spectrometer.append(float(line.split("\t")[2].replace(",", ".")))
        counts_spectrometer.append(float(line.split("\t")[3][:-1]))

fig = plt.figure(figsize=(11, 3))
panel = gridspec.GridSpec(1, 3, width_ratios=[1.5, 1.5, 1], wspace=0.24, figure=fig)

ax_1 = plt.subplot(panel[0, 0])
ax_2 = plt.subplot(panel[0, 1])
ax_3 = plt.subplot(panel[0, 2])

ax_1.text(0, 1.12, "(a)", transform=ax_1.transAxes, fontsize=12, va="top")
ax_1.imshow(mpimg.imread(Path(r"../data/samples/VincentVega.png")))
ax_1.axis("off")

ax_2.text(-0.19, 1.12, "(b)", transform=ax_2.transAxes, fontsize=12, va="top")
img = ax_2.pcolormesh(
    -1 * x,
    -1 * y,
    counts.transpose()[::-1] / 1000,
    vmax=10,
)
ax_2.set_xlabel("X Position (µm)", fontsize=12)
ax_2.set_ylabel("Y Position (µm)", fontsize=12)
ax_2.set_xticks([0, 10, 20, 30, 40, 50])
axinset = inset_axes(
    ax_2,
    width="10%",
    height="30%",
    bbox_to_anchor=(0.02, -0.05, 0.95, 0.95),
    bbox_transform=ax_2.transAxes,
    loc="upper left",
)
cbar = fig.colorbar(img, cax=axinset, orientation="vertical")
cbar.set_label("Counts (kCts/s)", color="white", fontsize=10)
cbar.ax.tick_params(color="white", labelsize=10, labelcolor="white")
cbar.outline.set_edgecolor("white")

ax_3.text(-0.29, 1.12, "(c)", transform=ax_3.transAxes, fontsize=12, va="top")
ax_3.plot(wavelength_spectrometer, np.array(counts_spectrometer) / 1000, color="navy")
ax_3.set_xlabel("Wavelength (nm)", fontsize=12)
ax_3.set_ylabel("Counts (kCts/s)", fontsize=12)
ax_3.set_xlim(600, 720)

fig.savefig(Path("../figures/fig_17_add.png"), dpi=200, bbox_inches="tight")
