import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import numpy as np
import pandas as pd
from matplotlib.ticker import MultipleLocator, FixedLocator, NullLocator
from figsquare import figsquare
import itertools
import string

plt.style.use('paper')

##import data
filename_1 = '/Users/MaaskantE/Documents/PhD/Characterization/TGA-MS/pdms poss/20150429 PDMS POSS pH 9_11 MID/ExpDat_20150429_PDMSPOSS_pH911_20K_1000C_AIR_TG_TGAMSmerged.xls'
filename_2 = '/Users/MaaskantE/Documents/PhD/Characterization/TGA-MS/pdms poss/20150429 PDMS POSS pH 9_11 MID/ExpDat_20150506_PDMSPOSS_pH911_20K_1000C_N2_TG_TGAMSmerged.xls'
filename_3 = '/Users/MaaskantE/Documents/PhD/Characterization/TGA-MS/pdms poss/Isothermal analysis/ExpDat_20160728_PDMS_POSS_amicacid_isothermal_250C_TGAMSmerged.xls'

filenames = [filename_1, filename_2]

plt.close('all')

plt.figure(1,figsize=(180/25.4,180/25.4))
gs1 = gridspec.GridSpec(2, 2, height_ratios=[1.2,2.5])
gs1.update(hspace=0.05,wspace=0.45,bottom=0.6,top=0.99)
gs2 = gridspec.GridSpec(2, 2, height_ratios=[1.2,2.5])
gs2.update(hspace=0.05,wspace=0.45,top=.52)


##make subplot and share axes where applicable
ax0 = plt.subplot(gs1[0])
ax2 = ax0.twinx()
ax1 = plt.subplot(gs1[2],sharex=ax0)
plt.yscale('log')

ax3 = plt.subplot(gs1[1],sharex=ax0,sharey=ax0)
ax5 = ax3.twinx()
ax4 = plt.subplot(gs1[3],sharex=ax0,sharey=ax1)
plt.yscale('log')

ax6 = plt.subplot(gs2[0])
ax8 = ax6.twinx()
ax7 = plt.subplot(gs2[2],sharey=ax1)
plt.yscale('log')

ax9 = plt.subplot(gs2[1],sharey=ax6)
ax11 = ax9.twinx()
ax10 = plt.subplot(gs2[3],sharey=ax1)
plt.yscale('log')

## no axis labels on shared axes
plt.setp(ax0.get_xticklabels(), visible=False)
plt.setp(ax3.get_xticklabels(), visible=False)
plt.setp(ax6.get_xticklabels(), visible=False)
plt.setp(ax9.get_xticklabels(), visible=False)

plt.setp(ax2.get_yticklabels(), visible=False)
plt.setp(ax5.get_yticklabels(), visible=False)
plt.setp(ax8.get_yticklabels(), visible=False)
plt.setp(ax11.get_yticklabels(), visible=False)

#limits and tick position
ax1.set_xlim([0,1000])
ax7.set_xlim([50,250])
ax10.set_xlim([0,180])

ax1.set_ylim([1E-13,30E-11])
ax0.set_ylim([0,101])
ax6.set_ylim([90,101])
ax11.set_ylim([-.005,.05])

ax0.yaxis.set_major_locator(FixedLocator([0,50,100]))
ax2.yaxis.set_major_locator(NullLocator())
ax5.yaxis.set_major_locator(NullLocator())
ax8.yaxis.set_major_locator(NullLocator())
ax11.yaxis.set_major_locator(NullLocator())
ax1.xaxis.set_major_locator(FixedLocator([0,200,400,600,800,1000]))
ax7.xaxis.set_major_locator(FixedLocator([50,100,150,200,250]))
ax10.xaxis.set_major_locator(FixedLocator([0,60,120,180]))

#tick params
ax1.tick_params('y',labelsize=9)
ax4.tick_params('y',labelsize=9)
ax7.tick_params('y',labelsize=9)
ax10.tick_params('y',labelsize=9)

#labels
ax0.set_ylabel('Mass (%)',labelpad=11)
ax3.set_ylabel('Mass (%)',labelpad=11)
ax6.set_ylabel('Mass (%)',labelpad=11)
ax9.set_ylabel('Mass (%)',labelpad=11)
ax1.set_xlabel(u'Temperature (\u00B0C)') 
ax4.set_xlabel(u'Temperature (\u00B0C)') 
ax7.set_xlabel(u'Temperature (\u00B0C)') 
ax10.set_xlabel('Time (min)') 
ax1.set_ylabel('Ion current (A)')
ax4.set_ylabel('Ion current (A)')
ax7.set_ylabel('Ion current (A)')
ax10.set_ylabel('Ion current (A)')
ax2.set_ylabel('dm/dT (%/\u00B0C)') 
ax5.set_ylabel('dm/dT (%/\u00B0C)') 
ax8.set_ylabel('dm/dT (%/\u00B0C)')
ax11.set_ylabel('dm/dT (%/\u00B0C)')  



##annotation
ax1.text(0.10, 0.85,'$\mathregular{H_2O}$', color='b',fontsize=10, transform = ax1.transAxes)
ax1.text(0.80, 0.53,'$\mathregular{CH_4}$', color='g',fontsize=10, transform = ax1.transAxes)
ax1.text(0.10, 0.36,'NO', color='#ff0066',fontsize=10, transform = ax1.transAxes)
ax1.text(0.80, 0.18,'$\mathregular{CO_2}$', color='k',fontsize=10, transform = ax1.transAxes)
ax1.text(0.60, 0.04,'$\mathregular{CH_3CH_2CH_2}$', color='#ff9933',fontsize=10, transform = ax1.transAxes)

ax4.text(0.10, 0.58,'$\mathregular{H_2O}$', color='b',fontsize=10, transform = ax4.transAxes)
ax4.text(0.80, 0.53,'$\mathregular{CH_4}$', color='g',fontsize=10, transform = ax4.transAxes)
ax4.text(0.80, 0.36,'NO', color='#ff0066',fontsize=10, transform = ax4.transAxes)
ax4.text(0.80, 0.20,'$\mathregular{CO_2}$', color='k',fontsize=10, transform = ax4.transAxes)
ax4.text(0.60, 0.03,'$\mathregular{CH_3CH_2CH_2}$', color='#ff9933',fontsize=10, transform = ax4.transAxes)

ax7.text(0.05, 0.88,'$\mathregular{H_2O}$', color='b',fontsize=10, transform = ax7.transAxes)
ax7.text(0.05, 0.65,'$\mathregular{CH_4}$', color='g',fontsize=10, transform = ax7.transAxes)
ax7.text(0.05, 0.40,'NO', color='#ff0066',fontsize=10, transform = ax7.transAxes)
ax7.text(0.05, 0.28,'$\mathregular{CO_2}$', color='k',fontsize=10, transform = ax7.transAxes)
ax7.text(0.05, 0.08,'$\mathregular{CH_3CH_2CH_2}$', color='#ff9933',fontsize=10, transform = ax7.transAxes)

ax0.text(0.93, 0.80,'a', fontsize=12, transform = ax0.transAxes)
ax3.text(0.93, 0.80,'b', fontsize=12, transform = ax3.transAxes)
ax6.text(0.93, 0.80,'c', fontsize=12, transform = ax6.transAxes)
ax9.text(0.93, 0.80,'d', fontsize=12, transform = ax9.transAxes)


## plot the data for air and N2
top_axes = [ax0, ax3]
top_axes_2 = [ax2, ax5]
bottom_axes = [ax1, ax4]

for i,filename in enumerate(filenames):
    df = pd.read_excel(filename)  
    
    top_axes[i].plot(df['Temperature (?C)'], df['Mass (%)'],'k',lw=1)
    top_axes_2[i].plot(df['Temperature (?C)'], df['Differential mass (%/min)'],'k',ls='--',lw=1)

    bottom_axes[i].plot(df['Temperature (?C)'], df[18.09],'b',ls=':',lw=1.2)
    bottom_axes[i].plot(df['Temperature (?C)'], df[43.97],'k',ls=':',lw=1.2)
    bottom_axes[i].plot(df['Temperature (?C)'], df[30.05],'#ff0066',ls=':',lw=1.2)
    bottom_axes[i].plot(df['Temperature (?C)'], df[15.09],'g',ls=':',lw=1.2)   
    bottom_axes[i].plot(df['Temperature (?C)'], df[42.97],'#ff9933',ls=':',lw=1.2)    

## Plot the isothermal data
df = pd.read_excel(filename_3)

for j,value in enumerate(df['Temperature (?C)']):
    if value >= 250:
        index_250 = j
        break

index_250 = index_250+1
df['Time_reset'] = df['Time (min)']-df['Time (min)'][index_250]

#temperature
ax6.plot(df['Temperature (?C)'][:index_250], df['Mass (%)'][:index_250],'k')
ax8.plot(df['Temperature (?C)'][:index_250], df['Differential mass (%/min)'][:index_250],'k',ls='--',lw=1)

ax7.plot(df['Temperature (?C)'][:index_250], df[18.09][:index_250],'b',ls=':',lw=1.2)
ax7.plot(df['Temperature (?C)'][:index_250], df[43.97][:index_250],'k',ls=':',lw=1.2)
ax7.plot(df['Temperature (?C)'][:index_250], df[30.05][:index_250],'#ff0066',ls=':',lw=1.2)
ax7.plot(df['Temperature (?C)'][:index_250], df[15.09][:index_250],'g',ls=':',lw=1.2)
ax7.plot(df['Temperature (?C)'][:index_250], df[42.97][:index_250],'#ff9933',ls=':',lw=1.2) 

#time
ax9.plot(df['Time_reset'][index_250:], df['Mass (%)'][index_250:],'k')
ax11.plot(df['Time_reset'][index_250:], df['Differential mass (%/min)'][index_250:],'k',ls='--',lw=1)

ax10.plot(df['Time_reset'][index_250:], df[18.09][index_250:],'b',ls=':',lw=1.2)
ax10.plot(df['Time_reset'][index_250:], df[43.97][index_250:],'k',ls=':',lw=1.2)
ax10.plot(df['Time_reset'][index_250:], df[30.05][index_250:],'#ff0066',ls=':',lw=1.2)
ax10.plot(df['Time_reset'][index_250:], df[15.09][index_250:],'g',ls=':',lw=1.2)
ax10.plot(df['Time_reset'][index_250:], df[42.97][index_250:],'#ff9933',ls=':',lw=1.2) 

   
      
#plt.tight_layout()
