import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
from PySide import QtGui
import scipy.ndimage
import os
from matplotlib.ticker import MultipleLocator
from figsquare import figsquare
import itertools

#plt.style.use('thesis')

#Import data
filename_1 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_amic_acid_pH8_32.txt'
filename_2 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_amic_acid_pH8_79.txt'
filename_3 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_amic_acid_pH9_11.txt'
filename_4 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_amic_acid_pH9_57.txt'
filename_5 = '/Users/MaaskantE/Documents/PhD/Characterization/FTIR/2015/PDMS POSS/PDMS_POSS_amic_acid_pH9_93.txt'

headers = ['Wavenumber','Absorbance']

filenames = [filename_1, filename_2, filename_3, filename_4] #9_9 is left out

## fit the data for figure 1
output = pd.DataFrame()
plt.close('all')
plt.figure(1,figsize=(80/25.4,80/25.4))

#color = itertools.cycle(('0.15', '0.3', '0.5', '0.7', '0.9'))
color = itertools.cycle(('0.7', '0.6', '0.4', '0.2', '0.05'))

for i, filename in reversed(list(enumerate(filenames))):
    data = pd.read_csv(filename, sep='\t', header=0, names=headers, skiprows=1)
    
    for j,value in enumerate(data['Wavenumber']):
        if value <= 1400:
            index_1400 = j
            break
            
    for j,value in enumerate(data['Wavenumber']):
        if value <= 1800:
            index_1800 = j
            break        
    
    data = data[index_1800-1:index_1400]    
        
    max = data['Absorbance'].max()
    min = data['Absorbance'].min()
    
    data['Normalized']= (data['Absorbance']-min)/(max-min)
    
    plt.plot(data['Wavenumber'],data['Normalized'], next(color), linewidth=1)
    
plt.figure(1)

plt.xlim(1800,1400)
plt.ylim(-0.02,1.1)

plt.ylabel('Absorbance (a.u.)')
ax = plt.gca()
ax.xaxis.set_major_locator(MultipleLocator(100))
ax.xaxis.set_minor_locator(MultipleLocator(50))
plt.xlabel(r'Wavenumber (cm$^{\endash1}$)')
plt.yticks([])
plt.annotate("", xy=(1720, 0.5), xytext=(1700, -0.01),
    arrowprops=dict(arrowstyle="<-"))
plt.text(1690,0.007,'pH')

figsquare()

