#plot zeta potential data

import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
from PySide import QtGui
import scipy.ndimage
import os
from figsquare import figsquare
from matplotlib.ticker import MultipleLocator, NullLocator
import itertools
import os

plt.style.use('paper')

# plt.rcParams['axes.unicode_minus'] = False
# 
# os.environ['PATH'] += ':/Library/TeX/texbin'
# plt.rcParams['text.usetex'] = True
# plt.rcParams['mathtext.default'] = 'regular'
# plt.rcParams['text.latex.preamble'] = [
# r'''
# \usepackage[version=3]{mhchem}
# \setlength{\parskip}{\medskipamount}
# \setlength{\parindent}{0pt}
# ''']


## select multiple files, and put filenames in a list
filenames = QtGui.QFileDialog.getOpenFileNames(None, 'Selecteer het bestand', filter = '*.txt')[0]

headers = ['Point', 'pH', 'ZP',	'ci pH', 'ci ZP']


##Import csv file, replace headers by defined headers
plt.close('all')

color_plot = itertools.cycle(('0.15', '0.3', '0.5'))
color_plot_2 = itertools.cycle(('0.15', '0.3', '0.5'))
color_error = itertools.cycle(('0.15', '0.3', '0.5'))

fig = plt.figure(1,figsize=(80/25.4,80/25.4))
plt.axhline(y=0, xmin=0, xmax=1, linestyle='--', color='0.8')

for filename in filenames:
    #read data 
    df = pd.read_csv(filename, sep='\t',header=0, names=headers,skiprows=1)
    
    min_pH_distance = 0.5
    
    selection = []
    last_pH = float('-inf')
    for idx, row in df.iterrows():
        if row['pH'] > last_pH + min_pH_distance:
            selection.append(idx)
            last_pH = row['pH']
            
    df = df.loc[selection]
    
    plt.errorbar(df['pH'],df['ZP'], yerr=df['ci ZP'],linestyle="None", marker="None", color=next(color_error),capsize=2,elinewidth=0.5)
    plt.plot(df['pH'],df['ZP'],'--s',color=next(color_plot),markerfacecolor='w',linewidth=0.5,ms=6)
    
    
    
plt.figure(1)
plt.xlim(3,11)
plt.ylim(-400,400)

ax = plt.gca()
ax.xaxis.set_major_locator(MultipleLocator(2))
ax.yaxis.set_major_locator(MultipleLocator(200))

plt.xlabel('pH')
plt.ylabel('Zeta potential (mV)')



#figsquare()
plt.tight_layout()
#plt.subplots_adjust(bottom=0.2,top=0.92,wspace=0.1,right=0.98,left=0.08)

plt.savefig('/Users/MaaskantE/Documents/PhD/Articles and outlines/PDMS_POSS_onalumina/Figures/Fig_x_zetapotential/Zetapotential.pdf')